/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.util.concurrent.ConcurrentHashMap;

public class InterceptorNameCache {
    private static ConcurrentHashMap<String, String> classNameToNameMap = new ConcurrentHashMap(128);
    private static IADLogger logger = ADLoggerFactory.getLogger("com.singularity.bci.InterceptorNameCache");

    public static String getInterceptorName(Class<? extends AMethodInterceptor> interceptorClass) {
        String name = classNameToNameMap.get(interceptorClass.getName());
        if (name != null) {
            return name;
        }
        try {
            name = interceptorClass.newInstance().getName();
            classNameToNameMap.put(interceptorClass.getName(), name);
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
            name = interceptorClass.getName();
            classNameToNameMap.put(name, name);
        }
        return name;
    }
}

