/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.InterceptorClassRegistryBoot;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ModifiedMethods {
    private final Map<ModifiedMethodId, ModifiedMethodId> mapOfModifiedMethods = new HashMap<ModifiedMethodId, ModifiedMethodId>();

    public void indicateMethodModified(String methodName, String methodDesc) {
        this._indicateMethodModified(methodName, methodDesc);
    }

    private ModifiedMethodId _indicateMethodModified(String methodName, String methodDesc) {
        ModifiedMethodId search = new ModifiedMethodId(methodName, methodDesc);
        ModifiedMethodId found = this.mapOfModifiedMethods.get(search);
        if (found == null) {
            this.mapOfModifiedMethods.put(search, search);
            found = search;
        }
        return found;
    }

    public boolean isMethodModified(String methodName, String methodDesc) {
        return this.getModifiedMethod(methodName, methodDesc) != null;
    }

    private ModifiedMethodId getModifiedMethod(String methodName, String methodDesc) {
        ModifiedMethodId search = new ModifiedMethodId(methodName, methodDesc);
        return this.mapOfModifiedMethods.get(search);
    }

    public void defineInjectedInstructionRange(String methodName, String methodDesc, int firstInsn, int lastInsn) {
        ModifiedMethodId found = this._indicateMethodModified(methodName, methodDesc);
        found.defineInjectedInstructionRange(firstInsn, lastInsn);
    }

    public void refreshInjectedInstructionRange(String methodName, String methodDesc, TreeMap<Integer, Integer> newInjectVsOffsetAmount) {
        ModifiedMethodId found = this.getModifiedMethod(methodName, methodDesc);
        if (found != null) {
            found.refreshInjectedInstructionRange(newInjectVsOffsetAmount);
        }
    }

    public boolean isInsnInjected(String methodName, String methodDesc, int insnNum) {
        boolean bReturn = false;
        ModifiedMethodId found = this.getModifiedMethod(methodName, methodDesc);
        if (found != null) {
            bReturn = found.isInsnInjected(insnNum);
        }
        return bReturn;
    }

    public int getNumModifiedMethods() {
        return this.mapOfModifiedMethods.size();
    }

    public String[][] getModifiedMethodsAsArray() {
        String[][] returnStringArray = new String[this.mapOfModifiedMethods.size()][];
        int index = 0;
        for (ModifiedMethodId nextMethodId : this.mapOfModifiedMethods.keySet()) {
            returnStringArray[index] = new String[2];
            returnStringArray[index][0] = nextMethodId.methodName;
            returnStringArray[index][1] = nextMethodId.methodDesc;
            ++index;
        }
        return returnStringArray;
    }

    public String[] getModifyingInterceptorsForMethod(String methodName, String methodDesc) {
        String[] returnInterceptors = null;
        ModifiedMethodId found = this.getModifiedMethod(methodName, methodDesc);
        if (found != null) {
            returnInterceptors = found.getModifyingInterceptors();
        }
        return returnInterceptors;
    }

    public void setMethodModifiedByTransformationInfos(String methodName, String methodDesc, TransformationInfo[] transformationInfos) {
        ModifiedMethodId found = this._indicateMethodModified(methodName, methodDesc);
        if (found != null) {
            for (TransformationInfo ti : transformationInfos) {
                TransformationRule[] rules = ti.getMatchingTransformationRules();
                if (rules == null) continue;
                for (TransformationRule rule : rules) {
                    Class<? extends AMethodInterceptor> interceptor = rule.getInterceptor();
                    String interceptorDescription = InterceptorClassRegistryBoot.getInterceptorDescription(interceptor);
                    found.setModifyingInterceptor(interceptorDescription);
                }
            }
        }
    }

    private class ModifiedMethodId {
        private final String methodName;
        private final String methodDesc;
        private final int hashValue;
        private final List<int[]> modifiedInsnRanges;
        private final Set<String> modifyingInterceptors;

        ModifiedMethodId(String methodName, String methodDesc) {
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.hashValue = methodName.hashCode() ^ methodDesc.hashCode();
            this.modifiedInsnRanges = new ArrayList<int[]>();
            this.modifyingInterceptors = new HashSet<String>();
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object o) {
            boolean bReturn;
            boolean bl = bReturn = this == o;
            if (!bReturn && o instanceof ModifiedMethodId) {
                ModifiedMethodId other = (ModifiedMethodId)o;
                bReturn = this.hashValue == other.hashValue && this.methodName.equals(other.methodName) && this.methodDesc.equals(other.methodDesc);
            }
            return bReturn;
        }

        void defineInjectedInstructionRange(int firstInsn, int lastInsn) {
            this.modifiedInsnRanges.add(new int[]{firstInsn, lastInsn});
        }

        void refreshInjectedInstructionRange(TreeMap<Integer, Integer> newInjectionVsOffsetAmount) {
            int[][] modifiedRangesArray = (int[][])this.modifiedInsnRanges.toArray((T[])new int[this.modifiedInsnRanges.size()][]);
            Arrays.sort(modifiedRangesArray, new Comparator<int[]>(){

                @Override
                public int compare(int[] range1, int[] range2) {
                    if (range1 == null && range2 == null) {
                        return 0;
                    }
                    if (range1 == null ^ range2 == null || range1.length != range2.length) {
                        return 1;
                    }
                    if (range1.length == 0) {
                        return 0;
                    }
                    return range1[0] - range2[0];
                }
            });
            int start = 0;
            for (int newInjectIndex : newInjectionVsOffsetAmount.keySet()) {
                for (int i = start; i < modifiedRangesArray.length; ++i) {
                    if (newInjectIndex >= modifiedRangesArray[i][1]) {
                        ++start;
                        continue;
                    }
                    if (newInjectIndex < modifiedRangesArray[i][0]) {
                        int amount = newInjectionVsOffsetAmount.get(newInjectIndex);
                        int[] nArray = modifiedRangesArray[i];
                        nArray[0] = nArray[0] + amount;
                        int[] nArray2 = modifiedRangesArray[i];
                        nArray2[1] = nArray2[1] + amount;
                        continue;
                    }
                    throw new RuntimeException("Injecting inside Injection!");
                }
            }
            for (int i = 0; i < modifiedRangesArray.length; ++i) {
                this.modifiedInsnRanges.set(i, modifiedRangesArray[i]);
            }
        }

        boolean isInsnInjected(int insnNum) {
            boolean bReturn = false;
            for (int[] nextRange : this.modifiedInsnRanges) {
                if (insnNum < nextRange[0] || insnNum > nextRange[1]) continue;
                bReturn = true;
                break;
            }
            return bReturn;
        }

        void setModifyingInterceptor(String interceptorId) {
            this.modifyingInterceptors.add(interceptorId);
        }

        String[] getModifyingInterceptors() {
            String[] returnStringArray = this.modifyingInterceptors.toArray(new String[this.modifyingInterceptors.size()]);
            return returnStringArray;
        }
    }
}

