/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.AClassTransformation;
import com.singularity.ee.agent.appagent.services.bciengine.notification.ClassContainer;
import com.singularity.ee.agent.appagent.services.bciengine.notification.ClassTransformationCallback;
import com.singularity.ee.agent.appagent.services.bciengine.pojo.util.UnableToRetransformException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.tasks.BatchTask;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import dagger.Lazy;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ReTransformTask
extends BatchTask {
    public static final String RE_TRANSFORM_TASK_CLASS_NAME = "ReTransformTask";
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.ReTransformTask");
    private AClassTransformation transformer;
    private boolean retransformationFailMessageIssued;
    private final Lazy<IBCIEngineService> bciEngineRef;
    private ConcurrentLinkedQueue<ClassContainer> toReTransform = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ClassContainer> toReTransformedIndividually = new ConcurrentLinkedQueue();
    private volatile int reTransformBatchSize = 1;
    int iterations = 0;

    public ReTransformTask(IAgentScheduledThreadPoolExecutor scheduler, Lazy<IBCIEngineService> bciEngineRef, AClassTransformation transformer) {
        super(scheduler);
        this.bciEngineRef = bciEngineRef;
        this.transformer = transformer;
        this.taskName = RE_TRANSFORM_TASK_CLASS_NAME;
    }

    public void addClassesToReTransform(ClassTransformationCallback callback, Class<?> ... classes) throws UnableToRetransformException {
        logger.info("Adding [" + classes.length + "] classes for re-transformation ");
        for (Class<?> clazz : classes) {
            this.toReTransform.add(new ClassContainer(clazz, callback));
        }
    }

    public void addClassesToReTransformIndividually(ClassTransformationCallback callback, Class<?> ... classes) {
        logger.info("Adding [" + classes.length + "] classes for individual re-transformation ");
        for (Class<?> clazz : classes) {
            this.toReTransformedIndividually.offer(new ClassContainer(clazz, callback));
        }
    }

    public IADLogger getLogger() {
        return logger;
    }

    protected void prepareOnce() {
        this.reTransformBatchSize = ((IBCIEngineService)this.bciEngineRef.get()).getRetransformBatchSize();
    }

    protected IBCIEngineService getBCIEngineService() {
        return (IBCIEngineService)this.bciEngineRef.get();
    }

    public boolean isDoneProcessing() {
        return this.toReTransform.isEmpty() && this.toReTransformedIndividually.isEmpty();
    }

    public void runOnce() {
        try {
            this.transformBatch();
            this.transformIndividually();
            this.retransformationFailMessageIssued = false;
        }
        catch (ClassNotFoundException e) {
            logger.error("Ignoring class load problems.", e);
        }
        catch (UnmodifiableClassException e) {
            logger.warn("Unmodifiable class error found. Disabling transformation for 1.5", e);
            this.setInactive();
        }
        catch (UnableToRetransformException e) {
            if (!this.retransformationFailMessageIssued) {
                e.sendError(logger, ((Object)((Object)this)).getClass().getSimpleName() + ".runOnce()");
                this.retransformationFailMessageIssued = true;
            }
        }
        catch (Throwable th) {
            logger.error("Hit error during actualRetransform", th);
        }
    }

    private void transformBatch() throws ClassNotFoundException, UnmodifiableClassException, UnableToRetransformException {
        ++this.iterations;
        if (this.toReTransform.isEmpty()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Now transforming a batch - total list is of size [" + this.toReTransform.size() + "]");
        }
        ArrayList<ClassContainer> listToTransform = new ArrayList<ClassContainer>();
        for (int batchCount = 0; this.toReTransform.peek() != null && batchCount < this.reTransformBatchSize; ++batchCount) {
            listToTransform.add(this.toReTransform.poll());
        }
        this.actualReTransform(listToTransform.toArray(new ClassContainer[listToTransform.size()]));
        if (logger.isDebugEnabled()) {
            logger.debug("Batch done, now remaining list size [" + this.toReTransform.size() + "]");
        }
    }

    private void transformIndividually() throws UnableToRetransformException {
        ClassContainer classContainer;
        while ((classContainer = this.toReTransformedIndividually.poll()) != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Transforming class \"%s\" individually", classContainer.getClazz().getName()));
                }
                this.actualReTransform(new ClassContainer[]{classContainer});
            }
            catch (UnableToRetransformException e) {
                throw e;
            }
            catch (Throwable t) {
                logger.error(String.format("Caught \"%s\" trying to retransform %s", t.toString(), classContainer.getClazz().getName()), t);
            }
        }
    }

    protected void actualReTransform(ClassContainer[] arrayToTransform) throws UnableToRetransformException {
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Classes in retransform batch: ");
            for (ClassContainer classContainer : arrayToTransform) {
                sb.append("[");
                sb.append(classContainer.getClazz().getName());
                sb.append("]");
            }
            logger.debug(sb.toString());
        }
        this.transformer.actualRetransform(arrayToTransform);
    }

    protected void setInactive() {
        this.transformer.setActive(false);
    }
}

