/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.util.JavaVersionUtil;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import com.singularity.ee.util.dtobootimpl.StringMatchBootType;
import java.util.HashSet;
import java.util.Set;

public class RuntimeExcludeManager {
    private static Set<StringMatchBoot> classExcludes = new HashSet<StringMatchBoot>();
    static final String LAMBDA_BRIDGE_CLASS_PATTERN = "$$Lambda$";

    public static boolean isLambdaClass(Class clazz) {
        return clazz != null && clazz.isSynthetic() && RuntimeExcludeManager.looksLikeLambdaClassName(clazz.getName());
    }

    public static boolean looksLikeLambdaClassName(String className) {
        return className.contains(LAMBDA_BRIDGE_CLASS_PATTERN);
    }

    public static boolean excludeClass(Class clazz) {
        if (clazz.isAnnotation() || !JavaVersionUtil.isJava8orHigher() && clazz.isInterface() || clazz.isEnum() || clazz.isPrimitive()) {
            return true;
        }
        return RuntimeExcludeManager.isExplicitlyExcluded(clazz.getName());
    }

    private static boolean isExplicitlyExcluded(String className) {
        for (StringMatchBoot pattern : classExcludes) {
            if (!pattern.matchString(className)) continue;
            return true;
        }
        return false;
    }

    static {
        classExcludes.add(new StringMatchBoot(StringMatchBootType.STARTSWITH, "["));
        classExcludes.add(new StringMatchBoot(StringMatchBootType.CONTAINS, LAMBDA_BRIDGE_CLASS_PATTERN));
    }
}

