/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.agent.appagent.kernel.spi.data.IServiceConfigData;
import com.singularity.ee.agent.appagent.services.bciengine.ISystemExcludeManager;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationRuleEngine;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.appagent.services.bciengine.spi.CustomExclude;
import com.singularity.ee.agent.appagent.services.bciengine.spi.ExcludeOverride;
import com.singularity.ee.agent.appagent.services.bciengine.spi.OverridableExclude;
import com.singularity.ee.agent.appagent.services.bciengine.spi.RetransformationExclude;
import com.singularity.ee.agent.appagent.services.bciengine.spi.SystemExcludeOverride;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import com.singularity.ee.util.dtobootimpl.StringMatchBootType;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.util.ArrayList;
import java.util.List;

public class SystemExcludeManager
implements ISystemExcludeManager {
    public static final String BCI_PROCESSING_EXCLUDES = "bci-processing-excludes";
    public static final String BCI_RETRANSFORMATION_EXCLUDES = "bci-retransformation-excludes";
    public static final String OVERRIDE_SYSTEM_EXCLUDE = "override-system-exclude";
    public static final String CUSTOM_EXCLUDE = "custom-exclude";
    public static final String RETRANSFORMATION_EXCLUDE = "retransformation-exclude";
    private static final String OVERRIDABLE_EXCLUDE_DEFINITION = "overridable-exclude-definition";
    private static final String EXCLUDE_OVERRIDE = "exclude-override";
    private static final String OVERRIDABLE_EXCLUDE = "overridable-exclude";
    public static final String FILTER_TYPE = "filter-type";
    public static final String FILTER_VALUE = "filter-value";
    public static final String INVERSE = "inverse";
    public static final String ENABLED = "enabled";
    public static final String METHOD_EXCLUDE = "method";
    public static final String JDK_JAVA_PREFIX = "java/";
    public static final String JDK_SUN_PREFIX = "sun/";
    public static final String JDK_COM_SUN_PREFIX = "com/sun/";
    public static final String JAVAX_PREFIX = "javax/";
    public static final String JAKARTA_PREFIX = "jakarta/";
    public static final String COM_SINGULARITY_AGENT_PREFIX = "com/singularity/ee";
    public static final String COM_SINGULARITY_DBAGENT_PREFIX = "com/singularity/ee/agent/dbagent";
    public static final String COM_SINGULARITY_BCIENGINE_INIT_PREFIX = "com/singularity/ee/agent/appagent/services/bciengine/init";
    public static final String COM_SINGULARITY_PREFIX = "com/singularity/";
    public static final String JROCKIT_PREFIX = "jrockit/";
    public static final String COM_BEA_JROCKIT_PREFIX = "com/bea/jrockit/";
    public static final String COM_YOURKIT_PREFIX = "com/yourkit";
    public static final String JERSEY_IMPL_CLASSES = "com/sun/jersey";
    public static final String SUN_JMS_MESSAGING_PKG = "com/sun/messaging";
    public static final String SUN_JAX_WS_SERVLET = "com/sun/enterprise/webservice/JAXWSServlet";
    public static final String JAVA_CONCURRENT_FUTURETASK = "java/util/concurrent/FutureTask$Sync";
    public static final String JAVA_SERVLET_REQUEST_WRAPPER = "javax/servlet/ServletRequestWrapper";
    public static final String JAVA_HTTP_SERVLET_REQUEST_WRAPPER = "javax/servlet/http/HttpServletRequestWrapper";
    public static final String JAKARTA_SERVLET_REQUEST_WRAPPER = "jakarta/servlet/ServletRequestWrapper";
    public static final String JAKARTA_HTTP_SERVLET_REQUEST_WRAPPER = "jakarta/servlet/http/HttpServletRequestWrapper";
    public static final String STREAM_REMOTE_CALL = "sun.rmi.transport.StreamRemoteCall";
    public static final String JAVA_CONCURRENT_RECURSIVETASK = "java/util/concurrent/RecursiveTask";
    public static final String ARGENTO_CLASSES = "com/cisco/argento";
    public static final String MT_AGENT_CLASSES = "com/cisco/mtagent";
    public static final String SUN_LDAP_ENUMERATION = "com/sun/jndi/ldap/LdapNamingEnumeration";
    private static List<String> systemClassesPrefix = new ArrayList<String>(){

        @Override
        public boolean add(String o) {
            return !this.contains(o) && super.add(o);
        }
    };
    private final List<CustomExclude> customExcludes = new ArrayList<CustomExclude>(){

        @Override
        public boolean add(CustomExclude o) {
            return !this.contains(o) && super.add(o);
        }
    };
    private final List<OverridableExclude> overridableExcludes = new ArrayList<OverridableExclude>(){

        @Override
        public boolean add(OverridableExclude o) {
            return !this.contains(o) && super.add(o);
        }
    };
    private final List<ExcludeOverride> excludeOverrides = new ArrayList<ExcludeOverride>(){

        @Override
        public boolean add(ExcludeOverride o) {
            return !this.contains(o) && super.add(o);
        }
    };
    private final List<SystemExcludeOverride> systemExcludeOverrides = new ArrayList<SystemExcludeOverride>(){

        @Override
        public boolean add(SystemExcludeOverride o) {
            return !this.contains(o) && super.add(o);
        }
    };
    private List<RetransformationExclude> retransformationExcludes = new ArrayList<RetransformationExclude>(){

        @Override
        public boolean add(RetransformationExclude o) {
            return !this.contains(o) && super.add(o);
        }
    };

    public SystemExcludeManager() {
        this.overrideSystemExclude(SystemExcludeManager.createStartsWithExcludeOverride(JERSEY_IMPL_CLASSES));
        this.overrideSystemExclude(SystemExcludeManager.createStartsWithExcludeOverride(SUN_JMS_MESSAGING_PKG));
        this.overrideSystemExclude(SystemExcludeManager.createEqualsClassExcludeOverride(SUN_JAX_WS_SERVLET));
        this.overrideSystemExclude(SystemExcludeManager.createEqualsClassExcludeOverride(JAVA_CONCURRENT_FUTURETASK));
        this.overrideSystemExclude(SystemExcludeManager.createEqualsClassExcludeOverride(JAVA_SERVLET_REQUEST_WRAPPER));
        this.overrideSystemExclude(SystemExcludeManager.createEqualsClassExcludeOverride(JAVA_HTTP_SERVLET_REQUEST_WRAPPER));
        this.overrideSystemExclude(SystemExcludeManager.createEqualsClassExcludeOverride(JAKARTA_SERVLET_REQUEST_WRAPPER));
        this.overrideSystemExclude(SystemExcludeManager.createEqualsClassExcludeOverride(JAKARTA_HTTP_SERVLET_REQUEST_WRAPPER));
        this.overrideSystemExclude(SystemExcludeManager.createStartsWithExcludeOverride(COM_SINGULARITY_BCIENGINE_INIT_PREFIX));
        this.overrideSystemExclude(SystemExcludeManager.createStartsWithExcludeOverride(JAVA_CONCURRENT_RECURSIVETASK));
        this.overrideSystemExclude(SystemExcludeManager.createStartsWithExcludeOverride(COM_SINGULARITY_DBAGENT_PREFIX));
        this.overrideSystemExclude(SystemExcludeManager.createStartsWithExcludeOverride("com/sun/j2ee/blueprints"));
        this.overrideSystemExclude(SystemExcludeManager.createStartsWithExcludeOverride("com/sun/javaee/blueprints"));
        this.overrideSystemExclude(SystemExcludeManager.createEqualsClassExcludeOverride(SUN_LDAP_ENUMERATION));
        this.overrideSystemExclude(SystemExcludeManager.createEqualsClassExcludeOverride("com/sun/jndi/ldap/LdapClient"));
        this.overrideSystemExclude(SystemExcludeManager.createEqualsClassExcludeOverride("com/sun/jndi/ldap/LdapClientFactory"));
        this.overrideSystemExclude(SystemExcludeManager.createEqualsClassExcludeOverride("javax/mail/Transport"));
        this.overrideSystemExclude(new SystemExcludeOverride(new StringMatchBoot(StringMatchBootType.EQUALS, "java/net/Socket")));
        this.overrideSystemExclude(new SystemExcludeOverride(new StringMatchBoot(StringMatchBootType.EQUALS, "java/mail/SocketInputStream")));
        this.overrideSystemExclude(new SystemExcludeOverride(new StringMatchBoot(StringMatchBootType.EQUALS, "java/mail/SocketOutputStream")));
        this.overrideSystemExclude(SystemExcludeManager.createEqualsClassExcludeOverride(STREAM_REMOTE_CALL));
        for (int i = 0; i < systemClassesPrefix.size(); ++i) {
            String prefix = systemClassesPrefix.get(i);
            if (prefix.equals(COM_SINGULARITY_PREFIX)) continue;
            BCTLoggerUtil.excludeSystemClass(prefix);
        }
    }

    private static SystemExcludeOverride createStartsWithExcludeOverride(String className) {
        return new SystemExcludeOverride(new StringMatchBoot(StringMatchBootType.STARTSWITH, SystemExcludeManager.transformDotToSlash(className)));
    }

    private static SystemExcludeOverride createEqualsClassExcludeOverride(String className) {
        return new SystemExcludeOverride(new StringMatchBoot(StringMatchBootType.EQUALS, SystemExcludeManager.transformDotToSlash(className)));
    }

    private static String transformDotToSlash(String in) {
        return in.replace('.', '/');
    }

    @Override
    public boolean isSystemExcludePackage(String className) {
        return (className = SystemExcludeManager.transformDotToSlash(className)).startsWith(JDK_COM_SUN_PREFIX) || className.startsWith(JAVAX_PREFIX) || className.startsWith(JAKARTA_PREFIX) || className.startsWith(JDK_SUN_PREFIX) || className.startsWith(JDK_JAVA_PREFIX) || className.startsWith(COM_SINGULARITY_AGENT_PREFIX);
    }

    @Override
    public void setSystemExcludesFromConfigXML(IServiceConfigData configData) {
        this.readExcludesFromConfig(configData);
    }

    @Override
    public synchronized void overrideSystemExclude(SystemExcludeOverride systemExcludeOverride) {
        if (this.isSystemExcludePackage(systemExcludeOverride.getExcludeDefinition().getMatchPattern())) {
            BCTLoggerUtil.includeSystemClass(systemExcludeOverride.toString());
            this.systemExcludeOverrides.add(systemExcludeOverride);
        }
    }

    public synchronized void addExcludeOverride(ExcludeOverride excludeOverride) {
        BCTLoggerUtil.println("Add Override for OverridableExclude: " + excludeOverride.toString());
        this.excludeOverrides.add(excludeOverride);
    }

    @Override
    public synchronized void removeSystemExcludeOverride(SystemExcludeOverride systemExcludeOverride) {
        this.systemExcludeOverrides.remove(systemExcludeOverride);
    }

    @Override
    public synchronized void addCustomExclude(CustomExclude customExclude) {
        BCTLoggerUtil.excludeCustomClass("Excluding custom classes\t" + customExclude.toString());
        this.customExcludes.add(customExclude);
    }

    @Override
    public synchronized void removeCustomExclude(CustomExclude customExclude) {
        BCTLoggerUtil.excludeCustomClass("Remove excluding custom classes\t" + customExclude.toString());
        this.customExcludes.add(customExclude);
    }

    @Override
    public synchronized void addRetransformationExclude(RetransformationExclude retransformationExclude) {
        BCTLoggerUtil.excludeClassesFromRetransformation("Excluding from retransformation custom classes\t" + this.retransformationExcludes.toString());
        this.retransformationExcludes.add(retransformationExclude);
    }

    @Override
    public synchronized void removeRetransformationExclude(RetransformationExclude retransformationExclude) {
        BCTLoggerUtil.excludeClassesFromRetransformation("Remove excluding from retransformation custom classes\t" + this.retransformationExcludes.toString());
        this.retransformationExcludes.remove(retransformationExclude);
    }

    @Override
    public boolean excludeClass(String className, ClassLoader loader) {
        int i;
        for (i = 0; i < this.customExcludes.size(); ++i) {
            CustomExclude customExclude = this.customExcludes.get(i);
            if (!customExclude.getExcludeDefinition().matchString(className) || customExclude.isExcludingSpecificMethods()) continue;
            return true;
        }
        for (int j = 0; j < systemClassesPrefix.size(); ++j) {
            String systemClassPrefix = systemClassesPrefix.get(j);
            if (!className.startsWith(systemClassPrefix)) continue;
            for (int i2 = 0; i2 < this.systemExcludeOverrides.size(); ++i2) {
                SystemExcludeOverride excludeOverride = this.systemExcludeOverrides.get(i2);
                if (!excludeOverride.getExcludeDefinition().matchString(className)) continue;
                BCTLoggerUtil.includeSystemClass(className + TransformationRuleEngine.getClassLoaderString(loader));
                return false;
            }
            if (!className.contains(COM_SINGULARITY_AGENT_PREFIX)) {
                // empty if block
            }
            return true;
        }
        for (i = 0; i < this.overridableExcludes.size(); ++i) {
            OverridableExclude exclude = this.overridableExcludes.get(i);
            if (!exclude.getExcludeDefinition().matchString(className)) continue;
            for (int j = 0; j < this.excludeOverrides.size(); ++j) {
                ExcludeOverride override = this.excludeOverrides.get(j);
                if (!override.getExcludeDefinition().matchString(className)) continue;
                BCTLoggerUtil.println("Including class [" + className + TransformationRuleEngine.getClassLoaderString(loader) + "]");
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean excludeClassFromRetransformation(Class<?> clazz) {
        String className = clazz.getName().replace('.', '/');
        for (int i = 0; i < this.retransformationExcludes.size(); ++i) {
            RetransformationExclude retransformationExclude = this.retransformationExcludes.get(i);
            if (!retransformationExclude.getExcludeDefinition().matchString(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean excludeSpecificMethod(String className, String methodName) {
        boolean bReturn = false;
        for (int i = 0; i < this.customExcludes.size(); ++i) {
            CustomExclude customExclude = this.customExcludes.get(i);
            if (!customExclude.getExcludeDefinition().matchString(className) || !customExclude.isExcludingSpecificMethods() || !customExclude.isMethodExcluded(methodName)) continue;
            bReturn = true;
            break;
        }
        return bReturn;
    }

    private void readExcludesFromConfig(IServiceConfigData serviceConfig) {
        Element configElement = (Element)serviceConfig.getConfigElement();
        if (configElement != null) {
            this.readBciProcessingExcludes(configElement);
            this.readOverridableExcludeDefinitions(configElement);
            this.readBciRetransformationExcludes(configElement);
        }
    }

    private void readBciProcessingExcludes(Element configElement) {
        Element bciEngineElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)configElement, (String)BCI_PROCESSING_EXCLUDES);
        if (bciEngineElement != null) {
            List overrideElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)bciEngineElement, (String)OVERRIDE_SYSTEM_EXCLUDE);
            for (Element overrideElement : overrideElements) {
                this.overrideSystemExclude(new SystemExcludeOverride(SystemExcludeManager.convertNode(overrideElement)));
            }
            List customExcludeElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)bciEngineElement, (String)CUSTOM_EXCLUDE);
            for (Element excludeElement : customExcludeElements) {
                CustomExclude customExclude = new CustomExclude(SystemExcludeManager.convertNode(excludeElement));
                BCTLoggerUtil.excludeCustomClass("Remove excluding custom classes\t" + customExclude.toString());
                this.getMethodExcludes(excludeElement, customExclude);
                this.customExcludes.add(customExclude);
            }
        }
    }

    private void readOverridableExcludeDefinitions(Element configElement) {
        Element overridableExcludeDefinitionElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)configElement, (String)OVERRIDABLE_EXCLUDE_DEFINITION);
        if (overridableExcludeDefinitionElement != null) {
            List excludeOverrideElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)overridableExcludeDefinitionElement, (String)EXCLUDE_OVERRIDE);
            for (Element excludeOverrideElement : excludeOverrideElements) {
                this.addExcludeOverride(new ExcludeOverride(SystemExcludeManager.convertNode(excludeOverrideElement)));
            }
            List overridableExcludeElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)overridableExcludeDefinitionElement, (String)OVERRIDABLE_EXCLUDE);
            for (Element excludeElement : overridableExcludeElements) {
                OverridableExclude overridableExclude = new OverridableExclude(SystemExcludeManager.convertNode(excludeElement));
                BCTLoggerUtil.excludeCustomClass("Remove excluding overridable classes\t" + overridableExclude.toString());
                this.overridableExcludes.add(overridableExclude);
            }
        }
    }

    private void readBciRetransformationExcludes(Element configElement) {
        Element bciRetransformationExcludeElement = XMLParseUtility.getFirstDirectChildUnderWithName((Node)configElement, (String)BCI_RETRANSFORMATION_EXCLUDES);
        if (bciRetransformationExcludeElement != null) {
            List retransformationExcludeElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)bciRetransformationExcludeElement, (String)RETRANSFORMATION_EXCLUDE);
            for (Element excludeElement : retransformationExcludeElements) {
                RetransformationExclude retransformationExclude = new RetransformationExclude(SystemExcludeManager.convertNode(excludeElement));
                BCTLoggerUtil.excludeClassesFromRetransformation("Excluding retransformation of classes\t" + retransformationExclude.toString());
                this.retransformationExcludes.add(retransformationExclude);
            }
        }
    }

    private void getMethodExcludes(Element excludeElement, CustomExclude customExclude) {
        List methodExcludeElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)excludeElement, (String)METHOD_EXCLUDE);
        if (methodExcludeElements != null) {
            for (Element methodElement : methodExcludeElements) {
                StringMatchBoot stringMatch = SystemExcludeManager.convertNode(methodElement);
                customExclude.defineMethodStringMatch(stringMatch);
            }
        }
    }

    public static StringMatchBoot convertNode(Element element) throws IllegalArgumentException {
        String filterType = (String)XMLParseUtility.getAttributeMapForElement((Element)element).get(FILTER_TYPE);
        String filterValue = (String)XMLParseUtility.getAttributeMapForElement((Element)element).get(FILTER_VALUE);
        boolean inverse = Boolean.parseBoolean((String)XMLParseUtility.getAttributeMapForElement((Element)element).get(INVERSE));
        StringMatchBootType matchType = StringMatchBootType.valueOf((String)StringOperations.toUppercaseEnglishLocale((String)filterType));
        return new StringMatchBoot(matchType, filterValue, inverse);
    }

    @Override
    public boolean isOverrideSystemExclude(SystemExcludeOverride excludeOverride) {
        return this.systemExcludeOverrides.contains(excludeOverride);
    }

    static {
        systemClassesPrefix.add(JDK_JAVA_PREFIX);
        systemClassesPrefix.add(JDK_SUN_PREFIX);
        systemClassesPrefix.add(JDK_COM_SUN_PREFIX);
        systemClassesPrefix.add(JAVAX_PREFIX);
        systemClassesPrefix.add(JAKARTA_PREFIX);
        systemClassesPrefix.add(COM_SINGULARITY_AGENT_PREFIX);
        systemClassesPrefix.add(JROCKIT_PREFIX);
        systemClassesPrefix.add(COM_BEA_JROCKIT_PREFIX);
        systemClassesPrefix.add(COM_YOURKIT_PREFIX);
        systemClassesPrefix.add(ARGENTO_CLASSES);
        systemClassesPrefix.add(MT_AGENT_CLASSES);
    }
}

