/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.services.bciengine.BCILock;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.thread.ThreadUtil;

public class TimeoutWaitingForLockException
extends Exception {
    private Thread threadHoldingLock;

    public TimeoutWaitingForLockException(BCILock lock, Thread threadHoldingLock) {
        super(String.format("Timeout waiting for lock %s", lock));
        this.threadHoldingLock = threadHoldingLock;
    }

    public void writeToLog(IADLogger logger) {
        logger.info(this.getHoldingLockStackTrace());
        this.threadHoldingLock = null;
    }

    public String getHoldingLockStackTrace() {
        String returnString = "Unable to find thread holding lock";
        if (this.threadHoldingLock != null) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("Thread holding lock:  %d  %s \n", this.threadHoldingLock.getId(), this.threadHoldingLock.getName()));
                String stackSummary = ThreadUtil.getUnfilteredADStackSummary((StackTraceElement[])this.threadHoldingLock.getStackTrace());
                sb.append(stackSummary);
                returnString = sb.toString();
            }
            catch (Throwable t) {
                returnString = String.format("%s caught trying to format stack trace", t);
            }
        }
        return returnString;
    }
}

