/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.FastInterceptorClassRegistryBoot;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IFastInterceptorClassRegistry;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IFastMethodInterceptor;
import com.singularity.ee.agent.appagent.kernel.bootimpl.FastInterceptorClassRegistry;
import com.singularity.ee.agent.appagent.services.bciengine.AInlineTrackedMethodInterceptor;
import com.singularity.ee.agent.appagent.services.bciengine.MidMethodInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.MethodInfo;
import com.singularity.ee.agent.util.reflect.AgentReflectionUtility;
import com.singularity.ee.agent.util.reflect.ReflectionException;
import java.util.List;

public class TransformationInfo
implements Comparable<TransformationInfo> {
    private final int transformationId;
    private final String interceptorClassName;
    private volatile TransformationRule[] matchingTransformationRules;
    private final int priority;
    private final boolean useFastInterceptor;
    private int fastInterceptorId;
    private final String className;
    private final MethodInfo methodInfo;
    private final boolean inlineInterceptor;
    private boolean hasMidInterceptor;

    public TransformationInfo(int transformationId, Class<? extends AMethodInterceptor> interceptor, List<TransformationRule> matchingTransformationRules, int priority, String className, MethodInfo methodInfo) throws ReflectionException {
        this(transformationId, interceptor, matchingTransformationRules, priority, className, methodInfo, null);
    }

    public TransformationInfo(int transformationId, Class<? extends AMethodInterceptor> interceptor, List<TransformationRule> matchingTransformationRules, int priority, String className, MethodInfo methodInfo, MidMethodInfo midMethodInfo) throws ReflectionException {
        this.transformationId = transformationId;
        this.interceptorClassName = interceptor.getName();
        this.matchingTransformationRules = matchingTransformationRules.toArray(new TransformationRule[matchingTransformationRules.size()]);
        this.priority = priority;
        this.useFastInterceptor = IFastMethodInterceptor.class.isAssignableFrom(interceptor);
        IFastInterceptorClassRegistry fastInterceptorClassRegistry = FastInterceptorClassRegistryBoot.getRegisteredImplementation();
        if (this.useFastInterceptor) {
            boolean useReflectiveCall = fastInterceptorClassRegistry != null && !(fastInterceptorClassRegistry instanceof FastInterceptorClassRegistry);
            this.fastInterceptorId = useReflectiveCall ? (Integer)AgentReflectionUtility.invokeMethod(fastInterceptorClassRegistry, "getFastInterceptorId", new Class[]{this.interceptorClassName.getClass()}, new Object[]{this.interceptorClassName}) : FastInterceptorClassRegistry.getFastInterceptorId(this.interceptorClassName);
        }
        this.className = className;
        this.methodInfo = methodInfo;
        this.inlineInterceptor = AInlineTrackedMethodInterceptor.class.isAssignableFrom(interceptor);
    }

    public String getClassName() {
        return this.className;
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public boolean isUseFastInterceptor() {
        return this.useFastInterceptor;
    }

    public int getFastInterceptorId() {
        return this.fastInterceptorId;
    }

    public String getInterceptorClassName() {
        return this.interceptorClassName;
    }

    public TransformationRule[] getMatchingTransformationRules() {
        return this.matchingTransformationRules;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getTransformationId() {
        return this.transformationId;
    }

    public boolean hasMidMethodInfo() {
        return this.hasMidInterceptor;
    }

    @Override
    public int compareTo(TransformationInfo o) {
        if (this.priority == o.getPriority()) {
            return this.interceptorClassName.compareTo(o.getInterceptorClassName());
        }
        return this.priority - o.getPriority();
    }

    public boolean usesInlineInterceptor() {
        return this.inlineInterceptor;
    }

    public void replaceTransformationRules(List<? extends AClassTransformationRule[]> listOfRulesToReplace) {
        block0: for (int i = 0; i < this.matchingTransformationRules.length; ++i) {
            TransformationRule tr = this.matchingTransformationRules[i];
            for (AClassTransformationRule[] aClassTransformationRuleArray : listOfRulesToReplace) {
                if (tr != aClassTransformationRuleArray[0]) continue;
                this.matchingTransformationRules[i] = (TransformationRule)aClassTransformationRuleArray[1];
                continue block0;
            }
        }
    }

    public void addMatchingTransformationRule(TransformationRule rule) {
        if (rule.hasMidMethodInterceptor()) {
            this.hasMidInterceptor = true;
            rule.getMidMethodInfo().setTransformationId(this.transformationId);
            rule.getMidMethodInfo().setFastInterceptorId(this.fastInterceptorId);
        }
        TransformationRule[] rules = new TransformationRule[this.matchingTransformationRules.length + 1];
        System.arraycopy(this.matchingTransformationRules, 0, rules, 0, this.matchingTransformationRules.length);
        rules[this.matchingTransformationRules.length] = rule;
        this.matchingTransformationRules = rules;
    }
}

