/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.kernel.spi.IAgentEnvironment;
import com.singularity.ee.agent.appagent.kernel.spi.IConfigManager;
import com.singularity.ee.agent.appagent.kernel.spi.IServicePropertyListener;
import com.singularity.ee.agent.appagent.kernel.spi.data.IServiceConfig;
import com.singularity.ee.agent.appagent.services.bciengine.BackgroundTransformerTask;
import com.singularity.ee.agent.appagent.services.bciengine.IByteCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.TimeoutWaitingForLockException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineInfoProvider;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.configuration.spi.IAgentSchedulerManager;
import com.singularity.ee.agent.util.bounded.collections.BoundedConcurrentHashMap;
import com.singularity.ee.agent.util.javalang.ADInteger;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.AsyncLogger;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.reflect.ClassLoaderUtil;
import com.singularity.ee.util.collections.bounded.SharedBoundsEnforcer;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class TransformationManager
implements IServicePropertyListener {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.bci.TransformationManager");
    private final AsyncLogger asyncLogger;
    private final IBCIEngineService bciEngine;
    private volatile long timeOfDayOKToRunNonBootstrapSync;
    private final IAgentAtomicInteger numActiveTransformTasks = new AgentAtomicIntegerImpl();
    private volatile int maxTimeToRunTransformsInBackground = 120;
    private volatile int maxTimeToRunNonBootstrapTransformsInBackground = 15;
    private volatile int threadPoolExecutorSize = 5;
    private volatile int maxConcurrentBackgroundTransforms = 25;
    private volatile ConcurrentHashMap<String, ADInteger> transformLimitMap;
    private volatile boolean transformInBackgroundThread;
    private volatile long maxTimeToWaitForBackgroundTransform = 5000L;
    private IBCIEngineInfoProvider infoProviderMBean;
    private final boolean isSpecialSynchronizationRequired;
    private final boolean isAgentRemoteAttached;
    private volatile int bciTransformThreadPoolExecutorUseCount;
    private volatile IAgentScheduledThreadPoolExecutor threadPoolExecutor;
    private volatile IAgentScheduledFuture terminateBackgroundTransformsFuture;
    private volatile boolean useBackgroundTransformationsForGlassfish;
    private Set<String> classesToTimeoutAsyncBCI;
    private final IAgentScheduledExecutorService globalScheduler;
    private final IAgentSchedulerManager schedulerInstance;
    private final boolean usingBootClassLoader;

    TransformationManager(IBCIEngineService bciEngine, IAgentSchedulerManager schedulerManager, IAgentEnvironment agentEnvironment) {
        this.bciEngine = bciEngine;
        this.usingBootClassLoader = ClassLoaderUtil.isBootstrapLoaded(this);
        this.isSpecialSynchronizationRequired = agentEnvironment.isDeadlockProneJVM();
        this.isAgentRemoteAttached = agentEnvironment.isRemoteAttached();
        this.schedulerInstance = schedulerManager;
        this.globalScheduler = schedulerManager.getAgentGlobalScheduler();
        this.asyncLogger = new AsyncLogger(logger, this.globalScheduler);
    }

    void init(IConfigManager configManager) {
        if (this.transformInBackgroundThread && this.shouldDoBackgroundTransformationsForGlassfish()) {
            this.createThreadPoolExecutor();
            new BackgroundTransformerTask();
            this.determineTimeOfDayOKToRunNonBootstrapSync();
        }
        String[] props = new String[]{"transform-in-background-thread", "transform-thread-pool-size", "background-transform-max-time", "background-transform-max-time-non-bootstrap", "max.background.transformation.time", "max-concurrent-background-transforms"};
        configManager.registerConfigPropertyChangeListener("BCIEngine.TransformationManager", props, (IServicePropertyListener)this);
    }

    void configure(IServiceConfig serviceConfig) {
        long maxTimeToWaitForBackgroundTransform = StringOperations.safeParseLong((String)serviceConfig.getConfigProperties().get("max.background.transformation.time"), (long)5000L);
        this.setMaxTimeToWaitForBackgroundTransform(maxTimeToWaitForBackgroundTransform);
        boolean transformInBackgroundThread = StringOperations.safeParseBoolean((String)serviceConfig.getConfigProperties().get("transform-in-background-thread"), (boolean)true);
        int threadPoolExecutorSize = StringOperations.safeParseInteger((String)serviceConfig.getConfigProperties().get("transform-thread-pool-size"), (int)5);
        this.setThreadPoolExecutorSize(threadPoolExecutorSize);
        int maxTimeToRunTransformsInBackground = StringOperations.safeParseInteger((String)serviceConfig.getConfigProperties().get("background-transform-max-time"), (int)120);
        this.setMaxTimeToRunTransformsInBackground(maxTimeToRunTransformsInBackground);
        int maxTimeToRunNonBootstrapTransformsInBackground = StringOperations.safeParseInteger((String)serviceConfig.getConfigProperties().get("background-transform-max-time-non-bootstrap"), (int)15);
        this.setMaxTimeToRunNonBootstrapTransformsInBackground(maxTimeToRunNonBootstrapTransformsInBackground);
        int maxConcurrentBackgroundTransforms = StringOperations.safeParseInteger((String)serviceConfig.getConfigProperties().get("max-concurrent-background-transforms"), (int)25);
        this.setMaxConcurrentBackgroundTransforms(maxConcurrentBackgroundTransforms);
        boolean useBackgroundTransformationsForGlassfish = StringOperations.safeParseBoolean((String)SystemUtils.getProperty((String)"appdynamics.allow.background.transform.on.glassfish"), (boolean)false);
        this.setUseBackgroundTransformationsForGlassfish(useBackgroundTransformationsForGlassfish);
        this.setTransformInBackgroundThread(transformInBackgroundThread);
    }

    @Override
    public void servicePropertyChanged(String serviceName, String propertyName, String newPropertyValue) {
        logger.info("TransformationManager service property " + propertyName + " changed, new value " + newPropertyValue);
        if (propertyName.equals("transform-in-background-thread")) {
            this.setTransformInBackgroundThreadFromString(newPropertyValue);
        } else if (propertyName.equals("transform-thread-pool-size")) {
            this.setThreadPoolExecutorSizeFromString(newPropertyValue);
        } else if (propertyName.equals("max-concurrent-background-transforms")) {
            this.setMaxConcurrentBackgroundTransformsFromString(newPropertyValue);
        } else if (propertyName.equals("max.background.transformation.time")) {
            this.setMaxTimeToWaitForBackgroundTransformFromString(newPropertyValue);
        } else if (propertyName.equals("background-transform-max-time")) {
            this.setMaxTimeToRunTransformsInBackgroundFromString(newPropertyValue);
        } else if (propertyName.equals("background-transform-max-time-non-bootstrap")) {
            this.setMaxTimeToRunNonBootstrapTransformsInBackgroundFromString(newPropertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] performTransformation(IByteCodeTransformer byteCodeTransformer, ClassLoader loader, String className, Class<?> classBeingRedefined, byte[] classfileBuffer, Object module) {
        long transformStartTime;
        byte[] result;
        block18: {
            result = null;
            transformStartTime = System.currentTimeMillis();
            try {
                if (this.infoProviderMBean == null) {
                    this.determineInfoProvider();
                }
                if (this.transformLimitMap == null) {
                    this.createTransformLimitMap();
                }
                IAgentScheduledThreadPoolExecutor threadPoolExecutor = null;
                if (loader == null || System.currentTimeMillis() < this.timeOfDayOKToRunNonBootstrapSync) {
                    threadPoolExecutor = this.getBCITransformThreadPoolExecutor();
                }
                if (threadPoolExecutor != null && this.numActiveTransformTasks.get() >= this.maxConcurrentBackgroundTransforms) {
                    this.doneWithBCITransformThreadPoolExecutor(threadPoolExecutor);
                    String errorMessage = String.format("Unable to transform class %s because maximum number of %d transform tasks are active", className, this.maxConcurrentBackgroundTransforms);
                    if (this.infoProviderMBean != null) {
                        this.infoProviderMBean.incrementNumTimedOutTransformations(1);
                    }
                    this.asyncLogger.warn(errorMessage);
                    this.scheduleForReTransform(className, classfileBuffer, loader);
                    return null;
                }
                if (this.isSpecialSynchronizationRequired && this.isAgentRemoteAttached && threadPoolExecutor != null && loader == null && classBeingRedefined == null && (this.bciEngine.isRetransformClassesSupported() || this.bciEngine.isRedefineClassesSupported())) {
                    this.doneWithBCITransformThreadPoolExecutor(threadPoolExecutor);
                    this.scheduleForReTransform(className, classfileBuffer, loader);
                    return null;
                }
                if (threadPoolExecutor != null) {
                    try {
                        result = this.transformInBackgroundThread(byteCodeTransformer, loader, className, classBeingRedefined, classfileBuffer, threadPoolExecutor, module);
                        if (result != null && this.infoProviderMBean != null) {
                            this.infoProviderMBean.incrementBackgroundTransformationTime(System.currentTimeMillis() - transformStartTime);
                        }
                        break block18;
                    }
                    finally {
                        this.doneWithBCITransformThreadPoolExecutor(threadPoolExecutor);
                    }
                }
                result = byteCodeTransformer.doTransform(loader, className, classBeingRedefined, classfileBuffer, module);
                this.transformLimitMap.remove(className);
            }
            catch (Throwable e) {
                String errorMessage = String.format("%s caught trying to transform class %s", e, className);
                if (e instanceof TimeoutWaitingForLockException) {
                    logger.warn(errorMessage, e);
                    TimeoutWaitingForLockException timeoutWaitingForLockException = (TimeoutWaitingForLockException)e;
                    timeoutWaitingForLockException.writeToLog(logger);
                }
                logger.error(errorMessage, e);
            }
        }
        long duration = System.currentTimeMillis() - transformStartTime;
        if (this.infoProviderMBean != null) {
            if (result != null) {
                this.infoProviderMBean.incrementTransformationTime(duration);
            } else {
                this.infoProviderMBean.incrementNonTransformationTime(duration);
            }
        }
        if (result == null && classBeingRedefined != null) {
            logger.info("Forcing replacement of unmodified class " + className);
            result = classfileBuffer;
        }
        return result;
    }

    private byte[] transformInBackgroundThread(IByteCodeTransformer byteCodeTransformer, ClassLoader loader, String className, Class<?> classBeingRedefined, byte[] classfileBuffer, IAgentScheduledThreadPoolExecutor threadPoolExecutor, Object module) throws InterruptedException {
        byte[] returnByteBuffer = null;
        CountDownLatch countdownLatch = new CountDownLatch(1);
        this.numActiveTransformTasks.incrementAndGet();
        BackgroundTransformerTask transformerThread = new BackgroundTransformerTask(byteCodeTransformer, loader, className, classBeingRedefined, classfileBuffer, countdownLatch, logger, this.numActiveTransformTasks, this, module);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Scheduling %s", transformerThread));
        }
        threadPoolExecutor.schedule(transformerThread, 0L, AgentTimeUnit.MILLISECONDS);
        if (countdownLatch.await(this.maxTimeToWaitForBackgroundTransform, TimeUnit.MILLISECONDS)) {
            returnByteBuffer = transformerThread.getTransformResult();
            this.transformLimitMap.remove(className);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("%s has completed.  returnByteBuffer is %s", transformerThread, returnByteBuffer == null ? "null" : "not null"));
            }
        } else {
            this.asyncLogger.warn(String.format("Unable to transform class %s.  %s timed out after %d seconds - ", className, transformerThread, this.maxTimeToWaitForBackgroundTransform / 1000L));
            byteCodeTransformer.notifyTransformationTimeout(className, loader, classBeingRedefined);
            if (this.infoProviderMBean != null) {
                this.infoProviderMBean.incrementNumTimedOutTransformations(1);
            }
            this.scheduleForReTransform(className, classfileBuffer, loader);
        }
        return returnByteBuffer;
    }

    private void scheduleForReTransform(String className, byte[] classFileBuffer, ClassLoader loader) {
        if (this.bciEngine.isRetransformClassesSupported() || this.bciEngine.isRedefineClassesSupported()) {
            if (!this.isRetransformLimitReached(className)) {
                this.bciEngine.getDeferredClassBCIHandler().scheduleForRetransform(className.replace('/', '.'), classFileBuffer, loader);
                this.asyncLogger.info(String.format("Class %s is scheduled for re-transformation", className));
            } else {
                this.asyncLogger.warn(String.format("Class %s cannot be retransformed because retransformation limit for the class was reached", className));
            }
        }
    }

    private boolean isRetransformLimitReached(String className) {
        ADInteger previousRetransformCount;
        ADInteger retransformCount = this.transformLimitMap.get(className);
        if (retransformCount == null && (previousRetransformCount = this.transformLimitMap.putIfAbsent(className, retransformCount = new ADInteger(0))) != null) {
            retransformCount = previousRetransformCount;
        }
        return retransformCount.incrementAndGet() > 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAgentScheduledThreadPoolExecutor getBCITransformThreadPoolExecutor() {
        IAgentScheduledThreadPoolExecutor returnValue = null;
        if (this.isAgentRemoteAttached && this.transformInBackgroundThread && this.shouldDoBackgroundTransformationsForGlassfish() && !this.usingBootClassLoader) {
            TransformationManager transformationManager = this;
            synchronized (transformationManager) {
                if (this.transformInBackgroundThread) {
                    this.createThreadPoolExecutor();
                    ++this.bciTransformThreadPoolExecutorUseCount;
                    returnValue = this.threadPoolExecutor;
                }
            }
        }
        return returnValue;
    }

    synchronized IAgentScheduledThreadPoolExecutor createThreadPoolExecutor() {
        if (this.threadPoolExecutor == null) {
            this.schedulerInstance.initBCITransformProcessor(this.threadPoolExecutorSize, (ILogger)logger);
            this.threadPoolExecutor = this.schedulerInstance.getBCITransformProcessor();
            if (this.maxTimeToRunTransformsInBackground > 0) {
                this.scheduleBackgroundTransformation();
            }
            this.bciTransformThreadPoolExecutorUseCount = 0;
            if (this.asyncLogger.isDebugEnabled()) {
                this.asyncLogger.debug(String.format("threadPoolExecutor %s has been created with %d threads", this.threadPoolExecutor, this.threadPoolExecutorSize));
            }
        }
        return this.threadPoolExecutor;
    }

    private synchronized void doneWithBCITransformThreadPoolExecutor(IAgentScheduledThreadPoolExecutor threadPoolExecutor) {
        if (this.threadPoolExecutor == threadPoolExecutor) {
            --this.bciTransformThreadPoolExecutorUseCount;
            if (this.bciTransformThreadPoolExecutorUseCount == 0) {
                if (logger.isTraceEnabled()) {
                    logger.trace("bciTransformThreadPoolExecutorUseCount has been reduced to 0 - notification will occur");
                }
                this.notify();
            }
        }
    }

    private synchronized void scheduleBackgroundTransformation() {
        this.terminateBackgroundTransformsFuture = this.globalScheduler.schedule(new IAgentRunnable(){

            public void run() {
                TransformationManager.this.setTransformInBackgroundThread(false);
            }
        }, (long)this.maxTimeToRunTransformsInBackground, AgentTimeUnit.SECONDS);
    }

    synchronized void setTransformInBackgroundThread(boolean newTransformInBackgroundThread) {
        if (this.transformInBackgroundThread != newTransformInBackgroundThread && this.shouldDoBackgroundTransformationsForGlassfish() && !this.usingBootClassLoader) {
            this.transformInBackgroundThread = newTransformInBackgroundThread;
            if (!this.transformInBackgroundThread) {
                try {
                    if (this.threadPoolExecutor != null) {
                        while (this.bciTransformThreadPoolExecutorUseCount > 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(String.format("bciTransformThreadPoolExecutorUseCount has value %d.  Waiting for it to reach 0", this.bciTransformThreadPoolExecutorUseCount));
                            }
                            this.wait();
                        }
                        this.schedulerInstance.terminateBCITransformProcessor();
                        this.threadPoolExecutor = null;
                        if (this.terminateBackgroundTransformsFuture != null) {
                            this.terminateBackgroundTransformsFuture.cancel(false);
                            this.terminateBackgroundTransformsFuture = null;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("threadPoolExecutor for background BCI transforms has been terminated");
                        }
                    }
                }
                catch (InterruptedException e) {
                    String errorMessage = String.format("Caught %s trying to shutdown BCITransform ThreadPool", e);
                    this.asyncLogger.error(errorMessage, (Throwable)e);
                }
            }
        }
        this.asyncLogger.info(String.format("Class transformations %s take place in a background thread", this.transformInBackgroundThread && this.shouldDoBackgroundTransformationsForGlassfish() ? "will" : "will not"));
    }

    boolean shouldDoBackgroundTransformationsForGlassfish() {
        return this.useBackgroundTransformationsForGlassfish || !this.bciEngine.isGlassfish();
    }

    void timeoutAsyncBCIForClass(String className) {
        if (this.classesToTimeoutAsyncBCI == null) {
            this.classesToTimeoutAsyncBCI = new HashSet<String>();
        }
        this.classesToTimeoutAsyncBCI.add(className.replace('.', '/'));
    }

    boolean shouldTimeoutAsyncBCIForClass(String className) {
        boolean bReturn = false;
        if (this.classesToTimeoutAsyncBCI != null) {
            bReturn = this.classesToTimeoutAsyncBCI.contains(className.replace('.', '/'));
        }
        return bReturn;
    }

    void determineTimeOfDayOKToRunNonBootstrapSync() {
        this.timeOfDayOKToRunNonBootstrapSync = System.currentTimeMillis() + (long)this.maxTimeToRunNonBootstrapTransformsInBackground * 1000L;
    }

    void setMaxConcurrentBackgroundTransforms(int maxConcurrentBackgroundTransforms) {
        this.maxConcurrentBackgroundTransforms = maxConcurrentBackgroundTransforms;
    }

    void setMaxTimeToRunNonBootstrapTransformsInBackground(int maxTimeToRunNonBootstrapTransformsInBackground) {
        this.maxTimeToRunNonBootstrapTransformsInBackground = maxTimeToRunNonBootstrapTransformsInBackground;
    }

    void setMaxTimeToRunTransformsInBackground(int maxTimeToRunTransformsInBackground) {
        this.maxTimeToRunTransformsInBackground = maxTimeToRunTransformsInBackground;
    }

    void setThreadPoolExecutorSize(int threadPoolExecutorSize) {
        this.threadPoolExecutorSize = threadPoolExecutorSize;
    }

    void setMaxTimeToWaitForBackgroundTransform(long maxTimeToWaitForBackgroundTransform) {
        this.maxTimeToWaitForBackgroundTransform = maxTimeToWaitForBackgroundTransform;
    }

    void setThreadPoolExecutorSizeFromString(String threadPoolExecutorSizeString) {
        this.threadPoolExecutorSize = StringOperations.safeParseInteger((String)threadPoolExecutorSizeString, (int)this.threadPoolExecutorSize);
    }

    void setMaxConcurrentBackgroundTransformsFromString(String maxConcurrentBackgroundTransformsString) {
        this.maxConcurrentBackgroundTransforms = StringOperations.safeParseInteger((String)maxConcurrentBackgroundTransformsString, (int)this.maxConcurrentBackgroundTransforms);
    }

    void setMaxTimeToRunTransformsInBackgroundFromString(String maxTimeToRunTransformsInBackgroundString) {
        this.maxTimeToRunTransformsInBackground = StringOperations.safeParseInteger((String)maxTimeToRunTransformsInBackgroundString, (int)this.maxTimeToRunTransformsInBackground);
    }

    void setMaxTimeToWaitForBackgroundTransformFromString(String maxTimeToWaitForBackgroundTransformString) {
        this.maxTimeToWaitForBackgroundTransform = StringOperations.safeParseLong((String)maxTimeToWaitForBackgroundTransformString, (long)this.maxTimeToWaitForBackgroundTransform);
    }

    void setMaxTimeToRunNonBootstrapTransformsInBackgroundFromString(String maxTimeToRunNonBootstrapTransformsInBackgroundFromString) {
        this.maxTimeToRunNonBootstrapTransformsInBackground = StringOperations.safeParseInteger((String)maxTimeToRunNonBootstrapTransformsInBackgroundFromString, (int)this.maxTimeToRunNonBootstrapTransformsInBackground);
    }

    long getMaxTimeToWaitForBackgroundTransform() {
        return this.maxTimeToWaitForBackgroundTransform;
    }

    void setUseBackgroundTransformationsForGlassfish(boolean useBackgroundTransformationsForGlassfish) {
        this.useBackgroundTransformationsForGlassfish = useBackgroundTransformationsForGlassfish;
    }

    void setTransformInBackgroundThreadFromString(String transformInBackgroundThreadString) {
        boolean transformInBackgroundThread = StringOperations.safeParseBoolean((String)transformInBackgroundThreadString, (boolean)this.transformInBackgroundThread);
        this.setTransformInBackgroundThread(transformInBackgroundThread);
    }

    private IBCIEngineInfoProvider determineInfoProvider() {
        this.infoProviderMBean = this.bciEngine.getInfoProvider();
        return this.infoProviderMBean;
    }

    private synchronized void createTransformLimitMap() {
        if (this.transformLimitMap == null) {
            this.transformLimitMap = new BoundedConcurrentHashMap(500, SharedBoundsEnforcer.DEFAULT_POLICY);
        }
    }
}

