/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.InterceptorClassRegistryBoot;
import com.singularity.ee.agent.appagent.kernel.spi.data.IServiceConfigData;
import com.singularity.ee.agent.appagent.services.bciengine.ASMTypes;
import com.singularity.ee.agent.appagent.services.bciengine.BCILock;
import com.singularity.ee.agent.appagent.services.bciengine.ClassIdentificationNotifier;
import com.singularity.ee.agent.appagent.services.bciengine.ISystemExcludeManager;
import com.singularity.ee.agent.appagent.services.bciengine.InstrumentationTracker;
import com.singularity.ee.agent.appagent.services.bciengine.TimeoutWaitingForLockException;
import com.singularity.ee.agent.appagent.services.bciengine.TranformationInfoCache;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.ClassIdentificationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.CustomExclude;
import com.singularity.ee.agent.appagent.services.bciengine.spi.ITransformationRuleEngine;
import com.singularity.ee.agent.appagent.services.bciengine.spi.RetransformationExclude;
import com.singularity.ee.agent.appagent.services.bciengine.spi.SystemExcludeOverride;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationLimitExceededException;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ByteCodeClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.MethodInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.bytecodeclassfilters.ALLByteCodeClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MatchClassNameFilter;
import com.singularity.ee.agent.debug.events.AgentDebugEvent;
import com.singularity.ee.agent.debug.events.AgentDebugTransformationEvent;
import com.singularity.ee.agent.debug.spi.IAgentDebugEventSenderBase;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.reflect.ReflectionException;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import com.singularity.ee.util.dtobootimpl.StringMatchBootType;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.javaspecific.collections.ADHashSet;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class TransformationRuleEngine
implements ITransformationRuleEngine {
    private final IADLogger fileLogger = ADLoggerFactory.getLogger("com.singularity.bci.TransformationRuleEngine");
    private static final List<AClassTransformationRule> EMPTY_TRANSFORMATION_RULE_LIST = new ArrayList<AClassTransformationRule>(0);
    private static final TransformationRule[] EMPTY_TRANSFORMATION_RULE_ARRAY = new TransformationRule[0];
    private final ADHashSet<AClassTransformationRule> transformationRules;
    private final Set<ClassIdentificationRule> identificationRules;
    private ClassIdentificationNotifier identificationNotifier;
    private ISystemExcludeManager systemExcludeManager;
    private final BCILock lock;
    private boolean transformerDisabled = false;
    private List<String> excludeInterceptors = Collections.EMPTY_LIST;
    private Map<String, Set<AClassTransformationRule>> classNameMatchRules;
    private final AtomicReference<Set<String>> instructionsDebugClassMethods = new AtomicReference<Object>(null);
    private ADConcurrentHashMap<ClassMethodFilter, ClassMethodFilter> classMethodFiltersWithMidInterceptor = new ADConcurrentHashMap();
    private ADConcurrentHashMap<Integer, TransformationRule> midMethodIdToRule = new ADConcurrentHashMap();
    private AtomicInteger currMidMethodId = new AtomicInteger(-1);
    private final TranformationInfoCache tranformationInfoCache;
    private final IAgentDebugEventSenderBase debugEventSender;
    private boolean excludeNonClassTypeForTransformation = false;

    public TransformationRuleEngine(ISystemExcludeManager systemExcludeManager, IAgentScheduledExecutorService globalScheduler, TranformationInfoCache tranformationInfoCache, IAgentDebugEventSenderBase debugEventSender) {
        this.lock = new BCILock("TransformationRuleEngine");
        this.transformationRules = new ADHashSet<AClassTransformationRule>(){

            public boolean add(AClassTransformationRule o) {
                return super.add((Object)o);
            }
        };
        this.identificationRules = new HashSet<ClassIdentificationRule>();
        this.classNameMatchRules = new HashMap<String, Set<AClassTransformationRule>>();
        this.identificationNotifier = new ClassIdentificationNotifier(globalScheduler);
        this.systemExcludeManager = systemExcludeManager;
        this.tranformationInfoCache = tranformationInfoCache;
        this.debugEventSender = debugEventSender;
    }

    public void setExcludeInterceptors(List<String> excludeInterceptors) {
        this.excludeInterceptors = excludeInterceptors;
    }

    @Override
    public TransformationInfo getTransformationInfo(int transformationId) {
        return this.tranformationInfoCache.getTransformationInfo(transformationId);
    }

    @Override
    public TranformationInfoCache getTranformationInfoCache() {
        return this.tranformationInfoCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsRule(AClassTransformationRule rule) throws TimeoutWaitingForLockException {
        this.lock.synchronize();
        try {
            String className = this.getClassNameIfMatchClassNameRule(rule);
            if (className != null && this.classNameMatchRules.get(className) != null) {
                boolean bl = this.classNameMatchRules.get(className).contains(rule);
                return bl;
            }
            boolean bl = this.transformationRules.contains((Object)rule);
            return bl;
        }
        finally {
            this.lock.unsynchronize();
        }
    }

    @Override
    public void registerTransformationRule(AClassTransformationRule rule) {
        try {
            this.registerTransformationRuleInternal(rule, true);
        }
        catch (TimeoutWaitingForLockException e) {
            BCTLoggerUtil.printStackTrace(e);
        }
    }

    @Override
    public void registerTransformationRuleIfAbsent(AClassTransformationRule rule) {
        try {
            this.registerTransformationRuleInternal(rule, false);
        }
        catch (TimeoutWaitingForLockException e) {
            BCTLoggerUtil.printStackTrace(e);
        }
    }

    @Override
    public void registerTransformationRulesIfAbsent(Set<? extends AClassTransformationRule> rules) {
        try {
            for (AClassTransformationRule aClassTransformationRule : rules) {
                this.registerTransformationRuleInternal(aClassTransformationRule, false);
            }
        }
        catch (TimeoutWaitingForLockException e) {
            BCTLoggerUtil.printStackTrace(e);
        }
    }

    /*
     * Exception decompiling
     */
    private void registerTransformationRuleInternal(AClassTransformationRule rule, boolean logWarningIfNotPresent) throws TimeoutWaitingForLockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void unregisterTransformationRule(AClassTransformationRule rule) {
        try {
            this.unregisterTransformationRuleInternal(rule, true);
        }
        catch (TimeoutWaitingForLockException e) {
            BCTLoggerUtil.printStackTrace(e);
        }
    }

    @Override
    public void unregisterTransformationRulesIfPresent(Set<? extends AClassTransformationRule> rules) {
        try {
            for (AClassTransformationRule aClassTransformationRule : rules) {
                this.unregisterTransformationRuleInternal(aClassTransformationRule, false);
            }
        }
        catch (TimeoutWaitingForLockException e) {
            BCTLoggerUtil.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterTransformationRuleInternal(AClassTransformationRule rule, boolean logWarningIfNotPresent) throws TimeoutWaitingForLockException {
        this.lock.synchronize();
        try {
            String className = this.getClassNameIfMatchClassNameRule(rule);
            if (className != null) {
                this.unregisterClassNameMatchRule(className, rule, logWarningIfNotPresent);
                return;
            }
            boolean remove = this.transformationRules.remove((Object)rule);
            if (logWarningIfNotPresent && !remove) {
                this.fileLogger.warn("Transformation rule NOT registered", new IllegalArgumentException("Transformation Rule not registered : " + rule));
            }
        }
        finally {
            this.lock.unsynchronize();
        }
    }

    private String getClassNameIfMatchClassNameRule(AClassTransformationRule rule) {
        ClassMethodFilter filter = rule.getFilter();
        if (filter instanceof MatchClassNameFilter && ((MatchClassNameFilter)filter).getClassMatch().getMatchType() == StringMatchBootType.EQUALS) {
            return ((MatchClassNameFilter)filter).getClassMatch().getMatchPattern().replace('.', '/');
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerClassNameMatchRule(String className, AClassTransformationRule rule, boolean logWarningIfNotPresent) throws TimeoutWaitingForLockException {
        this.lock.synchronize();
        try {
            Set<AClassTransformationRule> rules = this.classNameMatchRules.get(className);
            if (rules == null) {
                rules = new HashSet<AClassTransformationRule>();
                this.classNameMatchRules.put(className, rules);
            }
            if (logWarningIfNotPresent && rules.contains(rule)) {
                this.fileLogger.warn("Match Class name rule already registered ", new IllegalArgumentException("Already registered Rule +" + rule));
                return;
            }
            rules.add(rule);
            this.registerRule(rule);
        }
        finally {
            this.lock.unsynchronize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unregisterClassNameMatchRule(String className, AClassTransformationRule rule, boolean logWarningIfNotPresent) throws TimeoutWaitingForLockException {
        this.lock.synchronize();
        try {
            Set<AClassTransformationRule> ruleSet = this.classNameMatchRules.get(className);
            if (ruleSet == null) {
                this.fileLogger.warn("No class name match rule to unregister for class name [" + className + "] ");
                boolean bl = false;
                return bl;
            }
            boolean remove = ruleSet.remove(rule);
            if (logWarningIfNotPresent && !remove) {
                this.fileLogger.warn("No class name match rule to unregister " + rule);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unsynchronize();
        }
    }

    private void registerRule(AClassTransformationRule rule) {
        StringMatchBoot classMatch;
        ClassMethodFilter filter = rule.getFilter();
        if (filter instanceof MatchClassNameFilter && this.isSystemExclude((classMatch = ((MatchClassNameFilter)filter).getClassMatch()).getMatchPattern())) {
            this.overrideSystemExclude(new SystemExcludeOverride(classMatch));
        }
        if (rule instanceof TransformationRule) {
            Class<? extends AMethodInterceptor> interceptor = ((TransformationRule)rule).getInterceptor();
            InterceptorClassRegistryBoot.bindClass((String)ASMTypes.getInstance().getInternalName(interceptor), interceptor);
            if (((TransformationRule)rule).hasMidMethodInterceptor()) {
                this.classMethodFiltersWithMidInterceptor.put((Object)filter, (Object)filter);
            }
        }
    }

    @Override
    public TransformationRule getRuleFromMidMethodId(int midMethodId) {
        return (TransformationRule)this.midMethodIdToRule.get((Object)midMethodId);
    }

    @Override
    public void registerClassIdentificationRule(ClassIdentificationRule rule) {
        this.identificationRules.add(rule);
    }

    @Override
    public void unregisterClassIdentificationRule(ClassIdentificationRule rule) {
        try {
            this.unregisterClassIdentificationRuleInternal(rule);
        }
        catch (TimeoutWaitingForLockException e) {
            BCTLoggerUtil.printStackTrace(e);
        }
    }

    private void unregisterClassIdentificationRuleInternal(ClassIdentificationRule rule) throws TimeoutWaitingForLockException {
        this.lock.synchronize();
        try {
            this.identificationRules.remove(rule);
        }
        finally {
            this.lock.unsynchronize();
        }
    }

    @Override
    public void overrideSystemExclude(SystemExcludeOverride excludeOverride) {
        this.systemExcludeManager.overrideSystemExclude(excludeOverride);
    }

    @Override
    public void overrideSystemExcludes(Set<SystemExcludeOverride> excludeOverrides) {
        for (SystemExcludeOverride excludeOverride : excludeOverrides) {
            this.systemExcludeManager.overrideSystemExclude(excludeOverride);
        }
    }

    @Override
    public boolean isSystemExclude(String className) {
        return this.systemExcludeManager.isSystemExcludePackage(className);
    }

    @Override
    public void removeSystemExcludeOverride(SystemExcludeOverride excludeOverride) {
        this.systemExcludeManager.removeSystemExcludeOverride(excludeOverride);
    }

    @Override
    public void removeSystemExcludeOverrides(Set<SystemExcludeOverride> excludeOverrides) {
        for (SystemExcludeOverride excludeOverride : excludeOverrides) {
            this.systemExcludeManager.removeSystemExcludeOverride(excludeOverride);
        }
    }

    @Override
    public void addCustomExclude(CustomExclude customExclude) {
        this.systemExcludeManager.addCustomExclude(customExclude);
    }

    @Override
    public void removeCustomExclude(CustomExclude customExclude) {
        this.systemExcludeManager.removeCustomExclude(customExclude);
    }

    @Override
    public void addRetransformationExclude(RetransformationExclude retransformationExclude) {
        this.systemExcludeManager.addRetransformationExclude(retransformationExclude);
    }

    @Override
    public void removeRetransformationExclude(RetransformationExclude retransformationExclude) {
        this.systemExcludeManager.removeRetransformationExclude(retransformationExclude);
    }

    private boolean isInterceptorExcluded(Class clazz) {
        return this.excludeInterceptors != null && this.excludeInterceptors.contains(InterceptorClassRegistryBoot.getInterceptorName((Class)clazz));
    }

    public void setExcludeNonClassTypeForTransformation(boolean value) {
        this.excludeNonClassTypeForTransformation = value;
        if (this.excludeNonClassTypeForTransformation) {
            BCTLoggerUtil.warn("Disable transformation of non class types (annotations, interfaces & enums)");
        }
    }

    public boolean hasMidMethodInterceptors(BasicClassInfo classInfo, MethodInfo methodInfo) {
        for (ClassMethodFilter filter : this.classMethodFiltersWithMidInterceptor.keySet()) {
            if (!filter.getBasicClassFilter().matchClass(classInfo) || !filter.getMethodFilter().matchMethod(methodInfo)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AClassTransformationRule[] checkBasicClassFilters(BasicClassInfo basicClassInfo) throws TimeoutWaitingForLockException {
        this.lock.synchronize();
        try {
            AClassTransformationRule[] aClassTransformationRuleArray;
            BCTLoggerUtil.matchingClassname(basicClassInfo.getClassName() + TransformationRuleEngine.getClassLoaderString(basicClassInfo.getLoader()));
            List<AClassTransformationRule> matchedRules = EMPTY_TRANSFORMATION_RULE_LIST;
            Set<AClassTransformationRule> classMatchRules = this.classNameMatchRules.get(basicClassInfo.getClassName());
            if (classMatchRules != null) {
                for (AClassTransformationRule rule : classMatchRules) {
                    if (!this.checkBasicClassFilter(rule, basicClassInfo)) continue;
                    if (matchedRules == EMPTY_TRANSFORMATION_RULE_LIST) {
                        matchedRules = new ArrayList<AClassTransformationRule>();
                    }
                    matchedRules.add(rule);
                }
            }
            for (AClassTransformationRule rule : this.transformationRules) {
                if (!this.checkBasicClassFilter(rule, basicClassInfo)) continue;
                if (matchedRules == EMPTY_TRANSFORMATION_RULE_LIST) {
                    matchedRules = new ArrayList<AClassTransformationRule>();
                }
                matchedRules.add(rule);
            }
            BCTLoggerUtil.classMatchFound(matchedRules.size() > 0);
            if (matchedRules == EMPTY_TRANSFORMATION_RULE_LIST) {
                aClassTransformationRuleArray = EMPTY_TRANSFORMATION_RULE_ARRAY;
                return aClassTransformationRuleArray;
            }
            aClassTransformationRuleArray = matchedRules.toArray(new AClassTransformationRule[matchedRules.size()]);
            return aClassTransformationRuleArray;
        }
        finally {
            this.lock.unsynchronize();
        }
    }

    private boolean checkBasicClassFilter(AClassTransformationRule rule, BasicClassInfo basicClassInfo) {
        Class<? extends AMethodInterceptor> interceptor;
        boolean matches = rule.getFilter().getBasicClassFilter().matchClassWithLogging(basicClassInfo);
        if (matches && rule instanceof TransformationRule && this.isInterceptorExcluded(interceptor = ((TransformationRule)rule).getInterceptor())) {
            matches = false;
            BCTLoggerUtil.interceptorDisabled(interceptor.getName(), rule.toString());
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassIdentificationRule[] checkBasicClassIdentificationFilters(BasicClassInfo basicClassInfo) throws TimeoutWaitingForLockException {
        this.lock.synchronize();
        try {
            BCTLoggerUtil.matchingClassnameIdentification(basicClassInfo.getClassName());
            ArrayList<ClassIdentificationRule> matchedRules = new ArrayList<ClassIdentificationRule>();
            for (ClassIdentificationRule classIdentificationRule : this.identificationRules) {
                if (!classIdentificationRule.getFilter().getBasicClassFilter().matchClassWithLogging(basicClassInfo)) continue;
                if (classIdentificationRule.getFilter().getByteCodeClassFilter() instanceof ALLByteCodeClassFilter) {
                    BCTLoggerUtil.classIdentified(basicClassInfo.getClassName());
                    this.identificationNotifier.sendClassIdentification(basicClassInfo, classIdentificationRule);
                    continue;
                }
                matchedRules.add(classIdentificationRule);
            }
            ClassIdentificationRule[] classIdentificationRuleArray = matchedRules.toArray(new ClassIdentificationRule[matchedRules.size()]);
            return classIdentificationRuleArray;
        }
        finally {
            this.lock.unsynchronize();
        }
    }

    @Override
    public AClassTransformationRule[] checkByteCodeClassFilters(BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, ByteCodeClassInfo byteCodeClassInfo, AClassTransformationRule[] previousMatchedRules) {
        BCTLoggerUtil.matchingClassBytecode();
        ArrayList<AClassTransformationRule> matchedRules = new ArrayList<AClassTransformationRule>();
        for (AClassTransformationRule rule : previousMatchedRules) {
            if (!rule.getFilter().getByteCodeClassFilter().matchClassWithLogging(basicClassInfo, runtimeClassInfo, byteCodeClassInfo)) continue;
            matchedRules.add(rule);
        }
        BCTLoggerUtil.classMatchFound(matchedRules.size() > 0);
        return matchedRules.toArray(new AClassTransformationRule[matchedRules.size()]);
    }

    @Override
    public TransformationRule[] checkByteCodeClassFilters(BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, ByteCodeClassInfo byteCodeClassInfo, TransformationRule[] previousMatchedRules) {
        BCTLoggerUtil.matchingClassBytecode();
        ArrayList<TransformationRule> matchedRules = new ArrayList<TransformationRule>();
        for (TransformationRule rule : previousMatchedRules) {
            if (!rule.getFilter().getByteCodeClassFilter().matchClassWithLogging(basicClassInfo, runtimeClassInfo, byteCodeClassInfo)) continue;
            matchedRules.add(rule);
        }
        BCTLoggerUtil.classMatchFound(matchedRules.size() > 0);
        return matchedRules.toArray(new TransformationRule[matchedRules.size()]);
    }

    public void checkByteCodeClassIdentificationFilters(BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, ByteCodeClassInfo byteCodeClassInfo, ClassIdentificationRule[] previousMatchedRules) {
        for (ClassIdentificationRule rule : previousMatchedRules) {
            if (!rule.getFilter().getByteCodeClassFilter().matchClassWithLogging(basicClassInfo, runtimeClassInfo, byteCodeClassInfo)) continue;
            BCTLoggerUtil.classIdentified(basicClassInfo.getClassName());
            this.identificationNotifier.sendClassIdentification(basicClassInfo, runtimeClassInfo, byteCodeClassInfo, rule);
        }
    }

    public AClassTransformationRule[] checkRuntimeClassFilters(BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, AClassTransformationRule[] previousMatchedRules) {
        boolean ignoreBCIForNonClassTypes;
        BCTLoggerUtil.matchingRuntimeClass();
        ArrayList<AClassTransformationRule> matchedRules = new ArrayList<AClassTransformationRule>();
        boolean bl = ignoreBCIForNonClassTypes = runtimeClassInfo.getHelper().isNonClassType() && this.excludeNonClassTypeForTransformation;
        if (!ignoreBCIForNonClassTypes) {
            for (AClassTransformationRule rule : previousMatchedRules) {
                if (!rule.getFilter().getRuntimeClassFilter().matchClassWithLogging(basicClassInfo, runtimeClassInfo)) continue;
                matchedRules.add(rule);
            }
        }
        BCTLoggerUtil.classMatchFound(matchedRules.size() > 0);
        return matchedRules.toArray(new AClassTransformationRule[matchedRules.size()]);
    }

    public boolean checkBasicMethodMatchForRule(AClassTransformationRule rule, String className, MethodInfo methodInfo, boolean traceEnabledForMethod) {
        if (rule.getFilter().getMethodFilter().matchMethodWithLogging(methodInfo)) {
            if (traceEnabledForMethod) {
                BCTLoggerUtil.println(String.format("%s matches class %s and MethodInfo %s", rule, className, methodInfo));
            }
            if (rule.getBlackListedClassMethodFilter().excludeClassAndMethodCall(className, methodInfo.getName(), methodInfo.getDesc())) {
                if (traceEnabledForMethod) {
                    BCTLoggerUtil.println(String.format("%s is excluded for Blacklisted class %s and MethodInfo %s", rule, className, methodInfo));
                }
                return false;
            }
            if (rule.getExcludedClassMethodFilter().excludeClassAndMethodCall(className, methodInfo.getName(), methodInfo.getDesc())) {
                if (traceEnabledForMethod) {
                    BCTLoggerUtil.println(String.format("%s is excluded for class %s and MethodInfo %s", rule, className, methodInfo));
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public TransformationInfo[] checkUltimateMethodMatch(String className, ClassLoader classLoader, TransformationRule[] classMatchingTransformationRules, MethodInfo methodInfo, boolean traceEnabledForMethod) {
        if (traceEnabledForMethod && classMatchingTransformationRules != null && classMatchingTransformationRules.length > 0) {
            BCTLoggerUtil.println(String.format("The following TransformationRules passed to checkUltimateMethodMatch() for class %s and MethodInfo %s", className, methodInfo));
            for (TransformationRule rule : classMatchingTransformationRules) {
                BCTLoggerUtil.println(String.format("   %s", rule));
            }
        }
        String methodName = methodInfo.getName() + " (" + methodInfo.getDesc() + ")";
        BCTLoggerUtil.matchingMethod(methodName);
        HashMap<String, TransformationInfo> interceptorClassNameVsTransformationInfo = new HashMap<String, TransformationInfo>();
        for (TransformationRule interceptorRule : classMatchingTransformationRules) {
            if (!this.checkBasicMethodMatchForRule(interceptorRule, className, methodInfo, traceEnabledForMethod)) continue;
            Class<? extends AMethodInterceptor> interceptor = interceptorRule.getInterceptor();
            String interceptorClassName = interceptor.getName();
            if (this.isInterceptorExcluded(interceptor)) {
                BCTLoggerUtil.interceptorDisabled(interceptorClassName, interceptorRule.toString());
                continue;
            }
            try {
                TransformationInfo transformationInfo;
                interceptorRule.checkShouldApplyToClass(className, classLoader);
                if (interceptorRule.hasMidMethodInterceptor()) {
                    int midMethodId = this.getMidMethodId();
                    this.midMethodIdToRule.put((Object)midMethodId, (Object)interceptorRule);
                    interceptorRule.getMidMethodInfo().setMidMethodId(midMethodId);
                }
                if ((transformationInfo = (TransformationInfo)interceptorClassNameVsTransformationInfo.get(interceptorClassName)) == null) {
                    int transformationId = this.getTransformationId(interceptor);
                    int priority = this.getInterceptorPriority(interceptor);
                    transformationInfo = this.createTransformationInfo(interceptor, transformationId, priority, className, methodInfo);
                    interceptorClassNameVsTransformationInfo.put(interceptorClassName, transformationInfo);
                    interceptorRule.notifyRuleListeners(className, methodInfo, transformationId);
                    this.tranformationInfoCache.putTransformationInfo(transformationId, transformationInfo);
                    String interceptorDescription = InterceptorClassRegistryBoot.getInterceptorDescription(interceptor);
                    BCTLoggerUtil.applyingMethodInterceptor(className, methodName, interceptorDescription, transformationId);
                    if (this.debugEventSender.hasTransformationListener()) {
                        this.debugEventSender.onEvent((AgentDebugEvent)new AgentDebugTransformationEvent("transform", className, methodName, interceptorDescription));
                    }
                }
                transformationInfo.addMatchingTransformationRule(interceptorRule);
                InstrumentationTracker.trackInstrumentationForClass(className, interceptorRule);
                interceptorRule.addModifiedClassName(className);
                if (!traceEnabledForMethod) continue;
                BCTLoggerUtil.println(String.format("%s notified for match with class %s and MethodInfo %s", interceptorRule, className, methodInfo));
            }
            catch (TransformationLimitExceededException e) {
                BCTLoggerUtil.methodLimitedFromTransformation(e.getMessage());
            }
            catch (ReflectionException e) {
                BCTLoggerUtil.error("Exception caught ", e);
            }
        }
        TreeSet sortedByPriority = new TreeSet(interceptorClassNameVsTransformationInfo.values());
        return sortedByPriority.toArray(new TransformationInfo[sortedByPriority.size()]);
    }

    private int getTransformationId(Class<? extends AMethodInterceptor> interceptor) {
        return this.tranformationInfoCache.getTransformationId(interceptor);
    }

    private int getMidMethodId() {
        return this.currMidMethodId.incrementAndGet();
    }

    private int getInterceptorPriority(Class<? extends AMethodInterceptor> interceptor) {
        try {
            return InterceptorClassRegistryBoot.getInterceptorPriority(interceptor);
        }
        catch (Exception e) {
            BCTLoggerUtil.warn("Unexpected error: Method getPriority() not found in " + interceptor.getName());
            return 0;
        }
    }

    private TransformationInfo createTransformationInfo(Class<? extends AMethodInterceptor> interceptor, int transformationId, int priority, String className, MethodInfo methodInfo) throws ReflectionException {
        TransformationInfo transformationInfo = new TransformationInfo(transformationId, interceptor, new ArrayList<TransformationRule>(), priority, className, methodInfo);
        return transformationInfo;
    }

    public void setSystemExecludesFromConfigXML(IServiceConfigData serviceConfigData) {
        this.systemExcludeManager.setSystemExcludesFromConfigXML(serviceConfigData);
    }

    @Override
    public boolean excludeFromProcessing(Class clazz, ClassLoader loader) {
        if (clazz.isAnnotation() || clazz.isInterface() || clazz.isEnum() || clazz.isPrimitive() || clazz.getName().startsWith("[")) {
            return true;
        }
        String bciClassName = clazz.getName().replace('.', '/');
        return this.excludeFromProcessing(bciClassName, clazz.getClassLoader());
    }

    @Override
    public boolean excludeFromProcessing(String className, ClassLoader loader) {
        return this.systemExcludeManager.excludeClass(className, loader);
    }

    @Override
    public boolean excludeFromRetransformation(Class<?> clazz) {
        return this.systemExcludeManager.excludeClassFromRetransformation(clazz);
    }

    public boolean excludeFromProcessing(String className, String methodName) {
        return this.systemExcludeManager.excludeSpecificMethod(className, methodName);
    }

    public static String getClassLoaderString(ClassLoader loader) {
        if (loader == null) {
            return " [ClassLoader: Bootstrap]";
        }
        return " [ClassLoader]" + loader.getClass().getName() + "[hashcode]" + loader.hashCode();
    }

    @Override
    public void setTransformerDisabled(boolean transformerDisabled) {
        this.transformerDisabled = transformerDisabled;
        if (transformerDisabled) {
            BCTLoggerUtil.warn("Class File Transformer disabled, no classes will be instrumented");
        }
    }

    @Override
    public boolean isTransformerDisabled() {
        return this.transformerDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AClassTransformationRule> getTransformationRules() throws TimeoutWaitingForLockException {
        HashSet<AClassTransformationRule> rules = null;
        this.lock.synchronize();
        try {
            rules = new HashSet<AClassTransformationRule>((Collection<AClassTransformationRule>)this.transformationRules);
            for (Set<AClassTransformationRule> transformationRuleSet : this.classNameMatchRules.values()) {
                rules.addAll(transformationRuleSet);
            }
        }
        finally {
            this.lock.unsynchronize();
        }
        return rules;
    }

    @Override
    public Set<ClassIdentificationRule> getClassIdentificationRules() {
        return new HashSet<ClassIdentificationRule>(this.identificationRules);
    }

    public boolean enableOpcodeDebug(String className, String name) {
        Set<String> set = this.instructionsDebugClassMethods.get();
        String replace = className.replace('/', '.');
        return set != null && (set.contains(replace + "/" + name) || set.contains(replace + "/*"));
    }

    public String[] printInstructions(List<String> strings) {
        HashSet<String> opcodeDebugStrings = new HashSet<String>();
        ArrayList<String> classesToRetransform = new ArrayList<String>();
        for (int i = 0; i < strings.size(); ++i) {
            String classMethod = strings.get(i);
            int index = classMethod.indexOf(47);
            if (index != -1) {
                String className = classMethod.substring(0, index);
                classesToRetransform.add(className);
                opcodeDebugStrings.add(classMethod);
                continue;
            }
            BCTLoggerUtil.warn("Bad format for print-instructions:" + classMethod);
        }
        this.instructionsDebugClassMethods.set(opcodeDebugStrings);
        return classesToRetransform.toArray(new String[classesToRetransform.size()]);
    }

    public void replaceTransformationRules(Class<?> clazz, List<AClassTransformationRule[]> listOfRulesToReplace) {
        this.tranformationInfoCache.replaceTransformationRules(clazz, listOfRulesToReplace);
    }

    @Override
    public boolean isOverrideSystemExclude(SystemExcludeOverride excludeOverride) {
        return this.systemExcludeManager.isOverrideSystemExclude(excludeOverride);
    }

    public BCILock getLock() {
        return this.lock;
    }
}

