/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine;

import com.singularity.ee.agent.appagent.entrypoint.bciengine.AMethodInterceptor;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.FastInterceptorClassRegistryBoot;
import com.singularity.ee.agent.appagent.java9.IJava9Util;
import com.singularity.ee.agent.appagent.kernel.bootimpl.InterceptorClassRegistry;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ClassMethodFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.builtin.basicclasssfilters.ModuleNameMatchClassFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MatchClassAnnotationFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MatchClassNameFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MatchInterfaceFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MatchSuperClassNameFilter;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.complex.MethodInfo;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.dtobootimpl.POJOMatchTypeBoot;
import com.singularity.ee.util.dtobootimpl.POJOMethodDefinitionBoot;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import com.singularity.ee.util.dtobootimpl.StringMatchBootType;
import java.util.Arrays;
import java.util.List;

public class TransformationRuleHelper {
    public static ClassMethodFilter createClassMethodFilter(POJOMatchTypeBoot matchType, String className, String methodName, List<String> methodParams, boolean matchNoArgsOnly, String returnType, String moduleName, IADLogger logger, IJava9Util java9Util) {
        ClassMethodFilter classMethodFilter;
        switch (matchType) {
            case MATCHES_CLASS: {
                classMethodFilter = matchNoArgsOnly || methodParams == null || methodParams.isEmpty() ? new MatchClassNameFilter(className, new StringMatchBoot(StringMatchBootType.EQUALS, methodName), matchNoArgsOnly) : new MatchClassNameFilter(className, TransformationRuleHelper.getMethodInfo(methodName, methodParams, returnType));
                if (!logger.isDebugEnabled()) break;
                logger.debug("added match class name rule for[" + className + "] - method name [" + methodName + "]");
                break;
            }
            case IMPLEMENTS_INTERFACE: {
                classMethodFilter = methodParams == null || methodParams.isEmpty() ? new MatchInterfaceFilter(className, new StringMatchBoot(StringMatchBootType.EQUALS, methodName)) : new MatchInterfaceFilter(className, TransformationRuleHelper.getMethodInfo(methodName, methodParams, returnType));
                if (!logger.isDebugEnabled()) break;
                logger.debug("added match interface rule for[" + className + "] - method name [" + methodName + "]");
                break;
            }
            case INHERITS_FROM_CLASS: {
                classMethodFilter = methodParams == null || methodParams.isEmpty() ? new MatchSuperClassNameFilter(className, new StringMatchBoot(StringMatchBootType.EQUALS, methodName)) : new MatchSuperClassNameFilter(className, TransformationRuleHelper.getMethodInfo(methodName, methodParams, returnType));
                if (!logger.isDebugEnabled()) break;
                logger.debug("added matches inherits class rule for[" + className + "] - method name [" + methodName + "]");
                break;
            }
            case HAS_CLASS_ANNOTATION: {
                classMethodFilter = methodParams == null || methodParams.isEmpty() ? new MatchClassAnnotationFilter(className, new StringMatchBoot(StringMatchBootType.EQUALS, methodName)) : new MatchClassAnnotationFilter(className, TransformationRuleHelper.getMethodInfo(methodName, methodParams, returnType));
                if (!logger.isDebugEnabled()) break;
                logger.debug("added match class annotation rule for[" + className + "] - method name [" + methodName + "]");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid POJOMatchType: " + (Object)((Object)matchType));
            }
        }
        if (moduleName != null) {
            classMethodFilter.addModuleNameFilter(new ModuleNameMatchClassFilter(new StringMatchBoot(StringMatchBootType.EQUALS, moduleName), java9Util));
        }
        return classMethodFilter;
    }

    public static Class<? extends AMethodInterceptor> lookupInterceptorClass(String className) {
        Class interceptorClass = InterceptorClassRegistry.getClass(className);
        if (interceptorClass == null) {
            interceptorClass = FastInterceptorClassRegistryBoot.getFastClass((String)className);
        }
        if (interceptorClass == null) {
            return null;
        }
        return interceptorClass;
    }

    private static MethodInfo getMethodInfo(String methodName, List<String> methodParams, String returnType) {
        return new MethodInfo(methodName, methodParams);
    }

    public static ClassMethodFilter createClassMethodFilter(POJOMatchTypeBoot matchType, String className, String methodName, IADLogger logger, IJava9Util java9Util) {
        return TransformationRuleHelper.createClassMethodFilter(matchType, className, methodName, null, false, null, null, logger, java9Util);
    }

    public static ClassMethodFilter createClassMethodFilter(POJOMatchTypeBoot matchType, String className, List<MethodInfo> methods) {
        switch (matchType) {
            case MATCHES_CLASS: {
                return new MatchClassNameFilter(className, methods);
            }
            case IMPLEMENTS_INTERFACE: {
                return new MatchInterfaceFilter(className, methods);
            }
            case INHERITS_FROM_CLASS: {
                return new MatchSuperClassNameFilter(className, methods);
            }
            case HAS_CLASS_ANNOTATION: {
                return new MatchClassAnnotationFilter(className, methods);
            }
        }
        throw new IllegalArgumentException("Invalid POJOMatchType: " + (Object)((Object)matchType));
    }

    public static ClassMethodFilter createClassMethodFilter(POJOMethodDefinitionBoot methodDefinition, IADLogger logger, IJava9Util java9Util) {
        ClassMethodFilter classMethodFilter = TransformationRuleHelper.createClassMethodFilter(methodDefinition.getMatchType(), methodDefinition.getClassName(), methodDefinition.getMethodName(), Arrays.asList(methodDefinition.getMethodParameterTypes()), methodDefinition.getMethodParameterTypes().length == 0, null, methodDefinition.getModuleName(), logger, java9Util);
        return classMethodFilter;
    }
}

