/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.ClassReader;
import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.AbstractInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.AnnotationNode;
import com.singularity.asm.org.objectweb.asm.tree.ClassNode;
import com.singularity.asm.org.objectweb.asm.tree.FieldInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.FieldNode;
import com.singularity.asm.org.objectweb.asm.tree.InsnList;
import com.singularity.asm.org.objectweb.asm.tree.JumpInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.LabelNode;
import com.singularity.asm.org.objectweb.asm.tree.LookupSwitchInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.asm.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.TableSwitchInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.TryCatchBlockNode;
import com.singularity.asm.org.objectweb.asm.tree.TypeInsnNode;
import com.singularity.ee.agent.appagent.services.bciengine.templates.TemplateClassTypeChanger;
import com.singularity.ee.agent.util.JarFileUtilities;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

abstract class AMethodGenerator {
    protected static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.AMethodGenerator");
    protected static final int SIGNIFICANT_ACCESS_BITS = 7;
    private static final String TEMPLATE_CLASS_TYPE_CHANGER_CLASS_NAME = TemplateClassTypeChanger.class.getName();
    protected final String nameOfClassBeingCreated;
    protected String templateClassName;

    protected AMethodGenerator(String nameOfClassBeingCreated) {
        this.nameOfClassBeingCreated = nameOfClassBeingCreated;
    }

    protected static ClassNode createClassNode(String className, ClassLoader classLoader) throws RuntimeException {
        String resourceName = className.replace(".", "/") + ".class";
        InputStream is = classLoader.getResourceAsStream(resourceName);
        if (is == null) {
            throw new RuntimeException("Unable to locate class " + className + " in ClassLoader " + classLoader.toString());
        }
        ClassNode cn = AMethodGenerator.createClassNodeFrom(is);
        return cn;
    }

    protected static ClassNode createClassNode(String className, List<URL> libraryList) throws RuntimeException {
        String resourceName = className.replace(".", "/") + ".class";
        InputStream inputStream = JarFileUtilities.getInputStreamFromURLCollection(resourceName, libraryList, logger);
        if (inputStream == null) {
            throw new RuntimeException("Unable to locate class " + className + " in boot class path ");
        }
        ClassNode cn = AMethodGenerator.createClassNodeFrom(inputStream);
        return cn;
    }

    private static ClassNode createClassNodeFrom(InputStream inputStream) {
        ClassNode cn;
        try {
            ClassReader cr = new ClassReader(inputStream);
            cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
        return cn;
    }

    protected MethodNode findMethod(List<MethodNode> listOfMethods, String methodName, Type[] argTypes, int access, Type returnType) throws RuntimeException {
        MethodNode foundMethod = null;
        for (MethodNode nextMethod : listOfMethods) {
            Type[] nextMethodArgTypes;
            if (!nextMethod.name.equals(methodName) || !this.sameTypes(argTypes, nextMethodArgTypes = Type.getArgumentTypes((String)nextMethod.desc))) continue;
            Type nextMethodReturnType = Type.getReturnType((String)nextMethod.desc);
            if (!returnType.equals((Object)nextMethodReturnType)) {
                throw new RuntimeException("Found method " + methodName + " with identical argument list, but different return type");
            }
            int nextMethodAccess = nextMethod.access & 7;
            if (access != nextMethodAccess) {
                throw new RuntimeException("Found method " + methodName + " with identical argument list and return type, but different access flags");
            }
            foundMethod = nextMethod;
            break;
        }
        return foundMethod;
    }

    protected FieldNode findField(List<FieldNode> fieldNodes, String name, Type type) {
        for (FieldNode fieldNode : fieldNodes) {
            if (!fieldNode.name.equals(name) || !type.equals((Object)Type.getType((String)fieldNode.desc))) continue;
            return fieldNode;
        }
        return null;
    }

    private boolean sameTypes(Type[] types1, Type[] types2) {
        boolean bReturn;
        boolean bl = bReturn = types1.length == types2.length;
        if (bReturn) {
            for (int i = 0; i < types1.length; ++i) {
                if (types1[i].equals((Object)types2[i])) continue;
                bReturn = false;
                break;
            }
        }
        return bReturn;
    }

    protected void createNewMethodFromTemplate(List<MethodNode> listOfMethods, MethodNode templateMethod, Map<String, String> fieldToNewTypeMap, Map<TypeChangedMethod, TypeChangedMethod> mapOfTypeChangedMethods) {
        String[] exceptions = templateMethod.exceptions != null ? templateMethod.exceptions.toArray(new String[templateMethod.exceptions.size()]) : new String[]{};
        MethodNode createdMethod = new MethodNode(templateMethod.access, templateMethod.name, this.getUpdatedMethodDescriptor(templateMethod.desc), templateMethod.signature, exceptions);
        Map<LabelNode, LabelNode> labelMap = this.createLabelMap(templateMethod.instructions);
        this.copyInstructions(templateMethod.instructions, createdMethod.instructions, labelMap, fieldToNewTypeMap, mapOfTypeChangedMethods);
        this.copyTryCatchBlocks(templateMethod, createdMethod, labelMap);
        listOfMethods.add(createdMethod);
    }

    private Map<LabelNode, LabelNode> createLabelMap(InsnList insnList) {
        HashMap<LabelNode, LabelNode> returnMap = new HashMap<LabelNode, LabelNode>();
        for (AbstractInsnNode nextNode : insnList) {
            if (!(nextNode instanceof LabelNode)) continue;
            returnMap.put((LabelNode)nextNode, new LabelNode());
        }
        return returnMap;
    }

    private void copyTryCatchBlocks(MethodNode templateMethod, MethodNode newMethod, Map<LabelNode, LabelNode> labelMap) {
        List listOfTemplateTryCatches = templateMethod.tryCatchBlocks;
        if (listOfTemplateTryCatches != null && listOfTemplateTryCatches.size() > 0) {
            ArrayList<TryCatchBlockNode> listOfTargetTryCatches = newMethod.tryCatchBlocks;
            if (listOfTargetTryCatches == null) {
                newMethod.tryCatchBlocks = listOfTargetTryCatches = new ArrayList<TryCatchBlockNode>(listOfTemplateTryCatches.size());
            }
            for (TryCatchBlockNode nextTryCatch : listOfTemplateTryCatches) {
                TryCatchBlockNode newTryCatch = new TryCatchBlockNode(labelMap.get(nextTryCatch.start), labelMap.get(nextTryCatch.end), labelMap.get(nextTryCatch.handler), this.getUpdatedOwner(nextTryCatch.type));
                listOfTargetTryCatches.add(newTryCatch);
            }
        }
    }

    private void copyInstructions(InsnList fromList, InsnList toList, Map<LabelNode, LabelNode> labelMap, Map<String, String> fieldToNewTypeMap, Map<TypeChangedMethod, TypeChangedMethod> mapOfTypeChangedMethods) {
        ListIterator iter = fromList.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode nextNode = (AbstractInsnNode)iter.next();
            iter.remove();
            toList.add(this.copyInstruction(nextNode, labelMap, fieldToNewTypeMap, mapOfTypeChangedMethods));
        }
    }

    private AbstractInsnNode copyInstruction(AbstractInsnNode fromInsn, Map<LabelNode, LabelNode> labelMap, Map<String, String> fieldToNewTypeMap, Map<TypeChangedMethod, TypeChangedMethod> mapOfTypeChangedMethods) {
        AbstractInsnNode returnInsn = null;
        switch (fromInsn.getType()) {
            case 8: {
                returnInsn = this.copyLabelInsn((LabelNode)fromInsn, labelMap);
                break;
            }
            case 4: {
                returnInsn = this.copyFieldInsn((FieldInsnNode)fromInsn, fieldToNewTypeMap);
                break;
            }
            case 7: {
                returnInsn = this.copyJumpInsn((JumpInsnNode)fromInsn, labelMap);
                break;
            }
            case 12: {
                returnInsn = this.copyLookupSwitchInsn((LookupSwitchInsnNode)fromInsn, labelMap);
                break;
            }
            case 5: {
                returnInsn = this.copyMethodInsn((MethodInsnNode)fromInsn, mapOfTypeChangedMethods);
                break;
            }
            case 13: {
                returnInsn = this.copyMultiANewArrayInsn((MultiANewArrayInsnNode)fromInsn);
                break;
            }
            case 11: {
                returnInsn = this.copyTableSwitchInsn((TableSwitchInsnNode)fromInsn, labelMap);
                break;
            }
            case 3: {
                returnInsn = this.copyTypeInsn((TypeInsnNode)fromInsn);
                break;
            }
            default: {
                returnInsn = fromInsn;
            }
        }
        return returnInsn;
    }

    private AbstractInsnNode copyLabelInsn(LabelNode labelNode, Map<LabelNode, LabelNode> labelMap) {
        LabelNode newLabelNode = labelMap.get(labelNode);
        return newLabelNode;
    }

    private AbstractInsnNode copyFieldInsn(FieldInsnNode fieldNode, Map<String, String> fieldToNewTypeMap) {
        String desc = fieldToNewTypeMap != null ? this.getReplacementFieldTypeDesc(fieldNode, fieldToNewTypeMap) : fieldNode.desc;
        FieldInsnNode newInsn = new FieldInsnNode(fieldNode.getOpcode(), this.getUpdatedOwner(fieldNode.owner), fieldNode.name, this.getUpdatedClassDescriptor(desc));
        return newInsn;
    }

    private String getReplacementFieldTypeDesc(FieldInsnNode fieldInsnNode, Map<String, String> fieldToNewTypeMap) {
        String newClass;
        String returnDesc = fieldInsnNode.desc;
        if (fieldInsnNode.owner.equals(this.templateClassName) && (fieldInsnNode.getOpcode() == 180 || fieldInsnNode.getOpcode() == 181) && (newClass = fieldToNewTypeMap.get(fieldInsnNode.name)) != null) {
            Type newClassType = Type.getObjectType((String)newClass.replace('.', '/'));
            returnDesc = newClassType.getDescriptor();
        }
        return returnDesc;
    }

    private AbstractInsnNode copyJumpInsn(JumpInsnNode jumpNode, Map<LabelNode, LabelNode> labelMap) {
        JumpInsnNode newInsn = new JumpInsnNode(jumpNode.getOpcode(), labelMap.get(jumpNode.label));
        return newInsn;
    }

    private AbstractInsnNode copyLookupSwitchInsn(LookupSwitchInsnNode lookupNode, Map<LabelNode, LabelNode> labelMap) {
        LabelNode[] newInsnLabels = new LabelNode[lookupNode.labels.size()];
        for (int i = 0; i < newInsnLabels.length; ++i) {
            newInsnLabels[i] = labelMap.get(lookupNode.labels.get(i));
        }
        int[] keys = new int[lookupNode.keys.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = (Integer)lookupNode.keys.get(i);
        }
        LookupSwitchInsnNode newInsn = new LookupSwitchInsnNode(labelMap.get(lookupNode.dflt), keys, newInsnLabels);
        return newInsn;
    }

    private AbstractInsnNode copyMethodInsn(MethodInsnNode methodNode, Map<TypeChangedMethod, TypeChangedMethod> mapOfTypeChangedMethods) {
        MethodInsnNode newInsn = new MethodInsnNode(methodNode.getOpcode(), this.getUpdatedOwner(methodNode.owner), methodNode.name, this.getUpdatedMethodDescriptor(methodNode, mapOfTypeChangedMethods));
        return newInsn;
    }

    private AbstractInsnNode copyMultiANewArrayInsn(MultiANewArrayInsnNode multiANewArrayNode) {
        MultiANewArrayInsnNode newInsn = new MultiANewArrayInsnNode(this.getUpdatedOwner(multiANewArrayNode.desc), multiANewArrayNode.dims);
        return newInsn;
    }

    private AbstractInsnNode copyTableSwitchInsn(TableSwitchInsnNode tableSwitchNode, Map<LabelNode, LabelNode> labelMap) {
        LabelNode[] newInsnLabelNodes = new LabelNode[tableSwitchNode.labels.size()];
        for (int i = 0; i < newInsnLabelNodes.length; ++i) {
            newInsnLabelNodes[i] = labelMap.get(tableSwitchNode.labels.get(i));
        }
        TableSwitchInsnNode newInsn = new TableSwitchInsnNode(tableSwitchNode.min, tableSwitchNode.max, tableSwitchNode.dflt, newInsnLabelNodes);
        return newInsn;
    }

    private AbstractInsnNode copyTypeInsn(TypeInsnNode typeNode) {
        TypeInsnNode newInsn = new TypeInsnNode(typeNode.getOpcode(), this.getUpdatedOwner(typeNode.desc));
        return newInsn;
    }

    private String getUpdatedOwner(String originalOwner) {
        String returnOwner = originalOwner;
        if (returnOwner != null && returnOwner.replace(".", "/").equals(this.templateClassName)) {
            returnOwner = this.nameOfClassBeingCreated.replace(".", "/");
        }
        return returnOwner;
    }

    private String getUpdatedClassDescriptor(String originalDesc) {
        String returnDesc = originalDesc;
        int index = returnDesc.indexOf(this.templateClassName);
        if (index >= 0) {
            StringBuilder sb = new StringBuilder();
            if (index > 0) {
                sb.append(returnDesc.subSequence(0, index));
            }
            sb.append(this.nameOfClassBeingCreated.replace('.', '/'));
            sb.append(originalDesc.substring(index + this.templateClassName.length()));
            returnDesc = sb.toString();
        }
        return returnDesc;
    }

    private String getUpdatedMethodDescriptor(String methodDesc) {
        return this.getUpdatedMethodDescriptor(null, null, methodDesc);
    }

    private String getUpdatedMethodDescriptor(MethodInsnNode methodInsnNode, Map<TypeChangedMethod, TypeChangedMethod> mapOfTypeChangedMethods) {
        return this.getUpdatedMethodDescriptor(methodInsnNode, mapOfTypeChangedMethods, null);
    }

    private String getUpdatedMethodDescriptor(MethodInsnNode methodInsnNode, Map<TypeChangedMethod, TypeChangedMethod> mapOfTypeChangedMethods, String methodDesc) {
        TypeChangedMethod typeChangedMethod;
        String returnDesc = methodDesc != null ? methodDesc : methodInsnNode.desc;
        Type returnType = Type.getReturnType((String)returnDesc);
        Type[] args = Type.getArgumentTypes((String)returnDesc);
        boolean changed = false;
        if (mapOfTypeChangedMethods != null && methodInsnNode != null && methodInsnNode.getOpcode() == 182 && methodInsnNode.owner.equals(this.templateClassName) && (typeChangedMethod = mapOfTypeChangedMethods.get(new TypeChangedMethod(methodInsnNode.name, returnType, args))) != null) {
            Type changedReturnType = typeChangedMethod.getReplacedReturnType();
            Type[] changedArgTypes = typeChangedMethod.getReplaceArgTypes();
            if (changedReturnType != null) {
                returnType = changedReturnType;
            }
            if (changedArgTypes != null) {
                for (int i = 0; i < changedArgTypes.length; ++i) {
                    if (changedArgTypes[i] == null) continue;
                    args[i] = changedArgTypes[i];
                }
            }
            changed = true;
        }
        if (returnDesc.contains(this.templateClassName)) {
            String returnTypeDesc = returnType.getDescriptor();
            returnTypeDesc = this.getUpdatedClassDescriptor(returnTypeDesc);
            returnType = Type.getType((String)returnTypeDesc);
            for (int i = 0; i < args.length; ++i) {
                String argType = args[i].getDescriptor();
                argType = this.getUpdatedClassDescriptor(argType);
                args[i] = Type.getType((String)argType);
            }
            changed = true;
        }
        if (changed) {
            returnDesc = Type.getMethodDescriptor((Type)returnType, (Type[])args);
        }
        return returnDesc;
    }

    protected Map<String, String> createFieldToNewTypeMap(ClassNode cn) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        List fields = cn.fields;
        for (FieldNode nextField : fields) {
            List listOfAnnotations = nextField.visibleAnnotations;
            if (listOfAnnotations == null) continue;
            block1: for (AnnotationNode nextAnnotation : listOfAnnotations) {
                Type annotationType = Type.getType((String)nextAnnotation.desc);
                if (!annotationType.getClassName().equals(TEMPLATE_CLASS_TYPE_CHANGER_CLASS_NAME)) continue;
                List listOfValuePairs = nextAnnotation.values;
                Iterator iter = listOfValuePairs.iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    if (!iter.hasNext()) continue;
                    Object value = iter.next();
                    if (!(key instanceof String) || !(value instanceof String) || !key.equals("type") || ((String)value).length() <= 0) continue;
                    returnMap.put(nextField.name, (String)value);
                    continue block1;
                }
            }
        }
        return returnMap;
    }

    protected Map<TypeChangedMethod, TypeChangedMethod> createNewMethodMap(ClassNode cn) {
        HashMap<TypeChangedMethod, TypeChangedMethod> returnMap = new HashMap<TypeChangedMethod, TypeChangedMethod>();
        List methods = cn.methods;
        block0: for (MethodNode nextMethod : methods) {
            List listOfAnnotations;
            if ((nextMethod.access & 0x400) <= 0 || (listOfAnnotations = nextMethod.visibleAnnotations) == null) continue;
            for (AnnotationNode nextAnnotation : listOfAnnotations) {
                Type annotationType = Type.getType((String)nextAnnotation.desc);
                if (!annotationType.getClassName().equals(TEMPLATE_CLASS_TYPE_CHANGER_CLASS_NAME)) continue;
                TypeChangedMethod typeChangedMethod = this.createTypeChangedMethod(nextMethod, nextAnnotation);
                if (typeChangedMethod == null) continue block0;
                returnMap.put(typeChangedMethod, typeChangedMethod);
                continue block0;
            }
        }
        return returnMap;
    }

    private TypeChangedMethod createTypeChangedMethod(MethodNode method, AnnotationNode nextAnnotation) {
        TypeChangedMethod typeChangedMethod = null;
        try {
            List listOfValuePairs = nextAnnotation.values;
            Iterator iter = listOfValuePairs.iterator();
            Type replaceReturnType = null;
            Type[] replaceArgTypes = null;
            while (iter.hasNext()) {
                Object key = iter.next();
                if (!iter.hasNext()) continue;
                Object value = iter.next();
                if (!(key instanceof String)) continue;
                if (key.equals("returnType") && value instanceof String) {
                    if (((String)value).length() <= 0) continue;
                    replaceReturnType = Type.getObjectType((String)((String)value));
                    continue;
                }
                if (!key.equals("argTypes") || !(value instanceof List)) continue;
                List listOfArgTypes = (List)value;
                replaceArgTypes = new Type[listOfArgTypes.size()];
                int typeIdx = 0;
                for (String nextArgType : listOfArgTypes) {
                    if (nextArgType != null && nextArgType.length() > 0) {
                        replaceArgTypes[typeIdx] = Type.getObjectType((String)nextArgType);
                    }
                    ++typeIdx;
                }
            }
            if (replaceArgTypes != null || replaceReturnType != null) {
                Type returnType = Type.getReturnType((String)method.desc);
                Type[] argTypes = Type.getArgumentTypes((String)method.desc);
                typeChangedMethod = new TypeChangedMethod(method.name, returnType, argTypes);
                if (replaceArgTypes != null) {
                    typeChangedMethod.setReplacementArgTypes(replaceArgTypes);
                }
                if (replaceReturnType != null) {
                    typeChangedMethod.setReplacementReturnType(replaceReturnType);
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("%s caught in AMethodGenerator.createTypeChangedMethod", e), e);
            typeChangedMethod = null;
        }
        return typeChangedMethod;
    }

    static class TypeChangedMethod {
        private String methodName;
        private Type originalReturnType;
        private final Type[] originalArgTypes;
        private Type replacedReturnType;
        private Type[] replaceArgTypes;
        private int hashValue;

        TypeChangedMethod(String methodName, Type returnType, Type[] argTypes) {
            this.methodName = methodName;
            this.originalReturnType = returnType;
            this.originalArgTypes = argTypes;
            this.hashValue = methodName.hashCode() ^ returnType.toString().hashCode();
            for (Type argType : argTypes) {
                this.hashValue ^= argType.toString().hashCode();
            }
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object o) {
            boolean bReturn;
            boolean bl = bReturn = this == o;
            if (!bReturn && o instanceof TypeChangedMethod) {
                TypeChangedMethod other = (TypeChangedMethod)o;
                boolean bl2 = bReturn = this.hashValue == other.hashValue && this.methodName.equals(other.methodName) && this.originalReturnType.equals((Object)other.originalReturnType);
                if (bReturn) {
                    boolean bl3 = bReturn = this.originalArgTypes.length == other.originalArgTypes.length;
                    if (bReturn) {
                        for (int i = 0; i < this.originalArgTypes.length && bReturn; ++i) {
                            bReturn = this.originalArgTypes[i].equals((Object)other.originalArgTypes[i]);
                        }
                    }
                }
            }
            return bReturn;
        }

        void setReplacementReturnType(Type returnType) {
            this.replacedReturnType = returnType;
        }

        void setReplacementArgTypes(Type[] argTypes) {
            this.replaceArgTypes = argTypes;
        }

        Type getReplacedReturnType() {
            return this.replacedReturnType;
        }

        Type[] getReplaceArgTypes() {
            return this.replaceArgTypes;
        }
    }
}

