/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.ee.agent.appagent.services.bciengine.IASMType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class ASMType
implements IASMType<Type> {
    private final Type delegate;
    public static final int VOID = 0;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INT = 5;
    public static final int FLOAT = 6;
    public static final int LONG = 7;
    public static final int DOUBLE = 8;
    public static final int ARRAY = 9;
    public static final int OBJECT = 10;
    public static final int METHOD = 11;
    public static final ASMType VOID_TYPE = new ASMType(Type.VOID_TYPE);
    public static final ASMType BOOLEAN_TYPE = new ASMType(Type.BOOLEAN_TYPE);
    public static final ASMType CHAR_TYPE = new ASMType(Type.CHAR_TYPE);
    public static final ASMType BYTE_TYPE = new ASMType(Type.BYTE_TYPE);
    public static final ASMType SHORT_TYPE = new ASMType(Type.SHORT_TYPE);
    public static final ASMType INT_TYPE = new ASMType(Type.INT_TYPE);
    public static final ASMType FLOAT_TYPE = new ASMType(Type.FLOAT_TYPE);
    public static final ASMType LONG_TYPE = new ASMType(Type.LONG_TYPE);
    public static final ASMType DOUBLE_TYPE = new ASMType(Type.DOUBLE_TYPE);

    public static ASMType[] convertToWrappedArray(Type[] types) {
        if (types == null) {
            return null;
        }
        ASMType[] result = new ASMType[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = new ASMType(types[i]);
        }
        return result;
    }

    public static Type[] convertToRawArray(IASMType<Type>[] types) {
        if (types == null) {
            return null;
        }
        Type[] result = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = types[i].getDelegate();
        }
        return result;
    }

    public static IASMType getType(Class<?> c) {
        return new ASMType(Type.getType(c));
    }

    public static IASMType getType(String typeDescriptor) {
        return new ASMType(Type.getType((String)typeDescriptor));
    }

    public static String getMethodDescriptor(IASMType<Type> returnType, IASMType<Type> ... argumentTypes) {
        return Type.getMethodDescriptor((Type)returnType.getDelegate(), (Type[])ASMType.convertToRawArray(argumentTypes));
    }

    public static String getInternalName(Class<?> c) {
        return Type.getInternalName(c);
    }

    public static String getConstructorDescriptor(Constructor c) {
        return Type.getConstructorDescriptor((Constructor)c);
    }

    public static String getMethodDescriptor(Method m) {
        return Type.getMethodDescriptor((Method)m);
    }

    public static String getDescriptor(Class<?> c) {
        return Type.getDescriptor(c);
    }

    public static String getClassInternalName(Class<?> c) {
        return Type.getType(c).getInternalName();
    }

    public ASMType(Type delegate) {
        this.delegate = delegate;
    }

    @Override
    public Type getDelegate() {
        return this.delegate;
    }

    @Override
    public int getSort() {
        return this.delegate.getSort();
    }

    @Override
    public int getDimensions() {
        return this.delegate.getDimensions();
    }

    @Override
    public String getClassName() {
        return this.delegate.getClassName();
    }

    @Override
    public String getInternalName() {
        return this.delegate.getInternalName();
    }

    @Override
    public String getDescriptor() {
        return this.delegate.getDescriptor();
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    @Override
    public int getOpcode(int opcode) {
        return this.delegate.getOpcode(opcode);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ASMType asmType = (ASMType)o;
        return !(this.delegate != null ? !this.delegate.equals((Object)asmType.delegate) : asmType.delegate != null);
    }

    @Override
    public int hashCode() {
        return this.delegate != null ? this.delegate.hashCode() : 0;
    }
}

