/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationRuleEngine;
import com.singularity.ee.agent.appagent.services.bciengine.asm.AbstractCustomTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassBytecode;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AddClassAnnotationTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

class AddClassAnnotationTransformer
extends AbstractCustomTransformer {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.bci.AddClassAnnotationTransformer");

    AddClassAnnotationTransformer(TransformationRuleEngine ruleEngine) {
        super(ruleEngine);
    }

    byte[] transform(AClassTransformationRule[] matchedRules, RuntimeClassInfo runtimeClassInfo, BasicClassInfo basicClassInfo, byte[] oldByteCode) {
        return this.transformClass(matchedRules, runtimeClassInfo, basicClassInfo, oldByteCode);
    }

    private byte[] transformClass(AClassTransformationRule[] matchedRules, RuntimeClassInfo runtimeClassInfo, BasicClassInfo basicClassInfo, byte[] oldByteCode) {
        ClassBytecode classBytecode;
        byte[] returnClassBytes = null;
        List<AddClassAnnotationTransformationRule> listOfRules = new ArrayList<AddClassAnnotationTransformationRule>(matchedRules.length);
        for (AClassTransformationRule nextRule : matchedRules) {
            if (!(nextRule instanceof AddClassAnnotationTransformationRule)) continue;
            listOfRules.add((AddClassAnnotationTransformationRule)nextRule);
        }
        if (listOfRules.size() > 0 && (listOfRules = this.checkByteCodeRules(classBytecode = new ClassBytecode(oldByteCode), listOfRules, runtimeClassInfo, basicClassInfo)).size() > 0) {
            returnClassBytes = this.transformAccordingToRules(classBytecode, listOfRules, basicClassInfo.getClassName());
        }
        return returnClassBytes;
    }

    private byte[] transformAccordingToRules(ClassBytecode classBytecode, List<AddClassAnnotationTransformationRule> listOfRules, String className) {
        boolean modified = false;
        for (AddClassAnnotationTransformationRule rule : listOfRules) {
            modified = this.transformClassAccordingToRule(rule, classBytecode, className) || modified;
        }
        return modified ? classBytecode.generateAndGetBytes() : null;
    }

    private boolean transformClassAccordingToRule(AddClassAnnotationTransformationRule theRule, ClassBytecode classBytecode, String className) {
        boolean anyMethodMatch = false;
        for (MethodNode methodNode : classBytecode.getMethods()) {
            if (!this.isMethodMatch(theRule, methodNode, className)) continue;
            anyMethodMatch = true;
            logger.traceParams("Found match: {}.{}{}", className, methodNode.name, methodNode.desc);
            break;
        }
        if (anyMethodMatch) {
            Class<? extends Annotation> newAnnotationType = theRule.getAnnotationType();
            classBytecode.addClassAnnotationIfAbsent(newAnnotationType);
        } else {
            logger.traceParams("No method in {} matched", className);
        }
        return anyMethodMatch;
    }
}

