/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.AnnotationVisitor;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AnnotationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.EnumAnnotationValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AnnotationLister
extends AnnotationVisitor {
    private Map<String, Object> nameValuePairs;
    private List<Object> arrayList;
    private AnnotationVisitor av;
    private String name;
    private String desc;
    private boolean visible;
    private List<AnnotationInfo> parentAnnotationList;
    private Map<String, Object> parentNameValuePairs;
    private List<Object> parentArrayList;
    private boolean isChildAnnotation;
    private boolean isArray;
    private boolean isChildAnnotationArray;

    public AnnotationLister(AnnotationVisitor av, String desc, boolean visible, List<AnnotationInfo> parentAnnotationList) {
        super(589824);
        this.av = av;
        this.desc = desc;
        this.visible = visible;
        this.parentAnnotationList = parentAnnotationList;
        this.nameValuePairs = new HashMap<String, Object>();
    }

    public AnnotationLister(AnnotationVisitor av, String name, String desc, Map<String, Object> parentNameValuePairs) {
        super(589824);
        this.isChildAnnotation = true;
        this.av = av;
        this.name = name;
        this.desc = desc;
        this.parentNameValuePairs = parentNameValuePairs;
        this.nameValuePairs = new HashMap<String, Object>();
    }

    public AnnotationLister(AnnotationVisitor av, String name, Map<String, Object> parentNameValuePairs) {
        super(589824);
        this.isArray = true;
        this.av = av;
        this.name = name;
        this.parentNameValuePairs = parentNameValuePairs;
        this.arrayList = new ArrayList<Object>();
    }

    public AnnotationLister(AnnotationVisitor av, String name, String desc, List<Object> parentArrayList) {
        super(589824);
        this.isChildAnnotationArray = true;
        this.av = av;
        this.name = name;
        this.desc = desc;
        this.parentArrayList = parentArrayList;
        this.nameValuePairs = new HashMap<String, Object>();
    }

    public void visit(String name, Object value) {
        this.av.visit(name, value);
        if (this.isArray) {
            this.arrayList.add(value);
        } else {
            this.nameValuePairs.put(name, value);
        }
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        if (this.isArray) {
            return new AnnotationLister(this.av.visitAnnotation(name, desc), name, desc, this.arrayList);
        }
        return new AnnotationLister(this.av.visitAnnotation(name, desc), name, desc, this.nameValuePairs);
    }

    public AnnotationVisitor visitArray(String name) {
        return new AnnotationLister(this.av.visitArray(name), name, this.nameValuePairs);
    }

    public void visitEnd() {
        this.av.visitEnd();
        if (this.isArray) {
            this.parentNameValuePairs.put(this.name, this.arrayList.toArray());
        } else if (this.isChildAnnotation) {
            AnnotationInfo info = new AnnotationInfo(this.desc, this.visible, this.nameValuePairs);
            this.parentNameValuePairs.put(this.name, info);
        } else if (this.isChildAnnotationArray) {
            AnnotationInfo info = new AnnotationInfo(this.desc, this.visible, this.nameValuePairs);
            this.parentArrayList.add(info);
        } else {
            AnnotationInfo info = new AnnotationInfo(this.desc, this.visible, this.nameValuePairs);
            this.parentAnnotationList.add(info);
        }
    }

    public void visitEnum(String name, String desc, String value) {
        this.av.visitEnum(name, desc, value);
        if (this.isArray) {
            this.arrayList.add(new EnumAnnotationValue(desc, value));
        } else {
            this.nameValuePairs.put(name, new EnumAnnotationValue(desc, value));
        }
    }
}

