/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.ee.agent.appagent.services.bciengine.ClassNameUtils;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.PrimitiveType;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassMetaData;
import java.lang.ref.WeakReference;

public class ArrayClassMetaData
extends ClassMetaData {
    private WeakReference<ClassMetaData> baseClassRef;
    private final String baseClassName;
    private final PrimitiveType primitiveBaseType;
    private int numDimensions = -1;
    private final boolean shouldLogIfUnableToFind;

    ArrayClassMetaData(String baseClassName, ClassLoader classLoader, boolean shouldLogIfUnableToFind) {
        super(classLoader);
        this.baseClassName = ClassNameUtils.convertClassNameToExternalFormat(baseClassName);
        this.primitiveBaseType = ArrayClassMetaData.getPrimitiveType(baseClassName);
        this.shouldLogIfUnableToFind = shouldLogIfUnableToFind;
    }

    private static final PrimitiveType getPrimitiveType(String baseClassName) {
        return PrimitiveType.getType(baseClassName);
    }

    @Override
    public String getName() {
        if (this.primitiveBaseType != null) {
            return this.primitiveBaseType.getName();
        }
        return this.baseClassName + "[]";
    }

    @Override
    public String getSuperName() {
        return OBJECT_CLASS_NAME;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    ClassMetaData[] getInterfaces() {
        return new ClassMetaData[0];
    }

    private ClassMetaData getBaseClass() {
        ClassMetaData returnObject = null;
        if (this.primitiveBaseType == null) {
            ClassMetaData classMetaData = returnObject = this.baseClassRef != null ? (ClassMetaData)this.baseClassRef.get() : null;
            if (returnObject == null) {
                returnObject = ArrayClassMetaData.getClassMetaDataManager().getClassMetaData(this.baseClassName, this.getClassLoader(), this.shouldLogIfUnableToFind);
                this.baseClassRef = returnObject != null ? new WeakReference<ClassMetaData>(returnObject) : null;
            }
        }
        return returnObject;
    }

    @Override
    public int getNumDimensions() {
        if (this.numDimensions < 0) {
            if (this.primitiveBaseType != null) {
                this.numDimensions = 1;
            } else {
                int numDimensions = 1;
                String baseClassName = this.baseClassName;
                while (baseClassName.endsWith("[]")) {
                    ++numDimensions;
                    baseClassName = baseClassName.substring(0, baseClassName.length() - 2);
                }
                this.numDimensions = numDimensions;
            }
        }
        return this.numDimensions;
    }

    @Override
    public boolean doesThisClassExtend(IClassMetaData other) {
        boolean bReturn = false;
        if (other.getName().equals(OBJECT_CLASS_NAME)) {
            bReturn = true;
        } else if (this.getNumDimensions() >= other.getNumDimensions() && this.primitiveBaseType == null && other instanceof ArrayClassMetaData) {
            ClassMetaData baseClass = this.getBaseClass();
            ClassMetaData otherBaseClass = ((ArrayClassMetaData)other).getBaseClass();
            if (baseClass != null && otherBaseClass != null) {
                bReturn = baseClass.doesThisClassExtend(otherBaseClass);
            }
        }
        return bReturn;
    }

    @Override
    public boolean isAssignableFrom(IClassMetaData other) {
        boolean bReturn = false;
        if (this.primitiveBaseType != null) {
            if (other instanceof ArrayClassMetaData) {
                bReturn = this.primitiveBaseType.equals((Object)((ArrayClassMetaData)other).primitiveBaseType);
            }
            return bReturn;
        }
        bReturn = super.isAssignableFrom(other);
        return bReturn;
    }
}

