/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.ClassReader;
import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.AbstractInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.ClassNode;
import com.singularity.asm.org.objectweb.asm.tree.InsnList;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.asm.org.objectweb.asm.tree.analysis.AnalyzerException;
import com.singularity.asm.org.objectweb.asm.tree.analysis.BasicValue;
import com.singularity.asm.org.objectweb.asm.tree.analysis.SimpleVerifier;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.ModifiedMethods;
import com.singularity.ee.agent.appagent.services.bciengine.asm.BCIEngineAnalyzer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassMetaDataManager;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class BCIEngineClassVerifier
extends SimpleVerifier {
    private static final String NULL_DESC = "Lnull;";
    private static final int MAX_SUPERCLASS_ITERATIONS = 50;
    private final byte[] classBytes;
    private final ClassLoader classLoader;
    private IClassMetaData classMetaData;
    private static ClassMetaDataManager metaDataManager = ClassMetaDataManager.getInstance();
    private ClassNode classNode;
    private Map<AbstractInsnNode, Integer> injectedInstructions;
    private boolean isInInjectedCode;

    BCIEngineClassVerifier(byte[] classBytes, ClassLoader classLoader) {
        super(589824, null, null, null, false);
        this.classBytes = classBytes;
        this.classLoader = classLoader;
    }

    private ClassNode getClassNode() {
        if (this.classNode == null) {
            ClassReader reader = new ClassReader(this.classBytes);
            this.classNode = new ClassNode();
            reader.accept((ClassVisitor)this.classNode, 0);
        }
        return this.classNode;
    }

    void verifyClass(ModifiedMethods modifiedMethods, boolean testInjectedCode) throws AnalyzerException {
        this.getClassNode();
        if (this.classNode.methods != null) {
            this.classMetaData = metaDataManager.getClassMetaData(this.classNode, this.classLoader);
            Iterator methodIter = this.classNode.methods.iterator();
            BCIEngineAnalyzer a = new BCIEngineAnalyzer(this);
            while (methodIter.hasNext()) {
                MethodNode method = (MethodNode)methodIter.next();
                if (method.instructions.size() <= 0 || !modifiedMethods.isMethodModified(method.name, method.desc)) continue;
                try {
                    if (testInjectedCode) {
                        this.getInjectedInstructions(method, modifiedMethods);
                    }
                    try {
                        a.analyze(this.classNode.name, method);
                    }
                    catch (AnalyzerException e) {
                        if (this.isInInjectedCode || !testInjectedCode) {
                            throw e;
                        }
                        BCTLoggerUtil.println("AnalyzerException: " + e.toString() + " has been supressed because it did not occur in injected code");
                    }
                    BCTLoggerUtil.println("Method " + method.name + " with signature " + method.desc + " in class " + this.classNode.name + " has been successfully verified");
                }
                catch (AnalyzerException t) {
                    BCTLoggerUtil.warn("Error " + t.toString() + " caught while verifying method " + method.name + "  signature " + method.desc + "  in class " + this.classMetaData.getName());
                    throw t;
                }
            }
        }
    }

    private Map<AbstractInsnNode, Integer> getInjectedInstructions(MethodNode method, ModifiedMethods modifiedMethods) {
        this.injectedInstructions = new HashMap<AbstractInsnNode, Integer>();
        InsnList insnList = method.instructions;
        int instNum = -1;
        for (AbstractInsnNode nextInsn : insnList) {
            if (nextInsn.getType() == 14 || nextInsn.getType() == 8 || nextInsn.getType() == 15 || !modifiedMethods.isInsnInjected(method.name, method.desc, ++instNum)) continue;
            this.injectedInstructions.put(nextInsn, instNum);
        }
        return this.injectedInstructions;
    }

    protected boolean isInterface(Type t) {
        boolean bReturn = false;
        ClassMetaData cmd = metaDataManager.getClassMetaData(t, this.classLoader);
        if (cmd != null) {
            bReturn = cmd.isInterface();
        }
        return bReturn;
    }

    protected Type getSuperClass(Type t) {
        ClassMetaData cmd = metaDataManager.getClassMetaData(t, this.classLoader);
        if (cmd != null) {
            ClassMetaData superClass = (ClassMetaData)cmd.getSuperClass();
            return superClass != null ? superClass.getType() : null;
        }
        return null;
    }

    protected boolean isAssignableFrom(Type t, Type u) {
        if (t.getSort() != 9 && t.getSort() != 10) {
            if (u.getSort() != 9 && u.getSort() != 10) {
                return super.isAssignableFrom(t, u);
            }
            return false;
        }
        if (u.getSort() != 9 && u.getSort() != 10) {
            return false;
        }
        boolean bReturn = false;
        if (t.equals((Object)u)) {
            bReturn = true;
        } else if (u.equals((Object)NULL_TYPE)) {
            bReturn = true;
        } else {
            ClassMetaData metaDataT = metaDataManager.getClassMetaData(t, this.classLoader);
            ClassMetaData metaDataU = metaDataManager.getClassMetaData(u, this.classLoader);
            if (metaDataT != null && metaDataU != null) {
                bReturn = metaDataT.isCanBeAssignedToAnything() || metaDataU.isCanBeAssignedToAnything() || metaDataT.isAssignableFrom(metaDataU);
            } else {
                BCTLoggerUtil.println("Unable to test assignment from " + u.toString() + " to " + t.toString() + " because we could not get meta data for " + (metaDataT == null ? t.toString() : u.toString()));
            }
        }
        return bReturn;
    }

    protected Class getClass(Type t) {
        throw new RuntimeException("Unable to return Class object");
    }

    public BasicValue merge(BasicValue v, BasicValue w) {
        if (!v.equals((Object)w)) {
            Type t = v.getType();
            Type u = w.getType();
            if (!(t == null || t.getSort() != 10 && t.getSort() != 9 || u == null || u.getSort() != 10 && u.getSort() != 9)) {
                if (NULL_DESC.equals(t.getDescriptor())) {
                    return w;
                }
                if (NULL_DESC.equals(u.getDescriptor())) {
                    return v;
                }
                if (this.isAssignableFrom(t, u)) {
                    return v;
                }
                if (this.isAssignableFrom(u, t)) {
                    return w;
                }
                int iterationsLeft = 50;
                do {
                    Type[] interfaces;
                    if (--iterationsLeft <= 0 || t == null) {
                        return BasicValue.REFERENCE_VALUE;
                    }
                    if (!this.isInterface(t)) continue;
                    for (Type type : interfaces = this.getImplementedInterfaces(t)) {
                        if (!this.isAssignableFrom(type, u)) continue;
                        return this.newValue(type);
                    }
                } while ((t = this.getSuperClass(t)) == null || !this.isAssignableFrom(t, u));
                return this.newValue(t);
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return v;
    }

    private Type[] getImplementedInterfaces(Type t) {
        Type[] returnArray = null;
        ClassMetaData cmd = metaDataManager.getClassMetaData(t, this.classLoader);
        if (cmd != null) {
            ClassMetaData[] interfaces = cmd.getInterfaces();
            returnArray = new Type[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                returnArray[i] = interfaces[i].getType();
            }
        }
        return returnArray;
    }

    void determineIfInjected(AbstractInsnNode insn) {
        this.isInInjectedCode = this.injectedInstructions != null ? this.injectedInstructions.get(insn) != null : false;
    }
}

