/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.ClassReader;
import com.singularity.asm.org.objectweb.asm.ClassWriter;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.UnableToGetMetaDataException;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassMetaDataManager;

class BCIEngineClassWriter
extends ClassWriter {
    private static final String OBJECT_CLASS_NAME = "java/lang/Object";
    private final ClassLoader classLoader;
    private final String className;
    private final byte[] classBytes;
    private final boolean forceComputeStackFrames;

    BCIEngineClassWriter(ClassReader classReader, int flags, ClassLoader classLoader, String className, byte[] classBytes, boolean forceComputeStackFrames) {
        super(classReader, flags);
        this.classLoader = classLoader;
        this.className = className;
        this.classBytes = classBytes;
        this.forceComputeStackFrames = forceComputeStackFrames;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        ClassMetaData class2;
        IClassMetaData class1;
        if (OBJECT_CLASS_NAME.equals(type1) || OBJECT_CLASS_NAME.equals(type2)) {
            return OBJECT_CLASS_NAME;
        }
        try {
            class1 = this.getClassMetaData(type1);
            class2 = this.getClassMetaData(type2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (class1.isAssignableFrom(class2)) {
            return type1;
        }
        if (class2.isAssignableFrom(class1)) {
            return type2;
        }
        if (class1.isInterface() || class2.isInterface()) {
            return OBJECT_CLASS_NAME;
        }
        do {
            ClassMetaData previousClass = class1;
            if ((class1 = class1.getSuperClass()) != null) continue;
            throw new RuntimeException("Unable to obtain superclass ClassMetaData for " + previousClass.getName() + " from " + (this.classLoader != null ? "ClassLoader " + this.classLoader : "BootstrapClassLoader"));
        } while (!class1.isAssignableFrom(class2));
        return class1.getName().replace('.', '/');
    }

    protected ClassMetaData getClassMetaData(String className) throws UnableToGetMetaDataException {
        ClassMetaData returnObject = null;
        ClassMetaDataManager manager = ClassMetaDataManager.getInstance();
        returnObject = this.className.equals(className) ? manager.getClassMetaData(className, this.classBytes, this.classLoader) : manager.getClassMetaData(className, this.classLoader);
        if (this.forceComputeStackFrames && returnObject.isCanBeAssignedToAnything()) {
            throw new UnableToGetMetaDataException(String.format("Unable to obtain ClassMetaData for %s from ClassLoader %s", className, this.classLoader != null ? this.classLoader : "BootstrapClassLoader"));
        }
        return returnObject;
    }
}

