/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.ClassReader;
import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.tree.analysis.AnalyzerException;
import com.singularity.ee.agent.appagent.AgentEntryPoint;
import com.singularity.ee.agent.appagent.IAgentClassLoader;
import com.singularity.ee.agent.appagent.java9.IJava9Util;
import com.singularity.ee.agent.appagent.kernel.spi.IAgentEnvironment;
import com.singularity.ee.agent.appagent.kernel.spi.IClassLoadListener;
import com.singularity.ee.agent.appagent.services.bciengine.ASMConsumerFactory;
import com.singularity.ee.agent.appagent.services.bciengine.BCIEngineService;
import com.singularity.ee.agent.appagent.services.bciengine.ByteCodeTransformerHelper;
import com.singularity.ee.agent.appagent.services.bciengine.IByteCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.IDeferredClassBCIHandler;
import com.singularity.ee.agent.appagent.services.bciengine.InstrumentationTracker;
import com.singularity.ee.agent.appagent.services.bciengine.ModifiedMethods;
import com.singularity.ee.agent.appagent.services.bciengine.RuntimeExcludeManager;
import com.singularity.ee.agent.appagent.services.bciengine.TimeoutWaitingForLockException;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationRuleEngine;
import com.singularity.ee.agent.appagent.services.bciengine.asm.AddClassAnnotationTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.BCIEngineClassVerifier;
import com.singularity.ee.agent.appagent.services.bciengine.asm.BCIEngineClassWriter;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassCorruptor;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassMetaDataManager;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodContainingUnreachableInstructions;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodInvocationTrapTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.NewClassImplementationTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.UnreachableInstructionCorrector;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.ClassAttribute;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.ClassAttributeManager;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.ClassIdentificationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IAgentEventDataHandler;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineInfoProvider;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;
import com.singularity.ee.agent.debug.events.AgentDebugEvent;
import com.singularity.ee.agent.debug.events.AgentDebugTransformationEvent;
import com.singularity.ee.agent.debug.spi.IAgentDebugEventSenderBase;
import com.singularity.ee.agent.util.JavaVersionUtil;
import com.singularity.ee.agent.util.classloader.BootStrapClassLoaderProxy;
import com.singularity.ee.agent.util.log4j.ADLevel;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicLongImpl;
import com.singularity.ee.util.spi.IAgentAtomicLong;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.management.ManagementFactory;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class ByteCodeTransformer
implements ClassFileTransformer,
IByteCodeTransformer {
    private static final String APPDYNAMICS_BCIENGINE_WRITE2DISK_PROPERTY = "appdynamics.bciengine.write2disk";
    private static final String SHOULD_PREVERIFY_CLASS_PROPERTY = "appdynamics.bciengine.class.verify";
    private static final String SHOULD_DEFER_RISKY_BCI_PROPERTY = "appdynamics.bciengine.defer.risky.bci";
    private static final String SHOULD_IMPLEMENT_NEW_INTERFACES_PROPERTY = "appdynamics.bciengine.should.implement.new.interfaces";
    private static final String SHOULD_SKIP_CLASS_FOR_TEST = "appdynamics.bciengine.should.skip.class.on.initial.load";
    private static String modifiedClassesDumpPath = SystemUtils.getProperty((String)"appdynamics.bciengine.write2disk", null);
    private static final boolean SHOULD_PREVERIFY_CLASS = Boolean.valueOf(SystemUtils.getProperty((String)"appdynamics.bciengine.class.verify", (String)"true"));
    private static final boolean SHOULD_DEFER_RISKY_BCI = Boolean.valueOf(SystemUtils.getProperty((String)"appdynamics.bciengine.defer.risky.bci", (String)"true"));
    private static final boolean SHOULD_IMPLEMENT_NEW_INTERFACES = Boolean.valueOf(SystemUtils.getProperty((String)"appdynamics.bciengine.should.implement.new.interfaces", (String)"true"));
    private static final int MINIMUM_CLASS_VERSION_REQUIRING_STACK_FRAMES = 50;
    private static final int MINIMUM_CLASS_VERSION_REQUIRING_ENCLOSING_METHOD = 50;
    private static final String CLASS_WRITE_BEFORE_SUBDIR = "before";
    private static final String CLASS_WRITE_AFTER_SUBDIR = "after";
    private final IAgentAtomicLong fileOverwriteCount = new AgentAtomicLongImpl(0L);
    private final TransformationRuleEngine ruleEngine;
    private List<IClassLoadListener> classLoadListeners = null;
    private static Object marker = new Object();
    private String shouldSkipClassOnInitialLoad;
    BCIEngineService bciEngine;
    private IDeferredClassBCIHandler deferredBCIHandler;
    private final ThreadLocal<Boolean> dumpCallStackInProgress;
    private final ThreadLocal<Boolean> classRedefinitionInProgress;
    private volatile IBCIEngineInfoProvider infoProvider;
    private final boolean isUsingBootClassLoader;
    private final IAgentClassLoader agentClassLoader;
    private final NewClassImplementationTransformer classImplementationTransformer;
    private final AddClassAnnotationTransformer classAnnotationTransformer;
    private final MethodInvocationTrapTransformer methodInvocationTrapTransformer;
    private final IAgentEventDataHandler agentEventHandler;
    private final boolean isSpecialSynchronizationRequired;
    private final IAgentEnvironment agentEnvironment;
    private final IAgentDebugEventSenderBase debugEventSender;

    public ByteCodeTransformer(TransformationRuleEngine ruleEngine, BCIEngineService bciEngine, IAgentEventDataHandler agentEventHandler, IAgentEnvironment agentEnvironment, IAgentDebugEventSenderBase debugEventSender, IAgentScheduledThreadPoolExecutor agentScheduler, IJava9Util java9Util, BootStrapClassLoaderProxy bootStrapClassLoaderProxy) {
        this.isSpecialSynchronizationRequired = agentEnvironment.isDeadlockProneJVM();
        this.ruleEngine = ruleEngine;
        this.bciEngine = bciEngine;
        this.agentEventHandler = agentEventHandler;
        this.debugEventSender = debugEventSender;
        this.isUsingBootClassLoader = this.getClass().getClassLoader() == null;
        this.shouldSkipClassOnInitialLoad = SystemUtils.getProperty((String)SHOULD_SKIP_CLASS_FOR_TEST);
        this.dumpCallStackInProgress = new ThreadLocal();
        this.classRedefinitionInProgress = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        this.infoProvider = bciEngine.getInfoProvider();
        this.agentEnvironment = agentEnvironment;
        this.agentClassLoader = this.determineAgentClassLoader();
        this.classImplementationTransformer = new NewClassImplementationTransformer(ruleEngine, bciEngine, ASMConsumerFactory.getClassMetaDataManagerInstance(bciEngine, agentScheduler, java9Util, bootStrapClassLoaderProxy), agentEnvironment);
        this.classAnnotationTransformer = new AddClassAnnotationTransformer(ruleEngine);
        this.methodInvocationTrapTransformer = new MethodInvocationTrapTransformer(ruleEngine);
    }

    private IAgentClassLoader determineAgentClassLoader() {
        ClassLoader agentClassLoader;
        IAgentClassLoader returnClassLoader = null;
        if (this.getClass().getClassLoader() == null && (agentClassLoader = this.agentEnvironment.getAgentClassLoader()) instanceof IAgentClassLoader) {
            returnClassLoader = (IAgentClassLoader)agentClassLoader;
            try {
                returnClassLoader.setTransformOnCurrentThread(true);
                returnClassLoader.setTransformOnCurrentThread(false);
            }
            catch (AbstractMethodError ame) {
                BCTLoggerUtil.println("AgentClassLoader does not support setTransformOnCurrentThread() method");
                returnClassLoader = null;
            }
            catch (Throwable t) {
                BCTLoggerUtil.printStackTrace(t);
                returnClassLoader = null;
            }
        }
        return returnClassLoader;
    }

    @Override
    public void setDeferredBCIHandler(IDeferredClassBCIHandler deferredBCIHandler) {
        this.deferredBCIHandler = deferredBCIHandler;
    }

    @Override
    public void addClassLoadListener(IClassLoadListener listener) {
        if (this.classLoadListeners == null) {
            this.classLoadListeners = new ArrayList<IClassLoadListener>();
        }
        this.classLoadListeners.add(listener);
    }

    public void notifyListeners(String className) {
        if (this.classLoadListeners != null) {
            for (IClassLoadListener classLoadListener : this.classLoadListeners) {
                classLoadListener.loadedClass(className);
            }
        }
    }

    private void sendSkippedTransformationEvent(String className) {
        if (this.debugEventSender.hasTransformationListener()) {
            this.debugEventSender.onEvent((AgentDebugEvent)new AgentDebugTransformationEvent("skip_transform", className, null, null));
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        return this.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String jvmSuppliedClassName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, Object module) {
        if (this.infoProvider == null) {
            this.infoProvider = this.bciEngine.getInfoProvider();
        }
        if (this.infoProvider != null && classBeingRedefined == null) {
            this.infoProvider.incrementNumClassesLoaded(1);
        }
        if (this.ruleEngine.isTransformerDisabled()) {
            return null;
        }
        BCTLoggerUtil.provideLogger(jvmSuppliedClassName);
        try {
            byte[] byArray = this.transformWithLogging(loader, jvmSuppliedClassName, classBeingRedefined, classfileBuffer, module);
            return byArray;
        }
        finally {
            BCTLoggerUtil.flushLogger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] transformWithLogging(ClassLoader loader, String jvmSuppliedClassName, Class<?> classBeingRedefined, byte[] classfileBuffer, Object module) {
        String className = jvmSuppliedClassName;
        byte[] result = null;
        if (classBeingRedefined != null && this.classRedefinitionInProgress.get().booleanValue()) {
            BCTLoggerUtil.println("Balking at " + className + " while it is being redefined by its instrumented version");
            return null;
        }
        if (this.agentClassLoader != null && classBeingRedefined == null) {
            this.agentClassLoader.setTransformOnCurrentThread(true);
        }
        try {
            ByteCodeTransformerHelper.transformingBytes.set(marker);
            if (className == null && (className = this.extractClassNameFromBytecode(classfileBuffer)) == null) {
                byte[] byArray = null;
                return byArray;
            }
            if (this.bciEngine.shouldDumpCallStackOnLoad(className)) {
                this.dumpCallStackForClassLoad(className, loader);
            }
            if (className.equals(this.shouldSkipClassOnInitialLoad) && classBeingRedefined == null) {
                BCTLoggerUtil.println("Skipping BCI of class " + className + " on initial load");
                byte[] byArray = null;
                return byArray;
            }
            if (loader == AgentEntryPoint.getClassLoader() && !this.bciEngine.isAgentClassesTransformationEnabled()) {
                this.sendSkippedTransformationEvent(className);
                byte[] byArray = null;
                return byArray;
            }
            if (this.isSunReflectDelegateLoader(loader)) {
                this.sendSkippedTransformationEvent(className);
                byte[] byArray = null;
                return byArray;
            }
            InstrumentationTracker.clearInstrumentationForClass(className);
            if (this.excludeProcessing(className, loader)) {
                this.sendSkippedTransformationEvent(className);
                byte[] byArray = null;
                return byArray;
            }
            this.notifyListeners(className);
            result = this.bciEngine.performTransformation(this, loader, className, classBeingRedefined, classfileBuffer, module);
        }
        catch (Throwable e) {
            this.sendSkippedTransformationEvent(className);
            BCTLoggerUtil.warn("Error in transforming class bytes with loader :" + loader + ", className :" + className);
            BCTLoggerUtil.printStackTrace(e);
        }
        finally {
            if (this.agentClassLoader != null && classBeingRedefined == null) {
                this.agentClassLoader.setTransformOnCurrentThread(false);
            }
            ByteCodeTransformerHelper.transformingBytes.remove();
            this.defineBootstrapClass(className, loader, classBeingRedefined, classfileBuffer);
        }
        return result;
    }

    private void defineBootstrapClass(String className, ClassLoader loader, Class<?> classBeingRedefined, byte[] classBytes) {
        if (className != null && loader == null && classBeingRedefined == null && classBytes != null) {
            try {
                ClassMetaDataManager metaDataManager = (ClassMetaDataManager)this.bciEngine.getClassMetaDataManager();
                if (metaDataManager != null) {
                    metaDataManager.getClassMetaData(className, classBytes, loader);
                }
                this.bciEngine.getBootstrapClassManager().newBootstrapClassLoaded(className);
                if (this.infoProvider != null) {
                    this.infoProvider.incrementNumberOfBootstrapClassLoads(1);
                }
            }
            catch (Throwable t) {
                BCTLoggerUtil.warn("Error in transforming class bytes with loader :" + loader + ", className :" + className);
                BCTLoggerUtil.printStackTrace(t);
            }
        }
    }

    private String extractClassNameFromBytecode(byte[] classfileBuffer) {
        ClassReader reader = new ClassReader(classfileBuffer);
        return reader.getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] doTransform(ClassLoader loader, String className, Class<?> classBeingRedefined, byte[] classfileBuffer, Object module) throws TimeoutWaitingForLockException {
        if (this.infoProvider == null) {
            this.infoProvider = this.bciEngine.getInfoProvider();
        }
        boolean tracingEnabledForCurrentClass = false;
        if (this.infoProvider != null && this.infoProvider.isTracingEnabledFor(className)) {
            BCTLoggerUtil.traceEnabledForCurrentClass.set(Boolean.TRUE);
            tracingEnabledForCurrentClass = true;
        }
        if (this.agentClassLoader != null && classBeingRedefined == null) {
            this.agentClassLoader.setTransformOnCurrentThread(true);
        }
        try {
            if (tracingEnabledForCurrentClass) {
                BCTLoggerUtil.println(String.format("Class %s is being %s", className, classBeingRedefined == null ? "transformed" : "retransformed"));
            }
            BasicClassInfo basicClassInfo = new BasicClassInfo(loader, className, module);
            AClassTransformationRule[] matchedRules = this.ruleEngine.checkBasicClassFilters(basicClassInfo);
            RuntimeClassInfo runtimeClassInfo = null;
            if (classBeingRedefined != null) {
                runtimeClassInfo = new RuntimeClassInfo(classBeingRedefined, this.bciEngine.isClassLookAheadEnabledForClass(className), classfileBuffer, this.bciEngine.isSafeToCallHasAnnotation(classBeingRedefined), this.bciEngine.getClassMetaDataManager());
            } else if (this.bciEngine.isClassLookAheadEnabledForClass(className)) {
                runtimeClassInfo = new RuntimeClassInfo(className, classfileBuffer, loader, this.bciEngine.getClassMetaDataManager());
            }
            if (runtimeClassInfo != null) {
                matchedRules = this.ruleEngine.checkRuntimeClassFilters(basicClassInfo, runtimeClassInfo, matchedRules);
                if (tracingEnabledForCurrentClass) {
                    BCTLoggerUtil.println("The following TransformationRule returned from ruleEngine.checkRuntimeClassFilters():");
                    for (AClassTransformationRule nextRule : matchedRules) {
                        BCTLoggerUtil.println(String.format("    %s", nextRule));
                    }
                }
            }
            this.extractClassAttributesIfRequired(basicClassInfo, runtimeClassInfo, classfileBuffer);
            ClassIdentificationRule[] matchedIdentificationRules = this.ruleEngine.checkBasicClassIdentificationFilters(basicClassInfo);
            if (tracingEnabledForCurrentClass) {
                BCTLoggerUtil.println("The following ClassIdentificationRule returned from ruleEngine.checkBasicClassIdentificationFilters():");
                for (ClassIdentificationRule nextRule : matchedIdentificationRules) {
                    BCTLoggerUtil.println(String.format("    %s", nextRule));
                }
            }
            if (matchedRules.length > 0 || matchedIdentificationRules.length > 0 || classBeingRedefined != null) {
                byte[] bytes = this.modifyByteCode(classfileBuffer, basicClassInfo, runtimeClassInfo, matchedRules, matchedIdentificationRules, tracingEnabledForCurrentClass);
                if (tracingEnabledForCurrentClass) {
                    BCTLoggerUtil.println(String.format("Instrumentation %s performed on class %s", bytes != null ? "was" : "was not", className));
                }
                if (!StringOperations.isEmpty((String)modifiedClassesDumpPath) && bytes != null) {
                    this.writeModifiedClassToDisk(bytes, basicClassInfo, runtimeClassInfo, classfileBuffer);
                }
                if (bytes != null && this.infoProvider != null) {
                    this.infoProvider.incrementNumClassesTransformed(1);
                    if (runtimeClassInfo != null && runtimeClassInfo.getRunTimeClass() != null) {
                        this.infoProvider.incrementNumClassesRetransformed(1);
                    }
                }
                byte[] byArray = bytes;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (this.agentClassLoader != null && classBeingRedefined == null) {
                this.agentClassLoader.setTransformOnCurrentThread(false);
            }
            if (tracingEnabledForCurrentClass) {
                BCTLoggerUtil.traceEnabledForCurrentClass.set(Boolean.FALSE);
            }
        }
    }

    private void writeModifiedClassToDisk(byte[] bytes, BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, byte[] originalBytes) {
        File baseDir = new File(modifiedClassesDumpPath);
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            BCTLoggerUtil.warn("Cannot create directory specified by appdynamics.bciengine.write2disk[" + modifiedClassesDumpPath + "]");
            return;
        }
        if (baseDir.isDirectory()) {
            this.writeModifiedClassToDir(baseDir, bytes, basicClassInfo, runtimeClassInfo, originalBytes);
        } else {
            BCTLoggerUtil.warn("Path specified by appdynamics.bciengine.write2disk property [" + modifiedClassesDumpPath + "] is not a directory.");
        }
    }

    private void writeModifiedClassToDir(File baseDir, byte[] bytes, BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, byte[] originalBytes) {
        File beforeDir = new File(baseDir, CLASS_WRITE_BEFORE_SUBDIR);
        File afterDir = new File(baseDir, CLASS_WRITE_AFTER_SUBDIR);
        if (!beforeDir.exists() && !beforeDir.mkdirs()) {
            BCTLoggerUtil.warn("Cannot create modified class file directory " + beforeDir.getAbsolutePath());
            return;
        }
        if (!afterDir.exists() && !afterDir.mkdirs()) {
            BCTLoggerUtil.warn("Cannot create modified class file directory " + afterDir.getAbsolutePath());
            return;
        }
        this.writeBytesToDisk(beforeDir, originalBytes, basicClassInfo, runtimeClassInfo);
        this.writeBytesToDisk(afterDir, bytes, basicClassInfo, runtimeClassInfo);
    }

    private void writeBytesToDisk(File dir, byte[] bytes, BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo) {
        String className;
        String packageName;
        String classNameWithPkg = basicClassInfo.getClassName();
        int lastSlashAt = (classNameWithPkg = classNameWithPkg.replace('.', '/')).lastIndexOf(47);
        if (lastSlashAt != -1) {
            packageName = classNameWithPkg.substring(0, lastSlashAt);
            className = classNameWithPkg.substring(lastSlashAt + 1);
        } else {
            packageName = "";
            className = classNameWithPkg;
        }
        File classDir = new File(dir.getAbsolutePath() + File.separator + packageName);
        if (!classDir.exists() && !classDir.mkdirs()) {
            BCTLoggerUtil.warn("Cannot create directory [" + classDir.getAbsolutePath() + "]");
            return;
        }
        File file = new File(classDir.getAbsolutePath() + File.separator + className + ".class");
        if (file.exists()) {
            boolean renamed = file.renameTo(new File(file.getAbsolutePath() + "." + this.fileOverwriteCount.incrementAndGet()));
            if (!renamed) {
                BCTLoggerUtil.warn("Could not rename file: [" + file.getAbsolutePath() + "]");
            }
            if (file.exists()) {
                file.delete();
            }
        }
        try {
            FileOutputStream outStream = new FileOutputStream(file);
            outStream.write(bytes);
            outStream.close();
            BCTLoggerUtil.warn("File written [" + file.getAbsolutePath() + "]");
        }
        catch (IOException e) {
            BCTLoggerUtil.warn("Cannot create file [" + file.getAbsolutePath() + "] " + e.getMessage());
        }
    }

    private boolean isSunReflectDelegateLoader(ClassLoader loader) {
        return loader != null && loader.getClass().getName().equals("sun.reflect.DelegatingClassLoader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] modifyByteCode(byte[] oldByteCode, BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, AClassTransformationRule[] matchedRules, ClassIdentificationRule[] matchedIdentificationRules, boolean tracingEnabledForClass) throws TimeoutWaitingForLockException {
        byte[] returnObject;
        block9: {
            returnObject = null;
            ClassLoader myClassLoader = this.getClass().getClassLoader();
            Collection<ClassAttribute> missingAttributes = this.ensureRetransformClassAttributesPresent(basicClassInfo, runtimeClassInfo, oldByteCode);
            try {
                if (!this.isUsingBootClassLoader && this.isSpecialSynchronizationRequired && this.agentEnvironment.isRemoteAttached() && myClassLoader instanceof IAgentClassLoader && basicClassInfo.getLoader() == null && (runtimeClassInfo == null || runtimeClassInfo.getRunTimeClass() == null)) {
                    if ((AgentEntryPoint.reTransformSupported || AgentEntryPoint.reDefinitionSupported) && SHOULD_DEFER_RISKY_BCI && !RuntimeExcludeManager.looksLikeLambdaClassName(basicClassInfo.getClassName())) {
                        this.deferBCIForClass(basicClassInfo, oldByteCode);
                        if (tracingEnabledForClass) {
                            BCTLoggerUtil.println(String.format("BCI deferred for class %s", basicClassInfo.getClassName()));
                        }
                        break block9;
                    }
                    IAgentClassLoader agentClassLoader = (IAgentClassLoader)myClassLoader;
                    if (agentClassLoader.tryToLock()) {
                        try {
                            returnObject = this.modifyByteCodeLocked(oldByteCode, basicClassInfo, runtimeClassInfo, matchedRules, matchedIdentificationRules, missingAttributes, tracingEnabledForClass);
                            break block9;
                        }
                        finally {
                            agentClassLoader.releaseLock();
                        }
                    }
                    BCTLoggerUtil.warn("Unable to instrument class " + basicClassInfo.getClassName() + " because of potential ClassLoader deadlock condition");
                    this.abandonBCI(basicClassInfo, oldByteCode);
                    break block9;
                }
                returnObject = this.modifyByteCodeLocked(oldByteCode, basicClassInfo, runtimeClassInfo, matchedRules, matchedIdentificationRules, missingAttributes, tracingEnabledForClass);
            }
            catch (RuntimeException e) {
                BCTLoggerUtil.printlnWithPrefix(e.toString(), ADLevel.WARN);
                BCTLoggerUtil.printStackTrace(e);
                BCTLoggerUtil.printlnWithPrefix(String.format("Unable to apply instrumentation to class %s", basicClassInfo.getClassName()), ADLevel.WARN);
            }
        }
        return returnObject;
    }

    private byte[] modifyByteCodeLocked(byte[] oldByteCode, BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, AClassTransformationRule[] matchedRules, ClassIdentificationRule[] matchedIdentificationRules, Collection<ClassAttribute> missingAttributes, boolean tracingEnabledForClass) {
        byte[] newerByteCode;
        BCIEngineClassWriter classWriter;
        int classVersion = ByteCodeTransformer.getVersionFromClassBytes(oldByteCode);
        if (tracingEnabledForClass) {
            BCTLoggerUtil.println(String.format("Class version for class %s is %d", basicClassInfo.getClassName(), classVersion));
        }
        boolean stackFramesRequired = classVersion >= 51 || classVersion >= 50 && !this.bciEngine.isStackFramesIgnoredByJVM(JavaVersionUtil.isJava7(), ManagementFactory.getRuntimeMXBean());
        boolean enclosingMethodAttributeRequired = classVersion >= 50;
        int classReaderFlags = stackFramesRequired ? 8 : 4;
        int classWriterFlags = stackFramesRequired ? 2 : 1;
        ClassReader classReader = new ClassReader(oldByteCode);
        Object delegateTo = classWriter = new BCIEngineClassWriter(classReader, classWriterFlags, basicClassInfo.getLoader(), basicClassInfo.getClassName(), oldByteCode, stackFramesRequired);
        if (ClassCorruptor.shouldClassBeCorrupted(basicClassInfo.getClassName())) {
            delegateTo = new ClassCorruptor(basicClassInfo.getClassName(), (ClassVisitor)classWriter);
        }
        ArrayList<TransformationRule> interceptorRules = new ArrayList<TransformationRule>();
        for (AClassTransformationRule nextRule : matchedRules) {
            if (!(nextRule instanceof TransformationRule)) continue;
            interceptorRules.add((TransformationRule)nextRule);
        }
        ClassTransformer classTransformer = new ClassTransformer((ClassVisitor)delegateTo, this.ruleEngine, basicClassInfo, runtimeClassInfo, interceptorRules.toArray(new TransformationRule[interceptorRules.size()]), matchedIdentificationRules, stackFramesRequired, enclosingMethodAttributeRequired, missingAttributes, tracingEnabledForClass, this.bciEngine.isEnableUnreachableThrowTest());
        classReader.accept((ClassVisitor)classTransformer, classReaderFlags);
        boolean classModified = classTransformer.isClassModified();
        if (tracingEnabledForClass) {
            BCTLoggerUtil.println(String.format("Class %s %s modified", basicClassInfo.getClassName(), classModified ? "was" : "was not"));
        }
        if (!classModified) {
            // empty if block
        }
        byte[] newByteCode = null;
        if (classModified) {
            newByteCode = classWriter.toByteArray();
            Set<MethodContainingUnreachableInstructions> setOfUnreachableThrows = classTransformer.getSetOfUnreachableThrowMethods();
            if (setOfUnreachableThrows != null && setOfUnreachableThrows.size() > 0) {
                UnreachableInstructionCorrector unreachableInstructionCorrector = new UnreachableInstructionCorrector(newByteCode, setOfUnreachableThrows);
                newByteCode = unreachableInstructionCorrector.correctClass();
            }
        }
        if ((newerByteCode = this.applyCustomTransformations(newByteCode != null ? newByteCode : oldByteCode, basicClassInfo, runtimeClassInfo, classTransformer.getModifiedMethods(), matchedRules, classWriterFlags, tracingEnabledForClass)) != null) {
            classModified = true;
            newByteCode = newerByteCode;
        }
        if (classModified) {
            block17: {
                if (SHOULD_PREVERIFY_CLASS && !this.bciEngine.isDisableClassVerification()) {
                    try {
                        this.verifyClassBytes(newByteCode, basicClassInfo.getLoader(), classTransformer.getModifiedMethods(), true);
                    }
                    catch (Throwable t) {
                        boolean sameErrorInOriginalClass;
                        block16: {
                            BCTLoggerUtil.println("Exception: " + t.toString() + " caught during validation of modified class " + basicClassInfo.getClassName());
                            sameErrorInOriginalClass = false;
                            try {
                                this.verifyClassBytes(oldByteCode, basicClassInfo.getLoader(), classTransformer.getModifiedMethods(), false);
                            }
                            catch (Throwable t1) {
                                if (!this.isSameError(t, t1)) break block16;
                                sameErrorInOriginalClass = true;
                            }
                        }
                        if (sameErrorInOriginalClass) break block17;
                        BCTLoggerUtil.println("This exception did not exist in original class bytes.");
                        BCTLoggerUtil.printStackTrace(t);
                        this.sendClassValidationFailureEventToController(basicClassInfo, t);
                        this.writeClassFilesToLogDirectory(basicClassInfo, runtimeClassInfo, oldByteCode, newByteCode);
                        newByteCode = null;
                        if (this.infoProvider == null) break block17;
                        this.infoProvider.incrementNumValidationFailures(1);
                    }
                }
            }
            if (newByteCode != null && this.infoProvider != null) {
                this.infoProvider.incrementNumMethodsTransformed(classTransformer.getModifiedMethods().getNumModifiedMethods());
                if (this.infoProvider.isDetailCollection()) {
                    this.infoProvider.defineModifiedClassAndMethods(basicClassInfo.getClassName(), classTransformer.getModifiedMethods());
                }
            }
            return newByteCode;
        }
        return null;
    }

    private byte[] applyCustomTransformations(byte[] oldByteCode, BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, ModifiedMethods modifiedMethods, AClassTransformationRule[] matchedRules, int classWriterFlags, boolean tracingEnabledForClass) {
        byte[] currentBytes = oldByteCode;
        byte[] newByteCode = this.doNewInterfaceImplementationTransformation(currentBytes, basicClassInfo, runtimeClassInfo, matchedRules, classWriterFlags, tracingEnabledForClass);
        if (newByteCode != null) {
            currentBytes = newByteCode;
        }
        if ((newByteCode = this.doAddClassAnnotationTransformation(currentBytes, basicClassInfo, runtimeClassInfo, matchedRules, tracingEnabledForClass)) != null) {
            currentBytes = newByteCode;
        }
        if ((newByteCode = this.doMethodInvocationTrapTransformation(currentBytes, basicClassInfo, runtimeClassInfo, modifiedMethods, matchedRules, tracingEnabledForClass)) != null) {
            currentBytes = newByteCode;
        }
        return currentBytes == oldByteCode ? null : currentBytes;
    }

    private final void verifyClassBytes(byte[] classBytes, ClassLoader classLoader, ModifiedMethods modifiedMethods, boolean testInsnNumbers) throws AnalyzerException {
        BCIEngineClassVerifier verifier = new BCIEngineClassVerifier(classBytes, classLoader);
        verifier.verifyClass(modifiedMethods, testInsnNumbers);
    }

    private final boolean isSameError(Throwable t1, Throwable t2) {
        boolean bReturn = false;
        if (t1.getClass() == t2.getClass()) {
            String[] msg2;
            String re = "Error at instruction \\d+:";
            String[] msg1 = t1.toString().split("Error at instruction \\d+:");
            if (msg1.length == (msg2 = t2.toString().split("Error at instruction \\d+:")).length) {
                bReturn = true;
                for (int i = 0; i < msg1.length; ++i) {
                    if (msg1[i].equals(msg2[i])) continue;
                    bReturn = false;
                    break;
                }
            }
        }
        return bReturn;
    }

    private boolean excludeProcessing(String className, ClassLoader loader) {
        return this.ruleEngine.excludeFromProcessing(className, loader) || this.bciEngine.shouldClassesFromClassLoaderBeExcluded(loader);
    }

    private void abandonBCI(BasicClassInfo basicClassInfo, byte[] classBytes) {
        this.bciEngine.getAbandonedClassBCIManager().abandonClass(basicClassInfo, classBytes);
    }

    private void sendClassValidationFailureEventToController(BasicClassInfo basicClassInfo, Throwable t) {
        this.agentEventHandler.onErrorAgentEvent(null, null, "Unable to BCI class " + basicClassInfo.getClassName() + " because post-BCI class validation failure: " + t.toString());
    }

    private static int getVersionFromClassBytes(byte[] classBytes) {
        int versionNum = classBytes[6] << 8 | classBytes[7];
        return versionNum;
    }

    private void writeClassFilesToLogDirectory(BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, byte[] oldByteCode, byte[] newByteCode) {
        String logDirectory = this.agentEnvironment.getDefaultLogDirectory();
        File logDirectoryFile = new File(logDirectory);
        if (!logDirectoryFile.exists()) {
            BCTLoggerUtil.printlnWithPrefix("Unable to write verify failure class file because " + logDirectory + " is missing", ADLevel.WARN);
        }
        if (logDirectoryFile.isDirectory()) {
            File verifyFailureDirectory = new File(logDirectoryFile, "verifyFailure");
            if (!verifyFailureDirectory.exists() && !verifyFailureDirectory.mkdir()) {
                BCTLoggerUtil.printlnWithPrefix("Unable to write verify failure class file because directory " + verifyFailureDirectory.getAbsolutePath() + " cannot be created", ADLevel.WARN);
                return;
            }
            this.writeModifiedClassToDir(verifyFailureDirectory, newByteCode, basicClassInfo, runtimeClassInfo, oldByteCode);
        } else {
            BCTLoggerUtil.printlnWithPrefix("Unable to write verify failure class file because " + logDirectory + " is not a directory", ADLevel.WARN);
        }
    }

    private void deferBCIForClass(BasicClassInfo basicClassInfo, byte[] classBytes) {
        if (this.deferredBCIHandler != null) {
            if (this.deferredBCIHandler.scheduleForRetransform(basicClassInfo.getClassName().replace('/', '.'), classBytes, basicClassInfo.getLoader())) {
                BCTLoggerUtil.println(" BCI for class " + basicClassInfo.getClassName() + " has been deferred because of potential deadlock");
            } else {
                BCTLoggerUtil.warn("BCI for class " + basicClassInfo.getClassName() + " could not be BCI'd because of potential deadlocks, and cannot be deferred");
                this.abandonBCI(basicClassInfo, classBytes);
                if (this.infoProvider != null) {
                    this.infoProvider.incrementAbandonedBCICount(1);
                }
            }
        }
    }

    private void extractClassAttributesIfRequired(BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, byte[] classBytes) throws TimeoutWaitingForLockException {
        if ((runtimeClassInfo == null || runtimeClassInfo.getRunTimeClass() == null) && ByteCodeTransformer.shouldTestClassAttributes(basicClassInfo, runtimeClassInfo, classBytes)) {
            ClassAttributeManager cam = ClassAttributeManager.getInstance();
            cam.extractAndSaveAttributes(basicClassInfo.getClassName(), basicClassInfo.getLoader(), classBytes);
        }
    }

    static boolean shouldTestClassAttributes(BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, byte[] classBytes) {
        int classVersion = ByteCodeTransformer.getVersionFromClassBytes(classBytes);
        boolean bReturn = classVersion >= 50 && ByteCodeTransformer.isInnerClass(basicClassInfo.getClassName());
        return bReturn;
    }

    public static final boolean isInnerClass(String className) {
        String[] classNameQualifiers = className.split("/");
        return classNameQualifiers[classNameQualifiers.length - 1].contains("$");
    }

    private Collection<ClassAttribute> ensureRetransformClassAttributesPresent(BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, byte[] classBytes) throws TimeoutWaitingForLockException {
        Collection<ClassAttribute> returnObject = null;
        if (runtimeClassInfo != null && runtimeClassInfo.getRunTimeClass() != null && ByteCodeTransformer.shouldTestClassAttributes(basicClassInfo, runtimeClassInfo, classBytes)) {
            returnObject = ClassAttributeManager.getInstance().verifyAllClassAttributesExist(basicClassInfo.getClassName(), basicClassInfo.getLoader(), classBytes, null);
        }
        return returnObject;
    }

    private byte[] doNewInterfaceImplementationTransformation(byte[] oldByteCode, BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, AClassTransformationRule[] matchedRules, int classWriterFlags, boolean tracingEnabledForClass) {
        byte[] result = null;
        if (SHOULD_IMPLEMENT_NEW_INTERFACES) {
            try {
                result = this.classImplementationTransformer.transform(matchedRules, runtimeClassInfo, basicClassInfo, oldByteCode, classWriterFlags);
            }
            catch (Exception e) {
                BCTLoggerUtil.println("Exception " + e.toString() + " caught while attempt to add implemented interfaces for class " + basicClassInfo.getClassName());
                BCTLoggerUtil.printStackTrace(e);
            }
        }
        if (tracingEnabledForClass) {
            BCTLoggerUtil.println(String.format("Class %s %s modified to implement new interfaces", basicClassInfo.getClassName(), result != null ? "was" : "was not"));
        }
        return result;
    }

    private byte[] doAddClassAnnotationTransformation(byte[] oldByteCode, BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, AClassTransformationRule[] matchedRules, boolean tracingEnabledForClass) {
        byte[] result = null;
        try {
            result = this.classAnnotationTransformer.transform(matchedRules, runtimeClassInfo, basicClassInfo, oldByteCode);
        }
        catch (Exception e) {
            BCTLoggerUtil.println("Exception " + e.toString() + " caught while attempt to add annotation for class " + basicClassInfo.getClassName());
            BCTLoggerUtil.printStackTrace(e);
        }
        if (tracingEnabledForClass) {
            BCTLoggerUtil.println(String.format("Class %s %s modified by adding new annotation", basicClassInfo.getClassName(), result != null ? "was" : "was not"));
        }
        return result;
    }

    private byte[] doMethodInvocationTrapTransformation(byte[] oldByteCode, BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, ModifiedMethods modifiedMethods, AClassTransformationRule[] matchedRules, boolean tracingEnabledForClass) {
        byte[] result = null;
        try {
            result = this.methodInvocationTrapTransformer.transform(modifiedMethods, matchedRules, runtimeClassInfo, basicClassInfo, oldByteCode);
        }
        catch (Exception e) {
            BCTLoggerUtil.println("Exception " + e.toString() + " caught while attempt to add annotation for class " + basicClassInfo.getClassName());
            BCTLoggerUtil.printStackTrace(e);
        }
        if (tracingEnabledForClass) {
            BCTLoggerUtil.println(String.format("Class %s %s modified by MethodInvocationTrapTransformation", basicClassInfo.getClassName(), result != null ? "was" : "was not"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpCallStackForClassLoad(String className, ClassLoader loader) {
        Boolean dumpInProgress = this.dumpCallStackInProgress.get();
        if (dumpInProgress == null || !dumpInProgress.booleanValue()) {
            this.dumpCallStackInProgress.set(Boolean.TRUE);
            try {
                StackTraceElement[] trace = Thread.currentThread().getStackTrace();
                StringBuilder sb = new StringBuilder(String.format("Class %s being loaded by %s.  Call stack follows:", className, loader != null ? loader : "bootstrap"));
                for (StackTraceElement nextTraceElement : trace) {
                    sb.append("\n   ").append(nextTraceElement.toString());
                }
                BCTLoggerUtil.println(sb.toString());
            }
            finally {
                this.dumpCallStackInProgress.set(Boolean.FALSE);
            }
        }
    }

    @Override
    public void notifyTransformationTimeout(String className, ClassLoader classLoader, Class<?> classBeingRedefined) {
        if (classBeingRedefined == null) {
            this.classImplementationTransformer.indicateTransformationTimeout(className, classLoader);
        }
    }

    @Override
    public void setClassRedefinitionOnCurrentThread(boolean status) {
        BCTLoggerUtil.println("Setting classRedefinitionInProgress to " + status);
        this.classRedefinitionInProgress.set(status);
    }

    @Override
    public String getBCIWriteClassDirectory() {
        return modifiedClassesDumpPath;
    }

    @Override
    public void setBCIWriteClassDirectory(String directory) {
        modifiedClassesDumpPath = directory;
    }
}

