/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.ClassReader;
import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.ClassWriter;
import com.singularity.asm.org.objectweb.asm.tree.AnnotationNode;
import com.singularity.asm.org.objectweb.asm.tree.ClassNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.ee.agent.appagent.services.bciengine.ASMTypes;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AnnotationInfo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ClassBytecode {
    private final ClassNode classNode;
    private boolean methodBodyModified;

    public ClassBytecode(byte[] originalClassBytes) {
        ClassReader reader = new ClassReader(originalClassBytes);
        this.classNode = new ClassNode();
        reader.accept((ClassVisitor)this.classNode, 0);
    }

    public void markMethodModified() {
        this.methodBodyModified = true;
    }

    public List<AnnotationInfo> getAnnotationList() {
        AnnotationInfo annotationInfo;
        ArrayList<AnnotationInfo> returnList = new ArrayList<AnnotationInfo>();
        if (this.classNode.visibleAnnotations != null) {
            for (AnnotationNode nextAnnotationNode : this.classNode.visibleAnnotations) {
                annotationInfo = this.createAnnotationInfo(nextAnnotationNode, true);
                if (annotationInfo == null) continue;
                returnList.add(annotationInfo);
            }
        }
        if (this.classNode.invisibleAnnotations != null) {
            for (AnnotationNode nextAnnotationNode : this.classNode.invisibleAnnotations) {
                annotationInfo = this.createAnnotationInfo(nextAnnotationNode, false);
                if (annotationInfo == null) continue;
                returnList.add(annotationInfo);
            }
        }
        return returnList;
    }

    public void addClassAnnotationIfAbsent(Class<? extends Annotation> annotationType) {
        String newDesc = ASMTypes.getInstance().getDescriptor(annotationType);
        if (this.isClassAnnotationPresent(newDesc)) {
            return;
        }
        AnnotationNode newNode = new AnnotationNode(newDesc);
        if (this.classNode.visibleAnnotations == null) {
            this.classNode.visibleAnnotations = new ArrayList();
        }
        this.classNode.visibleAnnotations.add(newNode);
    }

    private boolean isClassAnnotationPresent(String desc) {
        if (this.classNode.visibleAnnotations != null) {
            for (AnnotationNode nextAnnotationNode : this.classNode.visibleAnnotations) {
                if (!nextAnnotationNode.desc.equals(desc)) continue;
                return true;
            }
        }
        if (this.classNode.invisibleAnnotations != null) {
            for (AnnotationNode nextAnnotationNode : this.classNode.invisibleAnnotations) {
                if (!nextAnnotationNode.desc.equals(desc)) continue;
                return true;
            }
        }
        return false;
    }

    private AnnotationInfo createAnnotationInfo(AnnotationNode annotationNode, boolean visible) {
        HashMap nameValuePairs = new HashMap();
        if (annotationNode.values != null) {
            Iterator nameValuePairIter = annotationNode.values.iterator();
            while (nameValuePairIter.hasNext()) {
                String name = (String)nameValuePairIter.next();
                if (!nameValuePairIter.hasNext()) break;
                Object value = nameValuePairIter.next();
                nameValuePairs.put(name, value);
            }
        }
        AnnotationInfo returnAnnotationInfo = new AnnotationInfo(annotationNode.desc, visible, nameValuePairs);
        return returnAnnotationInfo;
    }

    public byte[] generateAndGetBytes() {
        int asmClassWriterFlags = 0;
        if (this.methodBodyModified) {
            asmClassWriterFlags = 3;
        }
        ClassWriter cw = new ClassWriter(asmClassWriterFlags);
        this.classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public List<MethodNode> getMethods() {
        return this.classNode.methods;
    }

    public String getSuperName() {
        return this.classNode.superName;
    }

    public List<String> getInterfaces() {
        return this.classNode.interfaces;
    }
}

