/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.MethodVisitor;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodCorruptor;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

class ClassCorruptor
extends ClassVisitor {
    private static final String PROP_NAME_BASE = "appdynamics.bciengine.corrupt.class.";
    private static final Map<CorruptThisClass, Map<CorruptThisMethod, CorruptThisMethod>> classesToCorrupt = new HashMap<CorruptThisClass, Map<CorruptThisMethod, CorruptThisMethod>>();
    private final String className;
    private final Map<CorruptThisMethod, CorruptThisMethod> methodsToCorruptMap;

    public ClassCorruptor(String className, ClassVisitor cv) {
        super(589824, cv);
        this.className = className;
        this.methodsToCorruptMap = ClassCorruptor.getClassCorruption(className);
        if (this.methodsToCorruptMap != null) {
            BCTLoggerUtil.println("Class " + className + " will be deliberately corrupted by BCI Engine");
        }
    }

    private static final Map<CorruptThisMethod, CorruptThisMethod> getClassCorruption(String className) {
        Map<CorruptThisMethod, CorruptThisMethod> returnValue = null;
        returnValue = classesToCorrupt.get(new CorruptThisClass(className.replace('/', '.')));
        return returnValue;
    }

    public static boolean shouldClassBeCorrupted(String className) {
        return ClassCorruptor.getClassCorruption(className) != null;
    }

    public String getClassName() {
        return this.className;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        CorruptThisMethod corruptThisMethod;
        MethodVisitor delegateTo = this.cv.visitMethod(access, name, desc, signature, exceptions);
        MethodCorruptor methodCorruptor = null;
        if (this.methodsToCorruptMap != null && (corruptThisMethod = this.methodsToCorruptMap.get(new CorruptThisMethod(name))) != null) {
            methodCorruptor = new MethodCorruptor(name, corruptThisMethod.corruptionType, delegateTo, this);
        }
        if (methodCorruptor != null) {
            return methodCorruptor;
        }
        return delegateTo;
    }

    static {
        Properties sysProps = new Properties();
        sysProps.putAll((Map<?, ?>)System.getProperties());
        for (Map.Entry<Object, Object> nextEntry : sysProps.entrySet()) {
            MethodCorruptor.CorruptionType type;
            String[] classNameAndType;
            String key = (String)nextEntry.getKey();
            String value = (String)nextEntry.getValue();
            if (!key.startsWith(PROP_NAME_BASE) || (classNameAndType = value.split(",")).length != 3 || classNameAndType[0].length() <= 0 || classNameAndType[1].length() <= 0 || classNameAndType[2].length() <= 0 || (type = MethodCorruptor.parseCorruptionType(classNameAndType[2])) == null) continue;
            CorruptThisClass searchKey = new CorruptThisClass(classNameAndType[0]);
            Map<CorruptThisMethod, CorruptThisMethod> methods = classesToCorrupt.get(searchKey);
            if (methods == null) {
                methods = new HashMap<CorruptThisMethod, CorruptThisMethod>();
                classesToCorrupt.put(searchKey, methods);
            }
            CorruptThisMethod toInsert = new CorruptThisMethod(classNameAndType[1], type);
            methods.put(toInsert, toInsert);
        }
    }

    private static class CorruptThisMethod {
        String methodName;
        MethodCorruptor.CorruptionType corruptionType;
        int hashValue;

        CorruptThisMethod(String methodName) {
            this(methodName, null);
        }

        CorruptThisMethod(String methodName, MethodCorruptor.CorruptionType corruptionType) {
            this.methodName = methodName;
            this.corruptionType = corruptionType;
            this.hashValue = methodName.hashCode();
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object o) {
            boolean bReturn;
            boolean bl = bReturn = this == o;
            if (!bReturn && o instanceof CorruptThisMethod) {
                CorruptThisMethod other = (CorruptThisMethod)o;
                bReturn = this.hashValue == other.hashValue && this.methodName.equals(other.methodName);
            }
            return bReturn;
        }
    }

    private static class CorruptThisClass {
        String className;
        private final int hashValue;

        CorruptThisClass(String className) {
            this.className = className;
            this.hashValue = className.hashCode();
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object o) {
            boolean bReturn;
            boolean bl = bReturn = this == o;
            if (!bReturn && o instanceof CorruptThisClass) {
                CorruptThisClass other = (CorruptThisClass)o;
                bReturn = this.hashValue == other.hashValue && this.className.equals(other.className);
            }
            return bReturn;
        }
    }
}

