/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.ClassReader;
import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.ClassWriter;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.AnnotationNode;
import com.singularity.asm.org.objectweb.asm.tree.ClassNode;
import com.singularity.asm.org.objectweb.asm.tree.FieldNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.ee.agent.appagent.AgentEntryPoint;
import com.singularity.ee.agent.appagent.kernel.classloader.AgentClassLoaderReflector;
import com.singularity.ee.agent.appagent.kernel.spi.IAgentEnvironment;
import com.singularity.ee.agent.appagent.services.bciengine.ClassLoaderReader;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaDataManager;
import com.singularity.ee.agent.appagent.services.bciengine.asm.AMethodGenerator;
import com.singularity.ee.agent.appagent.services.bciengine.asm.SerialVersionUIDFieldCreator;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AnnotationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.util.JarFileUtilities;
import com.singularity.ee.agent.util.reflect.ClassLoaderUtil;
import com.singularity.ee.util.string.StringOperations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassExtensionGenerator
extends AMethodGenerator {
    private final ClassNode classNode;
    private final boolean isLoadedFromBootClassLoader;
    private static final String ENABLE_FIELD_INJECTION = "appdynamics.enable.field.injection";
    private static final boolean enableFieldInjection = StringOperations.safeParseBoolean((String)System.getProperty("appdynamics.enable.field.injection"), (boolean)false);
    private final int asmClassWriterFlags;
    private final IBCIEngineService bciEngine;
    private final IAgentEnvironment agentEnvironment;

    protected ClassExtensionGenerator(IBCIEngineService bciEngine, String nameOfClassBeingCreated, byte[] originalClassBytes, boolean isLoadedFromBootClassLoader, int classWriterFlags, IAgentEnvironment agentEnvironment) {
        super(nameOfClassBeingCreated);
        this.bciEngine = bciEngine;
        this.isLoadedFromBootClassLoader = isLoadedFromBootClassLoader;
        this.asmClassWriterFlags = classWriterFlags;
        this.agentEnvironment = agentEnvironment;
        ClassReader reader = new ClassReader(originalClassBytes);
        this.classNode = new ClassNode();
        reader.accept((ClassVisitor)this.classNode, 0);
    }

    public void forceClassToImplement(String interfaceName, String templateClassName, BasicClassInfo basicClassInfo, IClassMetaDataManager classMetaDataManager, boolean shouldInjectField) throws RuntimeException {
        if (shouldInjectField && !enableFieldInjection) {
            return;
        }
        if ((this.classNode.access & 0x200) != 0) {
            return;
        }
        if (this.doesInterfaceExistInClassLoader(basicClassInfo.getLoader(), interfaceName)) {
            ClassNode templateClass;
            ClassNode interfaceToImplement;
            if (this.isLoadedFromBootClassLoader) {
                List libraryList = AgentEntryPoint.getLibrariesAddedToBootClassPath();
                interfaceToImplement = ClassExtensionGenerator.createClassNode(interfaceName, libraryList);
                try {
                    templateClass = ClassExtensionGenerator.createClassNode(templateClassName, libraryList);
                }
                catch (RuntimeException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Unable to load template class %s from bootstrap class loader", templateClassName), e);
                    }
                    ClassLoader agentClassLoader = this.agentEnvironment.getAgentClassLoader();
                    templateClass = ClassExtensionGenerator.createClassNode(templateClassName, agentClassLoader);
                }
            } else {
                interfaceToImplement = ClassExtensionGenerator.createClassNode(interfaceName, this.getClass().getClassLoader());
                templateClass = ClassExtensionGenerator.createClassNode(templateClassName, this.getClass().getClassLoader());
            }
            this.templateClassName = templateClassName.replace(".", "/");
            Map<String, String> fieldToNewTypeMap = this.createFieldToNewTypeMap(templateClass);
            Map<AMethodGenerator.TypeChangedMethod, AMethodGenerator.TypeChangedMethod> mapOfTypeChangedMethods = this.createNewMethodMap(templateClass);
            List interfaceMethods = interfaceToImplement.methods;
            List bciClassMethods = this.classNode.methods;
            List templateClassMethods = templateClass.methods;
            if (interfaceMethods != null) {
                if (shouldInjectField && !this.injectFieldToClass(this.classNode, templateClass)) {
                    BCTLoggerUtil.println("Field injection was enabled but failed for class " + this.classNode.name + " trying to inject template class " + templateClassName + ". Aborting transformation");
                    return;
                }
                for (MethodNode nextInterfaceMethod : interfaceMethods) {
                    int access = nextInterfaceMethod.access & 7;
                    Type methodReturnType = Type.getReturnType((String)nextInterfaceMethod.desc);
                    Type[] argTypes = Type.getArgumentTypes((String)nextInterfaceMethod.desc);
                    if (this.doesMethodExistInClassOrSuperClass(bciClassMethods, nextInterfaceMethod.name, argTypes, access, methodReturnType, this.classNode, basicClassInfo.getLoader(), classMetaDataManager)) {
                        BCTLoggerUtil.println("Method " + nextInterfaceMethod.name + " with description " + nextInterfaceMethod.desc + " is already defined in class " + this.classNode.name);
                        continue;
                    }
                    MethodNode templateMethod = this.findMethod(templateClassMethods, nextInterfaceMethod.name, argTypes, access, methodReturnType);
                    if (templateMethod == null) {
                        throw new RuntimeException("Method " + nextInterfaceMethod.name + " with description " + nextInterfaceMethod.desc + " is not found in template class " + templateClassName);
                    }
                    templateClassMethods.remove(templateMethod);
                    this.createNewMethodFromTemplate(bciClassMethods, templateMethod, fieldToNewTypeMap, mapOfTypeChangedMethods);
                    BCTLoggerUtil.println(String.format("Method %s added to class %s from template class %s", templateMethod.name, this.classNode.name, templateClassName));
                }
            }
            this.addToImplementedInterfaceNames(interfaceName);
        } else {
            BCTLoggerUtil.println(String.format("Cannot force class %s to implement interface %s - interface not defined in ClassLoader %s", basicClassInfo.getClassName(), interfaceName, basicClassInfo.getLoader()));
            if (basicClassInfo.getLoader() != null && logger.isDebugEnabled()) {
                logger.debug("ClassLoader delegation: " + ClassLoaderUtil.getHierarchMessage(basicClassInfo.getLoader(), logger));
            }
        }
    }

    private boolean injectFieldToClass(ClassNode bciClassNode, ClassNode templateClassNode) {
        if (this.isLoadedFromBootClassLoader) {
            logger.warn("boot class loader unable to transform at the moment");
            return false;
        }
        List templateClassFields = templateClassNode.fields;
        if (templateClassFields.size() > 1) {
            logger.debugParams("More than one field in template class. {} field injected", templateClassFields.size());
        }
        for (FieldNode fieldNode : templateClassFields) {
            if (this.findField(bciClassNode.fields, fieldNode.name, Type.getType((String)fieldNode.desc)) == null) continue;
            BCTLoggerUtil.println(String.format("Field %s already exists! Aborting field injection for class %s", fieldNode.name, bciClassNode.name));
            return false;
        }
        bciClassNode.fields.addAll(templateClassFields);
        return true;
    }

    private boolean doesMethodExistInClassOrSuperClass(List<MethodNode> listOfMethods, String methodName, Type[] argTypes, int access, Type returnType, ClassNode classNode, ClassLoader classLoader, IClassMetaDataManager classMetaDataManager) {
        IClassMetaData classMetaData;
        boolean bReturn;
        MethodNode methodNode = this.findMethod(listOfMethods, methodName, argTypes, access, returnType);
        boolean bl = bReturn = methodNode != null;
        if (!bReturn && classMetaDataManager != null && (classMetaData = classMetaDataManager.getClassMetaData(classNode, classLoader)) != null) {
            String methodDesc = Type.getMethodDescriptor((Type)returnType, (Type[])argTypes);
            for (classMetaData = classMetaData.getSuperClass(); classMetaData != null && !(bReturn = classMetaData.isMethodDefined(methodName, methodDesc)); classMetaData = classMetaData.getSuperClass()) {
            }
        }
        return bReturn;
    }

    private boolean doesInterfaceExistInClassLoader(ClassLoader classLoader, String interfaceName) {
        boolean exists = false;
        interfaceName = interfaceName.replace('/', '.');
        if (classLoader != null) {
            exists = this.doesInterfaceResourceExistInClassLoader(classLoader, interfaceName);
        }
        if (!exists) {
            exists = this.isLoadedFromBootClassLoader || classLoader == null ? ClassExtensionGenerator.testAgentBootClassPathForClass(interfaceName) : this.isDynamicallyDefinedInterface(interfaceName, classLoader);
        }
        return exists;
    }

    private boolean doesInterfaceResourceExistInClassLoader(ClassLoader classLoader, String interfaceName) {
        boolean bReturn;
        ClassLoaderReader classLoaderReader = new ClassLoaderReader(this.bciEngine, classLoader, logger);
        boolean bl = bReturn = classLoaderReader.getInputStreamForClass(interfaceName, false) != null;
        if (!bReturn && (classLoader = classLoader.getParent()) != null) {
            bReturn = this.doesInterfaceResourceExistInClassLoader(classLoader, interfaceName);
        }
        return bReturn;
    }

    private boolean isDynamicallyDefinedInterface(String interfaceName, ClassLoader classLoader) {
        if (this.isLoadedFromBootClassLoader || classLoader == null) {
            return false;
        }
        boolean bReturn = false;
        ClassLoader classLoaderDefinedIn = AgentClassLoaderReflector.getClassLoaderDynamicallyDefinedIn(interfaceName);
        if (classLoaderDefinedIn != null) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Interface %s was dynamically defined to ClassLoader %s", interfaceName, classLoaderDefinedIn));
            }
            ClassLoader currentClassLoader = classLoader;
            do {
                if (currentClassLoader != classLoaderDefinedIn) continue;
                bReturn = true;
                break;
            } while ((currentClassLoader = currentClassLoader.getParent()) != null);
        } else if (logger.isDebugEnabled()) {
            logger.debug(String.format("Interface %s was not dynamically defined to a ClassLoader", interfaceName));
        }
        return bReturn;
    }

    private void addToImplementedInterfaceNames(String interfaceName) {
        List interfaceList;
        interfaceName = interfaceName.replace(".", "/");
        if (this.classNode.interfaces == null) {
            this.classNode.interfaces = new ArrayList();
        }
        if (!(interfaceList = this.classNode.interfaces).contains(interfaceName)) {
            interfaceList.add(interfaceName);
            BCTLoggerUtil.println("Class " + this.classNode.name + " now implements interface " + interfaceName);
        } else {
            BCTLoggerUtil.println("Class " + this.classNode.name + " already implements interface " + interfaceName);
        }
    }

    private static boolean testAgentBootClassPathForClass(String className) {
        List agentBootClassPath = AgentEntryPoint.getLibrariesAddedToBootClassPath();
        return JarFileUtilities.getInputStreamFromURLCollection(className = className.replace('.', '/') + ".class", agentBootClassPath, logger) != null;
    }

    public void defineSerialVersionUIDIfNecessary(BasicClassInfo basicClassInfo) throws RuntimeException {
        new SerialVersionUIDFieldCreator(this.classNode, basicClassInfo.getLoader()).defineSerialVersionUIDIfNecessary();
    }

    public List<AnnotationInfo> getAnnotationList() {
        AnnotationInfo annotationInfo;
        ArrayList<AnnotationInfo> returnList = new ArrayList<AnnotationInfo>();
        if (this.classNode.visibleAnnotations != null) {
            for (AnnotationNode nextAnnotationNode : this.classNode.visibleAnnotations) {
                annotationInfo = this.createAnnotationInfo(nextAnnotationNode, true);
                if (annotationInfo == null) continue;
                returnList.add(annotationInfo);
            }
        }
        if (this.classNode.invisibleAnnotations != null) {
            for (AnnotationNode nextAnnotationNode : this.classNode.invisibleAnnotations) {
                annotationInfo = this.createAnnotationInfo(nextAnnotationNode, false);
                if (annotationInfo == null) continue;
                returnList.add(annotationInfo);
            }
        }
        return returnList;
    }

    private AnnotationInfo createAnnotationInfo(AnnotationNode annotationNode, boolean visible) {
        HashMap nameValuePairs = new HashMap();
        if (annotationNode.values != null) {
            Iterator nameValuePairIter = annotationNode.values.iterator();
            while (nameValuePairIter.hasNext()) {
                String name = (String)nameValuePairIter.next();
                if (!nameValuePairIter.hasNext()) break;
                Object value = nameValuePairIter.next();
                nameValuePairs.put(name, value);
            }
        }
        AnnotationInfo returnAnnotationInfo = new AnnotationInfo(annotationNode.desc, visible, nameValuePairs);
        return returnAnnotationInfo;
    }

    public byte[] generateAndGetBytes() {
        ClassWriter cw = new ClassWriter(this.asmClassWriterFlags);
        this.classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public String getSuperName() {
        return this.classNode.superName;
    }

    public List<String> getInterfaces() {
        return this.classNode.interfaces;
    }
}

