/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.AnnotationVisitor;
import com.singularity.asm.org.objectweb.asm.ClassReader;
import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.MethodVisitor;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.AnnotationNode;
import com.singularity.asm.org.objectweb.asm.tree.ClassNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.ee.agent.appagent.services.bciengine.ClassNameUtils;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassMetaDataManager;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.string.StringOperations;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassMetaData
extends ClassVisitor
implements IClassMetaData {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.ClassMetaData");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final String OBJECT_CLASS_NAME = Object.class.getCanonicalName();
    private static final int MAX_DEPTH = 50;
    private final WeakReference<ClassLoader> classLoaderRef;
    private String className;
    private String superName;
    private volatile WeakReference<ClassMetaData> superClassRef;
    private int access;
    private String[] interfaceNames;
    private volatile WeakReference<ClassMetaData>[] interfaceRefs;
    private volatile boolean errorGettingSuperClass;
    private volatile Type type;
    private volatile String[] allInterfaceNames;
    private volatile String[] annotationNames;
    private List<Type> annotationList;
    private static volatile ClassMetaDataManager manager;
    private static IBCIEngineService bciEngine;
    private boolean sticky;
    private Set<MethodDefinition> methods;
    private volatile boolean canBeAssignedToAnything;
    private WeakReference<Class<?>> refToClass;

    ClassMetaData(String className, ClassMetaDataManager.ClassFileResource classFileResource) {
        super(589824);
        this.classLoaderRef = classFileResource.classLoaderFoundIn != null ? new WeakReference<ClassLoader>(classFileResource.classLoaderFoundIn) : null;
        this.className = ClassNameUtils.convertClassNameToExternalFormat(className);
        if (logger.isTraceEnabled()) {
            logger.trace("Reading class file for class " + className);
        }
        this.init(classFileResource.is);
        this.setSticky();
    }

    ClassMetaData(ClassNode classNode, ClassLoader classLoader) {
        super(589824);
        this.classLoaderRef = classLoader != null ? new WeakReference<ClassLoader>(classLoader) : null;
        this.className = ClassNameUtils.convertClassNameToExternalFormat(classNode.name);
        if (classNode.superName != null) {
            this.superName = ClassNameUtils.convertClassNameToExternalFormat(classNode.superName);
        }
        this.interfaceNames = ClassMetaData.externalizeNames(classNode.interfaces.toArray(new String[classNode.interfaces.size()]));
        this.access = classNode.access;
        List annotationList = classNode.visibleAnnotations;
        if (annotationList != null) {
            this.annotationNames = new String[annotationList.size()];
            int index = 0;
            for (AnnotationNode nextAnnotation : annotationList) {
                this.annotationNames[index++] = ClassNameUtils.convertClassNameToExternalFormat(Type.getType((String)nextAnnotation.desc).getClassName());
            }
        } else {
            this.annotationNames = EMPTY_STRING_ARRAY;
        }
        this.methods = new HashSet<MethodDefinition>();
        if (classNode.methods != null) {
            for (MethodNode methodNode : classNode.methods) {
                this.methods.add(new MethodDefinition(methodNode.name, methodNode.desc));
            }
        }
        this.setSticky();
    }

    protected ClassMetaData(ClassLoader classLoader) {
        super(589824);
        this.classLoaderRef = classLoader != null ? new WeakReference<ClassLoader>(classLoader) : null;
        this.annotationNames = EMPTY_STRING_ARRAY;
    }

    ClassMetaData(Class<?> clazz) {
        this(clazz, null);
    }

    ClassMetaData(Class<?> clazz, byte[] classBytes) {
        super(589824);
        Class<?>[] interfaces;
        this.className = clazz.getName();
        this.classLoaderRef = clazz.getClassLoader() != null ? new WeakReference<ClassLoader>(clazz.getClassLoader()) : null;
        this.access = clazz.getModifiers();
        this.refToClass = new WeakReference(clazz);
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            this.superName = superClass.getName();
            ClassMetaData superClassMetaData = ClassMetaData.getClassMetaDataManager().getClassMetaData(superClass);
            if (superClassMetaData != null) {
                this.superClassRef = new WeakReference<ClassMetaData>(superClassMetaData);
            }
        }
        if ((interfaces = clazz.getInterfaces()) != null) {
            this.interfaceNames = new String[interfaces.length];
            this.interfaceRefs = new WeakReference[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                this.interfaceNames[i] = interfaces[i].getName();
                ClassMetaData interfaceMetaData = ClassMetaData.getClassMetaDataManager().getClassMetaData(interfaces[i]);
                this.interfaceRefs[i] = interfaceMetaData != null ? new WeakReference<ClassMetaData>(interfaceMetaData) : null;
            }
        }
        if (classBytes != null) {
            this.annotationNames = this.getAnnotationNames(classBytes, clazz.getClassLoader());
        }
        this.setSticky();
    }

    ClassMetaData(String className, byte[] classBytes, ClassLoader classLoader) {
        super(589824);
        this.className = ClassNameUtils.convertClassNameToExternalFormat(className);
        this.classLoaderRef = classLoader != null ? new WeakReference<ClassLoader>(classLoader) : null;
        ByteArrayInputStream bais = new ByteArrayInputStream(classBytes);
        this.init(bais);
        this.setSticky();
    }

    ClassMetaData(String className, String superClassName, String[] interfaceNames, int access, Collection<MethodDefinition> methods, ClassLoader classLoader) {
        super(589824);
        this.className = className;
        this.superName = superClassName;
        this.interfaceNames = ClassMetaData.externalizeNames(interfaceNames);
        this.access = access;
        this.classLoaderRef = classLoader != null ? new WeakReference<ClassLoader>(classLoader) : null;
        this.annotationNames = EMPTY_STRING_ARRAY;
        this.methods = new HashSet<MethodDefinition>();
        if (methods != null) {
            this.methods.addAll(methods);
        }
        this.setSticky();
    }

    private static String[] externalizeNames(String[] classNames) {
        String[] returnNames = null;
        if (classNames != null) {
            returnNames = new String[classNames.length];
            for (int i = 0; i < classNames.length; ++i) {
                returnNames[i] = ClassNameUtils.convertClassNameToExternalFormat(classNames[i]);
            }
        }
        return returnNames;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (superName != null) {
            this.superName = ClassNameUtils.convertClassNameToExternalFormat(superName);
        }
        this.access = access;
        this.interfaceNames = ClassMetaData.externalizeNames(interfaces);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (visible) {
            Type annotation = Type.getType((String)desc);
            this.annotationList.add(annotation);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.methods == null) {
            this.methods = new HashSet<MethodDefinition>();
        }
        this.methods.add(new MethodDefinition(name, desc));
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public String getName() {
        return this.className;
    }

    public String getSuperName() {
        return this.superName;
    }

    @Override
    public final ClassLoader getClassLoader() {
        return this.classLoaderRef != null ? (ClassLoader)this.classLoaderRef.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(InputStream is) {
        BufferedInputStream bis = null;
        this.annotationNames = EMPTY_STRING_ARRAY;
        this.interfaceNames = EMPTY_STRING_ARRAY;
        try {
            bis = new BufferedInputStream(is);
            ClassReader reader = new ClassReader((InputStream)bis);
            this.annotationList = new ArrayList<Type>();
            reader.accept((ClassVisitor)this, 7);
            this.annotationNames = new String[this.annotationList.size()];
            for (int i = 0; i < this.annotationNames.length; ++i) {
                this.annotationNames[i] = ClassNameUtils.convertClassNameToExternalFormat(this.annotationList.get(i).getClassName());
            }
            this.annotationList = null;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            ClassLoader classLoader = this.getClassLoader();
            logger.info("Unable to parse class file for " + this.className + " from ClassLoader " + (classLoader != null ? classLoader.toString() : "boot") + " because of " + aioobe.toString() + ".  Annotations cannot be determined");
        }
        catch (Throwable t) {
            ClassLoader classLoader = this.getClassLoader();
            logger.error("Exception " + t.toString() + " caught trying to parse class file for " + this.className + " from ClassLoader " + (classLoader != null ? classLoader.toString() : "boot"), t);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Throwable t) {
                logger.error("Failed to close ClassReader input stream", t);
            }
        }
    }

    @Override
    public boolean isInterface() {
        return (this.access & 0x200) > 0;
    }

    public boolean isAbstract() {
        return (this.access & 0x400) > 0;
    }

    @Override
    public boolean isEnum() {
        return (this.access & 0x4000) > 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.access & 0x2000) > 0;
    }

    @Override
    public IClassMetaData getSuperClass() {
        ClassMetaData superClass;
        ClassMetaData classMetaData = superClass = this.superClassRef != null ? (ClassMetaData)this.superClassRef.get() : null;
        if (superClass == null && !this.errorGettingSuperClass) {
            if (this.getSuperName() != null) {
                superClass = ClassMetaData.getClassMetaDataManager().getClassMetaData(this.getSuperName(), this.getClassLoader());
                this.superClassRef = superClass != null ? new WeakReference<ClassMetaData>(superClass) : null;
                this.errorGettingSuperClass = superClass == null;
            } else {
                this.errorGettingSuperClass = true;
            }
        }
        return superClass;
    }

    ClassMetaData[] getInterfaces() {
        ClassMetaData[] interfaces = new ClassMetaData[this.interfaceNames.length];
        if (this.interfaceRefs == null) {
            this.interfaceRefs = new WeakReference[interfaces.length];
        }
        for (int i = 0; i < this.interfaceNames.length; ++i) {
            ClassMetaData nextInterface;
            ClassMetaData classMetaData = nextInterface = this.interfaceRefs[i] != null ? (ClassMetaData)this.interfaceRefs[i].get() : null;
            if (nextInterface == null) {
                nextInterface = ClassMetaData.getClassMetaDataManager().getClassMetaData(this.interfaceNames[i], this.getClassLoader());
                this.interfaceRefs[i] = nextInterface != null ? new WeakReference<ClassMetaData>(nextInterface) : null;
            }
            interfaces[i] = nextInterface;
        }
        return interfaces;
    }

    @Override
    public boolean doesThisClassExtend(IClassMetaData other) {
        if (other.getName().equals(OBJECT_CLASS_NAME)) {
            return true;
        }
        return this.doesThisClassExtend(other, 0);
    }

    private boolean doesThisClassExtend(IClassMetaData other, int depth) {
        boolean bReturn = false;
        IClassMetaData superClass = this.getSuperClass();
        while (!bReturn && superClass != null && depth++ < 50) {
            bReturn = other.equals(superClass);
            if (bReturn) continue;
            superClass = superClass.getSuperClass();
        }
        return bReturn;
    }

    @Override
    public boolean doesThisClassImplement(IClassMetaData intf) {
        return this.doesThisClassImplement(intf, 0);
    }

    private final boolean doesThisClassImplement(IClassMetaData intf, int depth) {
        boolean bReturn = false;
        ClassMetaData[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!intf.equals(interfaces[i])) continue;
            bReturn = true;
            break;
        }
        if (!bReturn && depth < 50) {
            IClassMetaData superClass = this.getSuperClass();
            if (superClass != null) {
                bReturn = superClass.doesThisClassImplement(intf);
            }
            if (!bReturn) {
                for (int i = 0; i < interfaces.length && !bReturn; ++i) {
                    if (interfaces[i] == null || (bReturn = interfaces[i].doesThisClassExtend(intf, depth + 1))) continue;
                    bReturn = interfaces[i].doesThisClassImplement(intf, depth + 1);
                }
            }
        }
        return bReturn;
    }

    @Override
    public boolean isAssignableFrom(IClassMetaData other) {
        boolean bReturn;
        boolean bl = bReturn = this.equals(other) || this.getName().equals(OBJECT_CLASS_NAME);
        if (!bReturn) {
            bReturn = !this.isInterface() ? other.doesThisClassExtend(this) : other.doesThisClassImplement(this);
        }
        return bReturn;
    }

    @Override
    public int getNumDimensions() {
        return 0;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        boolean bReturn;
        boolean bl = bReturn = this == o;
        if (!bReturn && o instanceof ClassMetaData) {
            bReturn = this.getName().equals(((ClassMetaData)o).getName());
        }
        return bReturn;
    }

    public Type getType() {
        if (this.type == null) {
            this.type = Type.getObjectType((String)ClassNameUtils.convertClassNameToInternalFormat(this.getName()));
        }
        return this.type;
    }

    @Override
    public String[] getDirectAnnotations() {
        if (this.annotationNames == null) {
            ClassLoader classLoader;
            if (this.classLoaderRef == null) {
                classLoader = null;
            } else {
                classLoader = (ClassLoader)this.classLoaderRef.get();
                if (classLoader == null) {
                    this.annotationNames = EMPTY_STRING_ARRAY;
                }
            }
            if (this.annotationNames == null) {
                this.annotationNames = this.getAnnotationNames(null, classLoader);
            }
        }
        return this.annotationNames;
    }

    @Override
    public String[] getAllInterfaceNames() {
        if (this.allInterfaceNames == null) {
            ClassMetaData[] immediateInterfaces;
            HashSet<String> interfaceNames = new HashSet<String>();
            for (ClassMetaData nextInterface : immediateInterfaces = this.getInterfaces()) {
                String[] indirectInterfaceNames;
                interfaceNames.add(nextInterface.getName());
                for (String indirectInterfaceName : indirectInterfaceNames = nextInterface.getAllInterfaceNames()) {
                    interfaceNames.add(indirectInterfaceName);
                }
            }
            IClassMetaData superClass = this.getSuperClass();
            if (superClass != null) {
                String[] superclassInterfaceNames;
                for (String superclassInterfaceName : superclassInterfaceNames = superClass.getAllInterfaceNames()) {
                    interfaceNames.add(superclassInterfaceName);
                }
            }
            this.allInterfaceNames = interfaceNames.toArray(new String[interfaceNames.size()]);
        }
        return this.allInterfaceNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ClassLoader classLoader = this.getClassLoader();
        sb.append("ClassMetaData for " + this.getName() + (classLoader != null ? " from ClassLoader " + classLoader.toString() : ""));
        return sb.toString();
    }

    private String[] getAnnotationNames(byte[] classBytes, ClassLoader classLoader) {
        String[] annotationNames = EMPTY_STRING_ARRAY;
        try {
            ClassMetaData metaDataFromClassFile = null;
            if (classBytes != null) {
                metaDataFromClassFile = new ClassMetaData(this.className, classBytes, classLoader);
            } else {
                String resourceName = ClassNameUtils.convertClassNameToInternalFormat(this.className) + ".class";
                ClassMetaDataManager.ClassFileResource classFileResource = ClassMetaData.getClassMetaDataManager().getClassFileResource(resourceName, this.classLoaderRef != null ? (ClassLoader)this.classLoaderRef.get() : null);
                if (classFileResource != null) {
                    metaDataFromClassFile = new ClassMetaData(this.className, classFileResource);
                }
            }
            if (metaDataFromClassFile != null) {
                annotationNames = metaDataFromClassFile.annotationNames;
            }
        }
        catch (Throwable t) {
            logger.error("Exception: " + t.toString() + " trying to get annotation names for class " + this.className, t);
        }
        return annotationNames;
    }

    private void setSticky() {
        ClassMetaData.getBciEngine();
        this.sticky = bciEngine != null && bciEngine.isGlassfish() && this.annotationNames != null && this.annotationNames.length > 0;
    }

    private Set<MethodDefinition> getMethodsFromClassObject(Class<?> clazz) {
        HashSet<MethodDefinition> returnSet = new HashSet<MethodDefinition>();
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray != null) {
            for (Method nextMethod : methodArray) {
                String name = nextMethod.getName();
                String desc = Type.getMethodDescriptor((Method)nextMethod);
                returnSet.add(new MethodDefinition(name, desc));
            }
        }
        return returnSet;
    }

    boolean isSticky() {
        return this.sticky;
    }

    void setCanBeAssignedToAnything(boolean canBeAssignedToAnything) {
        this.canBeAssignedToAnything = canBeAssignedToAnything;
    }

    @Override
    public boolean isCanBeAssignedToAnything() {
        return this.canBeAssignedToAnything;
    }

    private static IBCIEngineService getBciEngine() {
        if (bciEngine == null && ClassMetaData.getClassMetaDataManager() != null) {
            bciEngine = manager.getBciEngine();
        }
        return bciEngine;
    }

    protected static ClassMetaDataManager getClassMetaDataManager() {
        if (manager == null) {
            manager = ClassMetaDataManager.getInstance();
        }
        return manager;
    }

    @Override
    public boolean isMethodDefined(String methodName, String methodDesc) {
        boolean bReturn = false;
        if (this.methods == null) {
            Class clazz;
            Class clazz2 = clazz = this.refToClass != null ? (Class)this.refToClass.get() : null;
            if (clazz != null) {
                try {
                    this.methods = this.getMethodsFromClassObject(clazz);
                }
                catch (ClassCircularityError e) {
                    logger.warn(String.format("Unable to obtain methods for class %s because of %s", clazz.getName(), e), e);
                }
            }
        }
        if (this.methods != null) {
            bReturn = this.methods.contains(new MethodDefinition(methodName, methodDesc));
        }
        return bReturn;
    }

    class MethodDefinition {
        private final String methodName;
        private final String methodSignature;
        private final int hashValue;

        MethodDefinition(String methodName, String methodSignature) {
            this.methodName = methodName;
            this.methodSignature = methodSignature;
            this.hashValue = methodName.hashCode() ^ methodSignature.hashCode();
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object o) {
            boolean bReturn;
            boolean bl = bReturn = this == o;
            if (!bReturn && o instanceof MethodDefinition) {
                MethodDefinition other = (MethodDefinition)o;
                bReturn = this.hashValue == other.hashValue && StringOperations.eqOrNull((String)this.methodName, (String)other.methodName) && StringOperations.eqOrNull((String)this.methodSignature, (String)other.methodSignature);
            }
            return bReturn;
        }

        String getMethodName() {
            return this.methodName;
        }

        String getMethodSignature() {
            return this.methodSignature;
        }
    }
}

