/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.ClassNode;
import com.singularity.ee.agent.appagent.java9.IJava9Util;
import com.singularity.ee.agent.appagent.services.bciengine.ASURLClassLoaders;
import com.singularity.ee.agent.appagent.services.bciengine.ClassLoaderReader;
import com.singularity.ee.agent.appagent.services.bciengine.ClassNameUtils;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaDataManager;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ArrayClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineInfoProvider;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.util.JavaVersionUtil;
import com.singularity.ee.agent.util.bounded.collections.BoundedConcurrentReferenceHashMapBuilder;
import com.singularity.ee.agent.util.cache.ILRUCacheDeletionAdvisor;
import com.singularity.ee.agent.util.cache.StrongLRUCache;
import com.singularity.ee.agent.util.classloader.BootStrapClassLoaderProxy;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.reflect.AgentReflectionUtility;
import com.singularity.ee.agent.util.reflect.ClassLoaderUtil;
import com.singularity.ee.agent.util.reflect.ReflectionException;
import com.singularity.ee.util.collections.AdaptableConcurrentHashMap;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.system.SystemUtils;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassMetaDataManager
implements IAgentRunnable,
ILRUCacheDeletionAdvisor<String, ClassMetaData>,
IClassMetaDataManager {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.ClassMetaDataManager");
    private static final String[] NO_GET_RESOURCE_FROM_THESE_CLASS_LOADERS = new String[]{"oracle\\.classloader\\.PolicyClassLoader"};
    private final boolean disableCustomClassloaderReader;
    private static final int MAP_FULL_FREE_PCT = 20;
    private static final long MAX_INACTIVE_TIME = 120000L;
    private static final long MONITOR_FREQUENCY = 60L;
    private static final String MAX_ENTRIES_IN_MAP_PROP_NAME = "appdynamics.max.metadata.lru.size";
    private static int MAX_ENTRIES_IN_MAP = 200;
    private static volatile ClassMetaDataManager instance;
    private volatile Method findBootstrapClassOrNullMethod;
    private volatile Method findLoadedClassMethod;
    private volatile Method getBootstrapResourceMethod;
    private volatile ClassLoader bootClassLoader;
    private volatile long sumOfTimesToCreate;
    private volatile int numMetaDataCreated;
    private volatile int numFailedResourceSearches;
    private volatile int numFailedClassSearches;
    volatile int numClassResourceFilesRead;
    private final IBCIEngineService bciEngine;
    private static volatile ClassMetaData dummyMetaData;
    private final AdaptableConcurrentHashMap<ClassLoader, ClassLoaderReader> mapOfClassLoaderReaders = new AdaptableConcurrentHashMap();
    private final AdaptableConcurrentHashMap<ClassLoader, StrongLRUCache<String, ClassMetaData>> classMap;
    private final StrongLRUCache<String, ClassMetaData> bootClassLoaderMap;
    private boolean traceMode;
    private Set<String> classesLocatedInTraceMode;
    private AdaptableConcurrentHashMap<ClassLoader, Object> glassfishClassLoaders = null;
    private AdaptableConcurrentHashMap<ClassLoader, Boolean> badReflectionASURLClassLoaders = null;
    private static final Object DUMMY_CLASS_LOADER;
    private Collection<String> noGetResourceFromTheseClassLoaders;
    private volatile IBCIEngineInfoProvider infoProvider;
    private static final boolean usingBootClassLoader;
    private volatile ClassLoader java9PlatformClassLoader;
    private volatile boolean errorGettingPlatformClassLoader;
    private final IAgentScheduledThreadPoolExecutor agentScheduler;
    private final IJava9Util java9Util;
    private final BootStrapClassLoaderProxy bootStrapClassLoaderProxy;

    ClassMetaDataManager(IBCIEngineService bciEngine, IAgentScheduledThreadPoolExecutor agentScheduler, IJava9Util java9Util, BootStrapClassLoaderProxy bootStrapClassLoaderProxy) {
        this.agentScheduler = agentScheduler;
        this.java9Util = java9Util;
        String maxEntriesInMapString = System.getProperty(MAX_ENTRIES_IN_MAP_PROP_NAME);
        if (maxEntriesInMapString != null) {
            try {
                MAX_ENTRIES_IN_MAP = Integer.parseInt(maxEntriesInMapString);
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid value: " + maxEntriesInMapString + " for property " + MAX_ENTRIES_IN_MAP_PROP_NAME);
            }
        }
        this.classMap = new AdaptableConcurrentHashMap(16, AdaptableConcurrentHashMap.ReferenceType.WEAK, AdaptableConcurrentHashMap.ReferenceType.STRONG);
        this.bootClassLoaderMap = new StrongLRUCache(MAX_ENTRIES_IN_MAP, 20, "Boot ClassLoader", 120000L, (ILRUCacheDeletionAdvisor)this, agentScheduler);
        this.bciEngine = bciEngine;
        this.bootStrapClassLoaderProxy = bootStrapClassLoaderProxy;
        this.disableCustomClassloaderReader = this.bciEngine.isClassLoaderReaderDisabled();
        this.getAdditionalClassLoadersToAvoidGetResource();
        agentScheduler.scheduleAtFixedRate(this, 60L, 60L, AgentTimeUnit.SECONDS);
        if (logger.isDebugEnabled()) {
            logger.debug("ClassMetaDatamanager created with disableCustomClassloaderReader = " + this.disableCustomClassloaderReader);
            logger.debug("Monitoring task has been created");
        }
    }

    public static final ClassMetaDataManager getInstance(IBCIEngineService bciEngine, IAgentScheduledThreadPoolExecutor agentSchedular, IJava9Util java9Util, BootStrapClassLoaderProxy bootStrapClassLoaderProxy) {
        if (instance == null) {
            ClassMetaDataManager.getInstanceSync(bciEngine, agentSchedular, java9Util, bootStrapClassLoaderProxy);
        }
        return instance;
    }

    private static final synchronized ClassMetaDataManager getInstanceSync(IBCIEngineService bciEngine, IAgentScheduledThreadPoolExecutor agentSchedular, IJava9Util java9Util, BootStrapClassLoaderProxy bootStrapClassLoaderProxy) {
        if (instance == null) {
            instance = new ClassMetaDataManager(bciEngine, agentSchedular, java9Util, bootStrapClassLoaderProxy);
        }
        return instance;
    }

    public static final ClassMetaDataManager getInstance() {
        return instance;
    }

    private final ClassMetaData getClassMetaData(Factory factory) {
        ClassMetaData returnObject = this.getExistingMetaData(factory.getClassName(), factory.classLoader);
        if (returnObject == null) {
            long currentTime = System.currentTimeMillis();
            returnObject = factory.createClassMetaData();
            if (returnObject != null) {
                long timeToCreate = System.currentTimeMillis() - currentTime;
                this.getInfoProvider();
                if (this.infoProvider != null) {
                    this.infoProvider.incrementTimeToCreateMetaData(timeToCreate);
                }
                if (logger.isTraceEnabled()) {
                    this.sumOfTimesToCreate += timeToCreate;
                    ++this.numMetaDataCreated;
                    logger.trace("Time to create ClassMetaData for class " + returnObject.getName() + " is " + Long.toString(timeToCreate) + " milli-seconds");
                }
                returnObject = this.saveMetaData(returnObject);
            } else {
                returnObject = ClassMetaDataManager.getDummyMetaData();
                this.saveMetaData(factory.getClassName(), factory.classLoader, returnObject);
            }
        }
        return returnObject;
    }

    private final StrongLRUCache<String, ClassMetaData> getMapForClassLoader(ClassLoader classLoader) {
        StrongLRUCache returnObject = null;
        if (classLoader == null) {
            returnObject = this.bootClassLoaderMap;
        } else {
            StrongLRUCache existingClassLoaderMap;
            returnObject = (StrongLRUCache)this.classMap.get((Object)classLoader);
            if (returnObject == null && (existingClassLoaderMap = (StrongLRUCache)this.classMap.putIfAbsent((Object)classLoader, (Object)(returnObject = new StrongLRUCache(MAX_ENTRIES_IN_MAP, 20, ClassMetaDataManager.getClassLoaderName(classLoader), 120000L, (ILRUCacheDeletionAdvisor)this, this.agentScheduler)))) != null) {
                returnObject = existingClassLoaderMap;
            }
        }
        return returnObject;
    }

    private static String getClassLoaderName(ClassLoader classLoader) {
        String[] nameArray = classLoader.toString().trim().split("\n");
        String name = nameArray.length > 0 ? nameArray[0] : "unknown";
        return name.length() > 60 ? name.substring(0, 60) : name;
    }

    private final ClassMetaData getExistingMetaData(String className, ClassLoader classLoader) {
        StrongLRUCache<String, ClassMetaData> mapForClassLoader;
        ClassMetaData returnObject = null;
        if (className.startsWith("java.")) {
            classLoader = null;
        }
        if (classLoader != null && (returnObject = this.getExistingMetaData(className, classLoader.getParent())) == ClassMetaDataManager.getDummyMetaData()) {
            returnObject = null;
        }
        if (returnObject == null && (mapForClassLoader = this.getMapForClassLoader(classLoader)) != null) {
            returnObject = (ClassMetaData)mapForClassLoader.get((Object)className);
        }
        return returnObject;
    }

    private final ClassMetaData saveMetaData(ClassMetaData metaData) {
        ClassMetaData returnObject = metaData;
        ClassLoader classLoader = metaData.getClassLoader();
        StrongLRUCache<String, ClassMetaData> classLoaderMap = this.getMapForClassLoader(classLoader);
        ClassMetaData existing = (ClassMetaData)classLoaderMap.putIfAbsent((Object)metaData.getName(), (Object)metaData);
        if (existing != null) {
            returnObject = existing;
        }
        return returnObject;
    }

    private final ClassMetaData saveMetaData(String className, ClassLoader classLoader, ClassMetaData metaData) {
        ClassMetaData returnObject = metaData;
        StrongLRUCache<String, ClassMetaData> classLoaderMap = this.getMapForClassLoader(classLoader);
        ClassMetaData existing = (ClassMetaData)classLoaderMap.putIfAbsent((Object)className, (Object)metaData);
        if (existing != null) {
            returnObject = existing;
        }
        return returnObject;
    }

    @Override
    public final IClassMetaData getClassMetaDataIntf(String className, ClassLoader classLoader) {
        return this.getClassMetaData(className, classLoader, true);
    }

    public final ClassMetaData getClassMetaData(String className, ClassLoader classLoader) {
        return this.getClassMetaData(className, classLoader, true);
    }

    @Override
    public final ClassMetaData getClassMetaData(String className, ClassLoader classLoader, boolean shouldLogIfMissing) {
        if (className.endsWith("[]")) {
            return this.getClassMetaData(new FactoryFromArrayClass(className.substring(0, className.length() - 2), classLoader, shouldLogIfMissing));
        }
        return this.getClassMetaData(new FactoryFromClassFile(className, classLoader, shouldLogIfMissing));
    }

    @Override
    public final IClassMetaData getClassMetaData(Object cn, ClassLoader classLoader) {
        return this.getClassMetaData(new FactoryFromClassNode((ClassNode)cn, classLoader));
    }

    public final ClassMetaData getClassMetaData(Type type, ClassLoader classLoader) {
        if (type.getSort() == 10) {
            return this.getClassMetaData(new FactoryFromClassFile(type.getClassName(), classLoader));
        }
        if (type.getSort() == 9) {
            String className = type.getClassName();
            return this.getClassMetaData(new FactoryFromArrayClass(className.substring(0, className.length() - 2), classLoader));
        }
        return null;
    }

    public final ClassMetaData getClassMetaData(Class<?> clazz) {
        return this.getClassMetaData(new FactoryFromClassObject(clazz));
    }

    @Override
    public final ClassMetaData getClassMetaData(Class<?> clazz, byte[] classBytes) {
        return this.getClassMetaData(new FactoryFromClassObject(clazz, classBytes));
    }

    @Override
    public final ClassMetaData getClassMetaData(String className, byte[] classFileImage, ClassLoader classLoader) {
        return this.getClassMetaData(new FactoryFromClassBytes(className, classFileImage, classLoader));
    }

    public final ClassMetaData getClassMetaData(String className, String superClassName, String[] interfaceNames, int access, Collection<ClassMetaData.MethodDefinition> methods, ClassLoader classLoader) {
        return this.getClassMetaData(new FactoryFromAllMetaData(className, superClassName, interfaceNames, access, methods, classLoader));
    }

    private final Class<?> locateClass(String className, ClassLoader classLoader) {
        Class returnClass = null;
        if (this.classesLocatedInTraceMode != null) {
            this.classesLocatedInTraceMode.add(className);
        }
        if (className.startsWith("java.")) {
            classLoader = null;
        }
        if (classLoader != null) {
            returnClass = this.locateClass(className, classLoader.getParent());
        }
        if (returnClass == null) {
            try {
                if (classLoader != null) {
                    if (this.findLoadedClassMethod == null) {
                        this.findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                        this.findLoadedClassMethod.setAccessible(true);
                    }
                    if ((returnClass = (Class)this.findLoadedClassMethod.invoke((Object)classLoader, className)) == null) {
                        returnClass = (Class)this.findLoadedClassMethod.invoke((Object)classLoader, ClassNameUtils.convertClassNameToExternalFormat(className));
                    }
                } else {
                    returnClass = this.locateBootstrapClass(className);
                }
            }
            catch (Throwable t) {
                logger.error("Got exception: " + t.toString() + " trying to locate Class object for " + className, t);
            }
        }
        if (returnClass == null) {
            ++this.numFailedClassSearches;
        }
        return returnClass;
    }

    private final Class<?> locateBootstrapClass(String className) {
        Class<?> returnClass;
        block2: {
            returnClass = null;
            try {
                returnClass = this.bciEngine.getBootstrapClassManager().getBootstrapClassIfLoaded(className);
            }
            catch (ClassNotFoundException e) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace(e.toString() + " received trying to obtain bootstrap class " + className, e);
            }
        }
        return returnClass;
    }

    final ClassFileResource getClassFileResource(String resourceName, ClassLoader classLoader) {
        return this.getClassFileResource(resourceName, classLoader, true);
    }

    private ClassFileResource getClassFileResource(String resourceName, ClassLoader classLoader, boolean delegateToParent) {
        ClassFileResource returnObject = null;
        if (classLoader != null && delegateToParent) {
            returnObject = this.getClassFileResource(resourceName, classLoader.getParent());
        }
        if (returnObject == null) {
            if (classLoader != null) {
                if (this.shouldLoadClassFileResourcesFrom(classLoader)) {
                    long startTime = System.currentTimeMillis();
                    InputStream is = this.getInputStreamForClass(resourceName, classLoader);
                    if (is != null) {
                        returnObject = new ClassFileResource(classLoader, is);
                        ++this.numClassResourceFilesRead;
                        if (this.getInfoProvider() != null) {
                            this.infoProvider.incrementTimeToReadClassFiles(System.currentTimeMillis() - startTime);
                        }
                    }
                }
            } else {
                returnObject = this.getBootstrapResource(resourceName);
            }
        }
        if (returnObject == null) {
            ClassLoader platformClassLoader;
            if (JavaVersionUtil.isJava9orHigher() && classLoader == null && (platformClassLoader = this.getPlatformClassLoader()) != null) {
                returnObject = this.getClassFileResource(resourceName, platformClassLoader, false);
            }
            if (returnObject == null) {
                ++this.numFailedResourceSearches;
            }
        }
        return returnObject;
    }

    private ClassLoader getPlatformClassLoader() {
        if (this.java9PlatformClassLoader == null && !this.errorGettingPlatformClassLoader) {
            try {
                this.java9PlatformClassLoader = this.java9Util.getPlatformClassLoader();
            }
            catch (Exception e) {
                this.errorGettingPlatformClassLoader = true;
                logger.error(String.format("Unable to locate Java9 PlatformClassLoader: %s", e.toString()), e);
            }
        }
        return this.java9PlatformClassLoader;
    }

    private ClassLoaderReader getClassLoaderReader(ClassLoader classLoader) {
        ClassLoaderReader priorClassLoaderReader;
        ClassLoaderReader returnClassLoaderReader = (ClassLoaderReader)this.mapOfClassLoaderReaders.get((Object)classLoader);
        if (returnClassLoaderReader == null && (priorClassLoaderReader = (ClassLoaderReader)this.mapOfClassLoaderReaders.putIfAbsent((Object)classLoader, (Object)(returnClassLoaderReader = new ClassLoaderReader(this.bciEngine, classLoader, logger)))) != null) {
            returnClassLoaderReader = priorClassLoaderReader;
        }
        return returnClassLoaderReader;
    }

    private final ClassFileResource getBootstrapResource(String resourceName) {
        ClassFileResource returnObject = null;
        InputStream bootstrapResource = null;
        try {
            bootstrapResource = this.bootStrapClassLoaderProxy.getBootstrapResource(resourceName);
            if (bootstrapResource != null) {
                returnObject = new ClassFileResource(null, bootstrapResource);
                ++this.numClassResourceFilesRead;
            }
        }
        catch (Throwable t) {
            logger.error("Got exception: " + t.getMessage() + " trying to locate resource ", t);
        }
        return returnObject;
    }

    private InputStream getInputStreamForClass(String resourceName, ClassLoader classLoader) {
        if (this.disableCustomClassloaderReader) {
            return classLoader.getResourceAsStream(resourceName);
        }
        ClassLoaderReader reader = this.getClassLoaderReader(classLoader);
        return reader.getInputStreamForClass(resourceName);
    }

    public void run() {
        long startTime = System.currentTimeMillis();
        this.classMap.purgeStaleEntries();
        if (this.getInfoProvider() != null) {
            this.infoProvider.incrementTimeToPurgeMetaData(System.currentTimeMillis() - startTime);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Number of ClassMetaData created =               " + Integer.toString(this.numMetaDataCreated));
            logger.debug("Number of class file resources read =           " + Integer.toString(this.numClassResourceFilesRead));
            logger.debug("Number of failed class searches =               " + Integer.toString(this.numFailedClassSearches));
            logger.debug("Number of failed class file resource searches = " + Integer.toString(this.numFailedResourceSearches));
            logger.debug("Total time to create =                          " + Long.toString(this.sumOfTimesToCreate));
            logger.debug("Statistics for ClassMetaDataManager LRUCaches follows:");
            logger.debug(this.bootClassLoaderMap.toString());
            for (StrongLRUCache nextCache : this.classMap.values()) {
                logger.debug(nextCache);
            }
        }
    }

    public boolean shouldDelete(String key, ClassMetaData value) {
        return !value.isSticky();
    }

    @Override
    public void setTraceMode(boolean traceMode) {
        this.traceMode = traceMode;
        if (!traceMode) {
            this.classesLocatedInTraceMode = null;
        } else if (this.classesLocatedInTraceMode == null) {
            this.classesLocatedInTraceMode = new HashSet<String>();
        }
    }

    @Override
    public Set<String> getClassesLocatedInTraceMode() {
        HashSet<String> returnSet = null;
        if (this.classesLocatedInTraceMode != null) {
            returnSet = new HashSet<String>(this.classesLocatedInTraceMode);
        }
        return returnSet;
    }

    private boolean shouldLoadClassFileResourcesFrom(ClassLoader classLoader) {
        boolean bReturn = true;
        if (this.bciEngine.isGlassfish()) {
            boolean bl = bReturn = !this.isDoneClassLoaderPresent(classLoader);
            if (!bReturn && logger.isDebugEnabled()) {
                logger.debug("Unable to load class file resources from " + classLoader.toString() + " because \"done\" ASURLClassLoader found in ClassLoader hierarchy");
            }
        }
        if (bReturn) {
            String classLoaderClassName = classLoader.getClass().getName();
            for (String nextClassLoaderRegEx : this.noGetResourceFromTheseClassLoaders) {
                if (!classLoaderClassName.matches(nextClassLoaderRegEx)) continue;
                bReturn = false;
                break;
            }
        }
        return bReturn;
    }

    private static ClassLoader getAncestorASURLClassLoader(ClassLoader classLoader) {
        ClassLoader returnClassLoader = null;
        if (classLoader != null) {
            Class<?> classLoaderClass = classLoader.getClass();
            returnClassLoader = ASURLClassLoaders.isASURLClassLoader(classLoaderClass) ? classLoader : ClassMetaDataManager.getAncestorASURLClassLoader(classLoader.getParent());
        }
        return returnClassLoader;
    }

    @Override
    public boolean isDoneClassLoaderPresent(ClassLoader classLoader) {
        boolean bReturn = false;
        if (classLoader != null) {
            Object maybeASURLClassLoader;
            if (this.glassfishClassLoaders == null) {
                this.getClassLoaderMap();
            }
            if ((maybeASURLClassLoader = this.glassfishClassLoaders.get((Object)classLoader)) == null) {
                maybeASURLClassLoader = ClassMetaDataManager.getAncestorASURLClassLoader(classLoader);
                if (maybeASURLClassLoader == null) {
                    maybeASURLClassLoader = DUMMY_CLASS_LOADER;
                }
                this.glassfishClassLoaders.put((Object)classLoader, maybeASURLClassLoader);
            }
            if (maybeASURLClassLoader != DUMMY_CLASS_LOADER) {
                bReturn = this.isDoneASURLClassLoader((ClassLoader)maybeASURLClassLoader);
            }
        }
        return bReturn;
    }

    private synchronized AdaptableConcurrentHashMap<ClassLoader, Object> getClassLoaderMap() {
        if (this.glassfishClassLoaders == null) {
            this.glassfishClassLoaders = new BoundedConcurrentReferenceHashMapBuilder().withValueType(AdaptableConcurrentHashMap.ReferenceType.WEAK).withServiceName("BCIEngine").withPropertyName("ClassMetaData-glassfishClassLoaders-limit").build();
        }
        return this.glassfishClassLoaders;
    }

    @Override
    public boolean isDoneASURLClassLoader(ClassLoader classLoader) {
        boolean bReturn = false;
        this.getBadReflectionASURLClassLoadersMap();
        Boolean isReflectionError = (Boolean)this.badReflectionASURLClassLoaders.get((Object)classLoader);
        if (isReflectionError == null || !isReflectionError.booleanValue()) {
            try {
                Boolean doneCalled = (Boolean)AgentReflectionUtility.getFieldWithoutReporting(classLoader, "doneCalled", true);
                if (doneCalled != null) {
                    bReturn = doneCalled;
                }
            }
            catch (ReflectionException re) {
                logger.error(re.toString() + " caught trying to get doneCalled field for " + classLoader.toString(), re);
                this.badReflectionASURLClassLoaders.put((Object)classLoader, (Object)Boolean.TRUE);
            }
        }
        return bReturn;
    }

    private synchronized AdaptableConcurrentHashMap<ClassLoader, Boolean> getBadReflectionASURLClassLoadersMap() {
        if (this.badReflectionASURLClassLoaders == null) {
            this.badReflectionASURLClassLoaders = new BoundedConcurrentReferenceHashMapBuilder().withServiceName("BCIEngine").withPropertyName("ClassMetaData-BadGlassfishClassLoaders-limit").build();
        }
        return this.badReflectionASURLClassLoaders;
    }

    @Override
    public IBCIEngineService getBciEngine() {
        return this.bciEngine;
    }

    private static ClassMetaData getDummyMetaData() {
        if (dummyMetaData == null) {
            dummyMetaData = new ClassMetaData("", "java.lang.Object", new String[0], 0, null, null);
            dummyMetaData.setCanBeAssignedToAnything(true);
        }
        return dummyMetaData;
    }

    private void getAdditionalClassLoadersToAvoidGetResource() {
        this.noGetResourceFromTheseClassLoaders = new ArrayList<String>();
        String noGetResourceClassLoaderProp = SystemUtils.getProperty((String)"appdynamics.no.get.resource.class.loaders");
        if (!StringOperations.isEmpty((String)noGetResourceClassLoaderProp)) {
            List noGetResourceClassLoaders = StringOperations.parseCommaSeparatedString((String)noGetResourceClassLoaderProp);
            this.noGetResourceFromTheseClassLoaders.addAll(noGetResourceClassLoaders);
        }
        if (this.noGetResourceFromTheseClassLoaders.size() == 0) {
            for (String nextBuiltinClassLoaderToAvoid : NO_GET_RESOURCE_FROM_THESE_CLASS_LOADERS) {
                this.noGetResourceFromTheseClassLoaders.add(nextBuiltinClassLoaderToAvoid);
            }
        }
    }

    private IBCIEngineInfoProvider getInfoProvider() {
        if (this.infoProvider == null) {
            this.infoProvider = this.bciEngine.getInfoProvider();
        }
        return this.infoProvider;
    }

    static {
        DUMMY_CLASS_LOADER = new Object();
        usingBootClassLoader = ClassLoaderUtil.isBootstrapLoaded(ClassMetaDataManager.class);
    }

    static class ClassFileResource {
        ClassLoader classLoaderFoundIn;
        InputStream is;

        ClassFileResource(ClassLoader classLoaderFoundIn, InputStream is) {
            this.classLoaderFoundIn = classLoaderFoundIn;
            this.is = is;
        }
    }

    private static class FactoryFromAllMetaData
    extends Factory {
        private final String className;
        private final String superClassName;
        private final String[] interfaceNames;
        private final int access;
        private final Collection<ClassMetaData.MethodDefinition> methods;

        FactoryFromAllMetaData(String className, String superClassName, String[] interfaceNames, int access, Collection<ClassMetaData.MethodDefinition> methods, ClassLoader classLoader) {
            super(classLoader);
            this.className = className;
            this.superClassName = superClassName;
            this.interfaceNames = interfaceNames;
            this.access = access;
            this.methods = methods;
        }

        @Override
        ClassMetaData createClassMetaData() {
            return new ClassMetaData(this.className, this.superClassName, this.interfaceNames, this.access, this.methods, this.classLoader);
        }

        @Override
        String getClassName() {
            return ClassNameUtils.convertClassNameToExternalFormat(this.className);
        }
    }

    private static class FactoryFromClassBytes
    extends Factory {
        private final String className;
        private final byte[] classBytes;

        FactoryFromClassBytes(String className, byte[] classFileImage, ClassLoader classLoader) {
            super(classLoader);
            this.className = className;
            this.classBytes = classFileImage;
        }

        @Override
        ClassMetaData createClassMetaData() {
            return new ClassMetaData(this.className, this.classBytes, this.classLoader);
        }

        @Override
        String getClassName() {
            return ClassNameUtils.convertClassNameToExternalFormat(this.className);
        }
    }

    private static class FactoryFromClassObject
    extends Factory {
        private final Class<?> clazz;
        private byte[] classBytes;

        FactoryFromClassObject(Class<?> clazz) {
            this(clazz, null);
        }

        FactoryFromClassObject(Class<?> clazz, byte[] classBytes) {
            super(clazz.getClassLoader());
            this.clazz = clazz;
            this.classBytes = classBytes;
        }

        @Override
        ClassMetaData createClassMetaData() {
            return new ClassMetaData(this.clazz, this.classBytes);
        }

        @Override
        String getClassName() {
            return this.clazz.getName();
        }
    }

    private static class FactoryFromArrayClass
    extends Factory {
        private final String baseClassName;
        private final boolean shouldLogIfUnableToFind;

        FactoryFromArrayClass(String baseClassName, ClassLoader classLoader) {
            this(baseClassName, classLoader, true);
        }

        FactoryFromArrayClass(String baseClassName, ClassLoader classLoader, boolean shouldLogIfUnableToFind) {
            super(classLoader);
            this.baseClassName = baseClassName;
            this.shouldLogIfUnableToFind = shouldLogIfUnableToFind;
        }

        @Override
        ClassMetaData createClassMetaData() {
            return new ArrayClassMetaData(this.baseClassName, this.classLoader, this.shouldLogIfUnableToFind);
        }

        @Override
        String getClassName() {
            return ClassNameUtils.convertClassNameToExternalFormat(this.baseClassName) + "[]";
        }
    }

    private static class FactoryFromClassNode
    extends Factory {
        private final ClassNode classNode;

        FactoryFromClassNode(ClassNode classNode, ClassLoader classLoader) {
            super(classLoader);
            this.classNode = classNode;
        }

        @Override
        ClassMetaData createClassMetaData() {
            return new ClassMetaData(this.classNode, this.classLoader);
        }

        @Override
        String getClassName() {
            return ClassNameUtils.convertClassNameToExternalFormat(this.classNode.name);
        }
    }

    private class FactoryFromClassFile
    extends Factory {
        private final String className;
        private final boolean logUnableToLocate;

        FactoryFromClassFile(String className, ClassLoader classLoader) {
            this(className, classLoader, true);
        }

        FactoryFromClassFile(String className, ClassLoader classLoader, boolean logUnableToLocate) {
            super(classLoader);
            this.className = className;
            this.logUnableToLocate = logUnableToLocate;
        }

        @Override
        ClassMetaData createClassMetaData() {
            ClassMetaData returnObject = null;
            Class loadedClass = ClassMetaDataManager.this.locateClass(this.className, this.classLoader);
            if (loadedClass != null) {
                returnObject = new ClassMetaData(loadedClass);
            } else {
                String resourceName = ClassNameUtils.convertClassNameToInternalFormat(this.className) + ".class";
                ClassFileResource cfr = ClassMetaDataManager.this.getClassFileResource(resourceName, this.classLoader);
                if (cfr != null) {
                    returnObject = new ClassMetaData(this.className, cfr);
                } else if (logger.isInfoEnabled() && this.logUnableToLocate) {
                    logger.info("Unable to locate class meta data for " + this.className);
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Unable to locate class meta data for " + this.className);
                }
            }
            return returnObject;
        }

        @Override
        String getClassName() {
            return ClassNameUtils.convertClassNameToExternalFormat(this.className);
        }
    }

    private static abstract class Factory {
        ClassLoader classLoader;

        protected Factory(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        abstract ClassMetaData createClassMetaData();

        abstract String getClassName();
    }
}

