/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaData;
import com.singularity.ee.agent.util.reflect.Types;
import com.singularity.ee.util.dtobootimpl.StringMatchBoot;
import com.singularity.ee.util.string.StringOperations;

public abstract class ClassMetaDataUtility
extends Types {
    public static boolean extendsFromClass(IClassMetaData metaData, StringMatchBoot superClassMatchData) {
        if (metaData.getName().equals("java.lang.Object")) {
            return false;
        }
        IClassMetaData superClass = metaData.getSuperClass();
        if (superClass != null && !StringOperations.isEmpty((String)superClass.getName())) {
            if (superClassMatchData.matchString(superClass.getName())) {
                return true;
            }
            return ClassMetaDataUtility.extendsFromClass(superClass, superClassMatchData);
        }
        return false;
    }

    public static boolean hasDirectAnnotation(IClassMetaData metaData, StringMatchBoot annotationNameData) {
        String[] annos = metaData.getDirectAnnotations();
        for (int i = 0; i < annos.length; ++i) {
            if (!annotationNameData.matchString(annos[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotation(IClassMetaData classMetaData, StringMatchBoot annotationCls) {
        String[] annotations;
        if (classMetaData == null || classMetaData.getName().equals("java.lang.Object")) {
            return false;
        }
        for (String annotation : annotations = classMetaData.getDirectAnnotations()) {
            if (!annotationCls.matchString(annotation)) continue;
            return true;
        }
        IClassMetaData superClass = classMetaData.getSuperClass();
        return superClass != null ? ClassMetaDataUtility.hasAnnotation(superClass, annotationCls) : false;
    }

    public static boolean implementsInterface(IClassMetaData cmd, StringMatchBoot matchIntfData) {
        String[] interfaceNames;
        for (String interfaceName : interfaceNames = cmd.getAllInterfaceNames()) {
            if (!matchIntfData.matchString(interfaceName)) continue;
            return true;
        }
        return false;
    }

    public static boolean implementsInterface(IClassMetaData cmd, String matchIntf) {
        String[] interfaceNames;
        for (String interfaceName : interfaceNames = cmd.getAllInterfaceNames()) {
            if (!interfaceName.equals(matchIntf)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsOrIsAssignableFrom(IClassMetaData cmd, String className) {
        if (cmd.getName().equals(className)) {
            return true;
        }
        if (ClassMetaDataUtility.implementsInterface(cmd, className)) {
            return true;
        }
        return ClassMetaDataUtility.extendsFromClass(cmd, className);
    }

    public static boolean extendsFromClass(IClassMetaData cmd, String superClassName) {
        if (cmd.getName().equals("java.lang.Object")) {
            return false;
        }
        IClassMetaData superClass = cmd.getSuperClass();
        if (superClass != null && !StringOperations.isEmpty((String)superClass.getName())) {
            if (superClass.getName().equals(superClassName)) {
                return true;
            }
            return ClassMetaDataUtility.extendsFromClass(superClass, superClassName);
        }
        return false;
    }
}

