/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.AnnotationVisitor;
import com.singularity.asm.org.objectweb.asm.Attribute;
import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.FieldVisitor;
import com.singularity.asm.org.objectweb.asm.MethodVisitor;
import com.singularity.asm.org.objectweb.asm.commons.JSRInlinerAdapter;
import com.singularity.ee.agent.appagent.services.bciengine.ModifiedMethods;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationRuleEngine;
import com.singularity.ee.agent.appagent.services.bciengine.asm.AnnotationLister;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ByteCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodAnalyzer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodContainingUnreachableInstructions;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MidMethodTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.ClassAttribute;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.EnclosingMethodAttribute;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.appagent.services.bciengine.spi.ClassIdentificationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AnnotationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ByteCodeClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.MethodInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;
import com.singularity.ee.agent.util.JavaVersionUtil;
import com.singularity.ee.util.string.StringOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public final class ClassTransformer
extends ClassVisitor {
    private final TransformationRuleEngine ruleEngine;
    private final BasicClassInfo basicClassInfo;
    private final RuntimeClassInfo runtimeClassInfo;
    private TransformationRule[] matchedRules;
    private final ClassIdentificationRule[] matchedIdentificationRules;
    private String superClassName;
    private String[] interfaces;
    private final List<AnnotationInfo> annotations;
    private boolean isInterface;
    private boolean checkedForBytecodeAndRuntimeClassFilters;
    private boolean classMatched;
    private boolean classModified;
    private final ModifiedMethods modifiedMethods;
    private final boolean forceCompute;
    private boolean forceVisitOuterClassMethodRequired;
    private final boolean enclosingMethodAttributeRequired;
    private EnclosingMethodAttribute enclosingMethodAttribute;
    private boolean traceEnabledForClass;
    private final IBCIEngineService.UnreachableThrowableTestAction unReachableThrowableTest;
    private Set<MethodContainingUnreachableInstructions> setOfUnreachableThrowMethods;

    public ClassTransformer(ClassVisitor cv, TransformationRuleEngine ruleEngine, BasicClassInfo basicClassInfo, RuntimeClassInfo runtimeClassInfo, TransformationRule[] matchedRules, ClassIdentificationRule[] matchedIdentificationRules, boolean forceCompute, boolean enclosingMethodAttributeRequired, Collection<ClassAttribute> missingClassAttributes, boolean traceEnabledForClass, IBCIEngineService.UnreachableThrowableTestAction unReachableThrowableTest) {
        super(589824, cv);
        this.ruleEngine = ruleEngine;
        this.basicClassInfo = basicClassInfo;
        this.runtimeClassInfo = runtimeClassInfo;
        this.matchedRules = matchedRules;
        this.matchedIdentificationRules = matchedIdentificationRules;
        this.annotations = new ArrayList<AnnotationInfo>();
        this.forceCompute = forceCompute;
        this.unReachableThrowableTest = unReachableThrowableTest;
        this.enclosingMethodAttributeRequired = enclosingMethodAttributeRequired;
        this.modifiedMethods = new ModifiedMethods();
        this.setEnclosingMethodAttribute(missingClassAttributes);
        this.traceEnabledForClass = traceEnabledForClass;
        if (traceEnabledForClass && matchedRules != null && matchedRules.length > 0) {
            BCTLoggerUtil.println(String.format("The following matchedRules were passed to ClassTransformer for class %s", basicClassInfo.getClassName()));
            for (TransformationRule transformationRule : matchedRules) {
                BCTLoggerUtil.println(String.format("   %s", transformationRule));
            }
        }
        if (traceEnabledForClass && matchedIdentificationRules != null && matchedIdentificationRules.length > 0) {
            BCTLoggerUtil.println(String.format("The following matchedIdentificationRules were passed to ClassTransformer for class %s", basicClassInfo.getClassName()));
            for (ClassIdentificationRule classIdentificationRule : matchedIdentificationRules) {
                BCTLoggerUtil.println(String.format("   %s", classIdentificationRule));
            }
        }
    }

    private void setEnclosingMethodAttribute(Collection<ClassAttribute> missingClassAttributes) {
        if (this.enclosingMethodAttributeRequired && ByteCodeTransformer.isInnerClass(this.basicClassInfo.getClassName()) && this.runtimeClassInfo != null && this.runtimeClassInfo.getRunTimeClass() != null && missingClassAttributes != null) {
            for (ClassAttribute nextAttr : missingClassAttributes) {
                if (nextAttr.getAttributeType() != ClassAttribute.AttributeType.EnclosingMethod) continue;
                this.enclosingMethodAttribute = (EnclosingMethodAttribute)nextAttr;
                this.forceVisitOuterClassMethodRequired = true;
                break;
            }
        }
    }

    public void visitOuterClass(String owner, String methodName, String methodDesc) {
        super.visitOuterClass(owner, methodName, methodDesc);
        this.forceVisitOuterClassMethodRequired = false;
    }

    private void forceVisitOuterClassMethod() {
        if (this.forceVisitOuterClassMethodRequired && this.enclosingMethodAttribute != null) {
            this.visitOuterClass(this.enclosingMethodAttribute.getEnclosingClass(), this.enclosingMethodAttribute.getEnclosingMethodName(), this.enclosingMethodAttribute.getEnclosingMethodDesc());
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superClassName = superName;
        this.interfaces = interfaces;
        this.isInterface = (access & 0x200) != 0;
        this.cv.visit(version, access, name, signature, superName, interfaces);
        if (this.traceEnabledForClass) {
            if (superName != null) {
                BCTLoggerUtil.println(String.format("Superclass of class %s is %s", name, superName));
            }
            if (interfaces != null && interfaces.length > 0) {
                String allInterfaces = StringOperations.convertToCommaSeparateString((String[])interfaces);
                BCTLoggerUtil.println(String.format("Interfaces implement by class %s are %s", name, allInterfaces));
            }
        }
    }

    public void visitAttribute(Attribute attr) {
        this.forceVisitOuterClassMethod();
        super.visitAttribute(attr);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.forceVisitOuterClassMethod();
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.forceVisitOuterClassMethod();
        return super.visitField(access, name, desc, signature, value);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.forceVisitOuterClassMethod();
        AnnotationVisitor av = this.cv.visitAnnotation(desc, visible);
        if (av != null) {
            return new AnnotationLister(av, desc, visible, this.annotations);
        }
        return av;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.forceVisitOuterClassMethod();
        if (!this.checkedForBytecodeAndRuntimeClassFilters) {
            ByteCodeClassInfo byteCodeClassInfo = new ByteCodeClassInfo(this.superClassName, this.interfaces, this.annotations.toArray(new AnnotationInfo[this.annotations.size()]), this.runtimeClassInfo);
            if (this.matchedRules.length > 0) {
                this.matchedRules = this.ruleEngine.checkByteCodeClassFilters(this.basicClassInfo, this.runtimeClassInfo, byteCodeClassInfo, this.matchedRules);
                if (this.traceEnabledForClass && this.matchedRules != null && this.matchedRules.length > 0) {
                    BCTLoggerUtil.println(String.format("The following matchedRules were returned from checkByteCodeClassFilters() for class %s method %s %s", this.basicClassInfo.getClassName(), name, desc));
                    for (TransformationRule rule : this.matchedRules) {
                        BCTLoggerUtil.println(String.format("   %s", rule));
                    }
                }
            }
            if (this.matchedIdentificationRules.length > 0) {
                this.ruleEngine.checkByteCodeClassIdentificationFilters(this.basicClassInfo, this.runtimeClassInfo, byteCodeClassInfo, this.matchedIdentificationRules);
            }
            this.checkedForBytecodeAndRuntimeClassFilters = true;
            if (this.matchedRules.length > 0 && (JavaVersionUtil.isJava8orHigher() || !this.isInterface)) {
                this.classMatched = true;
            }
        }
        if (this.traceEnabledForClass) {
            BCTLoggerUtil.println(String.format("Class %s is %s for method %s %s", this.basicClassInfo.getClassName(), this.classMatched ? "matched" : "not matched", name, desc));
        }
        if (!this.classMatched) {
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
        boolean isSynthetic = (access & 0x1000) != 0;
        boolean isStaticInitializer = name.equals("<clinit>");
        boolean isStatic = (access & 8) != 0;
        Object mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (!isSynthetic && !isStaticInitializer) {
            if (this.ruleEngine.hasMidMethodInterceptors(this.basicClassInfo, new MethodInfo(access, isStatic, name, desc, signature, exceptions, this.annotations.toArray(new AnnotationInfo[this.annotations.size()])))) {
                mv = new MidMethodTransformer(this, (MethodVisitor)mv, access, name, desc, exceptions, signature, this.basicClassInfo.getClassName(), this.ruleEngine, this.forceCompute, this.traceEnabledForClass);
            }
            MethodTransformer mt = new MethodTransformer(this, (MethodVisitor)mv, access, name, desc, exceptions, signature, this.basicClassInfo.getClassName(), this.ruleEngine, this.matchedRules, this.forceCompute, this.traceEnabledForClass, this.unReachableThrowableTest);
            MethodAnalyzer methodAnalyzer = new MethodAnalyzer((MethodVisitor)mt, mt, access, name, desc, signature, exceptions);
            if (this.forceCompute) {
                mv = new JSRInlinerAdapter((MethodVisitor)methodAnalyzer, access, name, desc, signature, exceptions);
                return mv;
            }
            return methodAnalyzer;
        }
        if (this.forceCompute) {
            mv = new JSRInlinerAdapter(mv, access, name, desc, signature, exceptions);
        }
        return mv;
    }

    public boolean isClassMatched() {
        return this.classMatched;
    }

    public boolean isClassModified() {
        return this.classModified;
    }

    public void setClassModified(boolean modified) {
        this.classModified = modified;
    }

    ModifiedMethods getModifiedMethods() {
        return this.modifiedMethods;
    }

    void setMethodModified(String methodName, String methodDesc) {
        this.modifiedMethods.indicateMethodModified(methodName, methodDesc);
    }

    void setInsnRangeInjected(String methodName, String methodDesc, int firstInsn, int lastInsn) {
        this.modifiedMethods.defineInjectedInstructionRange(methodName, methodDesc, firstInsn, lastInsn);
    }

    void refreshRangeInjected(String methodName, String methodDesc, TreeMap<Integer, Integer> newInjectVsOffsetAmount) {
        this.modifiedMethods.refreshInjectedInstructionRange(methodName, methodDesc, newInjectVsOffsetAmount);
    }

    BasicClassInfo getBasicClassInfo() {
        return this.basicClassInfo;
    }

    void setMethodModifiedByTransformationInfos(String methodName, String methodDesc, TransformationInfo[] transformationInfos) {
        this.modifiedMethods.setMethodModifiedByTransformationInfos(methodName, methodDesc, transformationInfos);
    }

    void methodHasUnreachableInstructions(String methodName, String desc) {
        if (this.setOfUnreachableThrowMethods == null) {
            this.setOfUnreachableThrowMethods = new HashSet<MethodContainingUnreachableInstructions>();
        }
        MethodContainingUnreachableInstructions newObject = new MethodContainingUnreachableInstructions(methodName, desc);
        this.setOfUnreachableThrowMethods.add(newObject);
    }

    Set<MethodContainingUnreachableInstructions> getSetOfUnreachableThrowMethods() {
        return this.setOfUnreachableThrowMethods;
    }
}

