/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.ee.agent.appagent.services.bciengine.ADeferredClassRetransformer;
import com.singularity.ee.agent.appagent.services.bciengine.BCILock;
import com.singularity.ee.agent.appagent.services.bciengine.ClassToRetransform;
import com.singularity.ee.agent.appagent.services.bciengine.IDeferredClassBCIHandler;
import com.singularity.ee.agent.appagent.services.bciengine.TimeoutWaitingForLockException;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.management.memory.IMemoryLimitCheck;
import com.singularity.ee.agent.util.log4j.ADLevel;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DeferredClassBCIHandler
implements IAgentRunnable,
IDeferredClassBCIHandler {
    private static final int MAX_QUEUE_SIZE = 500;
    private static final int MAX_ATTEMPTS_PER_CLASS = 5;
    private final IAgentScheduledExecutorService scheduler;
    private final BCILock lock = new BCILock("DeferredBootBCIHandler");
    private Set<ClassToRetransform> classesToRetransform;
    private boolean currentlyScheduled;
    private static final long scheduleDelay = 5L;
    private final ADeferredClassRetransformer retransformer;

    public DeferredClassBCIHandler(Instrumentation instrumentation, IBCIEngineService bciEngine, IMemoryLimitCheck memoryLimitCheck, IAgentScheduledThreadPoolExecutor agentScheduler) {
        this.scheduler = agentScheduler;
        this.retransformer = ADeferredClassRetransformer.getBootClassTransformer(instrumentation, bciEngine, memoryLimitCheck);
        new ClassToRetransform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scheduleForRetransform(String className, byte[] classBytes, ClassLoader classLoader) {
        boolean bReturn = false;
        try {
            this.lock.synchronize();
            try {
                if (this.classesToRetransform == null) {
                    this.classesToRetransform = DeferredClassBCIHandler.getRetransformSet();
                }
                if (this.classesToRetransform.size() < 500) {
                    if (!this.retransformer.areClassBytesRequired()) {
                        classBytes = null;
                    }
                    this.classesToRetransform.add(new ClassToRetransform(className, classBytes, classLoader));
                    if (!this.currentlyScheduled) {
                        this.scheduleRetransformTask();
                    }
                    bReturn = true;
                }
            }
            finally {
                this.lock.unsynchronize();
            }
        }
        catch (TimeoutWaitingForLockException e) {
            BCTLoggerUtil.printStackTrace(e);
        }
        return bReturn;
    }

    private void scheduleRetransformTask() throws TimeoutWaitingForLockException {
        this.lock.synchronize();
        try {
            if (!this.currentlyScheduled) {
                this.scheduler.schedule(this, 5L, AgentTimeUnit.SECONDS);
                this.currentlyScheduled = true;
            }
        }
        finally {
            this.lock.unsynchronize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Collection<ClassToRetransform> failed;
            Set<ClassToRetransform> setToProcess;
            this.lock.lock();
            try {
                setToProcess = this.classesToRetransform;
                this.classesToRetransform = null;
            }
            finally {
                this.lock.unlock();
            }
            ArrayList<ClassToRetransform> retransformFailClasses = new ArrayList<ClassToRetransform>();
            if (setToProcess != null && (failed = this.retransformClass(setToProcess)) != null) {
                retransformFailClasses.addAll(failed);
            }
            for (ClassToRetransform nextFailedRequest : retransformFailClasses) {
                BCTLoggerUtil.printlnWithPrefix(" Deferred BCI processing could not be performed on class " + nextFailedRequest.getClassName() + (nextFailedRequest.incrementNumberOfRetransformAttempts() < 5 ? " - will try again next cycle" : " maximum number of attempts has been reached"), ADLevel.WARN);
            }
            this.lock.lock();
            try {
                this.currentlyScheduled = false;
                if (retransformFailClasses.size() > 0) {
                    if (this.classesToRetransform == null) {
                        this.classesToRetransform = DeferredClassBCIHandler.getRetransformSet();
                    }
                    for (ClassToRetransform nextFailedRequest : retransformFailClasses) {
                        if (nextFailedRequest.getNumberOfRetransformAttempts() >= 5) continue;
                        this.classesToRetransform.add(nextFailedRequest);
                    }
                }
                if (this.classesToRetransform != null && this.classesToRetransform.size() > 0) {
                    this.scheduleRetransformTask();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (TimeoutWaitingForLockException e) {
            BCTLoggerUtil.printStackTrace(e);
        }
    }

    private Collection<ClassToRetransform> retransformClass(Collection<ClassToRetransform> clazz) {
        return this.retransformer.transformDeferredClasses(clazz);
    }

    private static Set<ClassToRetransform> getRetransformSet() {
        return new HashSet<ClassToRetransform>();
    }
}

