/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.ee.agent.appagent.java9.IJava9ClassFileTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.IByteCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.IJava9TransformerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.reflect.ClassLoaderUtil;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Constructor;
import java.security.ProtectionDomain;

public class Java9TransformerFactory
implements IJava9TransformerFactory,
IJava9ClassFileTransformer {
    private static final String JAVA9_TRANSFORMER_CLASS_NAME = "com.singularity.ee.agent.appagent.java9.Java9ByteCodeTransformer";
    private final IByteCodeTransformer delegateTo;

    public Java9TransformerFactory(IByteCodeTransformer delegateTo) {
        this.delegateTo = delegateTo;
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, Object module) {
        return this.delegateTo.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, module);
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        return this.delegateTo.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    @Override
    public ClassFileTransformer createClassFileTransformer(IADLogger logger) {
        try {
            Class java9TransformerClass = ClassLoaderUtil.loadClass(this.getClass(), JAVA9_TRANSFORMER_CLASS_NAME);
            Constructor constructor = java9TransformerClass.getConstructor(IJava9ClassFileTransformer.class);
            ClassFileTransformer classFileTransformer = (ClassFileTransformer)constructor.newInstance(this);
            return classFileTransformer;
        }
        catch (Exception e) {
            logger.error(String.format("Exception '%s' caught in createClassFileTransformer()", e.toString()), e);
            return null;
        }
    }
}

