/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.Label;
import com.singularity.asm.org.objectweb.asm.MethodVisitor;
import com.singularity.asm.org.objectweb.asm.tree.AbstractInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.FieldInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.IincInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.IntInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.JumpInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.LabelNode;
import com.singularity.asm.org.objectweb.asm.tree.LdcInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.LookupSwitchInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.asm.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.TableSwitchInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.TryCatchBlockNode;
import com.singularity.asm.org.objectweb.asm.tree.TypeInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.VarInsnNode;
import com.singularity.ee.agent.appagent.services.bciengine.IMethodAnalyzer;
import com.singularity.ee.agent.appagent.services.bciengine.IMethodInfoListener;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;

public class MethodAnalyzer
extends MethodNode
implements IMethodAnalyzer {
    private static final int MAX_TRIVIAL_METHOD_INSTRUCTIONS = 10;
    private final MethodVisitor mv;
    private long methodRepresentationId;
    private long methodSignatureId;
    private boolean isMethodTrivial;
    private boolean gotMethodRepresentationId;
    private boolean gotMethodSignatureId;
    private boolean gotIsMethodTrivial;

    public MethodAnalyzer(MethodVisitor mv, IMethodInfoListener listener, int access, String name, String desc, String signature, String[] exceptions) {
        super(589824, access, name, desc, signature, exceptions);
        this.mv = mv;
        listener.setMethodAnalyzer(this);
    }

    public void visitEnd() {
        this.accept(this.mv);
    }

    @Override
    public boolean isMethodTrivial() {
        if (!this.gotIsMethodTrivial) {
            if ((this.access & 0x20) == 0 && this.instructions.size() <= 10) {
                this.isMethodTrivial = true;
                ListIterator iter = this.instructions.iterator();
                HashSet<Label> allLabels = new HashSet<Label>();
                while (iter.hasNext()) {
                    AbstractInsnNode nextInsn = (AbstractInsnNode)iter.next();
                    if (nextInsn instanceof LabelNode) {
                        allLabels.add(((LabelNode)nextInsn).getLabel());
                        continue;
                    }
                    if (nextInsn instanceof JumpInsnNode) {
                        Label lbl = ((JumpInsnNode)nextInsn).label.getLabel();
                        if (!allLabels.contains(lbl)) continue;
                        this.isMethodTrivial = false;
                        break;
                    }
                    if (nextInsn instanceof MethodInsnNode) {
                        this.isMethodTrivial = false;
                        break;
                    }
                    if (nextInsn.getOpcode() != 194) continue;
                    this.isMethodTrivial = false;
                    break;
                }
            }
            this.gotIsMethodTrivial = true;
        }
        return this.isMethodTrivial;
    }

    @Override
    public long getMethodSignatureId() {
        if (!this.gotMethodSignatureId) {
            try {
                this.methodSignatureId = MethodAnalyzer.getCRC32Value(this.desc);
            }
            catch (Throwable t) {
                BCTLoggerUtil.printStackTrace(t);
                this.methodSignatureId = 0L;
            }
            finally {
                this.gotMethodSignatureId = true;
            }
        }
        return this.methodSignatureId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMethodRepresentation() {
        if (!this.gotMethodRepresentationId) {
            try {
                ListIterator iter = this.instructions.iterator();
                HashMap<LabelNode, Integer> labelMap = new HashMap<LabelNode, Integer>();
                int insnNum = 0;
                while (iter.hasNext()) {
                    AbstractInsnNode nextNode = (AbstractInsnNode)iter.next();
                    if (nextNode instanceof LabelNode) {
                        labelMap.put((LabelNode)nextNode, insnNum);
                    }
                    ++insnNum;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(this.name).append(",").append(this.desc).append(",").append(Integer.toString(this.access)).append(";");
                MethodAnalyzer.appendExceptionListToString(this.exceptions, sb);
                MethodAnalyzer.appendTryCatchToString(this.tryCatchBlocks, sb, labelMap);
                for (AbstractInsnNode nextNode : this.instructions) {
                    MethodAnalyzer.appendInsnRepresentationToString(nextNode, sb, labelMap);
                }
                this.methodRepresentationId = MethodAnalyzer.getCRC32Value(sb.toString());
            }
            catch (Throwable t) {
                BCTLoggerUtil.printStackTrace(t);
            }
            finally {
                this.gotMethodRepresentationId = true;
            }
        }
        return this.methodRepresentationId;
    }

    private static final long getCRC32Value(String string) throws IOException {
        CRC32 crc32 = new CRC32();
        CheckedOutputStream cos = new CheckedOutputStream(new BufferedOutputStream(new ByteArrayOutputStream()), crc32);
        byte[] bytes = string.getBytes();
        cos.write(bytes, 0, bytes.length);
        cos.close();
        return crc32.getValue();
    }

    private static void appendExceptionListToString(List<String> exceptionList, StringBuilder sb) {
        Iterator<String> iter = exceptionList.iterator();
        while (iter.hasNext()) {
            String nextException = iter.next();
            sb.append(nextException);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append(";");
    }

    private static void appendTryCatchToString(List<TryCatchBlockNode> tryCatchList, StringBuilder sb, Map<LabelNode, Integer> labelMap) {
        Iterator<TryCatchBlockNode> iter = tryCatchList.iterator();
        while (iter.hasNext()) {
            TryCatchBlockNode nextTryCatch = iter.next();
            sb.append(nextTryCatch.type != null ? nextTryCatch.type : "null").append(",");
            Integer startInsnNum = labelMap.get(nextTryCatch.start);
            Integer endInsnNum = labelMap.get(nextTryCatch.end);
            Integer handlerInsnNum = labelMap.get(nextTryCatch.handler);
            sb.append(startInsnNum.toString()).append(",").append(endInsnNum.toString()).append(",").append(handlerInsnNum.toString());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append(";");
    }

    private static void appendInsnRepresentationToString(AbstractInsnNode insn, StringBuilder sb, Map<LabelNode, Integer> labelMap) {
        switch (insn.getType()) {
            case 4: {
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                sb.append(Integer.toString(fieldInsn.getOpcode())).append(',').append(fieldInsn.owner).append(',').append(fieldInsn.name).append(',').append(fieldInsn.desc).append(";");
                break;
            }
            case 10: {
                IincInsnNode incNode = (IincInsnNode)insn;
                sb.append(Integer.toString(incNode.getOpcode())).append(',').append(incNode.var).append(',').append(incNode.incr).append(";");
                break;
            }
            case 0: {
                sb.append(Integer.toString(insn.getOpcode())).append(";");
                break;
            }
            case 1: {
                IntInsnNode intNode = (IntInsnNode)insn;
                sb.append(Integer.toString(intNode.getOpcode())).append(',').append(Integer.toString(intNode.operand)).append(";");
                break;
            }
            case 7: {
                JumpInsnNode jumpNode = (JumpInsnNode)insn;
                Integer jumpTarget = labelMap.get(jumpNode.label);
                sb.append(Integer.toString(jumpNode.getOpcode())).append(',').append(jumpTarget.toString()).append(";");
                break;
            }
            case 9: {
                LdcInsnNode ldcInsn = (LdcInsnNode)insn;
                sb.append(Integer.toString(ldcInsn.getOpcode())).append(',');
                if (ldcInsn.cst instanceof String) {
                    sb.append("\"").append(ldcInsn.cst.toString()).append("\"");
                } else {
                    sb.append(ldcInsn.cst.toString());
                }
                sb.append(";");
                break;
            }
            case 12: {
                LookupSwitchInsnNode lookupInsn = (LookupSwitchInsnNode)insn;
                sb.append(Integer.toString(lookupInsn.getOpcode())).append(',');
                Iterator keyIter = lookupInsn.keys.iterator();
                Iterator labelIter = lookupInsn.labels.iterator();
                while (keyIter.hasNext()) {
                    Integer key = (Integer)keyIter.next();
                    LabelNode labelNode = (LabelNode)labelIter.next();
                    Integer labelInsnNum = labelMap.get(labelNode);
                    sb.append(key.toString()).append(",").append(labelInsnNum.toString());
                    if (!keyIter.hasNext()) continue;
                    sb.append(",");
                }
                sb.append(";");
                break;
            }
            case 5: {
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                sb.append(Integer.toString(methodInsn.getOpcode())).append(',').append(methodInsn.owner).append(",").append(methodInsn.name).append(",").append(methodInsn.desc).append(";");
                break;
            }
            case 13: {
                MultiANewArrayInsnNode multiNewArrayInsn = (MultiANewArrayInsnNode)insn;
                sb.append(multiNewArrayInsn.getOpcode()).append(",").append(Integer.toString(multiNewArrayInsn.dims)).append(",").append(multiNewArrayInsn.desc).append(";");
                break;
            }
            case 11: {
                TableSwitchInsnNode switchInsn = (TableSwitchInsnNode)insn;
                sb.append(switchInsn.getOpcode()).append(",").append(Integer.toString(switchInsn.min)).append(",").append(Integer.toString(switchInsn.max)).append(",");
                if (switchInsn.dflt != null) {
                    Integer insnNum = labelMap.get(switchInsn.dflt);
                    sb.append(insnNum.toString());
                } else {
                    sb.append("null");
                }
                if (switchInsn.labels != null && switchInsn.labels.size() > 0) {
                    for (LabelNode label : switchInsn.labels) {
                        Integer insnNum = labelMap.get(label);
                        sb.append(",").append(insnNum.toString());
                    }
                }
                sb.append(";");
                break;
            }
            case 3: {
                TypeInsnNode typeInsn = (TypeInsnNode)insn;
                sb.append(Integer.toString(typeInsn.getOpcode())).append(",").append(typeInsn.desc).append(";");
                break;
            }
            case 2: {
                VarInsnNode varInsn = (VarInsnNode)insn;
                sb.append(Integer.toString(varInsn.getOpcode())).append(",").append(Integer.toString(varInsn.var)).append(";");
            }
        }
    }
}

