/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.Label;
import com.singularity.asm.org.objectweb.asm.MethodVisitor;
import com.singularity.ee.agent.appagent.services.bciengine.IMethodCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationRuleEngine;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodInstructionsLoggingAdapter;
import com.singularity.ee.agent.appagent.services.bciengine.asm.custom.instrumentation.InstructionsHandlersWrapper;
import com.singularity.ee.agent.appagent.services.bciengine.custom.instrumentation.ICustomCodeInstrumentationRule;
import com.singularity.ee.agent.appagent.services.bciengine.custom.instrumentation.Instruction;
import com.singularity.ee.agent.appagent.services.bciengine.custom.instrumentation.InstructionsHandler;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import java.util.ArrayList;
import java.util.List;

public class MethodCodeTransformer
extends MethodInstructionsLoggingAdapter
implements IMethodCodeTransformer {
    private static final InstructionsHandlersWrapper DEFAULT_INSTRUMENTATION_CALLBACK = new InstructionsHandlersWrapper(null);
    private final List<Instruction> instructions = new ArrayList<Instruction>();
    private int lastKnownLineNumber;
    private final String mClassName;
    private final String mName;
    private final TransformationRuleEngine mRuleEngine;
    private InstructionsHandler codeInstrCallback = DEFAULT_INSTRUMENTATION_CALLBACK;
    private boolean modified = false;

    protected MethodCodeTransformer(MethodVisitor mv, int access, String className, String name, String desc, TransformationRuleEngine ruleEngine, TransformationRule[] matchedRules) {
        super(mv, access, className, name, desc, ruleEngine.enableOpcodeDebug(className, name));
        this.mClassName = className;
        this.mName = name;
        this.mRuleEngine = ruleEngine;
        ArrayList<InstructionsHandler> instructionCallbacks = new ArrayList<InstructionsHandler>();
        for (int i = 0; i < matchedRules.length; ++i) {
            InstructionsHandler callback;
            TransformationRule matchedRule = matchedRules[i];
            if (!(matchedRule instanceof ICustomCodeInstrumentationRule) || (callback = ((ICustomCodeInstrumentationRule)((Object)matchedRule)).getInstructionsHandler()) == null) continue;
            instructionCallbacks.add(callback);
        }
        if (instructionCallbacks.size() > 1) {
            this.codeInstrCallback = new InstructionsHandlersWrapper(instructionCallbacks);
        } else if (instructionCallbacks.size() == 1) {
            this.codeInstrCallback = (InstructionsHandler)instructionCallbacks.get(0);
        }
    }

    @Override
    public void visitLabel(Label label) {
        if (this.instructions.size() > 0) {
            this.codeInstrCallback.visitInstructions(this.instructions, this, this.mClassName, this.mName, this.lastKnownLineNumber);
            Instruction.release(this.instructions);
        }
        super.visitLabel(label);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (this.codeInstrCallback.require("visitVarInsn")) {
            this.instructions.add(Instruction.newInstruction("visitVarInsn", opcode, var));
        }
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (this.codeInstrCallback.require("visitLdcInsn")) {
            this.instructions.add(Instruction.newInstruction("visitLdcInsn", Integer.MIN_VALUE, cst));
        }
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (this.codeInstrCallback.require("visitMethodInsn")) {
            this.instructions.add(Instruction.newInstruction("visitMethodInsn", opcode, owner, name, desc));
        }
        if (!this.codeInstrCallback.visitMethodInsn(opcode, owner, name, desc, this, this.instructions)) {
            super.visitMethodInsn(opcode, owner, name, desc);
        } else {
            this.modified = true;
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean intf) {
        if (this.codeInstrCallback.require("visitMethodInsn")) {
            this.instructions.add(Instruction.newInstruction("visitMethodInsn", opcode, owner, name, desc));
        }
        if (!this.codeInstrCallback.visitMethodInsn(opcode, owner, name, desc, this, this.instructions)) {
            super.visitMethodInsn(opcode, owner, name, desc, intf);
        } else {
            this.modified = true;
        }
    }

    @Override
    public void logCodeInterceptor(String name) {
        BCTLoggerUtil.applyingCodeInterceptor(this.mClassName, this.mName, name, 0, this.lastKnownLineNumber);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        if (this.codeInstrCallback.require("visitTypeInsn")) {
            this.instructions.add(Instruction.newInstruction("visitTypeInsn", opcode, type));
        }
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.codeInstrCallback.require("visitFieldInsn")) {
            this.instructions.add(Instruction.newInstruction("visitFieldInsn", opcode, owner, name, desc));
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.lastKnownLineNumber = line;
        super.visitLineNumber(line, start);
    }

    @Override
    public boolean isMatched() {
        return this.codeInstrCallback.isInjected() || this.modified;
    }
}

