/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.MethodVisitor;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassCorruptor;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;

class MethodCorruptor
extends MethodVisitor {
    private static CorruptionType[] allTypes = new CorruptionType[]{CorruptionType.INSERT_EXTRA_DUP, CorruptionType.CORRUPT_CALL_TO_INTERCEPTOR, CorruptionType.REMOVE_CREATE_PARM_ARRAY};
    private final CorruptionType type;
    private boolean createTypeArrayRemoved;
    private boolean interceptorCallCorrupted;
    private boolean extraDupInserted;
    private final String methodName;
    private final ClassCorruptor classCorruptor;

    MethodCorruptor(String methodName, CorruptionType type, MethodVisitor mv, ClassCorruptor classCorruptor) {
        super(589824, mv);
        this.type = type;
        this.methodName = methodName;
        this.classCorruptor = classCorruptor;
        if (classCorruptor != null) {
            BCTLoggerUtil.println("Method " + methodName + " in class " + classCorruptor.getClassName() + "is being deliberately corrupted.  Type: " + type.toString());
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (this.type == CorruptionType.INSERT_EXTRA_DUP) {
            if (!this.extraDupInserted) {
                super.visitInsn(89);
                this.extraDupInserted = true;
            }
        } else {
            boolean modify;
            boolean bl = modify = this.type == CorruptionType.CORRUPT_CALL_TO_INTERCEPTOR && (opcode == 184 || opcode == 182) && owner.replace('/', '.').startsWith("com.singularity.ee.agent.appagent");
            if (modify) {
                desc = MethodCorruptor.removeLastArgFromMethodDesc(desc);
                this.interceptorCallCorrupted = true;
            }
        }
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    private static String removeLastArgFromMethodDesc(String originalDesc) {
        String returnDesc = originalDesc;
        Type[] argTypes = Type.getArgumentTypes((String)originalDesc);
        Type returnType = Type.getReturnType((String)originalDesc);
        if (argTypes.length >= 1) {
            Type[] newArgTypes = new Type[argTypes.length - 1];
            if (newArgTypes.length > 0) {
                System.arraycopy(argTypes, 0, newArgTypes, 0, argTypes.length - 1);
            }
            returnDesc = Type.getMethodDescriptor((Type)returnType, (Type[])newArgTypes);
        }
        return returnDesc;
    }

    public void visitTypeInsn(int opcode, String type) {
        boolean supress;
        boolean bl = supress = this.type == CorruptionType.REMOVE_CREATE_PARM_ARRAY && opcode == 189 && !this.createTypeArrayRemoved;
        if (!supress) {
            super.visitTypeInsn(opcode, type);
        } else {
            this.createTypeArrayRemoved = true;
        }
    }

    public void visitEnd() {
        if (this.type == CorruptionType.REMOVE_CREATE_PARM_ARRAY && !this.createTypeArrayRemoved || this.type == CorruptionType.CORRUPT_CALL_TO_INTERCEPTOR && !this.interceptorCallCorrupted || this.type == CorruptionType.INSERT_EXTRA_DUP && !this.extraDupInserted) {
            BCTLoggerUtil.println("Corruption type " + this.type.toString() + " for Method " + this.methodName + " in class " + this.classCorruptor.getClassName() + " could not be corrupted.  Required instruction not found");
        }
    }

    static CorruptionType parseCorruptionType(String stringCorruptionType) {
        CorruptionType returnObject = null;
        for (CorruptionType nextType : allTypes) {
            if (!nextType.toString().equalsIgnoreCase(stringCorruptionType)) continue;
            returnObject = nextType;
            break;
        }
        return returnObject;
    }

    static enum CorruptionType {
        INSERT_EXTRA_DUP{

            public String toString() {
                return "insertExtraDup";
            }
        }
        ,
        CORRUPT_CALL_TO_INTERCEPTOR{

            public String toString() {
                return "corruptCallToInterceptor";
            }
        }
        ,
        REMOVE_CREATE_PARM_ARRAY{

            public String toString() {
                return "removeCreateParmArray";
            }
        };

    }
}

