/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.AnnotationVisitor;
import com.singularity.asm.org.objectweb.asm.Attribute;
import com.singularity.asm.org.objectweb.asm.Label;
import com.singularity.asm.org.objectweb.asm.MethodVisitor;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.commons.AdviceAdapter;
import com.singularity.ee.agent.appagent.services.bciengine.asm.OpcodeToString;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class MethodInstructionsLoggingAdapter
extends AdviceAdapter {
    private static final AtomicInteger DEBUG_COUNT = new AtomicInteger(0);
    private static final OpcodeToString OPCODE_TO_STRING = new OpcodeToString();
    private final int debugCount;

    protected MethodInstructionsLoggingAdapter(MethodVisitor mv, int access, String className, String name, String desc, boolean debug) {
        super(589824, mv, access, name, desc);
        if (debug) {
            this.debugCount = DEBUG_COUNT.incrementAndGet();
            this.debugLog("========= START " + className + " " + name + "=========");
        } else {
            this.debugCount = 0;
        }
    }

    private void debugLog(String msg) {
        BCTLoggerUtil.println("DEBUG-" + this.debugCount + "[" + msg + "]");
    }

    public void visitIincInsn(int var, int increment) {
        if (this.debugCount > 0) {
            this.debugLog("visitIincInsn :var = [" + var + "], increment = [" + increment + "]");
        }
        super.visitIincInsn(var, increment);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.debugCount > 0) {
            this.debugLog("visitMaxs :maxStack = [" + maxStack + "], maxLocals = [" + maxLocals + "]");
        }
        super.visitMaxs(maxStack, maxLocals);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (this.debugCount > 0) {
            this.debugLog("visitLocalVariable :name = [" + name + "], desc = [" + desc + "], signature = [" + signature + "], start = [" + start + "], end = [" + end + "], index = [" + index + "]");
        }
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (this.debugCount > 0) {
            this.debugLog("visitFrame :type = [" + type + "], nLocal = [" + nLocal + "], local = [" + Arrays.toString(local) + "], nStack = [" + nStack + "], stack = [" + Arrays.toString(stack) + "]");
        }
        super.visitFrame(type, nLocal, local, nStack, stack);
    }

    public int newLocal(Type type) {
        if (this.debugCount > 0) {
            this.debugLog("newLocal :type = [" + type + "]");
        }
        return super.newLocal(type);
    }

    protected int newLocalMapping(Type type) {
        if (this.debugCount > 0) {
            this.debugLog("newLocalMapping :type = [" + type + "]");
        }
        return super.newLocalMapping(type);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        if (this.debugCount > 0) {
            this.debugLog("visitAnnotationDefault");
        }
        return super.visitAnnotationDefault();
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.debugCount > 0) {
            this.debugLog("visitAnnotation :desc = [" + desc + "], visible = [" + visible + "]");
        }
        return super.visitAnnotation(desc, visible);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (this.debugCount > 0) {
            this.debugLog("visitParameterAnnotation :parameter = [" + parameter + "], desc = [" + desc + "], visible = [" + visible + "]");
        }
        return super.visitParameterAnnotation(parameter, desc, visible);
    }

    public void visitAttribute(Attribute attr) {
        if (this.debugCount > 0) {
            this.debugLog("visitAttribute :attr = [" + attr + "]");
        }
        super.visitAttribute(attr);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (this.debugCount > 0) {
            this.debugLog("visitTryCatchBlock :start = [" + start + "], end = [" + end + "], handler = [" + handler + "], type = [" + type + "]");
        }
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitLineNumber(int line, Label start) {
        if (this.debugCount > 0) {
            this.debugLog("visitLineNumber :line = [" + line + "], start = [" + start + "]");
        }
        super.visitLineNumber(line, start);
    }

    public void visitEnd() {
        if (this.debugCount > 0) {
            this.debugLog("visitEnd");
        }
        super.visitEnd();
    }

    public void visitCode() {
        if (this.debugCount > 0) {
            this.debugLog("visitCode");
        }
        super.visitCode();
    }

    public void visitLabel(Label label) {
        if (this.debugCount > 0) {
            this.debugLog("visitLabel :label = [" + label + "]");
        }
        super.visitLabel(label);
    }

    public void visitInsn(int opcode) {
        if (this.debugCount > 0) {
            this.debugLog("visitInsn :opcode = [" + OPCODE_TO_STRING.resolveOpcode(opcode) + "]");
        }
        super.visitInsn(opcode);
    }

    public void visitVarInsn(int opcode, int var) {
        if (this.debugCount > 0) {
            this.debugLog("visitVarInsn :opcode = [" + OPCODE_TO_STRING.resolveOpcode(opcode) + "], var = [" + var + "]");
        }
        super.visitVarInsn(opcode, var);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.debugCount > 0) {
            this.debugLog("visitFieldInsn :opcode = [" + OPCODE_TO_STRING.resolveOpcode(opcode) + "], owner = [" + owner + "], name = [" + name + "], desc = [" + desc + "]");
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitIntInsn(int opcode, int operand) {
        if (this.debugCount > 0) {
            this.debugLog("visitIntInsn :opcode = [" + OPCODE_TO_STRING.resolveOpcode(opcode) + "], operand = [" + operand + "]");
        }
        super.visitIntInsn(opcode, operand);
    }

    public void visitLdcInsn(Object cst) {
        if (this.debugCount > 0) {
            this.debugLog("visitLdcInsn :cst = [" + cst + "]");
        }
        super.visitLdcInsn(cst);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        if (this.debugCount > 0) {
            this.debugLog("visitMultiANewArrayInsn :desc = [" + desc + "], dims = [" + dims + "]");
        }
        super.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTypeInsn(int opcode, String type) {
        if (this.debugCount > 0) {
            this.debugLog("visitTypeInsn :opcode = [" + OPCODE_TO_STRING.resolveOpcode(opcode) + "], type = [" + type + "]");
        }
        super.visitTypeInsn(opcode, type);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (this.debugCount > 0) {
            this.debugLog("visitMethodInsn :opcode = [" + OPCODE_TO_STRING.resolveOpcode(opcode) + "], owner = [" + owner + "], name = [" + name + "], desc = [" + desc + "]");
        }
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (this.debugCount > 0) {
            this.debugLog("visitJumpInsn :opcode = [" + OPCODE_TO_STRING.resolveOpcode(opcode) + "], label = [" + label + "]");
        }
        super.visitJumpInsn(opcode, label);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (this.debugCount > 0) {
            this.debugLog("visitLookupSwitchInsn :dflt = [" + dflt + "], keys = [" + Arrays.toString(keys) + "], labels = [" + Arrays.toString(labels) + "]");
        }
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        if (this.debugCount > 0) {
            this.debugLog("visitTableSwitchInsn :min = [" + min + "], max = [" + max + "], dflt = [" + dflt + "], labels = [" + Arrays.toString(labels) + "]");
        }
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    protected void onMethodEnter() {
        if (this.debugCount > 0) {
            this.debugLog("onMethodEnter");
        }
        super.onMethodEnter();
    }

    protected void onMethodExit(int opcode) {
        if (this.debugCount > 0) {
            this.debugLog("onMethodExit :opcode = [" + OPCODE_TO_STRING.resolveOpcode(opcode) + "]");
        }
        super.onMethodExit(opcode);
        if (this.debugCount > 0) {
            this.debugLog("=========== END ===============");
        }
    }
}

