/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.AbstractInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.InsnList;
import com.singularity.asm.org.objectweb.asm.tree.InsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.ee.agent.appagent.services.bciengine.InstrumentationTracker;
import com.singularity.ee.agent.appagent.services.bciengine.ModifiedMethods;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationRuleEngine;
import com.singularity.ee.agent.appagent.services.bciengine.asm.AbstractCustomTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassBytecode;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.MethodInvocationTrapRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import java.util.ArrayList;
import java.util.List;

public class MethodInvocationTrapTransformer
extends AbstractCustomTransformer {
    private static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.bci.AnonymousClassDefTransformer");
    private static final String INTERCEPTED_METHOD_DESCRIPTOR = "(Ljava/lang/Class;[B[Ljava/lang/Object;)Ljava/lang/Class;";
    private static final String INTERCEPTING_METHOD_DESCRIPTOR = "(Ljava/lang/Class;[B[Ljava/lang/Object;)[B";

    MethodInvocationTrapTransformer(TransformationRuleEngine ruleEngine) {
        super(ruleEngine);
    }

    byte[] transform(ModifiedMethods modifiedMethods, AClassTransformationRule[] matchedRules, RuntimeClassInfo runtimeClassInfo, BasicClassInfo basicClassInfo, byte[] oldByteCode) {
        return this.transformClass(modifiedMethods, matchedRules, runtimeClassInfo, basicClassInfo, oldByteCode);
    }

    private byte[] transformClass(ModifiedMethods modifiedMethods, AClassTransformationRule[] matchedRules, RuntimeClassInfo runtimeClassInfo, BasicClassInfo basicClassInfo, byte[] oldByteCode) {
        byte[] returnClassBytes = null;
        List listOfRules = new ArrayList<MethodInvocationTrapRule>(matchedRules.length);
        for (AClassTransformationRule nextRule : matchedRules) {
            if (!(nextRule instanceof MethodInvocationTrapRule)) continue;
            listOfRules.add((MethodInvocationTrapRule)nextRule);
        }
        if (listOfRules.size() > 0) {
            String className = basicClassInfo.getClassName();
            ClassBytecode classBytecode = new ClassBytecode(oldByteCode);
            if ((listOfRules = this.checkByteCodeRules(classBytecode, listOfRules, runtimeClassInfo, basicClassInfo)).size() > 0) {
                MethodInvocationTrapRule theRule = (MethodInvocationTrapRule)listOfRules.get(0);
                logger.debugParams("Matched {} for class {}", theRule.getClass().getSimpleName(), className);
                returnClassBytes = this.transformAccordingToRule(modifiedMethods, classBytecode, className, theRule);
            }
        }
        return returnClassBytes;
    }

    private byte[] transformAccordingToRule(ModifiedMethods modifiedMethods, ClassBytecode classBytecode, String className, MethodInvocationTrapRule theRule) {
        boolean instrumented = false;
        byte[] result = null;
        for (MethodNode methodNode : classBytecode.getMethods()) {
            if (!this.isMethodMatch(theRule, methodNode, className)) continue;
            logger.debugParams("Method {}{} matched", methodNode.name, methodNode.desc);
            boolean success = this.transformMethodAccordingToRule(methodNode, theRule);
            if (success) {
                logger.debug("Matched method transformed successfully");
                instrumented = true;
                classBytecode.markMethodModified();
                modifiedMethods.indicateMethodModified(methodNode.name, methodNode.desc);
                continue;
            }
            logger.info("Failed to transform " + methodNode.name + methodNode.desc);
        }
        if (instrumented) {
            InstrumentationTracker.trackInstrumentationForClass(className, theRule);
            classBytecode.markMethodModified();
            result = classBytecode.generateAndGetBytes();
        }
        return result;
    }

    private boolean transformMethodAccordingToRule(MethodNode methodNode, MethodInvocationTrapRule theRule) {
        boolean result = false;
        MethodInvocationTrapRule.Context context = (MethodInvocationTrapRule.Context)theRule.getTransformationRuleContext();
        if (!INTERCEPTED_METHOD_DESCRIPTOR.equals(context.internalSignature)) {
            logger.warn("Unable to handle signature " + context.internalSignature);
            return false;
        }
        for (AbstractInsnNode instruction : methodNode.instructions) {
            MethodInsnNode methodInsn;
            if (!(instruction instanceof MethodInsnNode) || !MethodInvocationTrapTransformer.isMethodInvocation((methodInsn = (MethodInsnNode)instruction).getOpcode()) || !context.internalMethodName.equals(methodInsn.name) || !INTERCEPTED_METHOD_DESCRIPTOR.equals(methodInsn.desc)) continue;
            InsnList interceptingCall = this.createInterceptingCall(context);
            methodNode.instructions.insertBefore(instruction, interceptingCall);
            result = true;
        }
        return result;
    }

    private static boolean isMethodInvocation(int opcode) {
        return 184 == opcode || 183 == opcode || 182 == opcode;
    }

    private InsnList createInterceptingCall(MethodInvocationTrapRule.Context context) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new InsnNode(93));
        list.add((AbstractInsnNode)new InsnNode(88));
        list.add((AbstractInsnNode)new InsnNode(93));
        list.add((AbstractInsnNode)new InsnNode(91));
        list.add((AbstractInsnNode)new InsnNode(87));
        list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName((Class)context.interceptingClass), context.interceptingMethodName, INTERCEPTING_METHOD_DESCRIPTOR));
        list.add((AbstractInsnNode)new InsnNode(93));
        list.add((AbstractInsnNode)new InsnNode(88));
        return list;
    }
}

