/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.AnnotationVisitor;
import com.singularity.asm.org.objectweb.asm.Label;
import com.singularity.asm.org.objectweb.asm.MethodVisitor;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.FastInterceptorClassRegistryBoot;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.FastMethodInterceptorDelegatorBoot;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IFastMethodInterceptor;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IMethodInterceptorDelegator;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.MethodExecutionEnvironment;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.MethodInterceptorDelegatorBoot;
import com.singularity.ee.agent.appagent.services.bciengine.AInlineTrackedMethodInterceptor;
import com.singularity.ee.agent.appagent.services.bciengine.IMethodAnalyzer;
import com.singularity.ee.agent.appagent.services.bciengine.IMethodInfoListener;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationRuleEngine;
import com.singularity.ee.agent.appagent.services.bciengine.asm.AnnotationLister;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.IInlineStateVar;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.SecondPassMethodTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.AInlineInterceptorTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.IInlineInterceptorTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AnnotationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.MethodInfo;
import com.singularity.ee.agent.util.log4j.ADLevel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class MethodTransformer
extends MethodCodeTransformer
implements IMethodInfoListener {
    private static final Type Type_MethodExecutionEnvironment = Type.getType(MethodExecutionEnvironment.class);
    private static final Type Type_MethodInterceptorDelegator_Intf = Type.getType(IMethodInterceptorDelegator.class);
    private static final Type Type_Object = Type.getType(Object.class);
    private static final Type Type_ObjectArray = Type.getType(Object[].class);
    private static final Type Type_Throwable = Type.getType(Throwable.class);
    private static final String InternalName_MethodExecutionEnvironment = Type.getInternalName(MethodExecutionEnvironment.class);
    private static final String InternalName_MethodInterceptorDelegator = Type.getInternalName(MethodInterceptorDelegatorBoot.class);
    private static final String InternalName_MethodInterceptorDelegator_Intf = Type.getInternalName(IMethodInterceptorDelegator.class);
    private static final String InternalName_FastMethodInterceptorDelegator = Type.getInternalName(FastMethodInterceptorDelegatorBoot.class);
    private static final String InternalName_Object = Type.getInternalName(Object.class);
    private static final String InternalName_Integer = Type.getInternalName(Integer.class);
    private static final String InternalName_Float = Type.getInternalName(Float.class);
    private static final String InternalName_Long = Type.getInternalName(Long.class);
    private static final String InternalName_Double = Type.getInternalName(Double.class);
    private static final String InternalName_Boolean = Type.getInternalName(Boolean.class);
    private static final String InternalName_Byte = Type.getInternalName(Byte.class);
    private static final String InternalName_Char = Type.getInternalName(Character.class);
    private static final String InternalName_Short = Type.getInternalName(Short.class);
    private static final String InternalName_String = Type.getInternalName(String.class);
    private static final String MethodDesc_IntegerValueOf = Type.getMethodDescriptor((Type)Type.getType(Integer.class), (Type[])new Type[]{Type.INT_TYPE});
    private static final String MethodDesc_LongValueOf = Type.getMethodDescriptor((Type)Type.getType(Long.class), (Type[])new Type[]{Type.LONG_TYPE});
    private static final String MethodDesc_FloatValueOf = Type.getMethodDescriptor((Type)Type.getType(Float.class), (Type[])new Type[]{Type.FLOAT_TYPE});
    private static final String MethodDesc_DoubleValueOf = Type.getMethodDescriptor((Type)Type.getType(Double.class), (Type[])new Type[]{Type.DOUBLE_TYPE});
    private static final String MethodDesc_BooleanValueOf = Type.getMethodDescriptor((Type)Type.getType(Boolean.class), (Type[])new Type[]{Type.BOOLEAN_TYPE});
    private static final String MethodDesc_ByteValueOf = Type.getMethodDescriptor((Type)Type.getType(Byte.class), (Type[])new Type[]{Type.BYTE_TYPE});
    private static final String MethodDesc_CharValueOf = Type.getMethodDescriptor((Type)Type.getType(Character.class), (Type[])new Type[]{Type.CHAR_TYPE});
    private static final String MethodDesc_ShortValueOf = Type.getMethodDescriptor((Type)Type.getType(Short.class), (Type[])new Type[]{Type.SHORT_TYPE});
    private static final String MethodDesc_MethodInterceptorDelegatorSafeOnMethodBegin = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type_MethodExecutionEnvironment});
    private static final String MethodDesc_FastMethodInterceptorDelegatorSafeOnMethodBegin = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE, Type.getType(Object.class), Type.getType(String.class), Type.getType(String.class), Type.getType(Object[].class)});
    private static final String MethodDesc_MethodInterceptorDelegatorSafeOnMethodEndNormal = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type_MethodExecutionEnvironment});
    private static final String MethodDesc_MethodInterceptorDelegatorSafeOnMethodEndException = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type_MethodExecutionEnvironment});
    private static final String MethodDesc_FastMethodInterceptorDelegatorSafeOnMethodEndNormal = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE, Type.getType(Object.class), Type.getType(String.class), Type.getType(String.class), Type.getType(Object[].class), Type.getType(Object.class), Type.getType(Object.class)});
    private static final String MethodDesc_FastMethodInterceptorDelegatorSafeOnMethodEndException = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE, Type.getType(Object.class), Type.getType(String.class), Type.getType(String.class), Type.getType(Object[].class), Type.getType(Object.class), Type.getType(Throwable.class)});
    private static final String MethodDesc_MethodExecutionEnvironmentSetThrownException = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Throwable.class)});
    private static final String MethodDesc_MethodExecutionEnvironmentSetReturnValue = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)});
    private static final String ConstructorDesc_MethodExecutionEnvironment = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class), Type.getType(String.class), Type.getType(String.class), Type.getType(Object[].class)});
    private static final String ConstructorDesc_MethodInterceptorDelegator = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String[].class), Type.getType(int[].class)});
    private static final String createDesc_MethodInterceptorDelegator = Type.getMethodDescriptor((Type)Type.getType(IMethodInterceptorDelegator.class), (Type[])new Type[]{Type.getType(String[].class), Type.getType(int[].class)});
    private static final String constructor = "<init>";
    private static final Label DUMMY_LABEL = new Label();
    private TransformationInfo[] mInterceptors;
    private final String mClassName;
    private String mClassNameWithDotAsSeparator;
    private final String mName;
    private final Type[] mMethodArgumentTypes;
    private final Type mReturnType;
    private final boolean mIsStatic;
    private final boolean mIsConstructor;
    private int mInterceptorDelegatorVar;
    private int mEnvVar;
    private int mParamsArrayVar;
    private int[] mFastInterceptorStateVars;
    private int[] mInlineInterceptorStateVars;
    private int mThrownExceptionVar;
    private int mReturnValVar;
    private final int mSaveReturnValueVar = -1;
    private final Label mStartFinally = new Label();
    private final Label mEndFinally = new Label();
    private final List<AnnotationInfo> mAnnotations;
    private final int mAccess;
    private final String mDesc;
    private final String[] mExceptions;
    private final String mSignature;
    private final TransformationRuleEngine mRuleEngine;
    private final TransformationRule[] mMatchedRules;
    private boolean mMatched;
    private boolean mCheckedMethodRules;
    private final ClassTransformer classTransformer;
    private TransformationInfo[] mFastInterceptors;
    private IInlineInterceptorTransformer[] inlineInterceptors;
    private final List<Label[]> tryCatchBlocks;
    private boolean mCaptureParams;
    private boolean mCaptureReturnVal;
    private boolean mSeenMethodEnter;
    private final Set<Label> labelsPriorToMethodEnter;
    private int currentInsnNum = -1;
    private int startInjectionCount;
    private int firstInjectedInsn = -1;
    private final boolean forceCompute;
    private boolean objectClassConstructor;
    private IMethodAnalyzer methodAnalyzer;
    private int saveLocVarForThisArgument;
    private int sizeOfMethodInBytes;
    private static int MAX_METHOD_SIZE = 65535;
    private final boolean traceEnabledForMethod;
    private List<Label> currentLabels;
    private Set<Label> reachableLabels;
    private List<List<Label>> labelsPreceedingATHROWs;
    private static final Set<Integer> OPCODES_WITH_UNREACHABLE_NEXT_INSTRUCTIONS = MethodTransformer.createOpcodeSetWithUnreachableNextInstruction();
    private final IBCIEngineService.UnreachableThrowableTestAction unReachableThrowableTest;

    private static Set<Integer> createOpcodeSetWithUnreachableNextInstruction() {
        HashSet<Integer> returnSet = new HashSet<Integer>();
        returnSet.add(177);
        returnSet.add(176);
        returnSet.add(172);
        returnSet.add(175);
        returnSet.add(173);
        returnSet.add(174);
        returnSet.add(191);
        returnSet.add(167);
        return returnSet;
    }

    protected MethodTransformer(ClassTransformer ct, MethodVisitor mv, int access, String name, String desc, String[] exceptions, String signature, String className, TransformationRuleEngine ruleEngine, TransformationRule[] matchedRules, boolean forceCompute, boolean traceEnabledForMethod, IBCIEngineService.UnreachableThrowableTestAction unReachableThrowableTest) {
        super(mv, access, className, name, desc, ruleEngine, matchedRules);
        this.mAccess = access;
        this.classTransformer = ct;
        this.mDesc = desc;
        this.mExceptions = exceptions;
        this.mName = name;
        this.mSignature = signature;
        this.forceCompute = forceCompute;
        this.traceEnabledForMethod = traceEnabledForMethod;
        this.unReachableThrowableTest = unReachableThrowableTest;
        this.mIsStatic = (access & 8) != 0;
        this.mClassName = className;
        if (className != null) {
            this.mClassNameWithDotAsSeparator = className.replace('/', '.');
        }
        this.mMethodArgumentTypes = Type.getArgumentTypes((String)desc);
        this.mReturnType = Type.getReturnType((String)desc);
        this.mAnnotations = new ArrayList<AnnotationInfo>();
        this.mRuleEngine = ruleEngine;
        this.mMatchedRules = matchedRules;
        this.mParamsArrayVar = -1;
        if (className.equals("java/lang/Object") && name.equals(constructor)) {
            this.resetConstructorFlagInASM();
            this.objectClassConstructor = true;
        }
        this.mIsConstructor = name.equals(constructor);
        this.tryCatchBlocks = new ArrayList<Label[]>();
        this.labelsPriorToMethodEnter = new HashSet<Label>();
    }

    private void captureParamsArray() {
        if (!this.mCaptureParams) {
            return;
        }
        this.startInjection();
        this._visitIntInsn(this.mMethodArgumentTypes.length);
        this.injectTypeInsn(189, InternalName_Object);
        int varPos = this.mIsStatic ? 0 : 1;
        for (int i = 0; i < this.mMethodArgumentTypes.length; ++i) {
            this.injectInsn(89);
            this._visitIntInsn(i);
            if (this.mMethodArgumentTypes[i].equals((Object)Type.INT_TYPE)) {
                this.injectVarInsn(21, varPos);
                ++varPos;
                this.callValueOf(this.mMethodArgumentTypes[i]);
            } else if (this.mMethodArgumentTypes[i].equals((Object)Type.LONG_TYPE)) {
                this.injectVarInsn(22, varPos);
                varPos += 2;
                this.callValueOf(this.mMethodArgumentTypes[i]);
            } else if (this.mMethodArgumentTypes[i].equals((Object)Type.FLOAT_TYPE)) {
                this.injectVarInsn(23, varPos);
                ++varPos;
                this.callValueOf(this.mMethodArgumentTypes[i]);
            } else if (this.mMethodArgumentTypes[i].equals((Object)Type.DOUBLE_TYPE)) {
                this.injectVarInsn(24, varPos);
                varPos += 2;
                this.callValueOf(this.mMethodArgumentTypes[i]);
            } else if (this.mMethodArgumentTypes[i].equals((Object)Type.BOOLEAN_TYPE)) {
                this.injectVarInsn(21, varPos);
                ++varPos;
                this.callValueOf(this.mMethodArgumentTypes[i]);
            } else if (this.mMethodArgumentTypes[i].equals((Object)Type.BYTE_TYPE)) {
                this.injectVarInsn(21, varPos);
                ++varPos;
                this.callValueOf(this.mMethodArgumentTypes[i]);
            } else if (this.mMethodArgumentTypes[i].equals((Object)Type.CHAR_TYPE)) {
                this.injectVarInsn(21, varPos);
                ++varPos;
                this.callValueOf(this.mMethodArgumentTypes[i]);
            } else if (this.mMethodArgumentTypes[i].equals((Object)Type.SHORT_TYPE)) {
                this.injectVarInsn(21, varPos);
                ++varPos;
                this.callValueOf(this.mMethodArgumentTypes[i]);
            } else {
                this.injectVarInsn(25, varPos);
                ++varPos;
            }
            this.injectInsn(83);
        }
        if (this.mParamsArrayVar < 0) {
            this.mParamsArrayVar = this.newLocal(Type_ObjectArray);
        }
        if (this.mv instanceof SecondPassMethodTransformer) {
            ((SecondPassMethodTransformer)this.mv).setParamArrayIndex(this.mParamsArrayVar);
        }
        this.injectVarInsn(58, this.mParamsArrayVar);
        this.endInjection();
    }

    private void insertMethodExecutionEnvironmentConstructor() {
        this.startInjection();
        this.injectTypeInsn(187, InternalName_MethodExecutionEnvironment);
        this.injectInsn(89);
        if (!this.mIsStatic) {
            this.injectVarInsn(25, 0);
        } else {
            this.injectInsn(1);
        }
        this.injectLdcInsn(this.mClassNameWithDotAsSeparator);
        this.injectLdcInsn(this.mName);
        this.injectVarInsn(25, this.mParamsArrayVar);
        this.injectMethodInsn(183, InternalName_MethodExecutionEnvironment, constructor, ConstructorDesc_MethodExecutionEnvironment);
        if (this.mEnvVar == -1) {
            this.mEnvVar = this.newLocal(Type_MethodExecutionEnvironment);
        }
        this.injectVarInsn(58, this.mEnvVar);
        this.endInjection();
    }

    private void _visitIntInsn(int i) {
        this.startInjection();
        switch (i) {
            case 0: {
                this.injectInsn(3);
                break;
            }
            case 1: {
                this.injectInsn(4);
                break;
            }
            case 2: {
                this.injectInsn(5);
                break;
            }
            case 3: {
                this.injectInsn(6);
                break;
            }
            case 4: {
                this.injectInsn(7);
                break;
            }
            case 5: {
                this.injectInsn(8);
                break;
            }
            case -1: {
                this.injectInsn(2);
                break;
            }
            default: {
                if (i >= -128 && i < 127) {
                    this.injectIntInsn(16, i);
                    break;
                }
                if (i >= Short.MIN_VALUE && i < Short.MAX_VALUE) {
                    this.injectIntInsn(17, i);
                    break;
                }
                this.injectLdcInsn(i);
            }
        }
        this.endInjection();
    }

    private void insertMethodInterceptorDelegatorConstructor() {
        int i;
        this.startInjection();
        this._visitIntInsn(this.mInterceptors.length);
        this.injectTypeInsn(189, InternalName_String);
        for (i = 0; i < this.mInterceptors.length; ++i) {
            this.injectInsn(89);
            this._visitIntInsn(i);
            this.injectLdcInsn(this.mInterceptors[this.mInterceptors.length - 1 - i].getInterceptorClassName());
            this.injectInsn(83);
        }
        this._visitIntInsn(this.mInterceptors.length);
        this.injectIntInsn(188, 10);
        for (i = 0; i < this.mInterceptors.length; ++i) {
            this.injectInsn(89);
            this._visitIntInsn(i);
            this._visitIntInsn(this.mInterceptors[this.mInterceptors.length - 1 - i].getTransformationId());
            this.injectInsn(79);
        }
        this.injectMethodInsn(184, InternalName_MethodInterceptorDelegator, "createMethodDelegatorInterceptor", createDesc_MethodInterceptorDelegator);
        if (this.mInterceptorDelegatorVar < 0) {
            this.mInterceptorDelegatorVar = this.newLocal(Type_MethodInterceptorDelegator_Intf);
        }
        this.injectVarInsn(58, this.mInterceptorDelegatorVar);
        this.endInjection();
    }

    private void insertMethodInterceptorDelegatorOnMethodBegin() {
        this.startInjection();
        this.injectVarInsn(25, this.mInterceptorDelegatorVar);
        this.injectVarInsn(25, this.mEnvVar);
        this.injectMethodInsn(185, InternalName_MethodInterceptorDelegator_Intf, "safeOnMethodBegin", MethodDesc_MethodInterceptorDelegatorSafeOnMethodBegin);
        this.endInjection();
    }

    private void callValueOf(Type type) {
        this.startInjection();
        if (type.equals((Object)Type.BYTE_TYPE)) {
            this.injectMethodInsn(184, InternalName_Byte, "valueOf", MethodDesc_ByteValueOf);
        } else if (type.equals((Object)Type.SHORT_TYPE)) {
            this.injectMethodInsn(184, InternalName_Short, "valueOf", MethodDesc_ShortValueOf);
        } else if (type.equals((Object)Type.CHAR_TYPE)) {
            this.injectMethodInsn(184, InternalName_Char, "valueOf", MethodDesc_CharValueOf);
        } else if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            this.injectMethodInsn(184, InternalName_Boolean, "valueOf", MethodDesc_BooleanValueOf);
        } else if (type.equals((Object)Type.INT_TYPE)) {
            this.injectMethodInsn(184, InternalName_Integer, "valueOf", MethodDesc_IntegerValueOf);
        } else if (type.equals((Object)Type.LONG_TYPE)) {
            this.injectMethodInsn(184, InternalName_Long, "valueOf", MethodDesc_LongValueOf);
        } else if (type.equals((Object)Type.FLOAT_TYPE)) {
            this.injectMethodInsn(184, InternalName_Float, "valueOf", MethodDesc_FloatValueOf);
        } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
            this.injectMethodInsn(184, InternalName_Double, "valueOf", MethodDesc_DoubleValueOf);
        }
        this.endInjection();
    }

    private void insertMethodExecutionEnvironmentSetReturnValue(int opCode) {
        this.startInjection();
        this.injectVarInsn(25, this.mEnvVar);
        this.injectVarInsn(25, this.mThrownExceptionVar);
        this.injectMethodInsn(182, InternalName_MethodExecutionEnvironment, "setThrownException", MethodDesc_MethodExecutionEnvironmentSetThrownException);
        this.injectVarInsn(25, this.mEnvVar);
        this.injectVarInsn(25, this.mReturnValVar);
        this.injectMethodInsn(182, InternalName_MethodExecutionEnvironment, "setReturnValue", MethodDesc_MethodExecutionEnvironmentSetReturnValue);
        this.endInjection();
    }

    private void insertMethodInterceptorDelegatorOnMethodEnd(int opCode) {
        this.startInjection();
        this.injectVarInsn(25, this.mInterceptorDelegatorVar);
        this.injectVarInsn(25, this.mEnvVar);
        if (opCode != 191) {
            this.injectMethodInsn(185, InternalName_MethodInterceptorDelegator_Intf, "safeOnMethodEndNormal", MethodDesc_MethodInterceptorDelegatorSafeOnMethodEndNormal);
        } else {
            this.injectMethodInsn(185, InternalName_MethodInterceptorDelegator_Intf, "safeOnMethodEndException", MethodDesc_MethodInterceptorDelegatorSafeOnMethodEndException);
        }
        this.endInjection();
    }

    private void insertMethodInterceptorDelegatorOnMethodBeginFast() {
        boolean stateVarsAlreadyInitialized = false;
        if (this.mFastInterceptorStateVars != null) {
            stateVarsAlreadyInitialized = true;
        } else {
            this.mFastInterceptorStateVars = new int[this.mFastInterceptors.length];
        }
        this.startInjection();
        boolean savedThisObject = false;
        for (int i = 0; i < this.mFastInterceptors.length; ++i) {
            int idx = this.mFastInterceptors.length - 1 - i;
            IFastMethodInterceptor interceptorInstance = FastInterceptorClassRegistryBoot.getFastInterceptorInstance((int)this.mFastInterceptors[idx].getFastInterceptorId());
            this.injectLdcInsn(this.mFastInterceptors[idx].getFastInterceptorId());
            this.injectLdcInsn(this.mFastInterceptors[idx].getTransformationId());
            if (!this.mIsStatic) {
                this.injectVarInsn(25, 0);
                if (this.saveLocVarForThisArgument > 0 && !savedThisObject) {
                    this.injectInsn(89);
                    this.injectVarInsn(58, this.saveLocVarForThisArgument);
                    savedThisObject = true;
                }
            } else {
                this.injectInsn(1);
            }
            this.injectLdcInsn(this.mClassNameWithDotAsSeparator);
            this.injectLdcInsn(this.mName);
            if (interceptorInstance.shouldPassParamsToOnMethodBegin()) {
                this.injectVarInsn(25, this.mParamsArrayVar);
            } else {
                this.injectInsn(1);
            }
            if (interceptorInstance.skipReentrantCheck()) {
                this.injectMethodInsn(184, InternalName_FastMethodInterceptorDelegator, "safeOnMethodBeginNoReentrantCheck", MethodDesc_FastMethodInterceptorDelegatorSafeOnMethodBegin);
            } else {
                this.injectMethodInsn(184, InternalName_FastMethodInterceptorDelegator, "safeOnMethodBegin", MethodDesc_FastMethodInterceptorDelegatorSafeOnMethodBegin);
            }
            if (!stateVarsAlreadyInitialized) {
                this.mFastInterceptorStateVars[idx] = this.newLocal(Type_Object);
            }
            this.injectVarInsn(58, this.mFastInterceptorStateVars[idx]);
        }
        this.endInjection();
    }

    private void insertMethodInterceptorDelegatorOnMethodBeginInline() {
        boolean stateVarsAlreadyInitialized = false;
        if (this.mInlineInterceptorStateVars != null) {
            stateVarsAlreadyInitialized = true;
        } else {
            this.mInlineInterceptorStateVars = new int[this.inlineInterceptors.length];
        }
        for (int i = 0; i < this.inlineInterceptors.length; ++i) {
            int idx = this.inlineInterceptors.length - 1 - i;
            if (!stateVarsAlreadyInitialized) {
                this.initInlineStateVarsFor(this.inlineInterceptors[idx]);
            }
            if (this.inlineInterceptors[idx].isParamArrayRequired()) {
                this.inlineInterceptors[idx].setParmArrayIndex(this.mParamsArrayVar);
            }
            this.inlineInterceptors[idx].doMethodEnterInstrumentation();
        }
    }

    private void initFastStateVars() {
        this.mFastInterceptorStateVars = new int[this.mFastInterceptors.length];
        this.startInjection();
        for (int i = 0; i < this.mFastInterceptors.length; ++i) {
            int idx = this.mFastInterceptors.length - 1 - i;
            IFastMethodInterceptor interceptorInstance = FastInterceptorClassRegistryBoot.getFastInterceptorInstance((int)this.mFastInterceptors[idx].getFastInterceptorId());
            this.mFastInterceptorStateVars[idx] = this.newLocal(Type_Object);
            this.injectInsn(1);
            this.injectVarInsn(58, this.mFastInterceptorStateVars[idx]);
        }
        if (this.mName.equals(constructor) && !this.objectClassConstructor) {
            this.saveLocVarForThisArgument = this.newLocal(Type_Object);
            this.injectInsn(1);
            this.injectVarInsn(58, this.saveLocVarForThisArgument);
        }
        if (this.mCaptureParams && this.mParamsArrayVar < 0) {
            this.mParamsArrayVar = this.newLocal(Type_Object);
            this.injectInsn(1);
            this.injectVarInsn(58, this.mParamsArrayVar);
        }
        this.endInjection();
    }

    private void initInlineStateVars() {
        this.mInlineInterceptorStateVars = new int[this.inlineInterceptors.length];
        boolean paramArrayRequired = false;
        for (int i = 0; i < this.inlineInterceptors.length; ++i) {
            int idx = this.inlineInterceptors.length - 1 - i;
            this.initInlineStateVarsFor(this.inlineInterceptors[idx]);
            this.mInlineInterceptorStateVars[idx] = -1;
            if (!this.inlineInterceptors[idx].isParamArrayRequired()) continue;
            paramArrayRequired = true;
        }
        if (paramArrayRequired && this.mParamsArrayVar < 0) {
            this.startInjection();
            this.mParamsArrayVar = this.newLocal(Type_Object);
            this.injectInsn(1);
            this.injectVarInsn(58, this.mParamsArrayVar);
            this.endInjection();
        }
    }

    private void initInlineStateVarsFor(IInlineInterceptorTransformer inlineInterceptor) {
        IInlineStateVar[] locVarTypesRequired = inlineInterceptor.getLocalVarsToInitialize();
        if (locVarTypesRequired != null && locVarTypesRequired.length > 0) {
            int[] locVarsAllocated = new int[locVarTypesRequired.length];
            for (int j = 0; j < locVarTypesRequired.length; ++j) {
                locVarsAllocated[j] = this.allocateLocVarForInline(locVarTypesRequired[j]);
            }
            inlineInterceptor.localVariablesDefined(locVarsAllocated);
        }
    }

    private int allocateLocVarForInline(IInlineStateVar type) {
        int iReturn = this.newLocal(type.getType());
        if (type.initializationRequired()) {
            switch (type.getType().getSort()) {
                case 9: 
                case 10: {
                    this.injectInsn(1);
                    this.injectVarInsn(58, iReturn);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.injectInsn(3);
                    this.injectVarInsn(54, iReturn);
                    break;
                }
                case 7: {
                    this.injectInsn(9);
                    this.injectVarInsn(55, iReturn);
                    break;
                }
                case 6: {
                    this.injectInsn(11);
                    this.injectVarInsn(56, iReturn);
                    break;
                }
                case 8: {
                    this.injectInsn(14);
                    this.injectVarInsn(57, iReturn);
                }
            }
        }
        return iReturn;
    }

    private void initSlowVars() {
        this.startInjection();
        this.mEnvVar = this.newLocal(Type_MethodExecutionEnvironment);
        this.injectInsn(1);
        this.injectVarInsn(58, this.mEnvVar);
        this.mInterceptorDelegatorVar = this.newLocal(Type_MethodInterceptorDelegator_Intf);
        this.injectInsn(1);
        this.injectVarInsn(58, this.mInterceptorDelegatorVar);
        if (this.mCaptureParams && this.mParamsArrayVar < 0) {
            this.mParamsArrayVar = this.newLocal(Type_Object);
            this.injectInsn(1);
            this.injectVarInsn(58, this.mParamsArrayVar);
        }
        this.endInjection();
    }

    private void captureReturnValueAndThrownException(int opCode) {
        this.startInjection();
        try {
            if (opCode == 191) {
                this.injectInsn(89);
            } else {
                this.injectInsn(1);
            }
            this.mThrownExceptionVar = this.newLocal(Type_Throwable);
            this.injectVarInsn(58, this.mThrownExceptionVar);
            if (!this.mCaptureReturnVal) {
                return;
            }
            switch (opCode) {
                case 191: {
                    this.injectInsn(1);
                    break;
                }
                case 172: 
                case 174: {
                    this.injectInsn(89);
                    this.callValueOf(this.mReturnType);
                    break;
                }
                case 173: 
                case 175: {
                    this.injectInsn(92);
                    this.callValueOf(this.mReturnType);
                    break;
                }
                case 176: {
                    this.injectInsn(89);
                    break;
                }
                case 177: {
                    this.injectInsn(1);
                }
            }
            this.mReturnValVar = this.newLocal(Type_Object);
            this.injectVarInsn(58, this.mReturnValVar);
        }
        finally {
            this.endInjection();
        }
    }

    private boolean doAnyInjectorsRequireExitCallback(int opcode) {
        boolean bReturn = false;
        if (this.mInterceptors != null && this.mInterceptors.length > 0) {
            bReturn = true;
        } else if (this.inlineInterceptors != null) {
            for (IInlineInterceptorTransformer nextInlineInterceptor : this.inlineInterceptors) {
                if (opcode == 191) {
                    bReturn = nextInlineInterceptor.shouldInjectTryCatch();
                } else {
                    AInlineTrackedMethodInterceptor inlineInterceptorInstance = nextInlineInterceptor.getInlineTrackedMethodInterceptor();
                    bReturn = inlineInterceptorInstance.shouldCallOnMethodEnd();
                }
                if (bReturn) break;
            }
        }
        if (!bReturn && this.mFastInterceptors != null) {
            for (TransformationInfo nextTransformInfo : this.mFastInterceptors) {
                IFastMethodInterceptor interceptorInstance = FastInterceptorClassRegistryBoot.getFastInterceptorInstance((int)nextTransformInfo.getFastInterceptorId());
                if (!interceptorInstance.shouldCallOnMethodEnd()) continue;
                bReturn = true;
                break;
            }
        }
        return bReturn;
    }

    private void insertMethodInterceptorDelegatorOnMethodEndFast(int opCode) {
        this.startInjection();
        for (int idx = 0; idx < this.mFastInterceptors.length; ++idx) {
            IFastMethodInterceptor interceptorInstance = FastInterceptorClassRegistryBoot.getFastInterceptorInstance((int)this.mFastInterceptors[idx].getFastInterceptorId());
            if (!interceptorInstance.shouldCallOnMethodEnd()) continue;
            this.injectLdcInsn(this.mFastInterceptors[idx].getFastInterceptorId());
            this.injectLdcInsn(this.mFastInterceptors[idx].getTransformationId());
            if (!this.mIsStatic) {
                int locVarNum = this.saveLocVarForThisArgument > 0 ? this.saveLocVarForThisArgument : 0;
                this.injectVarInsn(25, locVarNum);
            } else {
                this.injectInsn(1);
            }
            this.injectLdcInsn(this.mClassNameWithDotAsSeparator);
            this.injectLdcInsn(this.mName);
            if (interceptorInstance.shouldPassParamsToOnMethodBegin() && this.mParamsArrayVar >= 0) {
                this.injectVarInsn(25, this.mParamsArrayVar);
            } else {
                this.injectInsn(1);
            }
            this.injectVarInsn(25, this.mFastInterceptorStateVars[idx]);
            if (opCode == 191) {
                this.injectVarInsn(25, this.mThrownExceptionVar);
            } else if (interceptorInstance.shouldPassReturnValueToOnMethodEnd()) {
                this.injectVarInsn(25, this.mReturnValVar);
            } else {
                this.injectInsn(1);
            }
            if (interceptorInstance.skipReentrantCheck()) {
                if (opCode != 191) {
                    this.injectMethodInsn(184, InternalName_FastMethodInterceptorDelegator, "safeOnMethodEndNoReentrantCheckNormal", MethodDesc_FastMethodInterceptorDelegatorSafeOnMethodEndNormal);
                    continue;
                }
                this.injectMethodInsn(184, InternalName_FastMethodInterceptorDelegator, "safeOnMethodEndNoReentrantCheckException", MethodDesc_FastMethodInterceptorDelegatorSafeOnMethodEndException);
                continue;
            }
            if (opCode != 191) {
                this.injectMethodInsn(184, InternalName_FastMethodInterceptorDelegator, "safeOnMethodEndNormal", MethodDesc_FastMethodInterceptorDelegatorSafeOnMethodEndNormal);
                continue;
            }
            this.injectMethodInsn(184, InternalName_FastMethodInterceptorDelegator, "safeOnMethodEndException", MethodDesc_FastMethodInterceptorDelegatorSafeOnMethodEndException);
        }
        this.endInjection();
    }

    private void insertMethodInterceptorDelegatorOnMethodEndInline(int opCode) {
        for (int idx = 0; idx < this.inlineInterceptors.length; ++idx) {
            AInlineTrackedMethodInterceptor inlineInterceptorInstance = this.inlineInterceptors[idx].getInlineTrackedMethodInterceptor();
            if (!inlineInterceptorInstance.shouldCallOnMethodEnd()) continue;
            if (this.inlineInterceptors[idx].isReturnedObjectRequired()) {
                this.inlineInterceptors[idx].setReturnedObjectIndex(this.mReturnValVar);
            }
            if (this.inlineInterceptors[idx].isThrownExceptionRequired()) {
                this.inlineInterceptors[idx].setThrownExceptionIndex(this.mThrownExceptionVar);
            }
            this.inlineInterceptors[idx].doMethodExitInstrumentation(opCode);
        }
    }

    @Override
    protected void onMethodEnter() {
        boolean notFirstEnter = this.mSeenMethodEnter;
        this.mSeenMethodEnter = true;
        if (this.mMatched) {
            if (notFirstEnter) {
                BCTLoggerUtil.printlnWithPrefix("Duplicate onMethodEnter for " + this.mName + this.mDesc + " is ignored", ADLevel.WARN);
                return;
            }
            this.startInjection();
            if (this.mIsConstructor) {
                this.mv.visitLabel(this.mStartFinally);
            }
            this.captureParamsArray();
            if (this.mInterceptors.length > 0) {
                this.insertMethodExecutionEnvironmentConstructor();
                this.insertMethodInterceptorDelegatorConstructor();
                this.insertMethodInterceptorDelegatorOnMethodBegin();
            }
            if (this.mFastInterceptors.length > 0) {
                this.insertMethodInterceptorDelegatorOnMethodBeginFast();
            }
            if (this.inlineInterceptors.length > 0) {
                this.insertMethodInterceptorDelegatorOnMethodBeginInline();
            }
            this.endInjection();
        } else {
            super.onMethodEnter();
        }
    }

    private void onFinally(int opCode) {
        if (this.doAnyInjectorsRequireExitCallback(opCode)) {
            this.startInjection();
            this.captureReturnValueAndThrownException(opCode);
            if (this.inlineInterceptors.length > 0) {
                this.insertMethodInterceptorDelegatorOnMethodEndInline(opCode);
            }
            if (this.mFastInterceptors.length > 0) {
                this.insertMethodInterceptorDelegatorOnMethodEndFast(opCode);
            }
            if (this.mInterceptors.length > 0) {
                this.insertMethodExecutionEnvironmentSetReturnValue(opCode);
                this.insertMethodInterceptorDelegatorOnMethodEnd(opCode);
            }
            this.endInjection();
        }
    }

    @Override
    protected void onMethodExit(int opCode) {
        if (this.mMatched) {
            this.startInjection();
            if (opCode != 191) {
                this.onFinally(opCode);
            }
            this.endInjection();
        } else {
            super.onMethodExit(opCode);
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.mMatched || this.isMatched()) {
            if (this.areThereUnreachableATHROWs()) {
                switch (this.unReachableThrowableTest) {
                    case CORRECT: {
                        this.classTransformer.methodHasUnreachableInstructions(this.mName, this.mDesc);
                        break;
                    }
                    case EXCEPTION: {
                        throw new RuntimeException(String.format("Unreachable ATHROW instruction found in class %s and method %s", this.mClassName, this.mName));
                    }
                }
            }
            this.startInjection();
            if (this.inlineInterceptors.length > 0) {
                this.injectInlineInterceptorTryCatchBlocks();
            }
            if (this.shouldInjectTryCatch()) {
                this.mv.visitTryCatchBlock(this.mStartFinally, this.mEndFinally, this.mEndFinally, null);
                this.mv.visitLabel(this.mEndFinally);
                this.onFinally(191);
                if (this.inlineInterceptors.length > 0) {
                    this.injectInlineInterceptorFinallyTryCatchBlocks();
                }
                this.injectInsn(191);
            }
            if (this.sizeOfMethodInBytes > MAX_METHOD_SIZE) {
                String errorMessage = String.format("Cannot instrument method %s %s in class %s because resulting byte code size %d exceeds Java maximum", this.mName, this.mDesc, this.mClassName, this.sizeOfMethodInBytes);
                BCTLoggerUtil.printlnWithPrefix(errorMessage, ADLevel.WARN);
                throw new RuntimeException(errorMessage);
            }
            this.mv.visitMaxs(maxStack, maxLocals);
            this.classTransformer.setMethodModified(this.mName, this.mDesc);
            this.endInjection();
        } else {
            super.visitMaxs(maxStack, maxLocals);
            if (super.isMatched()) {
                this.classTransformer.setMethodModified(this.mName, this.mDesc);
            }
        }
    }

    private boolean areThereUnreachableATHROWs() {
        boolean bReturn = false;
        if (this.labelsPreceedingATHROWs != null) {
            for (List<Label> labelsPreceedingATHROW : this.labelsPreceedingATHROWs) {
                boolean reachableLabelFound = false;
                for (Label nextLabelPreceedingATHROW : labelsPreceedingATHROW) {
                    if (!this.reachableLabels.contains(nextLabelPreceedingATHROW)) continue;
                    reachableLabelFound = true;
                    break;
                }
                if (reachableLabelFound) continue;
                bReturn = true;
                break;
            }
        }
        return bReturn;
    }

    private void injectInlineInterceptorTryCatchBlocks() {
        for (int idx = this.inlineInterceptors.length - 1; idx >= 0; --idx) {
            this.inlineInterceptors[idx].defineTryCatchBlocks();
        }
    }

    private void injectInlineInterceptorFinallyTryCatchBlocks() {
        for (int idx = this.inlineInterceptors.length - 1; idx >= 0; --idx) {
            this.inlineInterceptors[idx].defineFinallyTryCatchBlocks();
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = this.mv.visitAnnotation(desc, visible);
        if (av != null) {
            AnnotationLister lister = new AnnotationLister(av, desc, visible, this.mAnnotations);
            return lister;
        }
        return av;
    }

    @Override
    public void visitCode() {
        if (!this.mCheckedMethodRules) {
            if (!this.mRuleEngine.excludeFromProcessing(this.mClassName, this.mName)) {
                MethodInfo methodInfo = new MethodInfo(this.mAccess, this.mIsStatic, this.mName, this.mDesc, this.mSignature, this.mExceptions, this.mAnnotations.toArray(new AnnotationInfo[this.mAnnotations.size()]));
                TransformationInfo[] interceptors = this.mRuleEngine.checkUltimateMethodMatch(this.mClassName, this.classTransformer.getBasicClassInfo().getLoader(), this.mMatchedRules, methodInfo, this.traceEnabledForMethod);
                if (this.traceEnabledForMethod && interceptors != null && interceptors.length > 0) {
                    BCTLoggerUtil.println(String.format("The following TransformationInfo objects returned by mRuleEngine.checkUltimateMethodMatch() for class %s and method %s %s", this.mClassName, this.mName, this.mDesc));
                    for (TransformationInfo ti : interceptors) {
                        BCTLoggerUtil.println(String.format("    %s", ti));
                    }
                }
                if (interceptors != null && interceptors.length > 0) {
                    if (this.mv instanceof SecondPassMethodTransformer) {
                        ArrayList<TransformationInfo> infosWithMidMethodInfo = new ArrayList<TransformationInfo>();
                        for (TransformationInfo info : interceptors) {
                            if (!info.hasMidMethodInfo()) continue;
                            infosWithMidMethodInfo.add(info);
                        }
                        ((SecondPassMethodTransformer)this.mv).setTransformationInfo(infosWithMidMethodInfo.toArray(new TransformationInfo[infosWithMidMethodInfo.size()]));
                    }
                    this.classTransformer.setMethodModifiedByTransformationInfos(this.mName, this.mDesc, interceptors);
                    this.mInterceptorDelegatorVar = -1;
                    this.mEnvVar = -1;
                    ArrayList<TransformationInfo> regularInterceptors = new ArrayList<TransformationInfo>();
                    ArrayList<TransformationInfo> fastInterceptors = new ArrayList<TransformationInfo>();
                    ArrayList<AInlineInterceptorTransformer> inlineInterceptors = new ArrayList<AInlineInterceptorTransformer>();
                    for (TransformationInfo interceptor : interceptors) {
                        if (interceptor.usesInlineInterceptor()) {
                            AInlineTrackedMethodInterceptor inlineInterceptorInstance = (AInlineTrackedMethodInterceptor)FastInterceptorClassRegistryBoot.getFastInterceptorInstance((int)interceptor.getFastInterceptorId());
                            AInlineInterceptorTransformer inlineTransformer = (AInlineInterceptorTransformer)inlineInterceptorInstance.getInlineTransformer();
                            inlineTransformer.init(this.mClassName, this.mName, this.mDesc, this.mAccess, this, interceptor);
                            if (!inlineTransformer.isMethodModificationRequired()) continue;
                            inlineInterceptors.add(inlineTransformer);
                            if (inlineTransformer.isParamArrayRequired()) {
                                this.mCaptureParams = true;
                            }
                            if (!inlineInterceptorInstance.shouldCallOnMethodEnd() || !inlineTransformer.isReturnedObjectRequired()) continue;
                            this.mCaptureReturnVal = true;
                            continue;
                        }
                        if (interceptor.isUseFastInterceptor()) {
                            fastInterceptors.add(interceptor);
                            IFastMethodInterceptor fastInterceptorInstance = FastInterceptorClassRegistryBoot.getFastInterceptorInstance((int)interceptor.getFastInterceptorId());
                            if (fastInterceptorInstance.shouldPassParamsToOnMethodBegin()) {
                                this.mCaptureParams = true;
                            }
                            if (!fastInterceptorInstance.shouldCallOnMethodEnd() || !fastInterceptorInstance.shouldPassReturnValueToOnMethodEnd()) continue;
                            this.mCaptureReturnVal = true;
                            continue;
                        }
                        regularInterceptors.add(interceptor);
                        this.mCaptureParams = true;
                        this.mCaptureReturnVal = true;
                    }
                    this.mInterceptors = regularInterceptors.toArray(new TransformationInfo[regularInterceptors.size()]);
                    this.mFastInterceptors = fastInterceptors.toArray(new TransformationInfo[fastInterceptors.size()]);
                    this.inlineInterceptors = inlineInterceptors.toArray(new AInlineInterceptorTransformer[inlineInterceptors.size()]);
                    if (this.mInterceptors.length > 0 || this.mFastInterceptors.length > 0 || this.inlineInterceptors.length > 0) {
                        this.mMatched = true;
                        this.classTransformer.setClassModified(true);
                    }
                }
            } else {
                BCTLoggerUtil.excludeMethod(this.mName + " " + this.mDesc);
            }
            this.mCheckedMethodRules = true;
        }
        if (this.traceEnabledForMethod) {
            BCTLoggerUtil.println(String.format("%s for class %s and method %s %s", this.mMatched ? "Is matched" : "Is not matched", this.mClassName, this.mName, this.mDesc));
        }
        if (this.mMatched) {
            this.startInjection();
            if (this.mName.equals(constructor) && !this.objectClassConstructor) {
                if (this.mInterceptors != null && this.mInterceptors.length > 0) {
                    this.initSlowVars();
                }
                if (this.mFastInterceptors != null && this.mFastInterceptors.length > 0) {
                    this.initFastStateVars();
                }
                if (this.inlineInterceptors != null && this.inlineInterceptors.length > 0) {
                    this.initInlineStateVars();
                }
                this.endInjection();
            }
            super.visitCode();
            if (!this.mIsConstructor) {
                this.mv.visitLabel(this.mStartFinally);
            }
            if (this.unReachableThrowableTest != IBCIEngineService.UnreachableThrowableTestAction.IGNORE) {
                this.currentLabels = new ArrayList<Label>();
                this.currentLabels.add(DUMMY_LABEL);
                this.reachableLabels = new HashSet<Label>();
                this.reachableLabels.add(DUMMY_LABEL);
                this.labelsPreceedingATHROWs = new ArrayList<List<Label>>();
            }
            this.endInjection();
        } else {
            super.visitCode();
        }
    }

    @Override
    public boolean isMatched() {
        return this.mMatched;
    }

    @Override
    public void visitLabel(Label label) {
        if (this.mIsConstructor && !this.mSeenMethodEnter) {
            this.labelsPriorToMethodEnter.add(label);
        }
        super.visitLabel(label);
        if (this.currentLabels != null) {
            this.currentLabels.add(label);
        }
    }

    private boolean shouldInjectTryCatch() {
        boolean bReturn = (!this.mIsConstructor || !this.shouldSupressConstructorTryCatch()) && this.doAnyInjectorsRequireExitCallback(191);
        return bReturn;
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (this.mIsConstructor) {
            this.tryCatchBlocks.add(new Label[]{start, end, handler});
        }
        super.visitTryCatchBlock(start, end, handler, type);
        if (this.reachableLabels != null) {
            this.reachableLabels.add(handler);
        }
    }

    private boolean shouldSupressConstructorTryCatch() {
        boolean bReturn = false;
        if (this.mIsConstructor) {
            for (Label[] nextLabelSet : this.tryCatchBlocks) {
                bReturn = this.labelsPriorToMethodEnter.contains(nextLabelSet[0]);
                if (!bReturn) continue;
                BCTLoggerUtil.warn("Unable to add try-finally to constructor for class " + this.mClassName + " because of conflicting try-catch definitions in method");
                break;
            }
        }
        return bReturn;
    }

    private void startInjection() {
        if (this.startInjectionCount++ == 0) {
            this.firstInjectedInsn = this.currentInsnNum + 1;
        }
    }

    private void endInjection() {
        if (--this.startInjectionCount == 0) {
            if (this.firstInjectedInsn >= 0 && this.firstInjectedInsn <= this.currentInsnNum) {
                this.classTransformer.setInsnRangeInjected(this.mName, this.mDesc, this.firstInjectedInsn, this.currentInsnNum);
            }
            this.firstInjectedInsn = -1;
        } else if (this.startInjectionCount < 0) {
            this.startInjectionCount = 0;
            this.firstInjectedInsn = -1;
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode == 191 && this.labelsPreceedingATHROWs != null) {
            if (this.currentLabels.size() == 0) {
                switch (this.unReachableThrowableTest) {
                    case CORRECT: {
                        this.classTransformer.methodHasUnreachableInstructions(this.mName, this.mDesc);
                        break;
                    }
                    case EXCEPTION: {
                        throw new RuntimeException(String.format("Unreachable ATHROW instruction found in class %s and method %s", this.mClassName, this.mName));
                    }
                }
            } else {
                this.labelsPreceedingATHROWs.add(new ArrayList<Label>(this.currentLabels));
            }
        }
        if (MethodTransformer.isNextInstructionUnreachable(opcode) && this.currentLabels != null) {
            this.currentLabels.clear();
        }
        this.updateMethodSize(this.getSizeOfInsn());
        super.visitInsn(opcode);
        ++this.currentInsnNum;
    }

    static boolean isNextInstructionUnreachable(int opcode) {
        return OPCODES_WITH_UNREACHABLE_NEXT_INSTRUCTIONS.contains(opcode);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.updateMethodSize(this.getSizeOfVarInsn(var));
        super.visitVarInsn(opcode, var);
        ++this.currentInsnNum;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.updateMethodSize(this.getSizeOfFieldInsn());
        super.visitFieldInsn(opcode, owner, name, desc);
        ++this.currentInsnNum;
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.updateMethodSize(this.getSizeOfIntInsn(opcode));
        super.visitIntInsn(opcode, operand);
        ++this.currentInsnNum;
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.updateMethodSize(this.getSizeOfLdcInsn());
        super.visitLdcInsn(cst);
        ++this.currentInsnNum;
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.updateMethodSize(this.getSizeOfMultiANewArrayInsn());
        super.visitMultiANewArrayInsn(desc, dims);
        ++this.currentInsnNum;
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.updateMethodSize(this.getSizeOfTypeInsn());
        super.visitTypeInsn(opcode, type);
        ++this.currentInsnNum;
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.updateMethodSize(this.getSizeOfIIncInsn(increment));
        super.visitIincInsn(var, increment);
        ++this.currentInsnNum;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.updateMethodSize(this.getSizeOfMethodInsn(opcode));
        super.visitMethodInsn(opcode, owner, name, desc);
        ++this.currentInsnNum;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean intf) {
        this.updateMethodSize(this.getSizeOfMethodInsn(opcode));
        super.visitMethodInsn(opcode, owner, name, desc, intf);
        ++this.currentInsnNum;
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.updateMethodSize(this.getSizeOfJumpInsn());
        super.visitJumpInsn(opcode, label);
        ++this.currentInsnNum;
        if (this.reachableLabels != null) {
            this.reachableLabels.add(label);
        }
        if (MethodTransformer.isNextInstructionUnreachable(opcode) && this.currentLabels != null) {
            this.currentLabels.clear();
        }
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.updateMethodSize(this.getSizeOfLookupSwitchInsn(keys));
        super.visitLookupSwitchInsn(dflt, keys, labels);
        ++this.currentInsnNum;
        if (this.reachableLabels != null) {
            if (labels != null) {
                for (Label nextLabel : labels) {
                    this.reachableLabels.add(nextLabel);
                }
            }
            if (dflt != null) {
                this.reachableLabels.add(dflt);
            }
        }
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.updateMethodSize(this.getSizeOfTableSwitchInsn(labels));
        super.visitTableSwitchInsn(min, max, dflt, labels);
        ++this.currentInsnNum;
        if (this.reachableLabels != null) {
            if (labels != null) {
                for (Label nextLabel : labels) {
                    this.reachableLabels.add(nextLabel);
                }
            }
            if (dflt != null) {
                this.reachableLabels.add(dflt);
            }
        }
    }

    public void injectInsn(int opcode) {
        this.updateMethodSize(this.getSizeOfInsn());
        ++this.currentInsnNum;
        this.mv.visitInsn(opcode);
    }

    public void injectVarInsn(int opcode, int var) {
        this.updateMethodSize(this.getSizeOfVarInsn(var));
        ++this.currentInsnNum;
        this.mv.visitVarInsn(opcode, var);
    }

    public void injectFieldInsn(int opcode, String owner, String name, String desc) {
        this.updateMethodSize(this.getSizeOfFieldInsn());
        ++this.currentInsnNum;
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void injectIntInsn(int opcode, int operand) {
        this.updateMethodSize(this.getSizeOfIntInsn(opcode));
        ++this.currentInsnNum;
        this.mv.visitIntInsn(opcode, operand);
    }

    public void injectLdcInsn(Object cst) {
        this.updateMethodSize(this.getSizeOfLdcInsn());
        ++this.currentInsnNum;
        this.mv.visitLdcInsn(cst);
    }

    public void injectMultiANewArrayInsn(String desc, int dims) {
        this.updateMethodSize(this.getSizeOfMultiANewArrayInsn());
        ++this.currentInsnNum;
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    public void injectTypeInsn(int opcode, String type) {
        this.updateMethodSize(this.getSizeOfTypeInsn());
        ++this.currentInsnNum;
        this.mv.visitTypeInsn(opcode, type);
    }

    public void injectMethodInsn(int opcode, String owner, String name, String desc) {
        this.updateMethodSize(this.getSizeOfMethodInsn(opcode));
        ++this.currentInsnNum;
        this.mv.visitMethodInsn(opcode, owner, name, desc);
    }

    public void injectJumpInsn(int opcode, Label label) {
        this.updateMethodSize(this.getSizeOfJumpInsn());
        ++this.currentInsnNum;
        this.mv.visitJumpInsn(opcode, label);
    }

    public void injectLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.updateMethodSize(this.getSizeOfLookupSwitchInsn(keys));
        ++this.currentInsnNum;
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void injectTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.updateMethodSize(this.getSizeOfTableSwitchInsn(labels));
        ++this.currentInsnNum;
        this.mv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void injectIincInsn(int var, int increment) {
        this.updateMethodSize(this.getSizeOfIIncInsn(increment));
        ++this.currentInsnNum;
        this.mv.visitIincInsn(var, increment);
    }

    public void injectLabel(Label label) {
        this.mv.visitLabel(label);
    }

    public void injectTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public boolean isTrivialMethod() {
        return this.methodAnalyzer != null ? this.methodAnalyzer.isMethodTrivial() : false;
    }

    public long getMethodRepresentation() {
        return this.methodAnalyzer != null ? this.methodAnalyzer.getMethodRepresentation() : 0L;
    }

    public int getParmsArrayLocVar() {
        return this.mParamsArrayVar;
    }

    public long getMethodSignatureId() {
        return this.methodAnalyzer != null ? this.methodAnalyzer.getMethodSignatureId() : 0L;
    }

    @Override
    public void setMethodAnalyzer(IMethodAnalyzer methodAnalyzer) {
        this.methodAnalyzer = methodAnalyzer;
    }

    private void updateMethodSize(int sizeOfNextInst) {
        this.sizeOfMethodInBytes += sizeOfNextInst;
    }

    private int getSizeOfInsn() {
        return 1;
    }

    private int getSizeOfVarInsn(int var) {
        int iReturn = var > 255 ? 4 : 2;
        return iReturn;
    }

    private int getSizeOfFieldInsn() {
        return 3;
    }

    private int getSizeOfIntInsn(int opcode) {
        int iReturn = 0;
        switch (opcode) {
            case 16: 
            case 188: {
                iReturn = 2;
                break;
            }
            case 17: {
                iReturn = 3;
            }
        }
        return iReturn;
    }

    private int getSizeOfLdcInsn() {
        return 3;
    }

    private int getSizeOfIIncInsn(int increment) {
        if (increment >= -128 && increment <= 127) {
            return 3;
        }
        return 6;
    }

    private int getSizeOfMultiANewArrayInsn() {
        return 4;
    }

    private int getSizeOfTypeInsn() {
        return 3;
    }

    private int getSizeOfMethodInsn(int opcode) {
        if (opcode == 185) {
            return 5;
        }
        return 3;
    }

    private int getSizeOfJumpInsn() {
        return 3;
    }

    private int getSizeOfLookupSwitchInsn(int[] keys) {
        return 12 + 8 * keys.length;
    }

    private int getSizeOfTableSwitchInsn(Label[] labels) {
        return 16 + 4 * labels.length;
    }

    public static void setMaxMethodSize(int MAX_METHOD_SIZE) {
        MethodTransformer.MAX_METHOD_SIZE = MAX_METHOD_SIZE;
    }

    private void resetConstructorFlagInASM() {
        try {
            Class<?> currentClass = this.getClass();
            while (!currentClass.getName().endsWith("AdviceAdapter") && (currentClass = currentClass.getSuperclass()) != null) {
            }
            if (currentClass != null) {
                Field constructorField = currentClass.getDeclaredField("constructor");
                constructorField.setAccessible(true);
                constructorField.setBoolean(this, false);
            }
        }
        catch (Throwable t) {
            BCTLoggerUtil.printStackTrace(t);
        }
    }
}

