/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.MethodVisitor;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.AbstractInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.FieldInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.InsnList;
import com.singularity.asm.org.objectweb.asm.tree.InsnNode;
import com.singularity.asm.org.objectweb.asm.tree.IntInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.LabelNode;
import com.singularity.asm.org.objectweb.asm.tree.LdcInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.LineNumberNode;
import com.singularity.asm.org.objectweb.asm.tree.LocalVariableNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.asm.org.objectweb.asm.tree.TypeInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.VarInsnNode;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.FastMethodInterceptorDelegatorBoot;
import com.singularity.ee.agent.appagent.services.bciengine.MidMethodInfo;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationRuleEngine;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.SecondPassMethodTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.appagent.services.bciengine.spi.TransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AnnotationInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;

class MidMethodTransformer
extends MethodNode
implements SecondPassMethodTransformer {
    private MethodVisitor delegate;
    private ClassTransformer ct;
    private boolean forceCompute;
    private boolean traceEnabledForMethod;
    private List<MidMethodInfo> lineInfos = new LinkedList<MidMethodInfo>();
    private List<MidMethodInfo> localVarInfos = new LinkedList<MidMethodInfo>();
    private List<MidMethodInfo> methodInvokeInfos = new LinkedList<MidMethodInfo>();
    private List<MidMethodInfo> fieldInfos = new LinkedList<MidMethodInfo>();
    private boolean isStatic;
    private String className;
    private String classNameWithDotAsSeparator;
    private Type[] methodArgumentTypes;
    private Type returnType;
    private List<AnnotationInfo> annotations;
    private int paramArray = -1;
    private int startingLine = -1;
    private TransformationInfo[] transformationInfos;
    private HashSet<Integer> localVarsInRangeSet = new HashSet();
    private TreeMap<Integer, Integer> newInjectionVsOffsetAmount = new TreeMap();
    private List<MidMethodInfo> delayedLineInfos = new LinkedList<MidMethodInfo>();
    public static final Type OBJECT_TYPE = Type.getType(Object.class);
    public static final Type STRING_TYPE = Type.getType(String.class);
    public static final Type OBJECT_ARR_TYPE = Type.getType(Object[].class);
    private static final String MethodDesc_FastMethodInterceptorDelegatorSafeOnMethodMiddleNormal = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, OBJECT_TYPE, STRING_TYPE, STRING_TYPE, OBJECT_ARR_TYPE, OBJECT_ARR_TYPE, Type.INT_TYPE});
    private HashMap<Integer, List<LocalVariableNode>> indexvsLocalVarNode = new HashMap();
    private HashMap<String, List<LocalVariableNode>> localVarNamevsNode = new HashMap();
    private HashMap<LabelNode, List<Integer>> endLabels = new HashMap();
    private HashMap<MidMethodInfo, Integer> midMethodInfovsOccurences = new HashMap();
    private static final HashSet<Integer> LOAD_OPCODES = new HashSet<Integer>(Arrays.asList(21, 22, 24, 23, 25));
    private static final HashSet<Integer> STORE_OPCODES = new HashSet<Integer>(Arrays.asList(54, 55, 57, 56, 58));
    private static final HashSet<Integer> FIELD_STORE_OPCODES = new HashSet<Integer>(Arrays.asList(181, 179));
    private static final HashSet<Integer> FIELD_LOAD_OPCODES = new HashSet<Integer>(Arrays.asList(180, 178));
    private static final HashSet<Type> PRIMITIVE_TYPES = new HashSet<Type>(Arrays.asList(Type.BOOLEAN_TYPE, Type.BYTE_TYPE, Type.SHORT_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.DOUBLE_TYPE, Type.FLOAT_TYPE, Type.CHAR_TYPE));
    private int currentInsnNum;
    private int firstInjectedInsn;
    private int currentLineNum;
    private int startInjectionCount;

    MidMethodTransformer(ClassTransformer ct, MethodVisitor mv, int access, String name, String desc, String[] exceptions, String signature, String className, TransformationRuleEngine ruleEngine, boolean forceCompute, boolean traceEnabledForMethod) {
        super(589824, access, name, desc, signature, exceptions);
        this.forceCompute = forceCompute;
        this.traceEnabledForMethod = traceEnabledForMethod;
        this.isStatic = (access & 8) != 0;
        this.className = className;
        if (className != null) {
            this.classNameWithDotAsSeparator = className.replace('/', '.');
        }
        this.methodArgumentTypes = Type.getArgumentTypes((String)desc);
        this.returnType = Type.getReturnType((String)desc);
        this.annotations = new ArrayList<AnnotationInfo>();
        this.delegate = mv;
        this.ct = ct;
        this.currentLineNum = -1;
        this.firstInjectedInsn = -1;
        this.currentInsnNum = -1;
        ct.setClassModified(true);
    }

    public void visitEnd() {
        if (this.transformationInfos != null && this.transformationInfos.length > 0) {
            for (TransformationInfo info : this.transformationInfos) {
                for (TransformationRule rule : info.getMatchingTransformationRules()) {
                    MidMethodInfo midMethodInfo = rule.getMidMethodInfo();
                    if (midMethodInfo == null) continue;
                    if (midMethodInfo.getLineNumber() > -1) {
                        this.lineInfos.add(midMethodInfo);
                        continue;
                    }
                    if (midMethodInfo.getLocalVarNameToMatch() != null) {
                        this.localVarInfos.add(midMethodInfo);
                        continue;
                    }
                    if (midMethodInfo.getMethodInvokeToMatch() != null) {
                        this.methodInvokeInfos.add(midMethodInfo);
                        continue;
                    }
                    if (midMethodInfo.getFieldNameToMatch() == null) continue;
                    this.fieldInfos.add(midMethodInfo);
                }
            }
            this.methodArgumentTypes = Type.getArgumentTypes((String)this.desc);
            if (this.localVariables == null) {
                BCTLoggerUtil.warn("Local variable information is not found! All local variable instrumentationswill be ignored.");
            }
            for (LocalVariableNode node : this.localVariables) {
                if (!this.indexvsLocalVarNode.containsKey(node.index)) {
                    this.indexvsLocalVarNode.put(node.index, new ArrayList());
                }
                if (!this.localVarNamevsNode.containsKey(node.name)) {
                    this.localVarNamevsNode.put(node.name, new ArrayList());
                }
                this.indexvsLocalVarNode.get(node.index).add(node);
                this.localVarNamevsNode.get(node.name).add(node);
                if (!this.endLabels.containsKey(node.end)) {
                    this.endLabels.put(node.end, new LinkedList());
                }
                this.endLabels.get(node.end).add(node.index);
            }
            this.transform();
            this.updateModifiedMethods();
        }
        this.accept(this.delegate);
    }

    @Override
    public void setParamArrayIndex(int paramArrayIndex) {
        this.paramArray = paramArrayIndex;
    }

    @Override
    public void setTransformationInfo(TransformationInfo[] transformationInfos) {
        this.transformationInfos = transformationInfos;
    }

    private void transform() {
        ListIterator insnIterator = this.instructions.iterator();
        LabelNode lastLabel = null;
        while (insnIterator.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)insnIterator.next();
            if (node.getType() == 8 && node instanceof LabelNode) {
                lastLabel = (LabelNode)node;
                this.processLabel((LabelNode)node);
            } else if (node.getType() == 7) {
                this.checkAndTransformDelayedLine(node);
            } else if (node.getType() == 15 && node instanceof LineNumberNode) {
                this.checkAndTransformDelayedLine((AbstractInsnNode)lastLabel);
                this.checkAndTransformLine((LineNumberNode)node);
            } else if (node.getType() == 2 && node instanceof VarInsnNode) {
                this.checkAndTransformLocalVar((VarInsnNode)node);
            } else if (node.getType() == 5 && node instanceof MethodInsnNode) {
                this.checkAndTransformMethodInvoke((MethodInsnNode)node);
            } else if (node.getType() == 4 && node instanceof FieldInsnNode) {
                this.checkAndTransformFieldInsn((FieldInsnNode)node);
            }
            if (node.getType() == 14 || node.getType() == 8 || node.getType() == 15) continue;
            ++this.currentInsnNum;
        }
    }

    private void updateModifiedMethods() {
        this.ct.refreshRangeInjected(this.name, this.desc, this.newInjectionVsOffsetAmount);
        for (int newInjectIndex : this.newInjectionVsOffsetAmount.keySet()) {
            this.ct.setInsnRangeInjected(this.name, this.desc, newInjectIndex + 1, newInjectIndex + this.newInjectionVsOffsetAmount.get(newInjectIndex));
        }
    }

    private InsnList constructInsnListForInsert(MidMethodInfo info) {
        if (this.traceEnabledForMethod) {
            if (info.getLineNumber() != -1) {
                BCTLoggerUtil.println(String.format("          Applying MidMethodInfo at %s line %d collecting %s", info.isAbsLineNum() ? "absolute" : "relative", info.getLineNumber(), Arrays.toString(info.getLocalVarNamesToCollect())));
            } else if (info.getLocalVarNameToMatch() != null) {
                BCTLoggerUtil.println(String.format("          Applying MidMethodInfo at local var %s %s %d times collecting %s", info.getLocalVarNameToMatch(), info.isRead() ? "read" : "write", info.getOccurrences(), Arrays.toString(info.getLocalVarNamesToCollect())));
            } else if (info.getMethodInvokeToMatch() != null) {
                BCTLoggerUtil.println(String.format("          Applying MidMethodInfo at method invoke %s %d times collecting %s", info.getMethodInvokeToMatch(), info.getOccurrences(), Arrays.toString(info.getLocalVarNamesToCollect())));
            }
        }
        if (info.getMidMethodId() == -1) {
            BCTLoggerUtil.warn("           MidMethodInfo is -1! This instrumentation point is ignored");
            return new InsnList();
        }
        InsnList insnList = new InsnList();
        insnList.add(this.translateIntInsn(info.getFastInterceptorId()));
        insnList.add(this.translateIntInsn(info.getTransformationId()));
        insnList.add(this.translateIntInsn(info.getMidMethodId()));
        if (!this.isStatic) {
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        } else {
            insnList.add((AbstractInsnNode)new InsnNode(1));
        }
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)this.classNameWithDotAsSeparator));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)this.name));
        insnList.add(this.captureParamsArray());
        insnList.add(this.captureLocalVarsArray(info));
        insnList.add(this.translateIntInsn(this.currentLineNum));
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(FastMethodInterceptorDelegatorBoot.class), "safeOnMethodMiddle", MethodDesc_FastMethodInterceptorDelegatorSafeOnMethodMiddleNormal, false));
        this.currentInsnNum += insnList.size();
        return insnList;
    }

    private void processLabel(LabelNode node) {
        if (this.endLabels.containsKey(node)) {
            this.localVarsInRangeSet.removeAll((Collection)this.endLabels.get(node));
        }
    }

    private void checkAndTransformDelayedLine(AbstractInsnNode node) {
        if (this.delayedLineInfos.size() > 0) {
            if (node instanceof LabelNode && this.endLabels.containsKey(node)) {
                this.localVarsInRangeSet.addAll((Collection<Integer>)this.endLabels.get(node));
            }
            if (node != null) {
                this.startInjection();
                InsnList insnList = new InsnList();
                for (MidMethodInfo info : this.delayedLineInfos) {
                    insnList.add(this.constructInsnListForInsert(info));
                }
                this.instructions.insertBefore(node, insnList);
                this.endInjection();
            }
            this.delayedLineInfos.clear();
            if (node instanceof LabelNode && this.endLabels.containsKey(node)) {
                this.localVarsInRangeSet.removeAll((Collection)this.endLabels.get(node));
            }
        }
    }

    private void checkAndTransformLine(LineNumberNode node) {
        int lineNum = node.line;
        if (this.startingLine == -1) {
            this.startingLine = lineNum;
        }
        this.currentLineNum = lineNum;
        for (MidMethodInfo info : this.lineInfos) {
            if (!info.isAbsLineNum()) {
                lineNum -= this.startingLine - 1;
            }
            if (lineNum == info.getLineNumber()) {
                if (info.isBefore()) {
                    this.startInjection();
                    this.instructions.insert((AbstractInsnNode)node, this.constructInsnListForInsert(info));
                    this.endInjection();
                } else {
                    this.delayedLineInfos.add(info);
                }
            }
            lineNum = this.currentLineNum;
        }
    }

    private void checkAndTransformLocalVar(VarInsnNode node) {
        if (STORE_OPCODES.contains(node.getOpcode())) {
            this.localVarsInRangeSet.add(node.var);
        }
        if (this.indexvsLocalVarNode.containsKey(node.var)) {
            block0: for (MidMethodInfo info : this.localVarInfos) {
                for (LocalVariableNode localVar : this.indexvsLocalVarNode.get(node.var)) {
                    if (!info.getLocalVarNameToMatch().equals(localVar.name) || info.isRead() && STORE_OPCODES.contains(node.getOpcode()) || !info.isRead() && LOAD_OPCODES.contains(node.getOpcode())) continue;
                    if (!this.shouldInstrumentBasedOnOccurrences(info)) continue block0;
                    if (info.isBefore()) {
                        this.startInjection();
                        if (STORE_OPCODES.contains(node.getOpcode())) {
                            this.localVarsInRangeSet.remove(node.var);
                        }
                        this.instructions.insertBefore((AbstractInsnNode)node, this.constructInsnListForInsert(info));
                        if (STORE_OPCODES.contains(node.getOpcode())) {
                            this.localVarsInRangeSet.add(node.var);
                        }
                        this.endInjection();
                        continue block0;
                    }
                    this.startInjectionAfter();
                    this.instructions.insert((AbstractInsnNode)node, this.constructInsnListForInsert(info));
                    this.endInjectionAfter();
                    continue block0;
                }
            }
        }
    }

    private void checkAndTransformFieldInsn(FieldInsnNode node) {
        for (MidMethodInfo info : this.fieldInfos) {
            if (!info.getFieldNameToMatch().equals(node.name) || (!info.isRead() || !FIELD_LOAD_OPCODES.contains(node.getOpcode())) && (info.isRead() || !FIELD_STORE_OPCODES.contains(node.getOpcode())) || !this.shouldInstrumentBasedOnOccurrences(info)) continue;
            if (info.isBefore()) {
                this.startInjection();
                this.instructions.insertBefore((AbstractInsnNode)node, this.constructInsnListForInsert(info));
                this.endInjection();
                continue;
            }
            this.startInjectionAfter();
            this.instructions.insert((AbstractInsnNode)node, this.constructInsnListForInsert(info));
            this.endInjectionAfter();
        }
    }

    private void checkAndTransformMethodInvoke(MethodInsnNode node) {
        for (MidMethodInfo info : this.methodInvokeInfos) {
            if (!info.getMethodInvokeToMatch().equals(node.name) || !this.shouldInstrumentBasedOnOccurrences(info)) continue;
            if (info.isBefore()) {
                this.startInjection();
                this.instructions.insertBefore((AbstractInsnNode)node, this.constructInsnListForInsert(info));
                this.endInjection();
                continue;
            }
            this.startInjectionAfter();
            this.instructions.insert((AbstractInsnNode)node, this.constructInsnListForInsert(info));
            this.endInjectionAfter();
        }
    }

    private boolean shouldInstrumentBasedOnOccurrences(MidMethodInfo info) {
        Integer occurrencesSeen = this.midMethodInfovsOccurences.get(info);
        occurrencesSeen = occurrencesSeen == null ? 0 : occurrencesSeen;
        occurrencesSeen = occurrencesSeen + 1;
        this.midMethodInfovsOccurences.put(info, occurrencesSeen);
        return occurrencesSeen.intValue() == info.getOccurrences();
    }

    private InsnList captureLocalVarsArray(MidMethodInfo info) {
        InsnList insnList = new InsnList();
        List<String> localVarsToCollectList = Arrays.asList(info.getLocalVarNamesToCollect());
        int pos = 0;
        for (String localVarToCollect : localVarsToCollectList) {
            if (!this.localVarNamevsNode.containsKey(localVarToCollect)) continue;
            boolean foundVarWithinRange = false;
            for (LocalVariableNode variableNode : this.localVarNamevsNode.get(localVarToCollect)) {
                if (!this.localVarWithinRange(variableNode)) continue;
                Type type = Type.getType((String)variableNode.desc);
                insnList.add((AbstractInsnNode)new InsnNode(89));
                insnList.add(this.translateIntInsn(pos));
                if (PRIMITIVE_TYPES.contains(type)) {
                    if (type.equals((Object)Type.INT_TYPE) || type.equals((Object)Type.BOOLEAN_TYPE) || type.equals((Object)Type.SHORT_TYPE) || type.equals((Object)Type.BYTE_TYPE) || type.equals((Object)Type.CHAR_TYPE)) {
                        insnList.add((AbstractInsnNode)new VarInsnNode(21, variableNode.index));
                    } else if (type.equals((Object)Type.LONG_TYPE)) {
                        insnList.add((AbstractInsnNode)new VarInsnNode(22, variableNode.index));
                    } else if (type.equals((Object)Type.FLOAT_TYPE)) {
                        insnList.add((AbstractInsnNode)new VarInsnNode(23, variableNode.index));
                    } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
                        insnList.add((AbstractInsnNode)new VarInsnNode(24, variableNode.index));
                    }
                    AbstractInsnNode callValueInsn = this.callValueOf(type);
                    if (callValueInsn == null) {
                        throw new RuntimeException("An unrecognized primitive encountered while calling valueOf");
                    }
                    insnList.add(callValueInsn);
                } else {
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, variableNode.index));
                }
                insnList.add((AbstractInsnNode)new InsnNode(83));
                foundVarWithinRange = true;
                break;
            }
            if (!foundVarWithinRange) {
                insnList.add((AbstractInsnNode)new InsnNode(89));
                insnList.add(this.translateIntInsn(pos));
                insnList.add((AbstractInsnNode)new InsnNode(1));
                insnList.add((AbstractInsnNode)new InsnNode(83));
            }
            ++pos;
        }
        if (pos > 0) {
            insnList.insert((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Object.class)));
            insnList.insert(this.translateIntInsn(pos));
        } else {
            insnList.insert((AbstractInsnNode)new InsnNode(1));
        }
        return insnList;
    }

    private InsnList captureParamsArray() {
        InsnList insnList = new InsnList();
        if (this.paramArray > -1) {
            insnList.add((AbstractInsnNode)new VarInsnNode(25, this.paramArray));
            return insnList;
        }
        insnList.add(this.translateIntInsn(this.methodArgumentTypes.length));
        insnList.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Object.class)));
        int varPos = this.isStatic ? 0 : 1;
        for (int i = 0; i < this.methodArgumentTypes.length; ++i) {
            insnList.add((AbstractInsnNode)new InsnNode(89));
            insnList.add(this.translateIntInsn(i));
            if (this.methodArgumentTypes[i].equals((Object)Type.INT_TYPE)) {
                insnList.add((AbstractInsnNode)new VarInsnNode(21, varPos));
                ++varPos;
                insnList.add(this.callValueOf(this.methodArgumentTypes[i]));
            } else if (this.methodArgumentTypes[i].equals((Object)Type.LONG_TYPE)) {
                insnList.add((AbstractInsnNode)new VarInsnNode(22, varPos));
                varPos += 2;
                insnList.add(this.callValueOf(this.methodArgumentTypes[i]));
            } else if (this.methodArgumentTypes[i].equals((Object)Type.FLOAT_TYPE)) {
                insnList.add((AbstractInsnNode)new VarInsnNode(23, varPos));
                ++varPos;
                insnList.add(this.callValueOf(this.methodArgumentTypes[i]));
            } else if (this.methodArgumentTypes[i].equals((Object)Type.DOUBLE_TYPE)) {
                insnList.add((AbstractInsnNode)new VarInsnNode(24, varPos));
                varPos += 2;
                insnList.add(this.callValueOf(this.methodArgumentTypes[i]));
            } else if (this.methodArgumentTypes[i].equals((Object)Type.BOOLEAN_TYPE)) {
                insnList.add((AbstractInsnNode)new VarInsnNode(21, varPos));
                ++varPos;
                insnList.add(this.callValueOf(this.methodArgumentTypes[i]));
            } else if (this.methodArgumentTypes[i].equals((Object)Type.BYTE_TYPE)) {
                insnList.add((AbstractInsnNode)new VarInsnNode(21, varPos));
                ++varPos;
                insnList.add(this.callValueOf(this.methodArgumentTypes[i]));
            } else if (this.methodArgumentTypes[i].equals((Object)Type.CHAR_TYPE)) {
                insnList.add((AbstractInsnNode)new VarInsnNode(21, varPos));
                ++varPos;
                insnList.add(this.callValueOf(this.methodArgumentTypes[i]));
            } else if (this.methodArgumentTypes[i].equals((Object)Type.SHORT_TYPE)) {
                insnList.add((AbstractInsnNode)new VarInsnNode(21, varPos));
                ++varPos;
                insnList.add(this.callValueOf(this.methodArgumentTypes[i]));
            } else {
                insnList.add((AbstractInsnNode)new VarInsnNode(25, varPos));
                ++varPos;
            }
            insnList.add((AbstractInsnNode)new InsnNode(83));
        }
        return insnList;
    }

    private AbstractInsnNode translateIntInsn(int i) {
        switch (i) {
            case 0: {
                return new InsnNode(3);
            }
            case 1: {
                return new InsnNode(4);
            }
            case 2: {
                return new InsnNode(5);
            }
            case 3: {
                return new InsnNode(6);
            }
            case 4: {
                return new InsnNode(7);
            }
            case 5: {
                return new InsnNode(8);
            }
            case -1: {
                return new InsnNode(2);
            }
        }
        if (i >= -128 && i < 127) {
            return new IntInsnNode(16, i);
        }
        if (i >= Short.MIN_VALUE && i < Short.MAX_VALUE) {
            return new IntInsnNode(17, i);
        }
        return new LdcInsnNode((Object)i);
    }

    private AbstractInsnNode callValueOf(Type type) {
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return new MethodInsnNode(184, Type.getInternalName(Byte.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Byte.class), (Type[])new Type[]{Type.BYTE_TYPE}), false);
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return new MethodInsnNode(184, Type.getInternalName(Short.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Short.class), (Type[])new Type[]{Type.SHORT_TYPE}), false);
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return new MethodInsnNode(184, Type.getInternalName(Character.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Character.class), (Type[])new Type[]{Type.CHAR_TYPE}), false);
        }
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return new MethodInsnNode(184, Type.getInternalName(Boolean.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Boolean.class), (Type[])new Type[]{Type.BOOLEAN_TYPE}), false);
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return new MethodInsnNode(184, Type.getInternalName(Integer.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Integer.class), (Type[])new Type[]{Type.INT_TYPE}), false);
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return new MethodInsnNode(184, Type.getInternalName(Long.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Long.class), (Type[])new Type[]{Type.LONG_TYPE}), false);
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return new MethodInsnNode(184, Type.getInternalName(Float.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Float.class), (Type[])new Type[]{Type.FLOAT_TYPE}), false);
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return new MethodInsnNode(184, Type.getInternalName(Double.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Double.class), (Type[])new Type[]{Type.DOUBLE_TYPE}), false);
        }
        return null;
    }

    private void startInjection() {
        if (this.startInjectionCount++ == 0) {
            this.firstInjectedInsn = this.currentInsnNum + 1;
        }
    }

    private void endInjection() {
        if (--this.startInjectionCount == 0) {
            if (this.firstInjectedInsn >= 0 && this.firstInjectedInsn <= this.currentInsnNum) {
                this.newInjectionVsOffsetAmount.put(this.firstInjectedInsn - 1, this.currentInsnNum - this.firstInjectedInsn + 1);
            }
            this.firstInjectedInsn = -1;
        } else if (this.startInjectionCount < 0) {
            this.startInjectionCount = 0;
            this.firstInjectedInsn = -1;
        }
    }

    private void startInjectionAfter() {
        ++this.currentInsnNum;
        this.startInjection();
    }

    private void endInjectionAfter() {
        this.endInjection();
        --this.currentInsnNum;
    }

    private boolean localVarWithinRange(LocalVariableNode variableNode) {
        return this.localVarsInRangeSet.contains(variableNode.index);
    }
}

