/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.ClassWriter;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.AbstractInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.ClassNode;
import com.singularity.asm.org.objectweb.asm.tree.InsnList;
import com.singularity.asm.org.objectweb.asm.tree.InsnNode;
import com.singularity.asm.org.objectweb.asm.tree.LdcInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.asm.org.objectweb.asm.tree.TypeInsnNode;
import com.singularity.ee.agent.appagent.IAgentClassLoader;
import com.singularity.ee.agent.appagent.services.bciengine.asm.AMethodGenerator;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IMissingMethodGenerator;
import com.singularity.ee.agent.util.io.Console;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

public class MissingMethodGenerator
extends AMethodGenerator
implements IMissingMethodGenerator {
    private static final String UNSUPPORTED_OPERATION_EXCEPTION_INTERNAL_NAME = Type.getInternalName(UnsupportedOperationException.class);
    private Class<?> interfaceToImplement;
    private ClassNode targetClassNode;
    private static final ProtectionDomain PROTECTION_DOMAIN = MissingMethodGenerator.getProtectionDomainForThisClass();

    public MissingMethodGenerator(String className, Class<?> interfaceToImplement) {
        super(className);
        this.interfaceToImplement = interfaceToImplement;
    }

    @Override
    public void generateMissingMethodsAndDefine(ClassLoader agentClassLoader) {
        byte[] classBytes = this.generateClass(agentClassLoader);
        ((IAgentClassLoader)agentClassLoader).defineGeneratedClass(this.nameOfClassBeingCreated, classBytes, PROTECTION_DOMAIN);
    }

    @Override
    public byte[] generateClass(ClassLoader agentClassLoader) {
        this.targetClassNode = MissingMethodGenerator.createClassNode(this.nameOfClassBeingCreated, agentClassLoader);
        this.createMissingMethods();
        int cwFlags = 1 | (this.targetClassNode.version >= 50 ? 2 : 0);
        ClassWriter cw = new ClassWriter(cwFlags);
        this.targetClassNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private void createMissingMethods() {
        Method[] allMethodsInInterface;
        for (Method nextMethod : allMethodsInInterface = this.interfaceToImplement.getDeclaredMethods()) {
            MethodNode newMethod;
            Type returnType = Type.getReturnType((Method)nextMethod);
            Type[] argTypes = Type.getArgumentTypes((Method)nextMethod);
            if (this.findMethod(this.targetClassNode.methods, nextMethod.getName(), argTypes, nextMethod.getModifiers() & 7, returnType) != null || (newMethod = this.createMissingMethod(nextMethod.getName(), nextMethod.getModifiers(), argTypes, returnType)) == null) continue;
            this.targetClassNode.methods.add(newMethod);
        }
    }

    private MethodNode createMissingMethod(String methodName, int access, Type[] argTypes, Type returnType) {
        String methodDesc = Type.getMethodDescriptor((Type)returnType, (Type[])argTypes);
        MethodNode returnMethod = new MethodNode(access, methodName, methodDesc, null, new String[]{UNSUPPORTED_OPERATION_EXCEPTION_INTERNAL_NAME});
        InsnList insns = returnMethod.instructions;
        insns.add((AbstractInsnNode)new TypeInsnNode(187, UNSUPPORTED_OPERATION_EXCEPTION_INTERNAL_NAME));
        insns.add((AbstractInsnNode)new InsnNode(89));
        insns.add((AbstractInsnNode)new LdcInsnNode((Object)String.format("Unimplemented method: %s", methodName)));
        insns.add((AbstractInsnNode)new MethodInsnNode(183, UNSUPPORTED_OPERATION_EXCEPTION_INTERNAL_NAME, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)})));
        insns.add((AbstractInsnNode)new InsnNode(191));
        Console.out().println(String.format("New method %s with signature %s has been defined in class %s", methodName, methodDesc, this.nameOfClassBeingCreated));
        return returnMethod;
    }

    private static ProtectionDomain getProtectionDomainForThisClass() {
        return MissingMethodGenerator.class.getProtectionDomain();
    }
}

