/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.ee.agent.appagent.kernel.spi.IAgentEnvironment;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaDataManager;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationRuleEngine;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassExtensionGenerator;
import com.singularity.ee.agent.appagent.services.bciengine.spi.AClassTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.IBCIEngineService;
import com.singularity.ee.agent.appagent.services.bciengine.spi.NewImplementationTransformationRule;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.AnnotationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.BasicClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.ByteCodeClassInfo;
import com.singularity.ee.agent.appagent.services.bciengine.spi.filters.RuntimeClassInfo;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class NewClassImplementationTransformer {
    static final IADLogger logger = ADLoggerFactory.getLogger("com.singularity.bci.NewClassImplementationTransformer");
    private final ConcurrentHashMap<ClassKey, List<NewImplementationTransformationRule>> mapOfTransformedClasses = new ADConcurrentHashMap();
    private final Set<ClassKey> failedInitialTransforms = Collections.synchronizedSet(new HashSet());
    private final IBCIEngineService bciEngine;
    private final IClassMetaDataManager classMetaDataManager;
    private final boolean isLoadedFromBootClassLoader = NewClassImplementationTransformer.class.getClassLoader() == null;
    private final IAgentEnvironment agentEnvironment;

    NewClassImplementationTransformer(TransformationRuleEngine ruleEngine, IBCIEngineService bciEngine, IClassMetaDataManager classMetaDataManager, IAgentEnvironment agentEnvironment) {
        this.bciEngine = bciEngine;
        this.classMetaDataManager = classMetaDataManager;
        this.agentEnvironment = agentEnvironment;
    }

    byte[] transform(AClassTransformationRule[] matchedRules, RuntimeClassInfo runtimeClassInfo, BasicClassInfo basicClassInfo, byte[] oldByteCode, int classWriterFlags) throws RuntimeException {
        if (runtimeClassInfo != null && runtimeClassInfo.getRunTimeClass() != null) {
            return this.retransformClass(basicClassInfo, oldByteCode, classWriterFlags);
        }
        return this.transformNewClass(matchedRules, runtimeClassInfo, basicClassInfo, oldByteCode, classWriterFlags);
    }

    private byte[] transformNewClass(AClassTransformationRule[] matchedRules, RuntimeClassInfo runtimeClassInfo, BasicClassInfo basicClassInfo, byte[] oldByteCode, int classWriterFlags) throws RuntimeException {
        ClassExtensionGenerator classExtensionGenerator;
        byte[] returnClassBytes = null;
        List<NewImplementationTransformationRule> listOfRules = new ArrayList<NewImplementationTransformationRule>(matchedRules.length);
        for (AClassTransformationRule nextRule : matchedRules) {
            if (!(nextRule instanceof NewImplementationTransformationRule)) continue;
            listOfRules.add((NewImplementationTransformationRule)nextRule);
        }
        if (listOfRules.size() > 0 && (listOfRules = this.checkByteCodeRules(classExtensionGenerator = new ClassExtensionGenerator(this.bciEngine, basicClassInfo.getClassName(), oldByteCode, this.isLoadedFromBootClassLoader, classWriterFlags, this.agentEnvironment), listOfRules, runtimeClassInfo, basicClassInfo)).size() > 0) {
            returnClassBytes = this.transformAccordingToRules(classExtensionGenerator, listOfRules, basicClassInfo);
            this.mapOfTransformedClasses.put(new ClassKey(basicClassInfo.getClassName(), basicClassInfo.getLoader()), listOfRules);
        }
        return returnClassBytes;
    }

    private List<NewImplementationTransformationRule> checkByteCodeRules(ClassExtensionGenerator classExtensionGenerator, List<NewImplementationTransformationRule> listOfRules, RuntimeClassInfo runtimeClassInfo, BasicClassInfo basicClassInfo) {
        ArrayList<NewImplementationTransformationRule> returnList;
        List<AnnotationInfo> annotationList = classExtensionGenerator.getAnnotationList();
        ByteCodeClassInfo byteCodeClassInfo = new ByteCodeClassInfo(classExtensionGenerator.getSuperName(), classExtensionGenerator.getInterfaces().toArray(new String[classExtensionGenerator.getInterfaces().size()]), annotationList.toArray(new AnnotationInfo[annotationList.size()]), runtimeClassInfo);
        AClassTransformationRule[] arrayOfRules = listOfRules.toArray(new AClassTransformationRule[listOfRules.size()]);
        arrayOfRules = this.bciEngine.geTransformationRuleEngine().checkByteCodeClassFilters(basicClassInfo, runtimeClassInfo, byteCodeClassInfo, arrayOfRules);
        if (arrayOfRules != null) {
            returnList = new ArrayList<NewImplementationTransformationRule>(arrayOfRules.length);
            for (AClassTransformationRule nextRule : arrayOfRules) {
                returnList.add((NewImplementationTransformationRule)nextRule);
            }
        } else {
            returnList = Collections.EMPTY_LIST;
        }
        return returnList;
    }

    private byte[] retransformClass(BasicClassInfo basicClassInfo, byte[] oldByteCode, int classWriterFlags) throws RuntimeException {
        byte[] returnByteArray = null;
        ClassKey keyToSearch = new ClassKey(basicClassInfo.getClassName(), basicClassInfo.getLoader());
        List<NewImplementationTransformationRule> listOfRules = this.mapOfTransformedClasses.get(keyToSearch);
        if (listOfRules != null) {
            if (!this.failedInitialTransforms.contains(keyToSearch)) {
                ClassExtensionGenerator classExtensionGenerator = new ClassExtensionGenerator(this.bciEngine, basicClassInfo.getClassName(), oldByteCode, this.isLoadedFromBootClassLoader, classWriterFlags, this.agentEnvironment);
                returnByteArray = this.transformAccordingToRules(classExtensionGenerator, listOfRules, basicClassInfo);
            } else {
                logger.warn(String.format("Unable to associate new interfaces to class %s because initial transformation failed", basicClassInfo.getClassName()));
            }
        }
        return returnByteArray;
    }

    private byte[] transformAccordingToRules(ClassExtensionGenerator classExtensionGenerator, List<NewImplementationTransformationRule> listOfRules, BasicClassInfo basicClassInfo) throws RuntimeException {
        classExtensionGenerator.defineSerialVersionUIDIfNecessary(basicClassInfo);
        for (NewImplementationTransformationRule rule : listOfRules) {
            this.transformClassAccordingToRule(rule, basicClassInfo, classExtensionGenerator);
        }
        return classExtensionGenerator.generateAndGetBytes();
    }

    private void transformClassAccordingToRule(NewImplementationTransformationRule rule, BasicClassInfo basicClassInfo, ClassExtensionGenerator classExtensionGenerator) throws RuntimeException {
        String[] interfacesToImplement = rule.getNewInterfaces();
        String[] templateClasses = rule.getNewMethodTemplateClasses();
        if (interfacesToImplement != null && templateClasses != null && interfacesToImplement.length == templateClasses.length) {
            for (int i = 0; i < interfacesToImplement.length; ++i) {
                classExtensionGenerator.forceClassToImplement(interfacesToImplement[i], templateClasses[i], basicClassInfo, this.classMetaDataManager, rule.isShouldInjectField());
            }
        } else {
            throw new RuntimeException("Error in definition of interfacesToImplement or templateClasses");
        }
    }

    public void indicateTransformationTimeout(String className, ClassLoader classLoader) {
        this.failedInitialTransforms.add(new ClassKey(className, classLoader));
    }

    private static class ClassKey {
        private final String className;
        private final WeakReference<ClassLoader> refToClassLoader;
        private final int hashValue;

        ClassKey(String className, ClassLoader classLoader) {
            this.className = className;
            this.refToClassLoader = new WeakReference<ClassLoader>(classLoader);
            this.hashValue = className.hashCode() ^ (classLoader != null ? classLoader.hashCode() : 0);
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object o) {
            boolean bReturn;
            boolean bl = bReturn = this == o;
            if (!bReturn && o instanceof ClassKey) {
                ClassKey other = (ClassKey)o;
                bReturn = this.hashValue == other.hashValue && this.className.equals(other.className) && this.refToClassLoader.get() == other.refToClassLoader.get();
            }
            return bReturn;
        }
    }
}

