/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.ClassReader;
import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.ClassWriter;
import com.singularity.ee.agent.appagent.services.bciengine.IPreTransformer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PreTransformer
implements IPreTransformer {
    private static final String CLASS_TO_PRE_TRANSFORM = "java/util/logging/Logger.class";

    @Override
    public void preTransform() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream is = classLoader.getResourceAsStream(CLASS_TO_PRE_TRANSFORM);
            byte[] classBytes = PreTransformer.convertToByteArray(is);
            ClassReader classReader = new ClassReader(classBytes);
            ClassWriter classWriter = new ClassWriter(classReader, 1);
            classReader.accept((ClassVisitor)classWriter, 4);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] convertToByteArray(InputStream is) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        try {
            int available;
            while ((available = bis.available()) > 0) {
                byte[] bytes = new byte[available];
                int bytesRead = bis.read(bytes);
                if (bytesRead < 0) {
                    break;
                }
                if (bytesRead <= 0) continue;
                bos.write(bytes, 0, bytesRead);
            }
        }
        finally {
            bis.close();
            bos.close();
        }
        byte[] classBytes = baos.toByteArray();
        return classBytes;
    }
}

