/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.ClassNode;
import com.singularity.asm.org.objectweb.asm.tree.FieldNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.ee.agent.appagent.services.bciengine.IClassMetaData;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassMetaDataManager;
import com.singularity.ee.agent.appagent.services.bciengine.asm.ClassMetaDataUtility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

class SerialVersionUIDFieldCreator {
    private static final String SERIAL_VERSION_UID_FIELD_NAME = "serialVersionUID";
    private static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    private static final String STATIC_CONSTRUCTOR_METHOD_NAME = "<clinit>";
    private final ClassNode classNode;
    private final ClassLoader classLoader;
    private static final int FIELD_ACCESS_FLAGS = 223;
    private static final int METHOD_MODIFIER_FLAGS = 3391;

    SerialVersionUIDFieldCreator(ClassNode classNode, ClassLoader classLoader) {
        this.classNode = classNode;
        this.classLoader = classLoader;
    }

    void defineSerialVersionUIDIfNecessary() throws RuntimeException {
        if (this.isSerializableClass() && !this.isSerialVersionUIDDefined()) {
            try {
                FieldNode serialVersionUIDField = new FieldNode(26, SERIAL_VERSION_UID_FIELD_NAME, Type.LONG_TYPE.getDescriptor(), null, (Object)this.calculateSerialVersionUIDValue());
                this.classNode.fields.add(serialVersionUIDField);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString(), e);
            }
        }
    }

    private boolean isSerializableClass() throws RuntimeException {
        if ((this.classNode.access & 0x200) != 0) {
            return false;
        }
        IClassMetaData metaData = ClassMetaDataManager.getInstance().getClassMetaData(this.classNode, this.classLoader);
        if (metaData == null) {
            throw new RuntimeException("Cannot obtain class meta data for class " + this.classNode.name);
        }
        return ClassMetaDataUtility.implementsInterface(metaData, "java.io.Serializable");
    }

    boolean isSerialVersionUIDDefined() throws RuntimeException {
        boolean bReturn = false;
        List listOfFields = this.classNode.fields;
        for (FieldNode nextField : listOfFields) {
            if (!nextField.name.equals(SERIAL_VERSION_UID_FIELD_NAME)) continue;
            if ((nextField.access & 8) > 0 && (nextField.access & 0x10) > 0 && nextField.desc.equals(Type.LONG_TYPE.getDescriptor())) {
                bReturn = true;
                break;
            }
            throw new RuntimeException("serialVersionUID field for class " + this.classNode.name + " is defined incorrectly.  Must be static long");
        }
        return bReturn;
    }

    long calculateSerialVersionUIDValue() throws Exception {
        long serialUID = 0L;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        List methods = this.classNode.methods;
        String className = this.classNode.name.replace("/", ".");
        out.writeUTF(className);
        int classMods = this.classNode.access & 0x611;
        out.writeInt(classMods);
        List interfaceNames = this.classNode.interfaces;
        if (interfaceNames != null) {
            int i;
            Object[] interfaces = new String[interfaceNames.size()];
            for (i = 0; i < interfaces.length; ++i) {
                interfaces[i] = ((String)interfaceNames.get(i)).replace("/", ".");
            }
            Arrays.sort(interfaces);
            for (i = 0; i < interfaces.length; ++i) {
                out.writeUTF((String)interfaces[i]);
            }
        }
        List listOfFields = this.classNode.fields;
        FieldNode[] fieldNodes = listOfFields.toArray(new FieldNode[listOfFields.size()]);
        Arrays.sort(fieldNodes, new Comparator<FieldNode>(){

            @Override
            public int compare(FieldNode o1, FieldNode o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        for (FieldNode nextField : fieldNodes) {
            int mods = nextField.access & 0xDF;
            if ((mods & 2) != 0 && (mods & 0x88) != 0) continue;
            out.writeUTF(nextField.name);
            out.writeInt(mods);
            out.writeUTF(nextField.desc);
        }
        ArrayList<MethodNode> constructorList = new ArrayList<MethodNode>();
        ArrayList<MethodNode> regularMethodList = new ArrayList<MethodNode>();
        if (methods != null) {
            int mods;
            for (MethodNode nextMethod : methods) {
                if (nextMethod.name.equals(STATIC_CONSTRUCTOR_METHOD_NAME)) {
                    out.writeUTF(STATIC_CONSTRUCTOR_METHOD_NAME);
                    out.writeInt(8);
                    out.writeUTF("()V");
                    continue;
                }
                if (nextMethod.name.equals(CONSTRUCTOR_METHOD_NAME)) {
                    constructorList.add(nextMethod);
                    continue;
                }
                regularMethodList.add(nextMethod);
            }
            MethodNode[] constructors = constructorList.toArray(new MethodNode[constructorList.size()]);
            MethodNode[] regularMethods = regularMethodList.toArray(new MethodNode[regularMethodList.size()]);
            Arrays.sort(constructors, new Comparator<MethodNode>(){

                @Override
                public int compare(MethodNode o1, MethodNode o2) {
                    return o1.desc.compareTo(o2.desc);
                }
            });
            for (MethodNode nextConstructor : constructors) {
                mods = nextConstructor.access & 0xD3F;
                if ((mods & 2) != 0) continue;
                out.writeUTF(CONSTRUCTOR_METHOD_NAME);
                out.writeInt(mods);
                out.writeUTF(nextConstructor.desc.replace('/', '.'));
            }
            Arrays.sort(regularMethods, new Comparator<MethodNode>(){

                @Override
                public int compare(MethodNode o1, MethodNode o2) {
                    int value = o1.name.compareTo(o2.name);
                    if (value == 0) {
                        value = o1.desc.compareTo(o2.desc);
                    }
                    return value;
                }
            });
            for (MethodNode method : regularMethods) {
                mods = method.access & 0xD3F;
                if ((mods & 2) != 0) continue;
                out.writeUTF(method.name);
                out.writeInt(mods);
                out.writeUTF(method.desc.replace('/', '.'));
            }
        }
        out.flush();
        MessageDigest digest = MessageDigest.getInstance("SHA");
        byte[] digested = digest.digest(bout.toByteArray());
        for (int i = Math.min(digested.length, 8) - 1; i >= 0; --i) {
            serialUID = serialUID << 8 | (long)(digested[i] & 0xFF);
        }
        return serialUID;
    }
}

