/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm;

import com.singularity.asm.org.objectweb.asm.ClassReader;
import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.ClassWriter;
import com.singularity.asm.org.objectweb.asm.Label;
import com.singularity.asm.org.objectweb.asm.tree.AbstractInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.ClassNode;
import com.singularity.asm.org.objectweb.asm.tree.InsnList;
import com.singularity.asm.org.objectweb.asm.tree.InsnNode;
import com.singularity.asm.org.objectweb.asm.tree.JumpInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.LabelNode;
import com.singularity.asm.org.objectweb.asm.tree.LookupSwitchInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.asm.org.objectweb.asm.tree.TableSwitchInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.TryCatchBlockNode;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodContainingUnreachableInstructions;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class UnreachableInstructionCorrector {
    private static final Label DUMMY_LABEL = new Label();
    private final byte[] originalClassBytes;
    private final Set<MethodContainingUnreachableInstructions> setOfUnreachableInsnsMethods;

    UnreachableInstructionCorrector(byte[] originalClassBytes, Set<MethodContainingUnreachableInstructions> setOfUnreachableInsnsMethods) {
        this.originalClassBytes = originalClassBytes;
        this.setOfUnreachableInsnsMethods = setOfUnreachableInsnsMethods;
    }

    byte[] correctClass() {
        byte[] returnClassBytes = this.originalClassBytes;
        ClassNode classNode = new ClassNode(589824);
        ClassReader classReader = new ClassReader(this.originalClassBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        if (this.correctMethods(classNode)) {
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            returnClassBytes = classWriter.toByteArray();
        }
        return returnClassBytes;
    }

    private boolean correctMethods(ClassNode classNode) {
        boolean bReturn = false;
        if (classNode.methods != null) {
            for (MethodNode methodNode : classNode.methods) {
                MethodContainingUnreachableInstructions testMethodContainingUnreachableInstructions = new MethodContainingUnreachableInstructions(methodNode.name, methodNode.desc);
                if (!this.setOfUnreachableInsnsMethods.contains(testMethodContainingUnreachableInstructions) || !this.correctMethod(methodNode)) continue;
                bReturn = true;
            }
        }
        return bReturn;
    }

    private boolean correctMethod(MethodNode methodNode) {
        boolean bReturn = false;
        InsnList instructions = methodNode.instructions;
        if (instructions != null) {
            ArrayList<Label> currentLabels = new ArrayList<Label>();
            currentLabels.add(DUMMY_LABEL);
            HashSet<Label> reachableLabels = new HashSet<Label>();
            reachableLabels.add(DUMMY_LABEL);
            HashMap mapOflabelsPreceedingATHROWs = new HashMap();
            ListIterator insnIter = instructions.iterator();
            if (methodNode.tryCatchBlocks != null) {
                for (TryCatchBlockNode tryCatchBlockNode : methodNode.tryCatchBlocks) {
                    reachableLabels.add(tryCatchBlockNode.handler.getLabel());
                }
            }
            while (insnIter.hasNext()) {
                AbstractInsnNode nextInsn = (AbstractInsnNode)insnIter.next();
                switch (nextInsn.getType()) {
                    case 8: {
                        LabelNode labelNode = (LabelNode)nextInsn;
                        currentLabels.add(labelNode.getLabel());
                        break;
                    }
                    case 0: {
                        InsnNode insnNode = (InsnNode)nextInsn;
                        if (insnNode.getOpcode() == 191 || insnNode.getOpcode() == 0) {
                            if (currentLabels.size() == 0) {
                                insnIter.remove();
                                bReturn = true;
                            } else {
                                mapOflabelsPreceedingATHROWs.put(insnNode, new ArrayList(currentLabels));
                            }
                        }
                        if (!MethodTransformer.isNextInstructionUnreachable(insnNode.getOpcode())) break;
                        currentLabels.clear();
                        break;
                    }
                    case 7: {
                        JumpInsnNode jumpInsnNode = (JumpInsnNode)nextInsn;
                        reachableLabels.add(jumpInsnNode.label.getLabel());
                        if (!MethodTransformer.isNextInstructionUnreachable(jumpInsnNode.getOpcode())) break;
                        currentLabels.clear();
                        break;
                    }
                    case 12: {
                        LookupSwitchInsnNode lookupSwitchInsnNode = (LookupSwitchInsnNode)nextInsn;
                        if (lookupSwitchInsnNode.labels != null) {
                            this.addLabelListToSet(lookupSwitchInsnNode.labels, reachableLabels);
                        }
                        if (lookupSwitchInsnNode.dflt == null) break;
                        reachableLabels.add(lookupSwitchInsnNode.dflt.getLabel());
                        break;
                    }
                    case 11: {
                        TableSwitchInsnNode tableSwitchInsnNode = (TableSwitchInsnNode)nextInsn;
                        if (tableSwitchInsnNode.labels != null) {
                            this.addLabelListToSet(tableSwitchInsnNode.labels, reachableLabels);
                        }
                        if (tableSwitchInsnNode.dflt == null) break;
                        reachableLabels.add(tableSwitchInsnNode.dflt.getLabel());
                        break;
                    }
                }
            }
            for (Map.Entry entry : mapOflabelsPreceedingATHROWs.entrySet()) {
                InsnNode athrowNode = (InsnNode)entry.getKey();
                List listOfLabels = (List)entry.getValue();
                boolean reachableLabelFound = false;
                for (Label nextLabelPreceedingATHROW : listOfLabels) {
                    if (!reachableLabels.contains(nextLabelPreceedingATHROW)) continue;
                    reachableLabelFound = true;
                    break;
                }
                if (reachableLabelFound) continue;
                instructions.remove((AbstractInsnNode)athrowNode);
                bReturn = true;
            }
        }
        return bReturn;
    }

    private void addLabelListToSet(Collection<LabelNode> labelList, Set<Label> setOfLabels) {
        for (LabelNode labelNode : labelList) {
            setOfLabels.add(labelNode.getLabel());
        }
    }
}

