/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.attributes;

import com.singularity.asm.org.objectweb.asm.Attribute;
import com.singularity.asm.org.objectweb.asm.ClassReader;
import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.ClassAttribute;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.EnclosingMethodAttribute;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.IClassAttributeExtractor;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.InnerClassAttribute;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.NonStandardClassAttribute;
import com.singularity.ee.agent.appagent.services.bciengine.attributes.SourceAttribute;
import java.util.HashSet;
import java.util.Set;

public class ClassAttributeExtractor
extends ClassVisitor
implements IClassAttributeExtractor {
    private Set<ClassAttribute> allDiscoveredAttributes;
    private final String className;

    public ClassAttributeExtractor(String className) {
        super(589824);
        this.className = className;
    }

    @Override
    public void extractAttributes(byte[] classBytes) {
        this.allDiscoveredAttributes = new HashSet<ClassAttribute>();
        ClassReader cr = new ClassReader(classBytes);
        cr.accept((ClassVisitor)this, 5);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.allDiscoveredAttributes.add(new EnclosingMethodAttribute(owner, name, desc));
    }

    @Override
    public Set<ClassAttribute> getAllDiscoveredAttributes() {
        return new HashSet<ClassAttribute>(this.allDiscoveredAttributes);
    }

    String getClassName() {
        return this.className;
    }

    public void visitAttribute(Attribute attr) {
        this.allDiscoveredAttributes.add(new NonStandardClassAttribute(attr.type));
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.allDiscoveredAttributes.add(new InnerClassAttribute(name, outerName, innerName, access));
    }

    public void visitSource(String source, String debug) {
        this.allDiscoveredAttributes.add(new SourceAttribute(source, debug));
    }
}

