/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.custom.instrumentation;

import com.singularity.asm.org.objectweb.asm.MethodVisitor;
import com.singularity.ee.agent.appagent.services.bciengine.IMethodCodeTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.custom.instrumentation.Instruction;
import com.singularity.ee.agent.appagent.services.bciengine.custom.instrumentation.InstructionsHandler;
import java.util.ArrayList;
import java.util.List;

public class InstructionsHandlersWrapper
extends InstructionsHandler<MethodVisitor> {
    private List<InstructionsHandler> mCustomInstructionCallbacks;
    private boolean needMore = true;

    public InstructionsHandlersWrapper(List<InstructionsHandler> callbacks) {
        this.mCustomInstructionCallbacks = callbacks;
        this.needMore = callbacks != null;
    }

    @Override
    public boolean require(String methodName) {
        if (!this.needMore) {
            return false;
        }
        for (int i = 0; i < this.mCustomInstructionCallbacks.size(); ++i) {
            InstructionsHandler instructionsCallback = this.mCustomInstructionCallbacks.get(i);
            if (!instructionsCallback.require(methodName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInjected() {
        if (this.mCustomInstructionCallbacks == null) {
            return false;
        }
        for (int i = 0; i < this.mCustomInstructionCallbacks.size(); ++i) {
            InstructionsHandler instructionsCallback = this.mCustomInstructionCallbacks.get(i);
            if (!instructionsCallback.isInjected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean visitMethodInsn(int opcode, String owner, String name, String desc, IMethodCodeTransformer callbackToInject, List<Instruction> instructions) {
        if (this.mCustomInstructionCallbacks == null) {
            return false;
        }
        for (int i = 0; i < this.mCustomInstructionCallbacks.size(); ++i) {
            InstructionsHandler instructionsCallback = this.mCustomInstructionCallbacks.get(i);
            if (!instructionsCallback.visitMethodInsn(opcode, owner, name, desc, callbackToInject, instructions)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean visitInstructions(List<Instruction> instructions, MethodVisitor methodVisitor, String mClassName, String mName, int lineNumber) {
        boolean needMore = false;
        for (int i = 0; i < this.mCustomInstructionCallbacks.size(); ++i) {
            InstructionsHandler instructionsCallback = this.mCustomInstructionCallbacks.get(i);
            needMore = needMore || instructionsCallback.visitInstructions(this.filter(instructions, instructionsCallback), methodVisitor, mClassName, mName, lineNumber);
        }
        this.needMore = needMore;
        return this.needMore;
    }

    private List<Instruction> filter(List<Instruction> instructions, InstructionsHandler instructionsCallback) {
        List<Instruction> filtered = null;
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            if (!instructionsCallback.require(instruction.getMethod())) {
                if (filtered != null) continue;
                filtered = new ArrayList<Instruction>();
                filtered.addAll(instructions.subList(0, i));
                continue;
            }
            if (filtered == null) continue;
            filtered.add(instruction);
        }
        return filtered != null ? filtered : instructions;
    }
}

