/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.inline;

import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.ee.agent.appagent.services.bciengine.AInlineTrackedMethodInterceptor;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.asm.IInlineStateVar;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.IInlineInterceptorTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.InstructionList;
import com.singularity.ee.agent.appagent.services.bciengine.inline.IInlineTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.inline.UnresolvedSymbolicReference;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;

public abstract class AInlineInterceptorTransformer
implements IInlineInterceptorTransformer,
IInlineTransformer {
    protected String className;
    protected String methodName;
    protected String methodDescriptor;
    protected int access;
    protected MethodTransformer mt;
    protected TransformationInfo ti;
    protected AInlineTrackedMethodInterceptor interceptor;
    protected boolean error;
    protected boolean returnObjectIsAvailable;
    protected boolean throwableObjectAvailable;
    protected int paramsVar;
    protected int thrownObjectVar = -1;
    protected int returnedObjectVar = -1;
    protected int returnInstructionOpCode;
    protected int saveReturnValueVarNumber = -1;
    protected int saveThrowableVarNumber = -1;
    protected Type[] argumentTypes;

    protected AInlineInterceptorTransformer(AInlineTrackedMethodInterceptor inlineTrackedMethodInterceptor) {
        this.interceptor = inlineTrackedMethodInterceptor;
    }

    @Override
    public void init(String className, String methodName, String methodDescriptor, int access, MethodTransformer methodTransformer, TransformationInfo tranformationInfo) {
        this.className = className.replace('/', '.');
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
        this.access = access;
        this.mt = methodTransformer;
        this.ti = tranformationInfo;
        this.argumentTypes = Type.getArgumentTypes((String)methodDescriptor);
    }

    @Override
    public int getInterceptorId() {
        return this.ti.getFastInterceptorId();
    }

    protected abstract InstructionList getMethodEntryInstructions();

    protected abstract InstructionList getMethodExitInstructions(int var1);

    @Override
    public abstract IInlineStateVar[] getLocalVarsToInitialize();

    @Override
    public abstract void localVariablesDefined(int[] var1);

    @Override
    public void doMethodEnterInstrumentation() {
        try {
            InstructionList list = this.getMethodEntryInstructions();
            if (list != null) {
                list.resolveSymbols();
                list.sendToMethodTransformer(this.mt);
            }
        }
        catch (UnresolvedSymbolicReference e) {
            this.error = true;
            BCTLoggerUtil.printStackTrace(e);
        }
    }

    @Override
    public void doMethodExitInstrumentation(int opcode) {
        try {
            this.returnInstructionOpCode = opcode;
            this.returnObjectIsAvailable = this.returnInstructionOpCode == 176 && this.returnedObjectVar >= 0;
            this.throwableObjectAvailable = this.returnInstructionOpCode == 191 && this.thrownObjectVar >= 0;
            InstructionList list = this.getMethodExitInstructions(opcode);
            if (list != null) {
                list.resolveSymbols();
                list.sendToMethodTransformer(this.mt);
            }
        }
        catch (UnresolvedSymbolicReference e) {
            this.error = true;
            BCTLoggerUtil.printStackTrace(e);
        }
    }

    @Override
    public void setParmArrayIndex(int parmArrayVar) {
        this.paramsVar = parmArrayVar;
    }

    @Override
    public void setThrownExceptionIndex(int throwableVar) {
        this.thrownObjectVar = throwableVar;
    }

    @Override
    public void setReturnedObjectIndex(int returnedObjectVar) {
        this.returnedObjectVar = returnedObjectVar;
    }

    @Override
    public int getReturnInstructionOpCode() {
        return this.returnInstructionOpCode;
    }

    @Override
    public int getSaveReturnValueVarNumber(Type type) {
        if (this.saveReturnValueVarNumber == -1) {
            this.saveReturnValueVarNumber = this.mt.newLocal(type);
        }
        return this.saveReturnValueVarNumber;
    }

    @Override
    public int getSaveThrowableVarNumber() {
        if (this.saveThrowableVarNumber == -1) {
            this.saveThrowableVarNumber = this.mt.newLocal(Type.getType(Throwable.class));
        }
        return this.saveThrowableVarNumber;
    }

    @Override
    public int getThrownObjectVar() {
        return this.thrownObjectVar;
    }

    @Override
    public int getSaveReturnValueVarNumber() {
        return this.saveReturnValueVarNumber;
    }

    @Override
    public boolean isThrowableObjectAvailable() {
        return this.throwableObjectAvailable;
    }

    @Override
    public boolean isReturnObjectIsAvailable() {
        return this.returnObjectIsAvailable;
    }

    @Override
    public int getReturnedObjectVar() {
        return this.returnedObjectVar;
    }

    @Override
    public MethodTransformer getMethodTransformer() {
        return this.mt;
    }

    @Override
    public AInlineTrackedMethodInterceptor getInlineTrackedMethodInterceptor() {
        return this.interceptor;
    }

    public int getMethodAccessFlags() {
        return this.access;
    }

    public int getParmArrayIndex() {
        return this.mt.getParmsArrayLocVar();
    }

    @Override
    public Type[] getMethodArgumentTypes() {
        return this.argumentTypes;
    }

    @Override
    public abstract boolean shouldInjectTryCatch();
}

