/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.inline;

import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.FieldInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.IInlineInterceptorTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.IincInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.IntInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.JumpInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.LabelPseudoInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.LdcInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.LookupSwitchInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.MethodExitReturnInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.MethodInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.MultiANewArrayInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.RestoreReturnValueInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.SaveReturnValueInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.SimpleInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.TableSwitchInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.TypeInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.VarInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.inline.IInlineTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.inline.Symbol;
import com.singularity.ee.agent.appagent.services.bciengine.inline.SymbolTable;
import com.singularity.ee.agent.appagent.services.bciengine.inline.UnresolvedSymbolicReference;
import java.lang.reflect.Array;

public abstract class ASMInstruction {
    protected int opCode;
    protected Object[] args;
    protected IInlineInterceptorTransformer interceptorTransformer;

    protected ASMInstruction() {
    }

    ASMInstruction(int opCode) {
        this.opCode = opCode;
    }

    protected ASMInstruction(int opCode, Object arg1) {
        this.opCode = opCode;
        this.args = new Object[]{arg1};
    }

    protected ASMInstruction(int opCode, Object arg1, Object arg2) {
        this.opCode = opCode;
        this.args = new Object[]{arg1, arg2};
    }

    protected ASMInstruction(int opCode, Object arg1, Object arg2, Object arg3) {
        this.opCode = opCode;
        this.args = new Object[]{arg1, arg2, arg3};
    }

    protected ASMInstruction(Object arg1, Object arg2, Object arg3, Object arg4) {
        this.args = new Object[]{arg1, arg2, arg3, arg4};
    }

    protected ASMInstruction(Object ... args) {
        this.args = args;
    }

    public static ASMInstruction generateFieldInsn(int opCode, Object owner, Object name, Object desc) {
        return new FieldInstruction(opCode, owner, name, desc);
    }

    public static ASMInstruction generateIincInsn(Object var, Object inc) {
        return new IincInstruction(var, inc);
    }

    public static ASMInstruction generateSimpleInsn(int opCode) {
        return new SimpleInstruction(opCode);
    }

    public static ASMInstruction generateIntInsn(int opCode, Object operand) {
        return new IntInstruction(opCode, operand);
    }

    public static ASMInstruction generateJumpInsn(int opCode, Object label) {
        return new JumpInstruction(opCode, label);
    }

    public static ASMInstruction generateLabel(Object label) {
        return new LabelPseudoInstruction(label);
    }

    public static ASMInstruction generateLdcInsn(Object cst) {
        return new LdcInstruction(cst);
    }

    public static ASMInstruction generateLookupSwitchInsn(Object label, int[] keys, Object[] labels) {
        return new LookupSwitchInstruction(label, keys, labels);
    }

    public static ASMInstruction generateMethodInsn(int opCode, Object owner, Object name, Object desc) {
        return new MethodInstruction(opCode, owner, name, desc);
    }

    public static ASMInstruction generateMultiANewArrayInsn(Object desc, Object dims) {
        return new MultiANewArrayInstruction(desc, dims);
    }

    public static ASMInstruction generateTableSwitchInsn(Object min, Object max, Object dfltLabel, Object[] labels) {
        return new TableSwitchInstruction(min, max, dfltLabel, labels);
    }

    public static ASMInstruction generateTypeInsn(int opCode, Object type) {
        return new TypeInstruction(opCode, type);
    }

    public static ASMInstruction generateVarInsn(int opCode, Object var) {
        return new VarInstruction(opCode, var);
    }

    public static ASMInstruction generateSaveReturnValueInstruction() {
        return new SaveReturnValueInstruction();
    }

    public static ASMInstruction generateRestoreReturnValueInstruction() {
        return new RestoreReturnValueInstruction();
    }

    public static ASMInstruction generateMethodExitReturnInstruction() {
        return new MethodExitReturnInstruction();
    }

    void resolveSymbols(SymbolTable symbolTable) throws UnresolvedSymbolicReference {
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                if (this.args[i] instanceof Symbol) {
                    this.args[i] = symbolTable.resolveSymbol((Symbol)this.args[i]);
                    continue;
                }
                if (this.args[i] == null || !this.args[i].getClass().isArray()) continue;
                int length = Array.getLength(this.args[i]);
                for (int j = 0; j < length; ++j) {
                    Object arrayElement = Array.get(this.args[i], j);
                    if (!(arrayElement instanceof Symbol)) continue;
                    Object arraySymbolValue = symbolTable.resolveSymbol((Symbol)arrayElement);
                    Array.set(this.args[i], j, arraySymbolValue);
                }
            }
        }
    }

    public IInlineTransformer getInterceptorTransformer() {
        return this.interceptorTransformer;
    }

    public void setInterceptorTransformer(IInlineInterceptorTransformer interceptorTransformer) {
        this.interceptorTransformer = interceptorTransformer;
    }

    abstract void visit(MethodTransformer var1);

    public abstract ASMInstruction clone();
}

