/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.inline;

import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.ASMInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.IInlineInterceptorTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.inline.SymbolTable;
import com.singularity.ee.agent.appagent.services.bciengine.inline.UnresolvedSymbolicReference;

public class InstructionList {
    private final ASMInstruction[] insnList;
    private final SymbolTable symbolTable;

    public InstructionList(ASMInstruction[] insnList, SymbolTable symbolTable, IInlineInterceptorTransformer interceptorTransformer) {
        this.insnList = new ASMInstruction[insnList.length];
        for (int i = 0; i < insnList.length; ++i) {
            this.insnList[i] = insnList[i].clone();
            this.insnList[i].setInterceptorTransformer(interceptorTransformer);
        }
        this.symbolTable = symbolTable;
    }

    public void resolveSymbols() throws UnresolvedSymbolicReference {
        for (ASMInstruction nextInsn : this.insnList) {
            nextInsn.resolveSymbols(this.symbolTable);
        }
    }

    public void sendToMethodTransformer(MethodTransformer mt) {
        for (ASMInstruction nextInsn : this.insnList) {
            nextInsn.visit(mt);
        }
    }
}

