/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.inline;

import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.ASMInstruction;

class LdcInstruction
extends ASMInstruction {
    private static final int[] ICONST_OPCODES = new int[]{2, 3, 4, 5, 6, 7, 8};

    LdcInstruction(Object cst) {
        super(0, cst);
    }

    @Override
    public void visit(MethodTransformer mt) {
        boolean visited = false;
        if (this.args[0] instanceof Number) {
            int constVal = ((Number)this.args[0]).intValue();
            if (constVal >= -1 && constVal <= 5) {
                mt.injectInsn(ICONST_OPCODES[constVal + 1]);
                visited = true;
            } else if (constVal >= -128 && constVal <= 127) {
                mt.injectIntInsn(16, constVal);
                visited = true;
            } else if (constVal >= Short.MIN_VALUE && constVal <= Short.MAX_VALUE) {
                mt.injectIntInsn(17, constVal);
                visited = true;
            }
        }
        if (!visited) {
            mt.injectLdcInsn(this.args[0]);
        }
    }

    @Override
    public ASMInstruction clone() {
        return new LdcInstruction(this.args[0]);
    }
}

