/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.inline;

import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.ASMInstruction;

class RestoreReturnValueInstruction
extends ASMInstruction {
    RestoreReturnValueInstruction() {
    }

    @Override
    public void visit(MethodTransformer mt) {
        if (this.interceptorTransformer != null) {
            int opcode = this.interceptorTransformer.getReturnInstructionOpCode();
            if (opcode == 191 && this.interceptorTransformer.isThrowableObjectAvailable()) {
                mt.injectVarInsn(25, this.interceptorTransformer.getThrownObjectVar());
            } else if (opcode == 176 && this.interceptorTransformer.isReturnObjectIsAvailable()) {
                mt.injectVarInsn(25, this.interceptorTransformer.getReturnedObjectVar());
            } else if (opcode != 177) {
                int locVar;
                int n = locVar = opcode == 191 ? this.interceptorTransformer.getSaveThrowableVarNumber() : this.interceptorTransformer.getSaveReturnValueVarNumber();
                if (locVar >= 0) {
                    switch (opcode) {
                        case 176: 
                        case 191: {
                            mt.injectVarInsn(25, locVar);
                            break;
                        }
                        case 172: {
                            mt.injectVarInsn(21, locVar);
                            break;
                        }
                        case 173: {
                            mt.injectVarInsn(22, locVar);
                            break;
                        }
                        case 174: {
                            mt.injectVarInsn(23, locVar);
                            break;
                        }
                        case 175: {
                            mt.injectVarInsn(24, locVar);
                        }
                    }
                }
            }
        }
    }

    @Override
    public ASMInstruction clone() {
        return new RestoreReturnValueInstruction();
    }
}

