/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.inline;

import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.ASMInstruction;

class SaveReturnValueInstruction
extends ASMInstruction {
    protected static final Type objectType = Type.getType(Object.class);
    protected static final Type throwableType = Type.getType(Throwable.class);
    protected static final Type intType = Type.getType(Integer.TYPE);
    protected static final Type longType = Type.LONG_TYPE;
    protected static final Type floatType = Type.FLOAT_TYPE;
    protected static final Type doubleType = Type.DOUBLE_TYPE;

    SaveReturnValueInstruction() {
    }

    @Override
    public void visit(MethodTransformer mt) {
        if (this.interceptorTransformer != null) {
            Type returnValueType = null;
            int opcode = this.interceptorTransformer.getReturnInstructionOpCode();
            if (opcode == 191 && this.interceptorTransformer.isThrowableObjectAvailable()) {
                return;
            }
            if (opcode == 176 && this.interceptorTransformer.isReturnObjectIsAvailable()) {
                return;
            }
            switch (opcode) {
                case 191: {
                    returnValueType = throwableType;
                    break;
                }
                case 176: {
                    returnValueType = objectType;
                    break;
                }
                case 172: {
                    returnValueType = intType;
                    break;
                }
                case 173: {
                    returnValueType = longType;
                    break;
                }
                case 174: {
                    returnValueType = floatType;
                    break;
                }
                case 175: {
                    returnValueType = doubleType;
                }
            }
            if (returnValueType != null) {
                int locVar;
                int n = locVar = opcode == 191 ? this.interceptorTransformer.getSaveThrowableVarNumber() : this.interceptorTransformer.getSaveReturnValueVarNumber(returnValueType);
                if (opcode == 173 || opcode == 175) {
                    mt.injectInsn(92);
                } else {
                    mt.injectInsn(89);
                }
                switch (opcode) {
                    case 176: 
                    case 191: {
                        mt.injectVarInsn(58, locVar);
                        break;
                    }
                    case 172: {
                        mt.injectVarInsn(54, locVar);
                        break;
                    }
                    case 173: {
                        mt.injectVarInsn(55, locVar);
                        break;
                    }
                    case 174: {
                        mt.injectVarInsn(56, locVar);
                        break;
                    }
                    case 175: {
                        mt.injectVarInsn(57, locVar);
                    }
                }
            }
        }
    }

    @Override
    public ASMInstruction clone() {
        return new SaveReturnValueInstruction();
    }
}

