/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template;

import com.singularity.asm.org.objectweb.asm.ClassReader;
import com.singularity.asm.org.objectweb.asm.ClassVisitor;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.ClassNode;
import com.singularity.ee.agent.appagent.AgentEntryPoint;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.IInlineInterceptor;
import com.singularity.ee.agent.appagent.entrypoint.bciengine.InlineInterceptorDelegator;
import com.singularity.ee.agent.appagent.services.bciengine.AInlineTrackedMethodInterceptor;
import com.singularity.ee.agent.appagent.services.bciengine.TransformationInfo;
import com.singularity.ee.agent.appagent.services.bciengine.asm.IInlineStateVar;
import com.singularity.ee.agent.appagent.services.bciengine.asm.MethodTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.AInlineInterceptorTransformer;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.ASMInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.ASMTryCatchBlock;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.InstructionList;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.IInlineInterceptorTransformerFromTemplate;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateClass;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateClassCache;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateMethod;
import com.singularity.ee.agent.appagent.services.bciengine.inline.template.InlineTemplateManager;
import com.singularity.ee.agent.appagent.services.bciengine.log.BCTLoggerUtil;
import com.singularity.ee.agent.util.JarFileUtilities;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class InlineInterceptorTransformerFromTemplate
extends AInlineInterceptorTransformer
implements IInlineInterceptorTransformerFromTemplate {
    private static final String INLINE_INTERCEPTOR_DELEGATOR_INTERNAL_CLASSNAME = InlineInterceptorDelegator.class.getName().replace('.', '/');
    private static final String SAFE_ON_METHOD_BEGIN_METHOD_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE, Type.getType(Object.class), Type.getType(String.class), Type.getType(String.class), Type.getType(Object[].class), Type.getType(Object.class)});
    private static final String SAFE_ON_METHOD_END_METHOD_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE, Type.getType(Object.class), Type.getType(String.class), Type.getType(String.class), Type.getType(Object[].class), Type.getType(Throwable.class), Type.getType(Object.class), Type.getType(Object.class)});
    private final String templateClassName;
    private TemplateClass templateClass;
    protected boolean isInline;
    private IInlineInterceptor nonInlineInterceptor;
    private ClassLoader templateClassLoader;
    private final InlineTemplateManager inlineTemplateManager;

    protected InlineInterceptorTransformerFromTemplate(String className, AInlineTrackedMethodInterceptor inlineTrackedMethodInterceptor, InlineTemplateManager inlineTemplateManager) {
        this(className, inlineTrackedMethodInterceptor, null, inlineTemplateManager);
    }

    protected InlineInterceptorTransformerFromTemplate(String className, AInlineTrackedMethodInterceptor inlineTrackedMethodInterceptor, ClassLoader templateClassLoader, InlineTemplateManager inlineTemplateManager) {
        super(inlineTrackedMethodInterceptor);
        this.templateClassName = className;
        this.templateClassLoader = templateClassLoader;
        this.inlineTemplateManager = inlineTemplateManager;
    }

    @Override
    public void init(String className, String methodName, String methodDescriptor, int access, MethodTransformer methodTransformer, TransformationInfo tranformationInfo) {
        super.init(className, methodName, methodDescriptor, access, methodTransformer, tranformationInfo);
        if (this.shouldInline(tranformationInfo)) {
            this.setTemplateClass();
            this.isInline = true;
        } else {
            this.setupNonInlineInterceptor();
            this.isInline = false;
        }
    }

    protected boolean shouldInline(TransformationInfo tranformationInfo) {
        return this.inlineTemplateManager.recordAndCheckShouldInline(this.className);
    }

    private void setTemplateClass() {
        TemplateClass dupTemplateClass;
        ClassNode cn;
        TemplateClassCache cache = TemplateClassCache.getInstance();
        TemplateClass templateClass = cache.getTemplateClass(this.templateClassName);
        if (templateClass == null && (cn = this.getClassNode()) != null && (dupTemplateClass = (TemplateClass)cache.putIfAbsent(templateClass = new TemplateClass(cn), templateClass)) != null) {
            templateClass = dupTemplateClass;
        }
        if (templateClass != null) {
            this.templateClass = templateClass.clone();
        }
    }

    private void setupNonInlineInterceptor() {
        this.nonInlineInterceptor = this.inlineTemplateManager.getInterceptor(this.templateClassName, this.templateClassLoader != null ? this.templateClassLoader : this.getClass().getClassLoader());
        if (this.interceptor != null) {
            InlineInterceptorDelegator.registerInterceptor((int)this.ti.getTransformationId(), (IInlineInterceptor)this.nonInlineInterceptor);
        }
    }

    private ClassNode getClassNode() {
        ClassNode cn = null;
        try {
            ClassLoader myClassLoader = this.getClass().getClassLoader();
            String resourceName = this.templateClassName.replace('.', '/') + ".class";
            InputStream is = myClassLoader != null ? myClassLoader.getResourceAsStream(resourceName) : InlineInterceptorTransformerFromTemplate.getResourceFromBootstrapClassLoader(resourceName);
            ClassReader cr = new ClassReader(is);
            cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 4);
        }
        catch (Throwable t) {
            BCTLoggerUtil.printStackTrace(t);
            cn = null;
        }
        return cn;
    }

    private static InputStream getResourceFromBootstrapClassLoader(String resourceName) {
        InputStream returnInputStream = null;
        List urlList = AgentEntryPoint.getLibrariesAddedToBootClassPath();
        if (urlList != null) {
            returnInputStream = JarFileUtilities.getInputStreamFromURLCollection(resourceName, urlList, null);
        }
        return returnInputStream;
    }

    @Override
    protected InstructionList getMethodEntryInstructions() {
        if (this.isInline) {
            if (this.templateClass != null) {
                return this.templateClass.getMethodEntryInstructions(this);
            }
            return null;
        }
        if (this.interceptor != null) {
            return this.generateNonInlineMethodEntryInstructions();
        }
        return null;
    }

    @Override
    protected InstructionList getMethodExitInstructions(int opcode) {
        if (this.isInline) {
            if (this.templateClass != null) {
                return this.templateClass.getMethodExitInstructions(this, opcode);
            }
            return null;
        }
        if (this.interceptor != null) {
            return this.generateNonInlineMethodExitInstructions(opcode);
        }
        return null;
    }

    @Override
    public IInlineStateVar[] getLocalVarsToInitialize() {
        if (this.isInline && this.templateClass != null) {
            return this.templateClass.getLocalVarsToInitialize(this);
        }
        return new IInlineStateVar[0];
    }

    @Override
    public void localVariablesDefined(int[] locVarIndexes) {
        if (this.isInline && this.templateClass != null) {
            this.templateClass.localVariablesDefined(locVarIndexes);
        }
    }

    @Override
    public void defineTryCatchBlocks() {
        ASMTryCatchBlock[] tryCatchBlocks;
        if (this.isInline && this.templateClass != null && (tryCatchBlocks = this.templateClass.getTryCatchBlocks(this)) != null) {
            for (ASMTryCatchBlock nextTryCatch : tryCatchBlocks) {
                nextTryCatch.visit(this.mt);
            }
        }
    }

    @Override
    public void defineFinallyTryCatchBlocks() {
        ASMTryCatchBlock[] tryCatchBlocks;
        if (this.isInline && this.templateClass != null && (tryCatchBlocks = this.templateClass.getFinallyTryCatchBlocks(this)) != null) {
            for (ASMTryCatchBlock nextTryCatch : tryCatchBlocks) {
                nextTryCatch.visit(this.mt);
            }
        }
    }

    @Override
    public boolean isParamArrayRequired() {
        return false;
    }

    @Override
    public boolean isThrownExceptionRequired() {
        return true;
    }

    @Override
    public boolean isReturnedObjectRequired() {
        return true;
    }

    @Override
    public Object getArgumentValue(int argNum, String argName, TemplateMethod.MethodType methodType, Type argType) {
        return null;
    }

    private InstructionList generateNonInlineMethodEntryInstructions() {
        ArrayList<ASMInstruction> listOfInstructions = new ArrayList<ASMInstruction>();
        listOfInstructions.add(ASMInstruction.generateLdcInsn(this.ti.getFastInterceptorId()));
        listOfInstructions.add(ASMInstruction.generateLdcInsn(this.ti.getTransformationId()));
        if ((this.access & 8) > 0) {
            listOfInstructions.add(ASMInstruction.generateSimpleInsn(1));
        } else {
            listOfInstructions.add(ASMInstruction.generateVarInsn(25, 0));
        }
        listOfInstructions.add(ASMInstruction.generateLdcInsn(this.className));
        listOfInstructions.add(ASMInstruction.generateLdcInsn(this.methodName));
        if (this.isParamArrayRequired()) {
            listOfInstructions.add(ASMInstruction.generateVarInsn(25, this.mt.getParmsArrayLocVar()));
        } else {
            listOfInstructions.add(ASMInstruction.generateSimpleInsn(1));
        }
        this.generateAdditionalArgumentInstructions(listOfInstructions);
        listOfInstructions.add(ASMInstruction.generateMethodInsn(184, INLINE_INTERCEPTOR_DELEGATOR_INTERNAL_CLASSNAME, "safeOnMethodBegin", SAFE_ON_METHOD_BEGIN_METHOD_DESC));
        ASMInstruction[] instArray = listOfInstructions.toArray(new ASMInstruction[listOfInstructions.size()]);
        return new InstructionList(instArray, null, this);
    }

    private InstructionList generateNonInlineMethodExitInstructions(int opcode) {
        ArrayList<ASMInstruction> listOfInstructions = new ArrayList<ASMInstruction>();
        listOfInstructions.add(ASMInstruction.generateLdcInsn(this.ti.getFastInterceptorId()));
        listOfInstructions.add(ASMInstruction.generateLdcInsn(this.ti.getTransformationId()));
        if ((this.access & 8) > 0) {
            listOfInstructions.add(ASMInstruction.generateSimpleInsn(1));
        } else {
            listOfInstructions.add(ASMInstruction.generateVarInsn(25, 0));
        }
        listOfInstructions.add(ASMInstruction.generateLdcInsn(this.className));
        listOfInstructions.add(ASMInstruction.generateLdcInsn(this.methodName));
        if (this.isParamArrayRequired()) {
            listOfInstructions.add(ASMInstruction.generateVarInsn(25, this.mt.getParmsArrayLocVar()));
        } else {
            listOfInstructions.add(ASMInstruction.generateSimpleInsn(1));
        }
        if (opcode == 191 && this.isThrownExceptionRequired()) {
            listOfInstructions.add(ASMInstruction.generateVarInsn(25, this.getThrownObjectVar()));
        } else {
            listOfInstructions.add(ASMInstruction.generateSimpleInsn(1));
        }
        if (opcode != 191 && this.isReturnedObjectRequired()) {
            listOfInstructions.add(ASMInstruction.generateVarInsn(25, this.getReturnedObjectVar()));
        } else {
            listOfInstructions.add(ASMInstruction.generateSimpleInsn(1));
        }
        this.generateAdditionalArgumentInstructions(listOfInstructions);
        listOfInstructions.add(ASMInstruction.generateMethodInsn(184, INLINE_INTERCEPTOR_DELEGATOR_INTERNAL_CLASSNAME, "safeOnMethodEnd", SAFE_ON_METHOD_END_METHOD_DESC));
        ASMInstruction[] instArray = listOfInstructions.toArray(new ASMInstruction[listOfInstructions.size()]);
        return new InstructionList(instArray, null, this);
    }

    protected void generateAdditionalArgumentInstructions(List<ASMInstruction> listOfInstructions) {
        listOfInstructions.add(ASMInstruction.generateSimpleInsn(1));
    }

    @Override
    public boolean needsToSaveMethodReturnValue() {
        return true;
    }

    @Override
    public boolean needToPreInitializeGlobalLocal(String varName) {
        return true;
    }

    @Override
    public boolean shouldInjectTryCatch() {
        return this.templateClass != null ? this.templateClass.shouldInjectTryCatch() : false;
    }
}

