/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template;

import com.singularity.asm.org.objectweb.asm.Label;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.AnnotationNode;
import com.singularity.asm.org.objectweb.asm.tree.ClassNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.ee.agent.appagent.services.bciengine.asm.IInlineStateVar;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.ASMInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.ASMTryCatchBlock;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.InstructionList;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.GlobalLocalVariable;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.IInlineInterceptorTransformerFromTemplate;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateMethod;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateMethodDef;
import com.singularity.ee.agent.appagent.services.bciengine.inline.SymbolTable;
import com.singularity.ee.util.string.StringOperations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TemplateClass {
    private static final String METHOD_TYPE_NAME = TemplateMethod.MethodType.class.getName();
    private static final String TEMPLATE_NAME = TemplateMethodDef.class.getName();
    private static final SymbolTable EMPTY_SYMBOL_TABLE = new SymbolTable();
    static final String ORIGINAL_ARGUMENTS_VAR_NAME = "originalArgs";
    static final String THIS_VAR_NAME = "this";
    static final String RETURN_VALUE_VAR_NAME = "returnValue";
    static final String THROWN_OBJECT_VAR_NAME = "thrownObject";
    static final String ORIGINAL_SPECIFIC_ARGUMENT_VAR_NAME_PATTERN = "arg[0-9]";
    static final String RETURN_VALUE_PRIMITIVE_NAME = "returnValuePrimitive";
    private static final String[] VAR_NAMES_TO_IGNORE = new String[]{"originalArgs", "this", "returnValue", "thrownObject", "arg[0-9]", "returnValuePrimitive"};
    private ClassNode cn;
    private final String className;
    private TemplateMethod[] templateMethods;
    private Map<String, GlobalLocalVariable> mapOfGlobalLocals;
    private int hashValue;
    private TemplateClass copiedFromTemplateClass;
    private List<ASMTryCatchBlock> listOfNormalTryCatches;
    private List<ASMTryCatchBlock> listOfFinallyTryCatches;
    private Set<Integer> tempLocVarPool;
    private IInlineInterceptorTransformerFromTemplate interceptorTransformer;

    TemplateClass(String className) {
        this.className = className;
        this.setHashCode();
    }

    TemplateClass(ClassNode cn) {
        this.cn = cn;
        this.className = cn.name.replace('/', '.');
        this.setHashCode();
        this.createTemplateMethods();
        this.createGlobalLocals();
    }

    private void setHashCode() {
        this.hashValue = this.className.hashCode();
    }

    private TemplateClass(TemplateClass copyFrom) {
        this.copiedFromTemplateClass = copyFrom;
        this.cn = copyFrom.cn;
        this.className = copyFrom.className;
        this.hashValue = copyFrom.hashValue;
        this.copyFieldsFrom(copyFrom);
    }

    public int hashCode() {
        return this.hashValue;
    }

    public boolean equals(Object o) {
        boolean bReturn;
        boolean bl = bReturn = this == o;
        if (!bReturn && o instanceof TemplateClass) {
            TemplateClass other = (TemplateClass)o;
            bReturn = this.hashValue == other.hashValue && this.className.equals(other.className);
        }
        return bReturn;
    }

    private void createTemplateMethods() {
        this.templateMethods = new TemplateMethod[TemplateMethod.MethodType.values().length];
        Iterator methodIter = this.cn.methods.iterator();
        int numTypesFound = 0;
        while (methodIter.hasNext()) {
            MethodNode mn = (MethodNode)methodIter.next();
            if (mn.visibleAnnotations == null || mn.visibleAnnotations.size() <= 0) continue;
            for (TemplateMethod.MethodType nextType : TemplateMethod.MethodType.values()) {
                if (!this.isMethodType(mn, nextType) || this.templateMethods[nextType.ordinal()] != null) continue;
                this.templateMethods[nextType.ordinal()] = new TemplateMethod(mn, nextType, this);
                if (++numTypesFound >= this.templateMethods.length) break;
            }
            if (numTypesFound < this.templateMethods.length) continue;
            break;
        }
    }

    private boolean isMethodType(MethodNode mn, TemplateMethod.MethodType testType) {
        boolean bReturn = false;
        List listOfAnnotations = mn.visibleAnnotations;
        if (listOfAnnotations != null) {
            for (AnnotationNode nextAnnotation : listOfAnnotations) {
                Type annotationType = Type.getType((String)nextAnnotation.desc);
                if (!annotationType.getClassName().equals(TEMPLATE_NAME)) continue;
                List listOfValuePairs = nextAnnotation.values;
                Iterator iter = listOfValuePairs.iterator();
                while (iter.hasNext()) {
                    Type valueType;
                    String[] nextValuePair;
                    Object value;
                    if (!iter.hasNext() || !((value = iter.next()) instanceof List)) continue;
                    List typeValues = (List)value;
                    Iterator iterator = typeValues.iterator();
                    while (iterator.hasNext() && ((nextValuePair = (String[])iterator.next()).length < 2 || StringOperations.isEmpty((String)nextValuePair[0]) || StringOperations.isEmpty((String)nextValuePair[1]) || !(valueType = Type.getType((String)nextValuePair[0])).getClassName().equals(METHOD_TYPE_NAME) || !(bReturn = nextValuePair[1].equals(testType.name())))) {
                    }
                    break;
                }
                if (!bReturn) continue;
                break;
            }
        }
        return bReturn;
    }

    private void createGlobalLocals() {
        this.mapOfGlobalLocals = new HashMap<String, GlobalLocalVariable>();
        for (MethodNode nextMethod : this.cn.methods) {
            String nextVarToIgnore;
            if ((nextMethod.access & 8) <= 0 || !nextMethod.name.startsWith("get")) continue;
            String varName = TemplateClass.getVarNameFromGetterSetterMethod(nextMethod.name);
            boolean ignoreVarName = false;
            String[] stringArray = VAR_NAMES_TO_IGNORE;
            int n = stringArray.length;
            for (int i = 0; i < n && !(ignoreVarName = varName.matches(nextVarToIgnore = stringArray[i])); ++i) {
            }
            if (ignoreVarName) continue;
            Type varType = Type.getReturnType((String)nextMethod.desc);
            GlobalLocalVariable var = new GlobalLocalVariable(varName, varType);
            this.mapOfGlobalLocals.put(varName, var);
        }
    }

    static String getVarNameFromGetterSetterMethod(String methodName) {
        String returnString = methodName.substring(3);
        returnString = returnString.substring(0, 1).toLowerCase() + returnString.substring(1);
        return returnString;
    }

    public TemplateClass clone() {
        return new TemplateClass(this);
    }

    private void copyFieldsFrom(TemplateClass copyFrom) {
        this.mapOfGlobalLocals = new HashMap<String, GlobalLocalVariable>();
        for (Map.Entry<String, GlobalLocalVariable> nextVarMapEntry : copyFrom.mapOfGlobalLocals.entrySet()) {
            String nextVarName = nextVarMapEntry.getKey();
            GlobalLocalVariable copyVar = nextVarMapEntry.getValue().clone();
            this.mapOfGlobalLocals.put(nextVarName, copyVar);
        }
    }

    private void copyMethodsFrom(TemplateClass copyFrom) {
        this.templateMethods = new TemplateMethod[TemplateMethod.MethodType.values().length];
        for (int i = 0; i < this.templateMethods.length; ++i) {
            if (copyFrom.templateMethods[i] == null) continue;
            this.templateMethods[i] = copyFrom.templateMethods[i].clone();
            this.templateMethods[i].setTemplateClass(this);
        }
    }

    IInlineStateVar[] getLocalVarsToInitialize(final IInlineInterceptorTransformerFromTemplate transformer) {
        IInlineStateVar[] returnTypes = new IInlineStateVar[this.mapOfGlobalLocals.size()];
        int idx = 0;
        for (GlobalLocalVariable nextVar : this.mapOfGlobalLocals.values()) {
            nextVar.setSequence(idx);
            final Type type = nextVar.getType();
            final String varName = nextVar.getVarName();
            returnTypes[idx++] = new IInlineStateVar(){

                @Override
                public Type getType() {
                    return type;
                }

                @Override
                public boolean initializationRequired() {
                    return transformer.needToPreInitializeGlobalLocal(varName);
                }
            };
        }
        return returnTypes;
    }

    void localVariablesDefined(int[] locVarIndexes) {
        for (GlobalLocalVariable nextVar : this.mapOfGlobalLocals.values()) {
            nextVar.setAssignedLocVarNumber(locVarIndexes[nextVar.getSequence()]);
        }
    }

    InstructionList getMethodEntryInstructions(IInlineInterceptorTransformerFromTemplate inlineInterceptorTransformer) {
        ASMInstruction[] instructions;
        this.tempLocVarPool = new HashSet<Integer>();
        this.interceptorTransformer = inlineInterceptorTransformer;
        InstructionList il = null;
        this.copyMethodsFrom(this.copiedFromTemplateClass);
        TemplateMethod templateMethod = this.templateMethods[TemplateMethod.MethodType.methodEntry.ordinal()];
        if (templateMethod != null && (instructions = templateMethod.getInstructions(inlineInterceptorTransformer)) != null) {
            il = new InstructionList(instructions, EMPTY_SYMBOL_TABLE, inlineInterceptorTransformer);
        }
        return il;
    }

    InstructionList getMethodExitInstructions(IInlineInterceptorTransformerFromTemplate inlineInterceptorTransformer, int opcode) {
        ASMInstruction[] instructions;
        InstructionList il = null;
        this.copyMethodsFrom(this.copiedFromTemplateClass);
        int methodIndex = opcode == 191 ? TemplateMethod.MethodType.exceptionMethodExit.ordinal() : TemplateMethod.MethodType.normalMethodExit.ordinal();
        TemplateMethod templateMethod = this.templateMethods[methodIndex];
        if (templateMethod != null && (instructions = templateMethod.getInstructions(inlineInterceptorTransformer, opcode)) != null) {
            il = new InstructionList(instructions, EMPTY_SYMBOL_TABLE, inlineInterceptorTransformer);
        }
        return il;
    }

    void defineNormalTryCatch(Label start, Label end, Label handler, String type) {
        if (this.listOfNormalTryCatches == null) {
            this.listOfNormalTryCatches = new ArrayList<ASMTryCatchBlock>();
        }
        this.listOfNormalTryCatches.add(new ASMTryCatchBlock(start, end, handler, type));
    }

    void defineFinallyTryCatch(Label start, Label end, Label handler, String type) {
        if (this.listOfFinallyTryCatches == null) {
            this.listOfFinallyTryCatches = new ArrayList<ASMTryCatchBlock>();
        }
        this.listOfFinallyTryCatches.add(new ASMTryCatchBlock(start, end, handler, type));
    }

    ASMTryCatchBlock[] getTryCatchBlocks(IInlineInterceptorTransformerFromTemplate inlineInterceptorTransformer) {
        ASMTryCatchBlock[] returnArray = null;
        if (this.listOfNormalTryCatches != null) {
            returnArray = this.listOfNormalTryCatches.toArray(new ASMTryCatchBlock[this.listOfNormalTryCatches.size()]);
        }
        return returnArray;
    }

    ASMTryCatchBlock[] getFinallyTryCatchBlocks(IInlineInterceptorTransformerFromTemplate inlineInterceptorTransformer) {
        ASMTryCatchBlock[] returnArray = null;
        if (this.listOfFinallyTryCatches != null) {
            returnArray = this.listOfFinallyTryCatches.toArray(new ASMTryCatchBlock[this.listOfFinallyTryCatches.size()]);
        }
        return returnArray;
    }

    String getClassName() {
        return this.className;
    }

    GlobalLocalVariable getGlobalLocal(String name) {
        return this.mapOfGlobalLocals.get(name);
    }

    int getTempLocVar(Type type) {
        int iReturnValue = -1;
        for (Integer nextLocVar : this.tempLocVarPool) {
            if (type.getSize() == 2) {
                Integer secondLocVar = nextLocVar + 1;
                if (!this.tempLocVarPool.contains(secondLocVar)) continue;
                iReturnValue = nextLocVar;
                this.tempLocVarPool.remove(nextLocVar);
                this.tempLocVarPool.remove(secondLocVar);
                break;
            }
            iReturnValue = nextLocVar;
            this.tempLocVarPool.remove(nextLocVar);
            break;
        }
        if (iReturnValue == -1) {
            iReturnValue = this.interceptorTransformer.getMethodTransformer().newLocal(type);
        }
        return iReturnValue;
    }

    void returnLocVarToPool(int locVarNum, Type type) {
        this.tempLocVarPool.add(locVarNum);
        if (type.getSize() == 2) {
            this.tempLocVarPool.add(locVarNum + 1);
        }
    }

    public boolean shouldInjectTryCatch() {
        boolean bReturn = false;
        if (this.templateMethods != null) {
            TemplateMethod method;
            TemplateMethod[] templateMethodArray = this.templateMethods;
            int n = templateMethodArray.length;
            for (int i = 0; !(i >= n || (method = templateMethodArray[i]) != null && (bReturn = method.shouldInjectTryCatch())); ++i) {
            }
        }
        return bReturn;
    }
}

