/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template;

import com.singularity.asm.org.objectweb.asm.Label;
import com.singularity.asm.org.objectweb.asm.Type;
import com.singularity.asm.org.objectweb.asm.tree.AbstractInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.FieldInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.IincInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.InsnNode;
import com.singularity.asm.org.objectweb.asm.tree.IntInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.JumpInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.LabelNode;
import com.singularity.asm.org.objectweb.asm.tree.LdcInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.LocalVariableNode;
import com.singularity.asm.org.objectweb.asm.tree.LookupSwitchInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.MethodNode;
import com.singularity.asm.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.TableSwitchInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.TryCatchBlockNode;
import com.singularity.asm.org.objectweb.asm.tree.TypeInsnNode;
import com.singularity.asm.org.objectweb.asm.tree.VarInsnNode;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.ASMInstruction;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.GlobalLocalVariable;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.IInlineInterceptorTransformerFromTemplate;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.LabelPlaceHolder;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.LocalLocalVariable;
import com.singularity.ee.agent.appagent.services.bciengine.asm.inline.template.TemplateClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TemplateMethod
implements Cloneable {
    private static final Type OBJ_TYPE = Type.getType(Object.class);
    private final MethodType methodType;
    private TemplateClass templateClass;
    private Map<Integer, LocalLocalVariable> mapOfLocalVars;
    private Map<Label, LabelPlaceHolder> mapOfLabels;
    private final MethodNode mn;
    private int instructionIdx;
    private IInlineInterceptorTransformerFromTemplate inlineInterceptorTransformer;
    private Type[] methodArgs;
    private Set<Label> exceptionHandlerLabels;

    TemplateMethod(MethodNode mn, MethodType methodType, TemplateClass templateClass) {
        this.templateClass = templateClass;
        this.mn = mn;
        this.methodType = methodType;
        this.setMethodArgs();
    }

    private TemplateMethod(TemplateMethod copyFrom) {
        this.mn = copyFrom.mn;
        this.methodType = copyFrom.methodType;
        this.methodArgs = copyFrom.methodArgs;
    }

    public TemplateMethod clone() {
        return new TemplateMethod(this);
    }

    private void setMethodArgs() {
        this.methodArgs = Type.getArgumentTypes((String)this.mn.desc);
    }

    void setTemplateClass(TemplateClass templateClass) {
        this.templateClass = templateClass;
    }

    ASMInstruction[] getInstructions(IInlineInterceptorTransformerFromTemplate inlineInterceptorTransformer) {
        return this.getInstructions(inlineInterceptorTransformer, 0);
    }

    ASMInstruction[] getInstructions(IInlineInterceptorTransformerFromTemplate inlineInterceptorTransformer, int exitOpCode) {
        ASMInstruction[] returnObject = null;
        this.mapOfLocalVars = new HashMap<Integer, LocalLocalVariable>();
        this.mapOfLabels = new HashMap<Label, LabelPlaceHolder>();
        this.inlineInterceptorTransformer = inlineInterceptorTransformer;
        this.createTryCatchBlocks();
        List<ASMInstruction> asmInstructionList = this.getListOfInstructions(inlineInterceptorTransformer);
        if (asmInstructionList != null) {
            returnObject = asmInstructionList.toArray(new ASMInstruction[asmInstructionList.size()]);
        }
        this.returnTempLocVars();
        return returnObject;
    }

    private List<ASMInstruction> getListOfInstructions(IInlineInterceptorTransformerFromTemplate transformer) {
        ArrayList<ASMInstruction> returnList = new ArrayList<ASMInstruction>();
        if ((this.methodType == MethodType.normalMethodExit || this.methodType == MethodType.exceptionMethodExit) && transformer.needsToSaveMethodReturnValue()) {
            returnList.add(ASMInstruction.generateSaveReturnValueInstruction());
        }
        this.instructionIdx = 0;
        while (this.instructionIdx < this.mn.instructions.size()) {
            AbstractInsnNode nextInsn = this.mn.instructions.get(this.instructionIdx);
            switch (nextInsn.getType()) {
                case 8: {
                    this.generateLabel((LabelNode)nextInsn, returnList);
                    break;
                }
                case 4: {
                    this.generateFieldInsn((FieldInsnNode)nextInsn, returnList);
                    break;
                }
                case 10: {
                    this.generateIincInsn((IincInsnNode)nextInsn, returnList);
                    break;
                }
                case 1: {
                    this.generateIntInsn((IntInsnNode)nextInsn, returnList);
                    break;
                }
                case 7: {
                    this.generateJumpInsn((JumpInsnNode)nextInsn, returnList);
                    break;
                }
                case 9: {
                    this.generateLdcInsn((LdcInsnNode)nextInsn, returnList);
                    break;
                }
                case 12: {
                    this.generateLookupSwitchInsn((LookupSwitchInsnNode)nextInsn, returnList);
                    break;
                }
                case 5: {
                    this.generateMethodInsn((MethodInsnNode)nextInsn, returnList, transformer);
                    break;
                }
                case 13: {
                    this.generateMultiANewArrayInsn((MultiANewArrayInsnNode)nextInsn, returnList);
                    break;
                }
                case 0: {
                    this.generateSimpleInsn((InsnNode)nextInsn, returnList);
                    break;
                }
                case 11: {
                    this.generateTableSwitchInsn((TableSwitchInsnNode)nextInsn, returnList);
                    break;
                }
                case 3: {
                    this.generateTypeInsn((TypeInsnNode)nextInsn, returnList);
                    break;
                }
                case 2: {
                    this.generateVarInsn((VarInsnNode)nextInsn, returnList);
                }
            }
            ++this.instructionIdx;
        }
        return returnList;
    }

    private void createTryCatchBlocks() {
        this.exceptionHandlerLabels = new HashSet<Label>();
        List tryCatchList = this.mn.tryCatchBlocks;
        for (TryCatchBlockNode nextTryCatch : tryCatchList) {
            Label start = this.getAssignedLabel(nextTryCatch.start);
            Label end = this.getAssignedLabel(nextTryCatch.end);
            Label handler = this.getAssignedLabel(nextTryCatch.handler);
            if (this.methodType != MethodType.exceptionMethodExit) {
                this.templateClass.defineNormalTryCatch(start, end, handler, nextTryCatch.type);
            } else {
                this.templateClass.defineFinallyTryCatch(start, end, handler, nextTryCatch.type);
            }
            this.exceptionHandlerLabels.add(handler);
        }
    }

    private AbstractInsnNode lookahead(int num) {
        if (this.instructionIdx + num < this.mn.instructions.size()) {
            return this.mn.instructions.get(this.instructionIdx + num);
        }
        return null;
    }

    private void skipNext() {
        this.skip(1);
    }

    private void skip(int instIndex) {
        this.instructionIdx += instIndex;
    }

    private void generateLabel(LabelNode ln, List<ASMInstruction> asmInstructionList) {
        AbstractInsnNode nextInst;
        Label newLabel = this.getAssignedLabel(ln);
        asmInstructionList.add(ASMInstruction.generateLabel(newLabel));
        if ((this.methodType == MethodType.normalMethodExit || this.methodType == MethodType.exceptionMethodExit) && this.exceptionHandlerLabels.contains(newLabel) && (nextInst = this.lookahead(1)).getOpcode() == 58) {
            this.skipNext();
            this.generateVarInsn((VarInsnNode)nextInst, asmInstructionList);
            asmInstructionList.add(ASMInstruction.generateRestoreReturnValueInstruction());
        }
    }

    private void generateFieldInsn(FieldInsnNode fin, List<ASMInstruction> asmInstructionList) {
        asmInstructionList.add(ASMInstruction.generateFieldInsn(fin.getOpcode(), fin.owner, fin.name, fin.desc));
    }

    private void generateIincInsn(IincInsnNode iin, List<ASMInstruction> asmInstructionList) {
        asmInstructionList.add(ASMInstruction.generateIincInsn(iin.var, iin.incr));
    }

    private void generateIntInsn(IntInsnNode iin, List<ASMInstruction> asmInstructionList) {
        asmInstructionList.add(ASMInstruction.generateIntInsn(iin.getOpcode(), iin.operand));
    }

    private void generateJumpInsn(JumpInsnNode jin, List<ASMInstruction> asmInstructionList) {
        asmInstructionList.add(ASMInstruction.generateJumpInsn(jin.getOpcode(), this.getAssignedLabel(jin.label)));
    }

    private void generateLdcInsn(LdcInsnNode lin, List<ASMInstruction> asmInstructionList) {
        asmInstructionList.add(ASMInstruction.generateLdcInsn(lin.cst));
    }

    private void generateLookupSwitchInsn(LookupSwitchInsnNode lsin, List<ASMInstruction> asmInstructionList) {
        List listOfLabels = lsin.labels;
        int idx = 0;
        int[] keys = new int[lsin.keys.size()];
        List keyList = lsin.keys;
        for (Object nextKey : keyList) {
            keys[idx++] = (Integer)nextKey;
        }
        Object[] labels = new Object[listOfLabels.size()];
        idx = 0;
        for (LabelNode nextLabel : listOfLabels) {
            labels[idx++] = this.getAssignedLabel(nextLabel);
        }
        Label defaultLabel = this.getAssignedLabel(lsin.dflt);
        asmInstructionList.add(ASMInstruction.generateLookupSwitchInsn(defaultLabel, keys, labels));
    }

    private void generateMethodInsn(MethodInsnNode min, List<ASMInstruction> asmInstructionList, IInlineInterceptorTransformerFromTemplate transformer) {
        String owningClass;
        boolean instReplaced = false;
        if (min.getOpcode() == 184 && (owningClass = min.owner.replace('/', '.')).equals(this.templateClass.getClassName())) {
            instReplaced = this.generateSubstituteMethodInvocationInstructions(min, asmInstructionList, transformer);
        }
        if (!instReplaced) {
            asmInstructionList.add(ASMInstruction.generateMethodInsn(min.getOpcode(), min.owner, min.name, min.desc));
        }
    }

    private boolean generateSubstituteMethodInvocationInstructions(MethodInsnNode min, List<ASMInstruction> asmInstructionList, IInlineInterceptorTransformerFromTemplate transformer) {
        String varName;
        GlobalLocalVariable global;
        boolean bReturn = false;
        String methodName = min.name;
        if ((methodName.startsWith("get") || methodName.startsWith("set")) && !(bReturn = this.generateSubstituteMethodInvocationInstructionsForSpecial(min, asmInstructionList, transformer)) && (global = this.templateClass.getGlobalLocal(varName = TemplateClass.getVarNameFromGetterSetterMethod(methodName))) != null) {
            ASMInstruction inst;
            ASMInstruction aSMInstruction = inst = methodName.startsWith("get") ? this.getLoadInstructionForGlobal(global) : this.getStoreInstructionForGlobal(global);
            if (inst != null) {
                asmInstructionList.add(inst);
                bReturn = true;
            }
        }
        return bReturn;
    }

    private boolean generateSubstituteMethodInvocationInstructionsForSpecial(MethodInsnNode min, List<ASMInstruction> asmInstructionList, IInlineInterceptorTransformerFromTemplate transformer) {
        boolean bReturn = false;
        if (min.name.startsWith("get")) {
            String varName = TemplateClass.getVarNameFromGetterSetterMethod(min.name);
            Type calledMethodReturnType = Type.getReturnType((String)min.desc);
            if (varName.equalsIgnoreCase("originalArgs")) {
                if (calledMethodReturnType.getSort() == 9 && calledMethodReturnType.getElementType().getClassName().equals("java.lang.Object")) {
                    int parmArrayIndex = this.inlineInterceptorTransformer.getParmArrayIndex();
                    if (parmArrayIndex >= 0) {
                        asmInstructionList.add(ASMInstruction.generateVarInsn(25, parmArrayIndex));
                    } else {
                        asmInstructionList.add(ASMInstruction.generateSimpleInsn(1));
                    }
                    bReturn = true;
                }
            } else if (varName.equalsIgnoreCase("returnValue")) {
                if (calledMethodReturnType.getClassName().equals("java.lang.Object")) {
                    int returnValueIndex = this.inlineInterceptorTransformer.getReturnedObjectVar();
                    if (returnValueIndex >= 0) {
                        asmInstructionList.add(ASMInstruction.generateVarInsn(25, returnValueIndex));
                    } else {
                        asmInstructionList.add(ASMInstruction.generateSimpleInsn(1));
                    }
                    bReturn = true;
                }
            } else if (varName.equalsIgnoreCase("thrownObject")) {
                if (calledMethodReturnType.getClassName().equals("java.lang.Throwable")) {
                    int thrownValueIndex = this.inlineInterceptorTransformer.getThrownObjectVar();
                    if (thrownValueIndex >= 0) {
                        asmInstructionList.add(ASMInstruction.generateVarInsn(25, thrownValueIndex));
                    } else {
                        asmInstructionList.add(ASMInstruction.generateSimpleInsn(1));
                    }
                    bReturn = true;
                }
            } else if (varName.equalsIgnoreCase("this")) {
                if ((this.inlineInterceptorTransformer.getMethodAccessFlags() & 8) == 0) {
                    asmInstructionList.add(ASMInstruction.generateVarInsn(25, 0));
                } else {
                    asmInstructionList.add(ASMInstruction.generateSimpleInsn(1));
                }
                bReturn = true;
            } else if (varName.equalsIgnoreCase("returnValuePrimitive")) {
                if (!calledMethodReturnType.equals((Object)Type.VOID_TYPE) && this.methodType == MethodType.normalMethodExit) {
                    this.dupReturnValue(asmInstructionList, calledMethodReturnType);
                    bReturn = true;
                }
            } else if (varName.matches("arg[0-9]")) {
                int argNum = Integer.parseInt(varName.substring(3));
                Type[] methodArgTypes = transformer.getMethodArgumentTypes();
                int access = transformer.getMethodAccessFlags();
                if (methodArgTypes != null && argNum < methodArgTypes.length) {
                    int locVarNum = (access & 8) > 0 ? 0 : 1;
                    for (int i = 0; i < argNum; ++i) {
                        locVarNum += methodArgTypes[i].getSize();
                    }
                    this.pushSpecificArgValue(asmInstructionList, methodArgTypes[argNum], locVarNum);
                    bReturn = true;
                }
            }
        }
        return bReturn;
    }

    private void pushSpecificArgValue(List<ASMInstruction> asmInstructionList, Type typeToPush, int locVarNum) {
        int opCode;
        switch (typeToPush.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                opCode = 21;
                break;
            }
            case 8: {
                opCode = 24;
                break;
            }
            case 7: {
                opCode = 22;
                break;
            }
            default: {
                opCode = 25;
            }
        }
        asmInstructionList.add(ASMInstruction.generateVarInsn(opCode, locVarNum));
    }

    private void dupReturnValue(List<ASMInstruction> asmInstructionList, Type returnValueType) {
        int opCode;
        switch (returnValueType.getSort()) {
            case 7: 
            case 8: {
                opCode = 92;
                break;
            }
            default: {
                opCode = 89;
            }
        }
        asmInstructionList.add(ASMInstruction.generateSimpleInsn(opCode));
    }

    private ASMInstruction getLoadInstructionForGlobal(GlobalLocalVariable global) {
        int opcode;
        switch (global.getType().getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                opcode = 21;
                break;
            }
            case 7: {
                opcode = 22;
                break;
            }
            case 6: {
                opcode = 23;
                break;
            }
            case 8: {
                opcode = 24;
                break;
            }
            default: {
                opcode = 25;
            }
        }
        return ASMInstruction.generateVarInsn(opcode, global.getAssignedLocVarNumber());
    }

    private ASMInstruction getStoreInstructionForGlobal(GlobalLocalVariable global) {
        int opcode;
        switch (global.getType().getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                opcode = 54;
                break;
            }
            case 7: {
                opcode = 55;
                break;
            }
            case 6: {
                opcode = 56;
                break;
            }
            case 8: {
                opcode = 57;
                break;
            }
            default: {
                opcode = 58;
            }
        }
        return ASMInstruction.generateVarInsn(opcode, global.getAssignedLocVarNumber());
    }

    private void generateMultiANewArrayInsn(MultiANewArrayInsnNode manain, List<ASMInstruction> asmInstructionList) {
        asmInstructionList.add(ASMInstruction.generateMultiANewArrayInsn(manain.desc, manain.dims));
    }

    private void generateSimpleInsn(InsnNode in, List<ASMInstruction> asmInstructionList) {
        boolean generateSubstituteInsn = false;
        if (in.getOpcode() == 1) {
            int lookaheadIndex = 1;
            AbstractInsnNode nextInst = null;
            while ((nextInst = this.lookahead(lookaheadIndex)) != null && nextInst instanceof LabelNode) {
                ++lookaheadIndex;
            }
            if (nextInst instanceof InsnNode && nextInst.getOpcode() == 176) {
                int i;
                for (i = 1; i < lookaheadIndex; ++i) {
                    this.generateLabel((LabelNode)this.lookahead(i), asmInstructionList);
                }
                for (i = 1; i < lookaheadIndex; ++i) {
                    this.generateLabel((LabelNode)this.lookahead(i), asmInstructionList);
                }
                int nextLookaheadIndex = lookaheadIndex + 1;
                while ((nextInst = this.lookahead(nextLookaheadIndex)) != null && nextInst instanceof LabelNode) {
                    ++nextLookaheadIndex;
                }
                if (nextInst != null) {
                    this.generateMethodExitInstructions(asmInstructionList);
                }
                this.skip(lookaheadIndex);
                generateSubstituteInsn = true;
            }
        } else if (in.getOpcode() == 177 && this.methodType == MethodType.methodEntry) {
            generateSubstituteInsn = true;
        }
        if (!generateSubstituteInsn) {
            asmInstructionList.add(ASMInstruction.generateSimpleInsn(in.getOpcode()));
        }
    }

    private void generateMethodExitInstructions(List<ASMInstruction> asmInstructionList) {
        asmInstructionList.add(ASMInstruction.generateMethodExitReturnInstruction());
    }

    private void generateTableSwitchInsn(TableSwitchInsnNode twin, List<ASMInstruction> asmInstructionList) {
        Object[] labels = new Object[twin.labels.size()];
        List listOfLabels = twin.labels;
        int idx = 0;
        for (LabelNode ln : listOfLabels) {
            labels[idx++] = this.getAssignedLabel(ln);
        }
        Label defaultLabel = this.getAssignedLabel(twin.dflt);
        asmInstructionList.add(ASMInstruction.generateTableSwitchInsn(twin.min, twin.max, defaultLabel, labels));
    }

    private void generateTypeInsn(TypeInsnNode tin, List<ASMInstruction> asmInstructionList) {
        asmInstructionList.add(ASMInstruction.generateTypeInsn(tin.getOpcode(), tin.desc));
    }

    private void generateVarInsn(VarInsnNode vin, List<ASMInstruction> asmInstructionList) {
        Type type = null;
        int argNum = this.getArgNumber(vin.var);
        if (argNum < 0) {
            switch (vin.getOpcode()) {
                case 21: 
                case 54: {
                    type = Type.INT_TYPE;
                    break;
                }
                case 22: 
                case 55: {
                    type = Type.LONG_TYPE;
                    break;
                }
                case 23: 
                case 56: {
                    type = Type.FLOAT_TYPE;
                    break;
                }
                case 24: 
                case 57: {
                    type = Type.DOUBLE_TYPE;
                    break;
                }
                case 25: 
                case 58: 
                case 169: {
                    type = OBJ_TYPE;
                }
            }
            int locVarNum = type != null ? this.getAssignedLocalVar(vin.var, type) : vin.var;
            asmInstructionList.add(ASMInstruction.generateVarInsn(vin.getOpcode(), locVarNum));
        } else {
            Object argValue = this.inlineInterceptorTransformer.getArgumentValue(argNum, this.getNameOfMethodArgument(argNum), this.methodType, this.methodArgs[argNum]);
            if (argValue instanceof Number) {
                asmInstructionList.add(ASMInstruction.generateLdcInsn(((Number)argValue).intValue()));
            } else if (argValue instanceof Boolean) {
                asmInstructionList.add(ASMInstruction.generateLdcInsn((Boolean)argValue != false ? Integer.valueOf(1) : Integer.valueOf(0)));
            } else if (argValue instanceof String) {
                asmInstructionList.add(ASMInstruction.generateLdcInsn(argValue));
            } else if (this.methodArgs[argNum].getSort() == 9 || this.methodArgs[argNum].getSort() == 10) {
                asmInstructionList.add(ASMInstruction.generateSimpleInsn(1));
            } else {
                asmInstructionList.add(ASMInstruction.generateSimpleInsn(3));
            }
        }
    }

    private String getNameOfMethodArgument(int argNum) {
        String returnValue = null;
        List listOfLocalVars = this.mn.localVariables;
        if (listOfLocalVars != null) {
            for (LocalVariableNode nextLocVar : listOfLocalVars) {
                if (nextLocVar.index != argNum) continue;
                returnValue = nextLocVar.name;
                break;
            }
        }
        return returnValue;
    }

    private int getAssignedLocalVar(int originalLocVar, Type type) {
        int returnValue;
        LocalLocalVariable locVar = this.mapOfLocalVars.get(originalLocVar);
        if (locVar == null) {
            returnValue = this.templateClass.getTempLocVar(type);
            locVar = new LocalLocalVariable(originalLocVar, type);
            locVar.setAssignedLocVarNumber(returnValue);
            this.mapOfLocalVars.put(originalLocVar, locVar);
        } else {
            returnValue = locVar.getAssignedLocVarNumber();
        }
        return returnValue;
    }

    private void returnTempLocVars() {
        for (LocalLocalVariable nextLocVar : this.mapOfLocalVars.values()) {
            this.templateClass.returnLocVarToPool(nextLocVar.getAssignedLocVarNumber(), nextLocVar.getType());
        }
    }

    private Label getAssignedLabel(LabelNode originalLabelNode) {
        Label returnLabel;
        Label originalLabel = originalLabelNode.getLabel();
        LabelPlaceHolder lph = this.mapOfLabels.get(originalLabel);
        if (lph == null) {
            lph = new LabelPlaceHolder(originalLabel);
            returnLabel = new Label();
            lph.setNewLabel(returnLabel);
            this.mapOfLabels.put(originalLabel, lph);
        } else {
            returnLabel = lph.getNewLabel();
        }
        return returnLabel;
    }

    private int getArgNumber(int locVarNum) {
        int argNumber = -1;
        if (this.methodArgs.length > 0) {
            int curLocVar;
            int argIdx = 0;
            int n = curLocVar = (this.mn.access & 8) > 0 ? 0 : 1;
            while (curLocVar < locVarNum && argIdx < this.methodArgs.length) {
                curLocVar += this.methodArgs[argIdx++].getSize();
            }
            if (argIdx < this.methodArgs.length) {
                argNumber = argIdx;
            }
        }
        return argNumber;
    }

    boolean shouldInjectTryCatch() {
        return this.methodType == MethodType.exceptionMethodExit;
    }

    public static enum MethodType {
        methodEntry,
        normalMethodExit,
        exceptionMethodExit;

    }
}

